<!-- =========================================================================
 Copyright (c) 2017 XMLmind Software. All rights reserved.
 
 Author: Hussein Shafie
 
 This file is part of the XMLmind W2X project.
 For conditions of distribution and use, see the accompanying legal.txt file.
========================================================================== -->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:h="http://www.w3.org/1999/xhtml"
  exclude-result-prefixes="h">

  <!-- =======================================================================
       Cannot be translated:
       applet, basefont, iframe, isindex, noframes.

       Other differences with the Transitional DTD:
       * address may not contain p.
       * Have flow content rather than element content:
         blockquote, body, form, noscript.
  ======================================================================== -->

  <xsl:template match="h:center">
    <xsl:element name="div">
      <xsl:call-template name="addClassOrStyle">
        <xsl:with-param name="class" select="'center'"/>
        <xsl:with-param name="style" select="'text-align:center;'"/>
      </xsl:call-template>

      <xsl:apply-templates select="@*[local-name() != 'class' and
                                      local-name() != 'style'] | node()"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="h:dir | h:menu">
    <xsl:element name="ul">
      <xsl:call-template name="addClass">
        <xsl:with-param name="class" select="local-name()"/>
      </xsl:call-template>

      <xsl:apply-templates select="@*[local-name() != 'class'] | node()"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="h:font">
    <xsl:element name="span">
      <xsl:variable name="size">
        <xsl:if test="@size">
          <xsl:choose>
            <xsl:when test="@size = '1'">xx-small</xsl:when>
            <xsl:when test="@size = '2'">small</xsl:when>
            <xsl:when test="@size = '3'">medium</xsl:when>
            <xsl:when test="@size = '4'">large</xsl:when>
            <xsl:when test="@size = '5'">x-large</xsl:when>
            <xsl:when test="@size = '6'">xx-large</xsl:when>
            <xsl:when test="@size = '7'">xx-large</xsl:when>

            <xsl:when test="@size = '+1'">1.20em</xsl:when>
            <xsl:when test="@size = '+2'">1.44em</xsl:when>
            <xsl:when test="@size = '+3'">1.72em</xsl:when>
            <xsl:when test="@size = '+5'">2.48em</xsl:when>
            <xsl:when test="@size = '+6'">2.98em</xsl:when>
            <xsl:when test="@size = '+7'">3.58em</xsl:when>

            <xsl:when test="@size = '-1'">0.83em</xsl:when>
            <xsl:when test="@size = '-2'">0.69em</xsl:when>
            <xsl:when test="@size = '-3'">0.57em</xsl:when>
            <xsl:when test="@size = '-4'">0.48em</xsl:when>
            <xsl:when test="@size = '-5'">0.40em</xsl:when>
            <xsl:when test="@size = '-6'">0.33em</xsl:when>
            <xsl:when test="@size = '-7'">0.28em</xsl:when>
          </xsl:choose>
        </xsl:if>
      </xsl:variable>

      <xsl:variable name="color" select="normalize-space(@color)"/>

      <xsl:variable name="face" select="normalize-space(@face)"/>

      <xsl:variable name="style">
        <xsl:if test="$size != ''">
          <xsl:value-of select="concat('font-size:', $size, ';')"/>
        </xsl:if>
        <xsl:if test="$color != ''">
          <xsl:value-of select="concat('color:', $color, ';')"/>
        </xsl:if>
        <xsl:if test="$face != ''">
          <xsl:value-of select="concat('font-family:', $face, ';')"/>
        </xsl:if>
      </xsl:variable>

      <xsl:call-template name="addStyle">
        <xsl:with-param name="style" select="$style"/>
      </xsl:call-template>

      <xsl:apply-templates select="@*[local-name() != 'style' and
                                      local-name() != 'size' and
                                      local-name() != 'color' and
                                      local-name() != 'face'] | node()"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="h:ol">
    <xsl:element name="ol">
      <xsl:variable name="type">
        <xsl:if test="@type">
          <xsl:choose>
            <xsl:when test="@type = '1'">decimal</xsl:when>
            <xsl:when test="@type = 'a'">lower-alpha</xsl:when>
            <xsl:when test="@type = 'A'">upper-alpha</xsl:when>
            <xsl:when test="@type = 'i'">lower-roman</xsl:when>
            <xsl:when test="@type = 'I'">upper-roman</xsl:when>
          </xsl:choose>
        </xsl:if>
      </xsl:variable>

      <xsl:variable name="start" select="normalize-space(@start)"/>

      <xsl:variable name="style">
        <xsl:if test="$type != ''">
          <xsl:value-of select="concat('list-style-type:', $type, ';')"/>
        </xsl:if>
        <xsl:if test="$start != ''">
          <xsl:value-of select="concat('-list-start-number:', $start, ';')"/>
        </xsl:if>
      </xsl:variable>

      <xsl:call-template name="addStyle">
        <xsl:with-param name="style" select="$style"/>
      </xsl:call-template>

      <xsl:apply-templates select="@*[local-name() != 'style' and
                                      local-name() != 'type' and
                                      local-name() != 'start'] | node()"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="h:s | h:strike">
    <xsl:element name="span">
      <xsl:call-template name="addClassOrStyle">
        <xsl:with-param name="class" select="local-name()"/>
        <xsl:with-param name="style" select="'text-decoration:line-through;'"/>
      </xsl:call-template>

      <xsl:apply-templates select="@*[local-name() != 'class' and
                                      local-name() != 'style'] | node()"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="h:u">
    <xsl:element name="span">
      <xsl:call-template name="addClassOrStyle">
        <xsl:with-param name="class" select="'u'"/>
        <xsl:with-param name="style" select="'text-decoration:underline;'"/>
      </xsl:call-template>

      <xsl:apply-templates select="@*[local-name() != 'class' and
                                      local-name() != 'style'] | node()"/>
    </xsl:element>
  </xsl:template>

  <!-- Attributes ======================================================== -->

  <xsl:template match="h:img/@name | h:form/@name | h:fieldset/@name">
    <xsl:call-template name="nameToId"/>
  </xsl:template>

  <xsl:template name="nameToId">
    <xsl:for-each select="parent::*">
      <xsl:if test="not(@id)">
        <xsl:attribute name="id">
          <xsl:value-of select="@name"/>
        </xsl:attribute>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="h:p/@align">
    <xsl:if test="(. = 'center' or . = 'right') and 
                  not(parent::h:p[starts-with(@class, 'role-')])">
      <xsl:call-template name="addClassOrStyle">
        <xsl:with-param name="class" select="."/>
        <xsl:with-param name="style" select="concat('text-align:', ., ';')"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <!-- Simply discard these relatively unimportant attributes:
       @align caption div h1 h2 h3 h4 h5 h6 hr img input legend object table
       @alink body
       @background body
       @bgcolor body table td tr
       @border img object
       @clear br
       @compact dl ol ul
       @height td th
       @hspace img object
       @language script
       @link body
       @noshade hr
       @nowrap td th
       @size hr
       @target a area base form link
       @text body
       @type li ul
       @value li
       @vlink body
       @vspace img object
       @width hr pre td th
  -->

  <xsl:template match="*[not(self::h:p or 
                             self::h:col or 
                             self::h:colgroup or 
                             self::h:tbody or 
                             self::h:td or self::h:th or
                             self::h:tfoot or
                             self::h:thead or 
                             self::h:tr)]/@align |
                       @alink |
                       h:img/@border | h:object/@border |
                       @background |
                       @bgcolor |
                       @clear |
                       @compact |
                       h:td/@height | h:th/@height |
                       @hspace |
                       @language |
                       @link |
                       @noshade |
                       @nowrap |
                       h:hr/@size |
                       @target |
                       @text |
                       h:ul/@type | h:li/@type |
                       h:li/@value |
                       @vspace |
                       @vlink |
                       h:hr/@width | h:pre/@width | h:td/@width | h:th/@width"/>

</xsl:stylesheet>
