<!-- =========================================================================
 Copyright (c) 2017-2019 XMLmind Software. All rights reserved.
 
 Author: Hussein Shafie
 
 This file is part of the XMLmind W2X project.
 For conditions of distribution and use, see the accompanying legal.txt file.
========================================================================== -->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:h="http://www.w3.org/1999/xhtml"
  exclude-result-prefixes="h">

  <xsl:template match="h:p[@class = 'role-inline-wrapper']">
    <xsl:choose>
      <xsl:when test="(parent::h:li or parent::h:dd) and
                      not(preceding-sibling::node())">
        <!-- Unwrap inline wrapper paragraph. -->
        <xsl:apply-templates/>
      </xsl:when>

      <xsl:when test="parent::h:body and count(parent::h:body/*) = 1">
        <!-- Needed to be able to paste inlines into XHTML Strict. -->
        <xsl:copy>
          <xsl:apply-templates select="@* | node()"/>
        </xsl:copy>
      </xsl:when>

      <xsl:otherwise>
        <!-- In any other case, class=role-inline-wrapper is not useful. -->
        <xsl:element name="p">
          <xsl:apply-templates select="@*[local-name() != 'class'] | node()"/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
