<!-- =========================================================================
 Copyright (c) 2017-2024 XMLmind Software. All rights reserved.
 
 Author: Hussein Shafie
 
 This file is part of the XMLmind W2X project.
 For conditions of distribution and use, see the accompanying legal.txt file.
========================================================================== -->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:h="http://www.w3.org/1999/xhtml"
  exclude-result-prefixes="h">

<xsl:import href="xhtml_common.xslt"/>
<xsl:import href="xhtml_strict_common.xslt"/>
<xsl:import href="xhtml_body_elements.xslt"/>

<xsl:param name="add-xml-lang" select="'yes'"/>

<xsl:output method="xml" encoding="UTF-8" indent="no"
  doctype-public="-//W3C//DTD XHTML 1.1//EN"
  doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/>

<!-- Compared to XHTML 1.0 Strict, XHTML 1.1 has:
     * New: rbc, rb, rp, rtc, rt, ruby.
     * noscript allowed inside more elements (e.g. inlines).
     * No base/@id, meta/@id, title/@id.
     * No a/@name, map/@name.
     * Back: @target, form/@name, img/@name.
-->

  <xsl:template match="h:a/@name | h:map/@name">
    <xsl:call-template name="nameToId"/>
  </xsl:template>

  <xsl:template match="@target | 
                       h:form/@name | 
                       h:img/@name">
    <xsl:copy/>
  </xsl:template>

  <xsl:template match="h:base/@id |
                       h:meta/@id |
                       h:title/@id"/>

</xsl:stylesheet>
