<!-- =========================================================================
 Copyright (c) 2017 XMLmind Software. All rights reserved.
 
 Author: Hussein Shafie
 
 This file is part of the XMLmind W2X project.
 For conditions of distribution and use, see the accompanying legal.txt file.
========================================================================== -->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:h="http://www.w3.org/1999/xhtml"
  exclude-result-prefixes="h">

<xsl:template name="olStart">
  <xsl:variable name="previousList" select="preceding-sibling::h:ol[1]"/>

  <xsl:choose>
    <xsl:when test="not($previousList)">1</xsl:when>

    <xsl:otherwise>
      <xsl:variable name="itemCount" select="count($previousList/h:li)"/>

      <xsl:choose>
        <xsl:when test="$previousList/@start">
          <xsl:variable name="start">
            <xsl:choose>
              <xsl:when test="number($previousList/@start) >= 0">
                <xsl:value-of select="number($previousList/@start)"/>
              </xsl:when>
              <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>

          <xsl:value-of select="$start + $itemCount"/>
        </xsl:when>

        <xsl:otherwise>
          <xsl:value-of select="$itemCount + 1"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
