function Snowball() {
BaseStemmer = function() {
this.setCurrent = function(value) {
this.current = value;
this.cursor = 0;
this.limit = this.current.length;
this.limit_backward = 0;
this.bra = this.cursor;
this.ket = this.limit;
};
this.getCurrent = function() {
return this.current;
};
this.copy_from = function(other) {
this.current = other.current;
this.cursor = other.cursor;
this.limit = other.limit;
this.limit_backward = other.limit_backward;
this.bra = other.bra;
this.ket = other.ket;
};
this.in_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor++;
return true;
};
this.in_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor--;
return true;
};
this.out_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) {
this.cursor++;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0X1 << (ch & 0x7))) == 0) {
this.cursor++;
return true;
}
return false;
};
this.out_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) {
this.cursor--;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) {
this.cursor--;
return true;
}
return false;
};
this.eq_s = function(s)
{
if (this.limit - this.cursor < s.length) return false;
if (this.current.slice(this.cursor, this.cursor + s.length) != s)
{
return false;
}
this.cursor += s.length;
return true;
};
this.eq_s_b = function(s)
{
if (this.cursor - this.limit_backward < s.length) return false;
if (this.current.slice(this.cursor - s.length, this.cursor) != s)
{
return false;
}
this.cursor -= s.length;
return true;
};
 this.find_among = function(v)
{
var i = 0;
var j = v.length;
var c = this.cursor;
var l = this.limit;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >>> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j; 
var w = v[k];
var i2;
for (i2 = common; i2 < w[0].length; i2++)
{
if (c + common == l)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c + common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break; 
if (j == i) break; 
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c + w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c + w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.find_among_b = function(v)
{
var i = 0;
var j = v.length
var c = this.cursor;
var lb = this.limit_backward;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j;
var w = v[k];
var i2;
for (i2 = w[0].length - 1 - common; i2 >= 0; i2--)
{
if (c - common == lb)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c - 1 - common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break;
if (j == i) break;
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c - w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c - w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.replace_s = function(c_bra, c_ket, s)
{
var adjustment = s.length - (c_ket - c_bra);
this.current = this.current.slice(0, c_bra) + s + this.current.slice(c_ket);
this.limit += adjustment;
if (this.cursor >= c_ket) this.cursor += adjustment;
else if (this.cursor > c_bra) this.cursor = c_bra;
return adjustment;
};
this.slice_check = function()
{
if (this.bra < 0 ||
this.bra > this.ket ||
this.ket > this.limit ||
this.limit > this.current.length)
{
return false;
}
return true;
};
this.slice_from = function(s)
{
var result = false;
if (this.slice_check())
{
this.replace_s(this.bra, this.ket, s);
result = true;
}
return result;
};
this.slice_del = function()
{
return this.slice_from("");
};
this.insert = function(c_bra, c_ket, s)
{
var adjustment = this.replace_s(c_bra, c_ket, s);
if (c_bra <= this.bra) this.bra += adjustment;
if (c_bra <= this.ket) this.ket += adjustment;
};
this.slice_to = function()
{
var result = '';
if (this.slice_check())
{
result = this.current.slice(this.bra, this.ket);
}
return result;
};
this.assign_to = function()
{
return this.current.slice(0, this.limit);
};
};
EnglishStemmer = function() {
var base = new BaseStemmer();
 var a_0 = [
["arsen", -1, -1],
["commun", -1, -1],
["gener", -1, -1]
];
 var a_1 = [
["'", -1, 1],
["'s'", 0, 1],
["'s", -1, 1]
];
 var a_2 = [
["ied", -1, 2],
["s", -1, 3],
["ies", 1, 2],
["sses", 1, 1],
["ss", 1, -1],
["us", 1, -1]
];
 var a_3 = [
["", -1, 3],
["bb", 0, 2],
["dd", 0, 2],
["ff", 0, 2],
["gg", 0, 2],
["bl", 0, 1],
["mm", 0, 2],
["nn", 0, 2],
["pp", 0, 2],
["rr", 0, 2],
["at", 0, 1],
["tt", 0, 2],
["iz", 0, 1]
];
 var a_4 = [
["ed", -1, 2],
["eed", 0, 1],
["ing", -1, 2],
["edly", -1, 2],
["eedly", 3, 1],
["ingly", -1, 2]
];
 var a_5 = [
["anci", -1, 3],
["enci", -1, 2],
["ogi", -1, 13],
["li", -1, 15],
["bli", 3, 12],
["abli", 4, 4],
["alli", 3, 8],
["fulli", 3, 9],
["lessli", 3, 14],
["ousli", 3, 10],
["entli", 3, 5],
["aliti", -1, 8],
["biliti", -1, 12],
["iviti", -1, 11],
["tional", -1, 1],
["ational", 14, 7],
["alism", -1, 8],
["ation", -1, 7],
["ization", 17, 6],
["izer", -1, 6],
["ator", -1, 7],
["iveness", -1, 11],
["fulness", -1, 9],
["ousness", -1, 10]
];
 var a_6 = [
["icate", -1, 4],
["ative", -1, 6],
["alize", -1, 3],
["iciti", -1, 4],
["ical", -1, 4],
["tional", -1, 1],
["ational", 5, 2],
["ful", -1, 5],
["ness", -1, 5]
];
 var a_7 = [
["ic", -1, 1],
["ance", -1, 1],
["ence", -1, 1],
["able", -1, 1],
["ible", -1, 1],
["ate", -1, 1],
["ive", -1, 1],
["ize", -1, 1],
["iti", -1, 1],
["al", -1, 1],
["ism", -1, 1],
["ion", -1, 2],
["er", -1, 1],
["ous", -1, 1],
["ant", -1, 1],
["ent", -1, 1],
["ment", 15, 1],
["ement", 16, 1]
];
 var a_8 = [
["e", -1, 1],
["l", -1, 2]
];
 var a_9 = [
["succeed", -1, -1],
["proceed", -1, -1],
["exceed", -1, -1],
["canning", -1, -1],
["inning", -1, -1],
["earring", -1, -1],
["herring", -1, -1],
["outing", -1, -1]
];
 var a_10 = [
["andes", -1, -1],
["atlas", -1, -1],
["bias", -1, -1],
["cosmos", -1, -1],
["dying", -1, 3],
["early", -1, 9],
["gently", -1, 7],
["howe", -1, -1],
["idly", -1, 6],
["lying", -1, 4],
["news", -1, -1],
["only", -1, 10],
["singly", -1, 11],
["skies", -1, 2],
["skis", -1, 1],
["sky", -1, -1],
["tying", -1, 5],
["ugly", -1, 8]
];
 var  g_v = [17, 65, 16, 1];
 var  g_v_WXY = [1, 17, 65, 208, 1];
 var  g_valid_LI = [55, 141, 2];
var  B_Y_found = false;
var  I_p2 = 0;
var  I_p1 = 0;
function r_prelude() {
B_Y_found = false;
var  v_1 = base.cursor;
lab0: {
base.bra = base.cursor;
if (!(base.eq_s("'")))
{
break lab0;
}
base.ket = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.cursor = v_1;
var  v_2 = base.cursor;
lab1: {
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab1;
}
base.ket = base.cursor;
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
}
base.cursor = v_2;
var  v_3 = base.cursor;
lab2: {
while(true)
{
var  v_4 = base.cursor;
lab3: {
golab4: while(true)
{
var  v_5 = base.cursor;
lab5: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab5;
}
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab5;
}
base.ket = base.cursor;
base.cursor = v_5;
break golab4;
}
base.cursor = v_5;
if (base.cursor >= base.limit)
{
break lab3;
}
base.cursor++;
}
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
continue;
}
base.cursor = v_4;
break;
}
}
base.cursor = v_3;
return true;
};
function r_mark_regions() {
I_p1 = base.limit;
I_p2 = base.limit;
var  v_1 = base.cursor;
lab0: {
lab1: {
var  v_2 = base.cursor;
lab2: {
if (base.find_among(a_0) == 0)
{
break lab2;
}
break lab1;
}
base.cursor = v_2;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab5: while(true)
{
lab6: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab6;
}
break golab5;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
}
I_p1 = base.cursor;
golab7: while(true)
{
lab8: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab8;
}
break golab7;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab9: while(true)
{
lab10: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab10;
}
break golab9;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
I_p2 = base.cursor;
}
base.cursor = v_1;
return true;
};
function r_shortv() {
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.out_grouping_b(g_v_WXY, 89, 121)))
{
break lab1;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
if (!(base.out_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
return false;
}
if (base.cursor > base.limit_backward)
{
return false;
}
}
return true;
};
function r_R1() {
if (!(I_p1 <= base.cursor))
{
return false;
}
return true;
};
function r_R2() {
if (!(I_p2 <= base.cursor))
{
return false;
}
return true;
};
function r_Step_1a() {
var  among_var;
var  v_1 = base.limit - base.cursor;
lab0: {
base.ket = base.cursor;
if (base.find_among_b(a_1) == 0)
{
base.cursor = base.limit - v_1;
break lab0;
}
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.ket = base.cursor;
among_var = base.find_among_b(a_2);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!base.slice_from("ss"))
{
return false;
}
break;
case 2:
lab1: {
var  v_2 = base.limit - base.cursor;
lab2: {
{
var  c1 = base.cursor - 2;
if (c1 < base.limit_backward)
{
break lab2;
}
base.cursor = c1;
}
if (!base.slice_from("i"))
{
return false;
}
break lab1;
}
base.cursor = base.limit - v_2;
if (!base.slice_from("ie"))
{
return false;
}
}
break;
case 3:
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_1b() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_4);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!r_R1())
{
return false;
}
if (!base.slice_from("ee"))
{
return false;
}
break;
case 2:
var  v_1 = base.limit - base.cursor;
golab0: while(true)
{
lab1: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break golab0;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
base.cursor = base.limit - v_1;
if (!base.slice_del())
{
return false;
}
var  v_3 = base.limit - base.cursor;
among_var = base.find_among_b(a_3);
if (among_var == 0)
{
return false;
}
base.cursor = base.limit - v_3;
switch (among_var) {
case 1:
{
var  c1 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c1;
}
break;
case 2:
base.ket = base.cursor;
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
break;
case 3:
if (base.cursor != I_p1)
{
return false;
}
var  v_4 = base.limit - base.cursor;
if (!r_shortv())
{
return false;
}
base.cursor = base.limit - v_4;
{
var  c2 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c2;
}
break;
}
break;
}
return true;
};
function r_Step_1c() {
base.ket = base.cursor;
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("y")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("Y")))
{
return false;
}
}
base.bra = base.cursor;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
lab2: {
if (base.cursor > base.limit_backward)
{
break lab2;
}
return false;
}
if (!base.slice_from("i"))
{
return false;
}
return true;
};
function r_Step_2() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_5);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ence"))
{
return false;
}
break;
case 3:
if (!base.slice_from("ance"))
{
return false;
}
break;
case 4:
if (!base.slice_from("able"))
{
return false;
}
break;
case 5:
if (!base.slice_from("ent"))
{
return false;
}
break;
case 6:
if (!base.slice_from("ize"))
{
return false;
}
break;
case 7:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 8:
if (!base.slice_from("al"))
{
return false;
}
break;
case 9:
if (!base.slice_from("ful"))
{
return false;
}
break;
case 10:
if (!base.slice_from("ous"))
{
return false;
}
break;
case 11:
if (!base.slice_from("ive"))
{
return false;
}
break;
case 12:
if (!base.slice_from("ble"))
{
return false;
}
break;
case 13:
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_from("og"))
{
return false;
}
break;
case 14:
if (!base.slice_from("less"))
{
return false;
}
break;
case 15:
if (!(base.in_grouping_b(g_valid_LI, 99, 116)))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_3() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_6);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 3:
if (!base.slice_from("al"))
{
return false;
}
break;
case 4:
if (!base.slice_from("ic"))
{
return false;
}
break;
case 5:
if (!base.slice_del())
{
return false;
}
break;
case 6:
if (!r_R2())
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_4() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_7);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R2())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_del())
{
return false;
}
break;
case 2:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("s")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("t")))
{
return false;
}
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_5() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_8);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!r_R2())
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!r_R1())
{
return false;
}
{
var  v_2 = base.limit - base.cursor;
lab2: {
if (!r_shortv())
{
break lab2;
}
return false;
}
base.cursor = base.limit - v_2;
}
}
if (!base.slice_del())
{
return false;
}
break;
case 2:
if (!r_R2())
{
return false;
}
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_exception2() {
base.ket = base.cursor;
if (base.find_among_b(a_9) == 0)
{
return false;
}
base.bra = base.cursor;
if (base.cursor > base.limit_backward)
{
return false;
}
return true;
};
function r_exception1() {
var  among_var;
base.bra = base.cursor;
among_var = base.find_among(a_10);
if (among_var == 0)
{
return false;
}
base.ket = base.cursor;
if (base.cursor < base.limit)
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("ski"))
{
return false;
}
break;
case 2:
if (!base.slice_from("sky"))
{
return false;
}
break;
case 3:
if (!base.slice_from("die"))
{
return false;
}
break;
case 4:
if (!base.slice_from("lie"))
{
return false;
}
break;
case 5:
if (!base.slice_from("tie"))
{
return false;
}
break;
case 6:
if (!base.slice_from("idl"))
{
return false;
}
break;
case 7:
if (!base.slice_from("gentl"))
{
return false;
}
break;
case 8:
if (!base.slice_from("ugli"))
{
return false;
}
break;
case 9:
if (!base.slice_from("earli"))
{
return false;
}
break;
case 10:
if (!base.slice_from("onli"))
{
return false;
}
break;
case 11:
if (!base.slice_from("singl"))
{
return false;
}
break;
}
return true;
};
function r_postlude() {
if (!B_Y_found)
{
return false;
}
while(true)
{
var  v_1 = base.cursor;
lab0: {
golab1: while(true)
{
var  v_2 = base.cursor;
lab2: {
base.bra = base.cursor;
if (!(base.eq_s("Y")))
{
break lab2;
}
base.ket = base.cursor;
base.cursor = v_2;
break golab1;
}
base.cursor = v_2;
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
if (!base.slice_from("y"))
{
return false;
}
continue;
}
base.cursor = v_1;
break;
}
return true;
};
this.stem =  function() {
lab0: {
var  v_1 = base.cursor;
lab1: {
if (!r_exception1())
{
break lab1;
}
break lab0;
}
base.cursor = v_1;
lab2: {
{
var  v_2 = base.cursor;
lab3: {
{
var  c1 = base.cursor + 3;
if (c1 > base.limit)
{
break lab3;
}
base.cursor = c1;
}
break lab2;
}
base.cursor = v_2;
}
break lab0;
}
base.cursor = v_1;
r_prelude();
r_mark_regions();
base.limit_backward = base.cursor; base.cursor = base.limit;
var  v_5 = base.limit - base.cursor;
r_Step_1a();
base.cursor = base.limit - v_5;
lab4: {
var  v_6 = base.limit - base.cursor;
lab5: {
if (!r_exception2())
{
break lab5;
}
break lab4;
}
base.cursor = base.limit - v_6;
var  v_7 = base.limit - base.cursor;
r_Step_1b();
base.cursor = base.limit - v_7;
var  v_8 = base.limit - base.cursor;
r_Step_1c();
base.cursor = base.limit - v_8;
var  v_9 = base.limit - base.cursor;
r_Step_2();
base.cursor = base.limit - v_9;
var  v_10 = base.limit - base.cursor;
r_Step_3();
base.cursor = base.limit - v_10;
var  v_11 = base.limit - base.cursor;
r_Step_4();
base.cursor = base.limit - v_11;
var  v_12 = base.limit - base.cursor;
r_Step_5();
base.cursor = base.limit - v_12;
}
base.cursor = base.limit_backward;
var  v_13 = base.cursor;
r_postlude();
base.cursor = v_13;
}
return true;
};
this['stemWord'] = function(word) {
base.setCurrent(word);
this.stem();
return base.getCurrent();
};
};
return new EnglishStemmer();
}
wh.search_stemmer = Snowball();
wh.search_baseNameList = [
 "manual.html",
 "manual-1.html",
 "manual-2.html",
 "manual-3.html",
 "manual-4.html",
 "manual-6.html",
 "manual-7.html",
 "manual-8.html",
 "manual-9.html",
 "manual-10.html",
 "manual-11.html",
 "manual-12.html",
 "manual-13.html",
 "manual-14.html",
 "manual-15.html",
 "manual-16.html",
 "manual-17.html",
 "manual-18.html",
 "manual-21.html",
 "manual-22.html",
 "manual-23.html",
 "manual-24.html",
 "manual-26.html",
 "manual-27.html",
 "manual-28.html",
 "manual-29.html",
 "manual-30.html",
 "manual-31.html",
 "manual-32.html",
 "manual-33.html",
 "manual-34.html",
 "manual-35.html",
 "manual-36.html",
 "manual-38.html",
 "manual-39.html",
 "manual-40.html",
 "manual-41.html",
 "manual-42.html",
 "manual-43.html",
 "manual-44.html",
 "manual-45.html",
 "manual-46.html",
 "manual-47.html",
 "manual-49.html",
 "manual-52.html",
 "manual-53.html",
 "manual-54.html"
];
wh.search_titleList = [
 "XMLmind Word To XML Manual",
 "Introduction",
 "Installing w2x",
 "Contents of the installation directory",
 "Alternatives to using the w2x command-line utility",
 "The “Word To XML” add-on for XMLmind XML Editor",
 "Installing the “Word To XML” add-on",
 "The “Word To XML” servlet",
 "Contents of the servlet software distribution",
 "Installing the servlet",
 "Configuring the servlet",
 "Using the servlet to convert DOCX files",
 "Non interactive requests",
 "Getting started with w2x",
 "How to generate useful multi-page HTML",
 "Going further with w2x",
 "Stock XED scripts",
 "Customizing the output of w2x",
 "Appending custom styles to the styles embedded in the XHTML+CSS file",
 "Using an external CSS file rather than embedded CSS styles",
 "Combining all the above methods",
 "Customizing the semantic XML files generated by w2x",
 "Converting custom paragraph styles to semantic tags",
 "The general case",
 "Generating XML conforming to a custom schema",
 "Packaging your customization as a w2x plugin",
 "Anatomy of a plugin",
 "Registering a plugin with w2x",
 "The w2x command-line utility",
 "Variables substituted in the parameter values passed to the –p and –pu options",
 "Default conversion steps",
 "Automatic conversion step parameters",
 "Conversion step reference",
 "Delete files step",
 "Edit step",
 "EPUB step",
 "Load step",
 "Save step",
 "Split step",
 "Transform step",
 "Web Help step",
 "Embedding w2x in a Java™ application",
 "Extension points",
 "Custom image converters",
 "Limitations and implementation specificities",
 "About tab stops",
 "Index"
];
wh.search_wordMap= {
"german": [[32,44]],
"don\'t": [2,45],
"upload": [10],
"zipstep.java": [26],
"ready-to-deploy": [8],
"your": [2,24,1,11,[7,9,14,25,28,43]],
"elimin": [23],
"without": [[16,26,28,29,32,43]],
"these": [34,16,[3,10,40],[12,15,17,21,22,24,26,32,35,38,44,45]],
"remove-styles.x": [34],
"image_convers": [43],
"would": [[22,23,32,44]],
"mathemat": [34],
"my.xml": [25],
"xml": [[3,5,34],[6,28],39,[1,7,32],13,[0,2,9,10,12,16,23,24,26,29,36,41,44],[8,11,15,21,27,30,37,38,43,45]],
"tei": [44],
"manual.dita": [13],
"i.e": [44],
"solid": [18],
"thus": [[33,38]],
"wordtoxml.app": [2,[3,27,28]],
"cdn": [34],
"click": [[6,11],2],
"befor": [16,20,32,[1,6,39,44]],
"single-top": [39],
"util": [3,[4,13,28,41],[11,25]],
"size": [[11,34,35]],
"sub-subsect": [13],
"left": [38,[13,20,44]],
"wh-layout": [40],
"much": [13,1,15],
"besid": [[17,20]],
"object": [32,44],
"chapter": [39,[13,15,23]],
"inlines.big-el": [34],
"role": [24],
"turn": [[13,32,34]],
"suffici": [9],
"edit.inlines.tt-el": [34],
"x-small": [34],
"result": [34,[11,12,15,20,30,32,33,35,36,37,38,39]],
"convert.resource-directori": [32],
"same": [38,[32,34],43,[28,37,39],[2,7,15,19,22,26,27,35,40]],
"checkbox": [6],
"jpeg": [43,32,[35,44]],
"after": [16,[20,23],[32,39]],
"quiet": [32],
"transform.topic-typ": [29,[13,28]],
"editstep": [41,42],
"rebuild": [8],
"verbos": [15,28],
"the": [34,39,32,15,38,2,[3,43],23,35,29,[22,28],[17,20],[13,44],26,12,11,[9,21,27],[16,37],[30,40],[24,31],[1,5,6,8,14,41],[10,18,33],7,[25,45],[4,19,36],[0,42]],
"title.x": [34],
"imag": [43,32,35,[26,28]],
"wrap": [34,44],
"standard": [34,43,[7,9,44]],
"callout": [39],
"remove-pis.except": [34],
"correct": [44],
"good": [14],
"deploy": [9,[1,7]],
"pad": [18],
"exceed": [35],
"implement": [[26,43,44],[1,42],[3,9,15,20,22,28]],
"tip": [[14,23,38]],
"options_url_or_fil": [28],
"export": [27],
"check": [[2,14]],
"list": [34,32,[0,1,2,13,15,22,28,38]],
"inlines.u-el": [34],
"v5.1": [39,[13,28]],
"resolut": [43],
"success": [12],
"topic.xslt": [23,39,[21,24,28]],
"inlines.generate-big-smal": [34],
"fr-fr": [44],
"captions.x": [34],
"child": [34],
"soffic": [43],
"fortun": [[22,34]],
"ensur": [34],
"minim": [44],
"padding-left": [44],
"jetti": [9],
"primari": [44],
"margin-left": [18],
"xsl": [23,39,24,44],
"determin": [32,44,[28,35]],
"lower-level": [41],
"root": [[35,39,40]],
"combin": [20,29],
"thread-saf": [43],
"discard-index-term": [39],
"perform": [34,43],
"w2x.bat": [3],
"map.xslt": [39],
"better": [44,43],
"with": [34,32,29,[3,23,43],[13,14,16,22,27,44],[1,6,11,12,15,24,25,26,31,36,38,39,40]],
"pdf": [[1,3]],
"certif": [2],
"there": [34,[9,15,21,22]],
"well": [[8,22,26]],
"syntax": [43,[12,16,21,22,34]],
"personnel": [7],
"edit.ids.generate-section-id": [34],
"empti": [34,32,39,[3,13,23,29,38]],
"cover-image-url-or-fil": [35],
"catalog": [[3,23,30,34]],
"w2x-app.jstart": [3],
"desir": [15,[11,17,23]],
"emul": [12,45,34,35],
"variabl": [34,[29,43],27,28,[9,44]],
"block": [20],
"per": [[22,34,41,43]],
"write": [1,[21,22,23,24]],
"convert-to": [43],
"flow": [34],
"order": [15,34,2,11,[1,3,6,8,14,17,23,24,28,38,43]],
"e.g": [34,[32,38],16,[1,14,27],[11,15,22,26,28,37]],
"proceed": [6],
"xvf": [11],
"integ": [34,[14,38]],
"intel": [2],
"fr-ca": [32,35],
"out_spec": [28,2],
"set-vari": [20],
"xed-url-or-fil": [[15,34]],
"regexp": [34],
"subtitl": [[35,40]],
"save": [37,38,[15,28,32,39],[19,31,41]],
"toc": [[35,39,40]],
"restrict": [34],
"matter": [39,40],
"articl": [[9,39]],
"manual.xml": [13,15],
"top": [13],
"too": [[22,34,38]],
"have": [34,[22,44],2,21,[11,23,43],[13,14,16,24,26,31,32,38,39],[12,15,17,20,25,27,28,30,33,35,40]],
"role-xref": [24],
"printenv": [28,2],
"avail": [[3,5,43]],
"product": [[37,38]],
"programlist": [22,17],
"asian": [44,32],
"calibri": [17],
"charact": [34,21,[32,37,44],[11,43],[26,29,38]],
"instanc": [41,43,28],
"instal": [2,6,[1,3,9,27],[0,28]],
"almost": [[5,34]],
"pleas": [[7,11,34,39],[5,6,9,13,32,38,41]],
"index.x": [34],
"whether": [34,[19,38],[26,35,37,40,44]],
"w2x_all.jar": [3],
"function": [20,7],
"stock": [23,[24,34],16,[12,21,22,25,26,28,42,43]],
"book-sect1": [39],
"thread-safeti": [[41,43]],
"deletefilesstep": [42],
"less": [[1,14,38]],
"absolut": [[39,43],34,28,29,[23,27,30,32,35]],
"translat": [44,[16,34,38]],
"uniqu": [[34,35]],
"were": [[13,25]],
"tertiari": [44],
"inlines.small-el": [34],
"basic": [13],
"w2x.war": [8,9,10],
"disabl": [[35,45]],
"manual_docbook5": [12],
"finish-styles.css-uri": [34,16],
"tiff": [43,44],
"footer": [44],
"saxon": [3],
"shorthand": [[15,27]],
"respons": [12],
"style_spec": [[21,22,34]],
"design": [1],
"transform.root-topic-id": [13],
"command-lin": [[3,15],[4,13,23,28],[11,12,24,25,26,29,41]],
"unpack": [[8,11]],
"lang": [32,44,39],
"lookup-length": [20],
"xhtml_to_foo.xsl": [24],
"multi-pag": [28,[12,14],[13,34,38]],
"omit-toc-root": [[35,40]],
"css": [17,34,20,19,18,[13,15],[16,28],[1,44],[21,22,35,39,45]],
"enhanc": [3],
"quoted_attribute_valu": [[21,22,34]],
"imageconverterfactories.regist": [43],
"let": [34,[11,23,24,25,29,38]],
"onlin": [[3,4]],
"element": [34,39,22,32,21,[17,20,23],[24,44],[13,37,38,45]],
"frameset": [[13,38],14,[12,28,34]],
"want": [[2,23],[22,34,45],[1,13,15,27,43]],
"png": [43,32,[35,44]],
"shortdesc": [39],
"edit.inlines.small-el": [34],
"end-of-sect": [44],
"processor": [41,15,[0,1,2]],
"each": [14,[32,38],34],
"javascript": [[34,35,45]],
"role-field": [44],
"pno": [28,29],
"input": [39,28,43,32,12,34,[11,15,29,33,35,38],[24,26,30,36,37,40,41,44]],
"init-styl": [16],
"com.xmlmind.w2x.processor.processor": [43],
"file.separ": [29],
"must": [[9,35],[10,15,24,29,34,43,44]],
"pnx": [29],
"suppli": [10],
"myborders.x": [16],
"document": [32,[15,34],39,28,44,1,[17,35,40],[3,14,36,38],[9,16,20],[10,13,31,37]],
"zip.out-fil": [26],
"two": [34,[3,16,23,32,41,44]],
"user-defin": [34],
"anyway": [34],
"semant": [34,[1,15,21,24],[3,13,16,22,26,45],[12,14,23,28,35,38,40]],
"found": [43,[13,34],3,15,[2,4,6,10,14,16,17,18,19,20,26,28,38,41]],
"get-styl": [20],
"anoth": [[11,29,34]],
"graphic": [43,3,4,5],
"resourc": [32,[2,3,27,28]],
"latest": [[6,9]],
"think": [44],
"docbook5": [15,28,[12,13,39],23],
"role-footnote-ref": [24],
"high-level": [41],
"docx": [11,[28,32,44],[12,15],[1,5,14,29,43],34,[3,6,13,24,25,26,30]],
"break-column": [44],
"blocks.x": [34,[22,23]],
"quit": [22],
"polish": [[15,16,34]],
"chart": [44],
"definit": [43,22],
"lib": [[3,8,9]],
"lists.x": [34],
"tiff.png": [43],
"prepar": [[16,34]],
"align": [[34,45]],
"frameset_strict": [28],
"set-attribut": [23],
"split-before-level": [38,14],
"structur": [39,1],
"index.html": [40,3],
"has": [2,[1,3,6,7,12,17,18,19,22,23,27,28,32,35,38,40,43]],
"keyword": [21],
"converted.zip": [11],
"actual": [[2,44]],
"given": [34,44,38,[16,22,32]],
"pre": [22,34,39,17],
"last": [[26,31]],
"web.xml": [[10,12]],
"batch": [28,2],
"develop": [28,[11,23]],
"xmlresolver.jar": [3],
"bookmark": [[32,38]],
"warn": [44],
"easiest": [34],
"inlin": [34,20],
"low-level": [41,3],
"page": [38,[35,44],40,[13,14],[11,12]],
"doctyp": [32,[36,39]],
"full": [29,[8,16]],
"becaus": [1,[20,34],[7,15,17,21,22,23,28,32,35,43,44,45]],
"concept": [[29,39]],
"column-numb": [32],
"white-spac": [17],
"init-styles.x": [20,[16,34]],
"edit.do.bord": [16],
"xmlns": [23],
"precis": [1],
"snowbal": [3],
"w2x.jar": [3],
"begin-sdt": [44],
"clariti": [[32,33,34,35,37,38,39,40]],
"yes": [39,34,40,32,[26,38],[13,35],[28,37,41,45]],
"center": [39],
"start": [[32,34],[2,3,14,23,38,44],[6,13,24,26,29,31,36,39,40]],
"equal": [34,[13,14,33,38]],
"headless": [43],
"intenserefer": [34],
"chang": [44,[1,9]],
"anywher": [27,2],
"short": [16,[0,1,2,3,9,26,34,39]],
"lower-case-resource-nam": [32],
"time": [2,[14,15,28,38]],
"combobox": [44,[11,25]],
"pub": [28],
"compris": [[27,35]],
"program": [[22,34,43]],
"c-placeholdertext": [44],
"three": [12],
"caucho": [9],
"unsolv": [23],
"borderless": [34,45],
"metafil": [43],
"conv_manual.bat": [3],
"applic": [2,[3,4],[1,7,12,41],[0,5,8,25,32]],
"patch_manual_restyled.x": [20],
"preced": [29],
"role-section2": [[24,34]],
"quot": [43,34],
"role-section1": [24],
"engin": [3,34],
"tabl": [39,14,[13,34,38,45],32,[6,44]],
"processcommonattribut": [[23,39]],
"unzip": [2],
"x-mlmind": [[12,23,34]],
"smart": [44],
"openjdk": [2],
"manual.css": [19,16],
"editor": [5,6,3],
"manual.epub": [13,[12,14]],
"zip.w2x_plugin": [26],
"mmmm": [44],
"char": [34],
"margin-bottom": [18],
"clip": [44],
"personnam": [44],
"small": [34],
"www.w3": [23],
"remove-pi": [16],
"convert.set-column-numb": [[13,28]],
"uuid": [35],
"major": [9],
"titl": [34,21,[35,40]],
"inspir": [28],
"group": [34,22,23,27],
"external_image_convers": [43],
"suppos": [[11,23,25,29,38]],
"eastasia": [[32,44]],
"format": [43,3,28,[11,15,34,39],[23,32],[1,13,14,25,26,35,44,45]],
"done": [22,[21,24,41]],
"w2x_plugin": [27,26],
"webapps-javae": [9],
"abbrev": [21],
"launcher": [3],
"param-nam": [10],
"request": [12],
"media-alt": [39],
"procedur": [9],
"finish-styles.mathjax": [34],
"part": [[14,26],[5,34,39]],
"processstep.process": [42],
"generat": [[34,39],32,13,38,35,44,[3,14,40],[1,11,15,17,18,19,21,22,23,24,45],[5,10,16,26,31,33,41]],
"their": [[1,15,26,34,43]],
"point": [34,[11,15,32,35,36,39,40,42,43]],
"general": [2,[21,22,23,34],[9,12,32,39,43,45]],
"east": [[32,44]],
"transform.cals-t": [[13,39]],
"style_pattern": [[21,22,34]],
"browser": [[11,34,43],[13,31,32,35,45]],
"title.subtitle-style-nam": [34],
"easi": [[13,18,38]],
"facil": [34],
"process": [34,41,[10,15,16,24,26,45]],
"temp": [38,43,27],
"debug": [15],
"wbmp.png": [28],
"attribut": [34,32,[22,39,44],21,17,[20,24]],
"clear": [[20,22]],
"clean": [[1,13],[22,30]],
"fully_qualified_java_class_nam": [43],
"chive": [8],
"single-pag": [28,34],
"build": [[2,41],26],
"mean": [43,[23,34,44],[2,14,15,21,22,26,28,29,32,38]],
"ms-cp-lastmodifiedbi": [44],
"topic-typ": [39,28],
"further": [[15,23]],
"semi-colon": [27],
"account": [10],
"number-footnot": [16,39],
"processor.parametermap.put": [41],
"been": [[2,23,31],[1,3,20,27,28,30,38]],
"taho": [2],
"part-sect1": [39],
"ident": [[5,15,16,34,41]],
"servlet": [9,8,[7,10,11],12],
"japanes": [32,44],
"addit": [[21,22,34,44]],
"subdirectori": [3,39,[10,23,26,27,30,34]],
"path": [32,39,[2,29,33,35,37,38,43],[27,28,34],9],
"strict": [28,[1,13,16,32,39]],
"abbr": [21],
"you": [2,34,22,[1,15,44],[7,9,13,43,45],[3,14,23,24,25,27,32,38,39]],
"happen": [[13,44]],
"transform.xslt-url-or-fil": [15,28],
"d0e35": [34],
"sequoia": [2],
"pass": [[15,29],24,[16,34,39,45],[21,22,32,38,40,41]],
"add-rul": [[17,20]],
"xhtml_strict.xslt": [39],
"bill": [44],
"especi": [34],
"cours": [31,[1,13,20,44]],
"configur": [[10,41],34],
"nativ": [34],
"for-each": [[20,23]],
"mathjax": [34],
"descript": [39,34,[26,29,32],[25,33,35,37,38,40]],
"organ": [16],
"depict": [15],
"zip_step.jar": [[3,26]],
"jpeg.png.jpg.png.png.jpg.png.jpeg.tif.jpg.tif.jpeg": [28],
"consecut": [34,22,[15,16,45]],
"how": [[0,1],[24,28,43],[4,14,34]],
"snowball.jar": [3],
"index.index-term-separ": [34],
"setup.ex": [2],
"com.xmlmind.w2x.processor.transformstep": [28],
"term": [39,[22,34]],
"server-sid": [7,1],
"leblanc": [0],
"convert.default-lang": [32,44],
"counter-incr": [20],
"right": [[2,44]],
"quotechar": [34],
"end-sdt": [44],
"insid": [[27,37,38,39]],
"answer": [20],
"tif.png.tiff.jpg.tiff.jpeg.tiff.png.wbmp.jpg.wbmp.jpeg": [28],
"maximum": [34],
"wizard": [39],
"inch": [43],
"manual.ditamap": [13],
"dir": [2],
"div": [24,[23,39],34],
"habit": [1],
"plugin.multifileoutput": [26],
"legal": [3,2],
"before-save.x": [[15,34]],
"signal": [44],
"info": [44],
"brows": [[13,38]],
"hyperlink": [39],
"test": [16,[28,36]],
"p-subtitl": [34],
"remove-rul": [20,17],
"out.xhtml": [36],
"take": [11],
"schemas-microsoft-com": [44],
"final": [15],
"system.exit": [41],
"excerpt": [[16,17]],
"some": [[20,34,39],[12,26,28,35,45]],
"blank": [44],
"rather": [34,19],
"back": [39],
"root-topic-id": [39],
"miss": [[34,38]],
"solv": [23],
"load": [36,[15,28],34,[26,39]],
"p-head": [20],
"selector": [20,17],
"just": [26,[32,38,43,44]],
"pixel": [35],
"asid": [[26,34]],
"htm": [31],
"metas.keep": [34],
"dll": [9],
"custom": [23,[16,17,24,34],18,[19,21],[20,22],[1,3,15,26,42,43],[0,25,28]],
"length": [34],
"font-famili": [18,[17,44]],
"monitor": [41],
"home": [27],
"print": [28,[1,2]],
"wmf_converter.jar": [3],
"role-not": [23],
"interpret": [44],
"www.xmlmind.com": [0],
"out-fil": [38,[15,28,31,35,37,39]],
"build.xml": [[8,41],26],
"relat": [39,34,44,[28,35],27,[32,33,37,38]],
"append": [18,[12,32,34,38]],
"dmg": [2,[3,27,28]],
"explain": [[0,1,4,13,21,22,23]],
"smarttag": [44],
"convers": [34,15,12,[22,28,43],[21,26,31,42],[24,30,41],[3,10,11,25,32,44]],
"visibl": [34,15],
"cambria": [44],
"convert": [34,43,39,32,[13,15],[21,22,28,44],[11,24],1,[3,12],[16,17,25,41,45],[14,20,23,26,30,31,38]],
"ignor": [[34,39],2,33],
"attempt": [32,[7,36]],
"assembl": [39,[13,28]],
"text": [34,44,32,[12,21],[3,13,17,19,22,23,26,28,39,45]],
"creat": [34,[14,38],[39,41],[23,26,32],[13,16,17,20,24],[1,5,9,10,21,22,25,30,33,36,37,40,43]],
"made": [32,[13,15,38]],
"web-inf": [[10,12],9],
"maco": [[2,27]],
"field": [44,12,26],
"singl": [[26,34,35,40,43],[1,12,22,42]],
"invalid": [[32,39,44]],
"doc": [41,3,[15,23,29],13,[17,20],2],
"doe": [[1,39,44],[10,13,21,22,40]],
"xslt-url-or-fil": [[15,28,39]],
"w2x": [34,15,[2,13],3,28,23,[1,39,44],[30,32],[12,25,27,41],[0,17,24,26],14,[4,20,29,31,43,45],[8,11,16,18,19,21,36,38]],
"infil": [41],
"java_image_convers": [43],
"java_class_nam": [28],
"server": [2],
"xhtml_loos": [[12,13,28,39]],
"don": [44],
"simple_spec": [34],
"logo.wmf": [43],
"paramet": [34,39,32,40,[15,28,38],[35,43],[10,16,29,31],44,[14,18,21,22,33,37],[12,13,19,23,26,36,41]],
"glob": [33],
"dot": [43],
"skip": [39],
"unfortun": [44],
"overrid": [[23,43]],
"savestep": [41,42],
"mac": [2,[3,27,28,43]],
"deriv": [[15,28,42]],
"style-count": [20],
"file": [[32,39],28,[26,43],34,[11,15,38],29,41,33,[13,37,44],[3,35],1,[2,9,17,18,19,27,40],[5,10,12,21,24,30,36,45],[6,16,22,23]],
"anatomi": [[15,26]],
"pnxi": [29],
"dpi": [43],
"legal.txt": [3],
"map": [39,[13,34],[12,23,28,29,33]],
"may": [34,43,27,[16,25,28],[9,11,15,17,18,20,26,29,32,37,38,39,42,44]],
"webhelp.wh-collapse-toc": [40],
"bookmap.xslt": [39,28],
"menu": [5,6],
"uri": [39,34],
"url": [34,29,[12,23,28,30,35],[32,39,43]],
"urn": [44,[12,23,34,35]],
"widest": [1],
"a-za-z": [32],
"probabl": [5],
"topic-path": [39],
"transformstep": [42],
"mail": [[0,44]],
"docbook.xslt": [39,[21,24]],
"use": [34,39,3,43,28,[2,32],44,[11,13,23],15,[1,20],[4,14,16,26,38],[19,22,25,33,35,41,45],[0,5,8,10,12,17,18,21,24,27,30,36,40]],
"main": [32,[1,16,34],[28,35,36]],
"subtlerefer": [34],
"w2x_plugin_path": [27],
"title.subtitle-contain": [34],
"convent": [16],
"home-mad": [3],
"strip": [22],
"conveni": [[13,38]],
"fine": [[11,22]],
"find": [[23,25]],
"host": [11,1],
"logo": [43],
"utf": [[13,28,32],[11,37],[3,26,31,34,40,43]],
"end-smarttag": [44],
"sort": [44],
"manual.docx": [13,[14,15],12,[17,18,19,20]],
"trash": [2],
"guarante": [34],
"servic": [12],
"forget": [[23,32,34,38,39]],
"task": [39,13,42],
"null": [41],
"cleanup": [[26,28,33]],
"transit": [34,32,[15,16,24,28],[13,26,39]],
"true": [38,32,37,26],
"com.xmlmind.w2x_ext.emf2png.emf2png": [43,28],
"header": [44],
"add-on": [[5,6]],
"style-with-class": [39],
"xhtml_loose.xslt": [39],
"xxe.jstart": [3],
"best": [[9,14]],
"phonet": [44],
"transform": [[15,39],28,24,34,[21,22,23,26,31,33]],
"execut": [15,24,[2,16,41,43],[17,23,28,29]],
"dtd": [[36,39],32],
"ids.section-id-max-length": [34],
"make": [34,[2,9,11,13,18,29,38,39]],
"set-lang": [32],
"abov": [15,[20,22,34],[13,23,26,43],[9,16,17,19,21,28,29,30,41]],
"thread": [41],
"outfil": [41],
"manual_restyled.html": [[19,20],18],
"due": [32],
"conform": [24,35],
"expand-tab": [16],
"underlin": [20],
"wordart": [44],
"merg": [22],
"migrat": [9],
"curl": [12],
"inform": [[3,20,26,34,35,44]],
"depend": [[11,15,39,41]],
"form-data": [12],
"about": [[2,3,9,32,43],[13,15,20,22,26,34,35,41,44,45]],
"bookmap": [39,28,13,[12,23,33,34]],
"yyyi": [44],
"xslt_url_or_fil": [28,24],
"cover": [35,44],
"param_nam": [28],
"unoconv": [43],
"meaning": [34],
"section-depth": [39,13],
"text-align": [39],
"august": [44],
"edit.do.expand-tab": [45],
"shortdesc-class-nam": [39],
"add-index": [39,40],
"wmf2svg.jar": [3],
"in_docx_filen": [28,2],
"meta": [34,32,44,13],
"declar": [32,[13,43]],
"except": [44,[22,28,38]],
"programm": [15],
"libreoffic": [43],
"fact": [15,[22,43]],
"split.split-before-level": [[14,38]],
"global": [34,35],
"long": [[9,32]],
"bmp.jpg.bmp.jpeg.bmp.png.gif.jpg.gif.jpeg.gif.png": [28],
"bewar": [9],
"into": [34,22,[38,40],[13,14,15,16,35]],
"com.xmlmind.w2x_ext.wmf_converter.wmfconverterfactori": [43,28],
"unless": [31,[22,34,38]],
"pre-element-nam": [39],
"defin": [34,16,12,[23,29,30]],
"free": [40],
"mix": [[2,44]],
"convert-tabs.unwrap-paragraph": [34],
"redirect": [34],
"plug-in": [[3,27]],
"notes.x": [23],
"though": [[9,15,34]],
"appendix-sect1": [39],
"script_nam": [16],
"non-mod": [5],
"progress": [41],
"oper": [[10,20,44]],
"open": [2,44,[1,5,12,22,40]],
"converted-image-extens": [32],
"treat": [13],
"com.xmlmind.w2x.processor.editstep": [28],
"prepend": [32],
"project": [44],
"whatev": [[15,44]],
"webhelp.wh-layout": [26],
"sever": [[11,32,38],[22,23,35,40]],
"loos": [32],
"c-footnoterefer": [18],
"evalu": [13,5],
"enclos": [44],
"invers": [[20,34]],
"expand-tabs.j": [[35,45]],
"look": [13,[1,15,24]],
"repres": [[2,34]],
"omml2mml.xsl": [44],
"expand-tabs.x": [16],
"loadstep": [42],
"internet": [2],
"allow": [34,[1,17],[3,14,19,20,23,31,32,35,38,39,45]],
"processing-instruct": [34,32],
"control_id": [44],
"binari": [8],
"edit.after.bord": [16],
"proper": [[1,2,15]],
"rule": [17,20,19],
"detect": [44,32],
"everi": [15],
"mml": [32],
"w2x_rt.jar": [3],
"common": [34,22],
"appli": [15,[16,34,43]],
"edit2": [28],
"linux": [2,[27,32,43]],
"parameter_nam": [[16,43]],
"p-note": [23],
"emf.png.wmf.png": [43,28],
"xhtml_element_qnam": [34],
"writabl": [10],
"layout": [44],
"edit.after.block": [23],
"manual-n.xhtml": [14],
"processor.steplist.add": [41],
"step": [28,15,34,31,[24,26],38,[33,39],[30,32,36],[16,21,22,35,40,42],[17,37,44],[3,20,41]],
"comment": [[26,44]],
"p-placehold": [34],
"mark": [34],
"base": [[3,32,34]],
"stem": [3],
"intermedi": [34,33],
"plugin.nam": [26],
"prefix": [34,32,[38,39],[15,16,17,21,22,23,30,33,35,37,40,44]],
"role-index-term": [39,24],
"find-rul": [20],
"whole": [34],
"xmlmind.com": [0],
"add-class": [[17,20]],
"consist": [30],
"grammar": [44],
"rambouillet": [0],
"convert.xhtml-fil": [15,26],
"processor.parametermap": [41],
"my.zip": [25],
"zip": [26,11,3,[2,12,25],8],
"profession": [13],
"val": [[32,44]],
"still": [[2,15]],
"text-ind": [18],
"work": [39,[34,35],22,[11,14,27,28,33,37,38]],
"webhelp_loos": [28],
"fail": [44],
"itself": [2],
"math": [32,44,28],
"word": [1,[3,7],[5,6],[0,2,9,10,13,26],[8,11,12,14,16,27,28,34,41,43]],
"introduction.dita": [34],
"biblio.style-nam": [34],
"requir": [39,2,[1,12,21,22],[14,15,16,23,33,34,35,37,38]],
"report.xml": [29],
"eas": [34],
"finish-styles.x": [34,16,[18,19,20]],
"simplest": [[15,24,44]],
"p-code2": [34],
"emf.svg.wmf.svg": [43],
"loui": [0],
"abstract": [[1,15,42]],
"p-code1": [34],
"rss.xslt": [26],
"sample_plugin": [26,3,27],
"epub3": [12],
"cannot": [35,[1,2,32,41]],
"epub2": [12],
"epub1": [28],
"first": [[2,15],32,[9,23,28,29,31,33,34,44]],
"role-document-titl": [34],
"allow-lonely-head": [38],
"span": [44,34,[22,45],32,[21,35,39],24],
"prefer": [2,[13,26]],
"float": [20],
"space": [34,[32,37,38]],
"spec": [34],
"simpl": [34,[22,26],[11,13,21,23,37,38,41,44]],
"webhelp2": [12],
"webhelp1": [28],
"from": [[2,34],[28,44],[1,3,15,16,17,22,35,40]],
"html": [38,13,[12,32,39],[28,34],[14,26],[20,23,35],[17,31,40,45]],
"webhelp3": [12],
"custom.css": [[18,19],20],
"spell": [44],
"you\'ll": [2,[25,34]],
"bottom": [20],
"templat": [23,39,1],
"moreov": [2,[13,15,19,38]],
"fals": [38,32,37,[25,26]],
"p-abstract": [39],
"impli": [43],
"img": [39],
"interact": [12],
"error": [3],
"number-footnotes.x": [16],
"platform": [[2,29,32]],
"plugin.outputdescript": [26],
"webhelp.out-fil": [26],
"public": [2,0],
"array": [41],
"parameter": [[3,28]],
"input_file_extens": [43],
"track": [44],
"padding-top": [44],
"webhelp5": [26,[14,28]],
"in_docx_file1": [28,2],
"instead": [34],
"p-shortdesc": [39],
"command": [[20,34],[2,13,17,22,23],[12,15,41,43]],
"set-column-numb": [[32,39]],
"int": [41],
"unlik": [[39,43,44]],
"stricttask": [39],
"serif": [18],
"biblio.x": [34],
"perman": [35],
"negat": [43],
"break-pag": [44],
"before-save.allow-flow": [34],
"w2x_servet": [8],
"wmfconverterfactori": [43],
"epubcheck": [32],
"sorta": [44],
"temporari": [[10,32]],
"describ": [41],
"poor": [34],
"xhtml_css": [28,[12,30]],
"double-click": [2],
"absent": [36],
"c-strong": [34],
"instruct": [[2,5,6,15]],
"appendix": [39],
"liststep": [28,15,2],
"concat": [20],
"url_or_fil": [28],
"version": [2,32,39,9,[13,28],[5,6,23]],
"report.docx": [29],
"plugin.outputextens": [26],
"folder": [2,[9,32],10],
"stop": [45,34,[35,44]],
"detail": [15],
"convert-tabs.to-t": [34],
"least": [9],
"manual": [41,13,3,[15,23],[14,17,20,34],[0,2,12,44]],
"title.title-contain": [34],
"wlang": [[32,44]],
"machin": [1],
"behavior": [[34,38]],
"webhelp": [13,[12,14,28,40]],
"learn": [[9,15,24,28]],
"abl": [3],
"invok": [34,[16,20,41],[22,23,25,26]],
"doc_fil": [43,32],
"role-sect": [39,34],
"chapter-sect1": [39],
"basenam": [38,[26,43],[16,28,32,34]],
"possibly_quoted_parameter_valu": [43],
"specif": [34,43,1,[22,44],[21,26,35,40]],
"act": [39,13],
"use-id-as-filenam": [38],
"post": [12],
"p-programlist": [22,17,[16,34]],
"rel": [19],
"sampl": [34,[3,41]],
"http-equiv": [[13,32]],
"add": [39,28,32,[17,34],[5,30,37,38]],
"need": [3,2,[8,13,38],[5,9,14,15,20,28,32,34]],
"pose": [42],
"often": [[23,34,38]],
"equival": [34,43,44,[27,28,29,30]],
"els": [[21,22,23,38,41]],
"article-sect1": [39],
"respect": [34],
"rfc": [35],
"manual-toc.xhtml": [13],
"referenc": [[2,9,27,32,34]],
"port": [11,1],
"altern": [[4,27,34]],
"http": [23,12,11],
"tomcat_install_dir": [9],
"emb": [41,32,[0,1]],
"title-styled.x": [16],
"emf": [43,44],
"prevent": [[35,40]],
"softwar": [[1,8,11],[0,5,41]],
"end": [[22,39,44],[19,32,34]],
"docbook": [39,13,34,[21,23],28,[1,12,15,16,22,32,44,45]],
"footnot": [39],
"modifi": [29,17,43,[15,20,34]],
"transform.out-fil": [[15,28],26],
"otherwis": [[32,34],[20,28]],
"get-rul": [20],
"shafi": [[0,44]],
"label": [39,23],
"howev": [38,[1,2,5,11,23,27,32,34,35,39,43,44,45]],
"foo-toc.html": [38],
"special": [26],
"numer": [39],
"edit.xed-url-or-fil": [15,[28,30,41]],
"directori": [39,27,[32,38],[2,10,13,28,33,34],[3,35],[8,9,23,26,29,30,37,43]],
"emf2png": [43],
"smaller": [[18,34]],
"role-footnot": [24],
"tomcat": [9],
"captions.style-nam": [34],
"properti": [[17,44],[27,28,29,43]],
"number": [34,[15,39,43],[1,2,10,16,17,20,24,26,28,32,38,44]],
"identifi": [35],
"specifi": [34,39,32,38,28,43,37,33,[10,18,23,30,31,35,41,44],[12,14,15,19,22,40]],
"leverag": [[16,34,43]],
"jane": [28],
"invis": [34],
"similar": [[23,34]],
"shape": [44],
"in_docx_fil": [[2,28,29]],
"dcterm": [34],
"script": [16,34,[3,15],23,20,[17,28],[22,24],[18,19,21,26,35,36,44,45]],
"edit.before.finish-styl": [[16,17,20]],
"exit": [28,2],
"system": [3,[10,27,28,29,44]],
"openxml": [44,32],
"issu": [[2,39,44]],
"partial": [44],
"padding-right": [44],
"other": [34,[29,39],[13,44],[3,12,14,15,25,28,32,40,45]],
"aim": [1],
"cell": [32,34],
"local": [39],
"date_util.jar": [3],
"crude": [44],
"valid": [32,[1,15],13,[30,37,39]],
"pictur": [44,3],
"interfac": [43],
"locat": [34,[18,23,30]],
"counter-reset": [17],
"sections.x": [34],
"share": [[32,41]],
"givennam": [44],
"output-path": [39,28],
"template_topic.xslt": [23],
"output_file_basenam": [32],
"tc-tablegrid": [44],
"notic": [[6,21,22,34]],
"args.length": [41],
"inlines.s-el": [34],
"exampl": [34,[39,44],43,[29,32],[22,28],[14,21,24,26,27],[12,15,16,17,18,23,25,38,41],[1,2,3,9,10,19,20,33,35,36,40]],
"cite": [34],
"w2x_install_dir": [41,23,26,20,15,[16,22,27],[2,13,17,21,24],[4,18,19,35,45]],
"namespac": [23,34],
"screen": [25],
"correspond": [[17,38,44]],
"mergeformat": [44],
"mode": [[2,5]],
"jre64": [2],
"in-memori": [28],
"etc": [34,[1,40,43],[2,24,28,32,35,45]],
"resource-prefix": [32],
"all": [34,44,[3,39],43,28,20,[15,19,22,26,27,38,40,45],[5,10,11,13,16,23,24,29,35]],
"border": [16,[15,20,34]],
"new": [41,14,38],
"escap": [43],
"read": [15],
"below": [34,[5,15,22,25,39,43]],
"alt": [39],
"choos": [[11,44]],
"rememb": [39],
"real": [43],
"com.xmlmind.w2x.docx.image.imageconverterfactoryimpl": [43,28],
"programmat": [[13,38]],
"tool": [[1,3,12,24]],
"non-nest": [39],
"role-tab": [45,[35,44]],
"alreadi": [[2,31,32],[13,21,22,38,40]],
"vvv": [28,2],
"remove-class": [[17,20,23]],
"docbook-vers": [39],
"therefor": [[2,15],[5,17]],
"bodi": [39,[17,18,20,23]],
"unix": [3],
"indent": [[37,38],30],
"simpler": [16],
"p-bibliographi": [34],
"resolv": [3],
"unparsed-styl": [[20,34]],
"borders.x": [16],
"and": [34,44,[15,23],32,[2,29],[26,39],[3,22,38],[13,20,21,28],[1,9,10,16,41],[0,11,12,14,25,35,43,45],[6,7,27,30,31,40]],
"xhtml-file": [32,[15,31,34]],
"row": [6],
"obsolet": [[13,38]],
"ani": [34,39,[2,32,43],[3,16,22,28,29],[1,9,13,14,23,35,38,45]],
"render": [34],
"custom_topic.xslt": [23],
"ant": [41,[8,26]],
"p-normal": [44],
"c3%": [43],
"xslt": [39,23,15,24,[3,21,28],[22,26,34,44],30],
"reason": [1],
"font-weight": [34],
"ship": [43],
"compon": [7,[1,3]],
"java": [2,43,41,[3,28],[1,8],26,[0,7,11,15,27,29,44]],
"exe": [3],
"english": [44],
"jar": [[3,11,26]],
"mistak": [34],
"api": [[3,41]],
"app": [2],
"set-styl": [[17,20]],
"zipstep": [26],
"code2": [34],
"code1": [34],
"appl": [2],
"frameset_loos": [28],
"recommend": [32,[27,34,41]],
"default": [34,39,32,38,35,43,40,37,[10,13,14,17,26,28,30,33,41,45]],
"rss": [26,[3,25,27]],
"processor.steplist": [41],
"are": [34,44,39,[15,43],[1,3,10,28,32,38],[31,40,45],[5,7,12,14,16,18,19,26,29,33,37,42]],
"arg": [41],
"where": [[1,3,10,17,18,19,20,32,37,38,43]],
"popular": [1],
"arm": [2],
"get-class": [20,23],
"art": [44],
"p-term": [[22,34]],
"webhelp.use-id-as-filenam": [26],
"suppress": [[1,34]],
"nest": [[13,34,39]],
"processor.configur": [41],
"acut": [43],
"jdk": [11],
"call": [[15,24],34,[25,28],[17,26,41,43,44]],
"such": [34,44,[9,11,23,24,35,40,42]],
"plugin": [26,27,25,3,28],
"frameset3": [12],
"frameset2": [12],
"frameset1": [28],
"ask": [[2,7]],
"principl": [2],
"rue": [0],
"enref": [32],
"run": [3,2,[11,34,41],[5,8,9,10,45]],
"microsoft": [1],
"worri": [2],
"webhelp.omit-toc-root": [26],
"either": [17],
"yourself": [34],
"discov": [26],
"those": [34,[32,41]],
"examin": [32,[35,44]],
"dure": [[10,26,34]],
"bold": [[23,34]],
"effici": [20],
"privat": [2],
"name": [34,39,28,32,26,15,[11,12,16,17,33,35,37,38,40,44],[21,22,23,27,29]],
"non-system": [3],
"next": [9],
"import": [5,[15,23],[6,14,38]],
"string": [34,32,[5,13,29,35,39,40,41]],
"color": [[18,44]],
"submit": [44],
"parse-styl": [[20,34]],
"xhtml5": [13,39,[12,28]],
"book": [35,39,13],
"non": [12],
"button": [14],
"comput": [2,34,[9,35,45]],
"not": [32,39,[34,44],[23,38,43],[1,2,7,13,20,22,29],[5,10,11,14,15,16,17,21,26,28,30,31,35,36,37,40,41,45]],
"finish-styles.mathjax-url": [34],
"introduct": [1],
"now": [6],
"xhtml1": [39,[12,28]],
"webhelp_strict": [28],
"emphasi": [34],
"was": [[32,36]],
"title.keep-titl": [34],
"war": [[8,9]],
"greet": [44],
"com.xmlmind.w2x.docx.image.imageconverterfactori": [43],
"way": [34,[32,38],[13,14,37,44]],
"xhtml": [34,28,13,32,21,[15,22],39,17,[23,24],[1,14,16,26,35],[20,38,45],[3,18,30,31,37,40,41,44]],
"target": [[22,34]],
"what": [22,21,34],
"refer": [39,[3,9,14,15,32,41,42,43]],
"colon": [43],
"window": [2,43,3,[4,9,27,29,32,37,44]],
"edit.blocks.convert-to-pr": [34],
"discard": [[22,39]],
"siames": [34],
"cals-tabl": [39],
"edit.inlines.b-el": [34],
"when": [34,32,[38,39,44],[22,28,29,35,45],[2,3,5,15,17,33]],
"assembly.xslt": [39],
"sequenc": [15,34,[16,43]],
"role-figcapt": [24],
"embed": [[19,41],[1,17,18]],
"zip.include-top-dir": [25],
"greater": [34,43],
"case": [[21,22],[23,39],[1,15,34,35,41,43,44,45]],
"transform.single-top": [28],
"give": [34,[15,20,26,32,35,45]],
"item": [[5,34],[6,44]],
"multipl": [13,26],
"main-styled.x": [34,[16,30],[15,41]],
"p-titl": [34],
"modul": [39],
"index-sort-a": [44],
"patch_manual.x": [16,17],
"consid": [34,32,[31,43,44]],
"w2x_image_convers": [43,28],
"ids.x": [34],
"phone": [0],
"call-templ": [[23,39]],
"title.title-style-nam": [34],
"everyth": [3],
"style": [34,17,[22,38],[12,18,21,28,39],[15,16,20,35],[1,14,19],[13,23,44],[3,24,30,32,40,45]],
"inlines.sub-el": [34],
"output_file_extens": [43],
"implicit": [23],
"hussein": [[0,44]],
"role-figur": [24],
"direct": [34,[2,20,39,41]],
"pattern": [[32,33],[21,22,34],20],
"transform2": [28,[13,39]],
"compil": [40,[3,41],26],
"caus": [[32,34,44],[11,22,39]],
"modern": [[35,45]],
"web": [40,28,[3,13,14,26,31,34,43],[0,11,32,35,38,45]],
"w2x-app.ex": [3],
"older": [[9,39]],
"protect": [44],
"footnote-number-format": [39],
"more": [34,28,43,[1,20,22,29,35]],
"display": [20,[5,6,11,34]],
"interchang": [1],
"great": [[14,32,34,43]],
"command_lin": [43],
"usag": [[2,28]],
"width": [20,[35,45]],
"add-xml-lang": [39],
"saxon.jar": [3],
"certain": [34],
"default-lang": [[32,35]],
"en-us": [44],
"wh5": [26,3,25],
"whitespac": [[34,37,38]],
"section": [39,34,44,[13,21,22]],
"frameset5": [28],
"simpli": [[2,13,15,18,26,34]],
"few": [[26,34]],
"codeph": [21],
"transform.shortdesc-class-nam": [39],
"kind": [34,[16,43]],
"usabl": [34],
"both": [[23,34],[16,20,27,30,44]],
"most": [2,[1,11,15,16,44]],
"resin": [9],
"transfer": [12],
"effect": [22],
"keep": [34,39,32],
"specification_list": [43],
"topic": [39,13,23,[12,28,33,34]],
"xhtml_strict": [[12,13,28,39]],
"whi": [[20,32,44]],
"non-empti": [32],
"c-booktitl": [34],
"shtm": [31],
"omit": [39,[32,33,34,35,37,38,40]],
"fallback": [38],
"option": [28,15,23,13,[12,29],34,[2,30,45],[6,16,18,19,24,41]],
"self-contain": [3],
"goback": [32],
"launchpad": [2],
"init-param": [10,12],
"insert": [32,[13,16,43]],
"indexterm": [44],
"toc123": [32],
"reject": [44],
"whc.jar": [3],
"messag": [3],
"convert-tabs.x": [34],
"edit.inlines.convert": [21,16],
"font-siz": [20,[17,18,34]],
"move": [2],
"nxo": [29],
"padding-bottom": [44],
"also": [[12,26,38],[1,3,5,16,17,21,22,27,28,34,43]],
"differ": [[2,39],[34,41]],
"consol": [3],
"wh-local-jqueri": [40],
"favor": [32,44],
"various": [44],
"archiv": [26,[11,12]],
"a9": [43],
"front": [39],
"w2x-support": [0],
"user": [34,[16,24,27,28,31,44],3],
"extent": [44],
"parent": [34,[22,28],[23,29,30,43,44]],
"title-styl": [16],
"extens": [43,[20,32],[26,29],[13,16,28,31,42]],
"custom-styles-url-or-fil": [34,18],
"complet": [1],
"step_nam": [28,31,16],
"blocks.convert": [[22,34],23],
"fix": [39],
"complex": [44],
"jre": [2],
"mkdir": [13],
"apply-templ": [[23,39]],
"w2x_math_converter_xslt": [44],
"posit": [43],
"sure": [[2,11]],
"ad": [[31,32,45],[20,35,41]],
"parametr": [28],
"reus": [41],
"inlines.convert": [[21,34]],
"create-mathml-object": [32],
"automat": [34,32,[13,14],31,[18,19,22,30,38],[1,2,3,5,23,26,28,39,40,44]],
"an": [39,34,43,[28,32],[35,38,41],[3,14,17,23,44],[1,2,5,12,13,15,19,20,24,30,40],[6,7,21,22,26,36]],
"subsect": [39,13],
"finder": [2],
"ar": [8],
"automatic-id": [32],
"as": [38,[32,34,39],13,[26,35,43],[5,6,8,15,25,37,40,41],[1,2,3,7,11,16,17,19,22,24,27,28,31,36,44,45]],
"at": [43,39,[2,9,13,22,34,38]],
"edit.do.title-styl": [16],
"schema": [44,24,1],
"bb": [44],
"strong": [34,[27,32,41]],
"be": [34,39,43,[2,32],[3,15,22,35],[9,10,16,25,28,37,38],[1,4,11,14,17,18,19,20,24,27,29,31,33,41,42,44,45]],
"icon": [2],
"remove-styles.preserved-class": [34],
"delet": [[23,33],2,[20,34]],
"javadoc": [[3,41]],
"wmf": [43,[3,44],32],
"see": [34,43,39,[3,13,15,23,25,29,38,42,44]],
"by": [34,32,[23,26],[2,29],[3,41],[39,43],[16,17,20,21,28,31,44],[10,13,22,35],[15,24,27,30,38],[1,5,9,12,33,36,40,42,45]],
"epub": [35,[12,14,28],[11,13,34],[31,38]],
"franc": [0],
"cd": [[2,13]],
"blocks.convert-to-pr": [34],
"fli": [38],
"contain": [[34,39],[3,13],28,22,[9,32],[11,26],[8,12,38],[17,20,27,44],[10,23,35],[2,5,6,14,15,18,19,29,40,43,45]],
"set": [32,34,44,[20,27],[28,35,40,43]],
"incorrect": [[11,32,44]],
"column": [32,44],
"note_group_memb": [23],
"attribute_spec": [34],
"e2": [[28,30]],
"figur": [15],
"user-specifi": [32],
"my_script.x": [36],
"apach": [9,41],
"foo.html": [38],
"font": [34],
"dc": [34],
"dd": [22,34],
"de": [35],
"featur": [44,[13,38]],
"offic": [44],
"dl": [22,34],
"forc": [2],
"extern": [43,19,[32,34]],
"do": [16,39,34,[7,22,23,32,38],[1,11,13,21,24,29,37,40]],
"itlechar": [34],
"dt": [22,34],
"outlin": [[14,38],34],
"startup": [26],
"contact": [44],
"useless": [[13,22,23]],
"eb": [8],
"digit": [2],
"which": [39,34,32,13,23,[15,30,43,44],[2,3,7,11,14,16,18,19,20,21,22,25,26,27,33,35,38]],
"set-rul": [20,17],
"signific": [[15,28,34,37,38]],
"ei": [43],
"em": [34],
"en": [32,35],
"she": [44],
"never": [44],
"multipart": [12],
"compat": [6],
"role-document-subtitl": [34],
"frame": [38,13],
"compar": [44],
"foo": [38,24,[22,29]],
"for": [[34,39,44],23,32,[35,43],[1,2,14,22],[5,13,15,21,26,33,38,40],[0,3,7,12,20,25,27,28,29,37,41,42]],
"h1": [34],
"h2": [34],
"h3": [34],
"h4": [34],
"sect2": [39],
"h5": [34],
"sect1": [39],
"content": [20,14,[32,38],[1,3,13,34],[2,8,10,27,28,44]],
"h6": [34],
"random": [[5,13]],
"sect5": [39],
"sect4": [39],
"desktop": [[2,7],[1,25]],
"sect3": [39],
"class": [39,24,34,20,44,23,[3,16,17,42,43,45],[15,28,35,41]],
"over": [32,44],
"someth": [[23,30,34,44]],
"go": [[15,23]],
"counter": [20],
"kept": [34],
"border-bottom": [18],
"form": [[11,12],1],
"removes-styles.x": [34],
"publish": [1],
"xmlmind": [3,5,[0,2,6,40],[1,13],[16,27,28,34,41,43]],
"hierarchy-nam": [39],
"setup": [25],
"headings.x": [34],
"dc.subject": [34],
"gate": [44],
"tp-tablegrid": [44],
"p-caption": [34],
"prompt": [2],
"he": [44],
"hh": [43],
"big": [34],
"select": [11,6],
"bin": [13,2,[3,14],15,[4,28]],
"custom.c": [20],
"easili": [1,[9,23]],
"bit": [2],
"output": [28,[13,26],[3,5,11,15,23,29,34,35,38,43,45],[0,1,17,24,25,30,41]],
"veri": [13,[2,15,23],[1,34,37,38,44]],
"edit.prune.preserv": [[16,22]],
"autom": [[1,41]],
"css-uri": [19],
"drag": [2],
"id": [34,22,[23,38,39],13],
"join": [34],
"blockquot": [34],
"literallayout": [39],
"if": [39,32,34,[13,43],2,[23,31,38],[20,22,28,36,40,45],[3,7,9,10,11,14,15,21,27,30,41,44]],
"xedscript": [3],
"non-ascii": [11],
"save.out-fil": [28],
"in": [34,15,43,[2,32],3,41,38,[13,22,44],[17,21,23,26],[1,10,28,35,39],[5,8,9,11,14,20,25,29],[4,6,12,18,19,24,27,30,45],[0,16,37,40]],
"manual.xhtml": [13,15,14],
"termin": [2],
"index": [39,44,34,46],
"is": [34,32,[39,43],38,[28,29],44,[13,35],[2,22],[3,14,15,20,23],[1,21,33,41],[26,27],5,[9,24,30,37,40,45],[4,10,12,16,31,36],[6,7,11,17]],
"mathml": [32,34,44],
"it": [1,32,34,[15,26,43],[13,17,27,38,41,44],[7,10,28,33,45],[2,4,5,6,8,11,12,16,18,20,22,23,25,29,35,39]],
"workdir": [10],
"ja": [32,44],
"john": [27,[16,24],44],
"com.xmlmind.w2x.docx.imag": [43],
"paragraph": [34,22,23,[15,16,17],[1,14,38,45]],
"charset": [32,[13,31]],
"librari": [3,[8,12]],
"valu": [34,[39,43],[22,29],[21,28,32],[26,35,38,40],[10,14,20,33,37]],
"inlines.i-el": [34],
"amaz": [1],
"bm3": [32],
"attribute_nam": [[21,22]],
"ms-outlinelvl": [44],
"ko": [32,44],
"add-toc": [39],
"break": [44,[9,34]],
"themselv": [39],
"raster": [43],
"metas.x": [34],
"case-sensit": [32],
"off": [38,32,[26,34,37]],
"report": [29],
"li": [34,16],
"wmf.svg": [43,28],
"ll": [34,[13,22,23,32,38,39,43]],
"expans": [35],
"lookup-styl": [20],
"auto": [[32,34]],
"lists.alternate-ordered-list-group": [34],
"bmp": [44],
"sign": [2],
"in.xhtml": [36],
"while": [[1,13,20,38]],
"suffix": [26],
"convertstep": [41],
"second": [[11,23]],
"resource-directori": [32],
"that": [34,[2,43],[22,32,44],29,[14,28],[1,5,13,21,38,39],[3,6,7,9,11,26,27,35,36,41,42,45]],
"download": [2,[6,11]],
"out_fil": [31,[2,28,29]],
"split": [12,38,[35,40],[14,31]],
"than": [34,[3,44],[19,43],[1,4,13,14,29,38,39]],
"limit": [[32,44],17],
"dita": [39,34,[13,21],[23,28],[1,16,22,32,33,41,44,45]],
"entri": [44,[15,34]],
"level": [[14,34,38]],
"author": [[1,34,35,40]],
"ms": [44],
"w2x_trace": [28],
"restyl": [1],
"my": [29,44],
"plus": [[35,40]],
"disk": [[15,28,32,37,38]],
"border-bottom-width": [18],
"ni": [[29,43]],
"edit.finish-styles.css-uri": [[16,19,20]],
"no": [39,34,26,32,[1,35,40],38,[28,37,43,44],[13,15,33,36,42]],
"code": [21,34,32,[3,35,45],[8,26,44],[16,41]],
"seal": [34],
"box": [5,[6,44]],
"nx": [29],
"vnd.openxmlformats-officedocument.wordprocessingml.docu": [12],
"decent": [[35,45]],
"head": [38,12,[14,34],20,[13,17,32]],
"dialog": [5,6],
"dw2x_plugin_path": [27],
"of": [34,39,32,43,38,[15,29],26,44,41,[2,16,22],[3,17,28,35],[13,14,20],[12,23],[1,8,9,21,30],[5,11,37],[10,31,33],[0,6,7,18,24,25,27,36,40,42]],
"bundl": [2],
"possibl": [39,34,45,[12,13,15,16,20,21,22,28]],
"inlines.x": [34],
"attribute_qnam": [34],
"ok": [[6,14]],
"dynam": [[10,35]],
"ol": [[16,34]],
"on": [2,12,3,43,38,[11,32,34],[9,20,29],[1,13,15,26,27,28,37,39,44,45]],
"macro": [[1,44]],
"suffic": [22,[17,21,42]],
"purpos": [[13,34]],
"technic": [42],
"or": [34,28,39,44,32,33,29,1,[2,16,26,35,43],[11,14,17,19,27,31,38,41],[12,21,22,23,24,40]],
"src": [8,[3,26]],
"control": [43,44],
"title_of_this_sect": [34],
"encod": [37,[11,32],[3,12,13,26,34,40]],
"mytask": [13],
"offici": [2],
"easier": [3,4],
"pi": [[29,43]],
"mailto": [0],
"pn": [29],
"po": [26,[28,43]],
"metadata": [1],
"inlines.sup-el": [34],
"pu": [[16,29],[20,28,31],[15,17,18,19,23]],
"edit.blocks.convert": [22,[23,34,39]],
"finish.x": [22],
"main.x": [15,34,[24,26],[16,28]],
"environ": [27,[2,9,28,43,44]],
"factori": [43],
"style_nam": [[21,22,34]],
"conv_manual.sh": [3],
"manual.html": [[13,17],14],
"recent": [2],
"generaltask": [39],
"they": [31,[16,28,34]],
"edit.convert-tabs.to-t": [45],
"secondari": [44],
"webhelp.split-before-level": [[14,26]],
"after-translate.x": [15],
"edit": [34,15,[13,24,28],[21,22],[5,16,17,20,26,41]],
"ms-word": [[34,44],32,14,1,38],
"them": [15,39],
"then": [43,[9,15,32],[2,22,44],[21,23,24,36,39]],
"cleanup.fil": [26,28],
"out_file_with_an_xhtml_extens": [31],
"third-parti": [3],
"accept": [44],
"node": [17],
"includ": [2,[5,26,43]],
"ri": [43],
"ole_link": [32],
"t2": [[28,30]],
"minut": [11],
"sub": [34],
"access": [[20,44]],
"end-us": [7],
"languag": [32,44,35,3],
"sup": [34],
"workaround": [44],
"xpath": [20],
"current": [39,34,[28,35],[27,33,37,38]],
"vector": [43],
"conjunct": [32],
"sn": [44],
"email": [[0,1]],
"silent": [39],
"intern": [34,20],
"onc": [[1,25]],
"svg": [43,32,[3,44]],
"one": [34,32,[20,43],[12,14,19,22,23,26,28,29,41,44]],
"ids.generate-section-id": [34],
"launch": [2],
"store": [34,[2,10,32]],
"delete-text": [23],
"stori": [9],
"outdir": [43],
"confirm": [2],
"td": [44],
"remov": [34,16,[13,20,22]],
"assist": [25],
"my.docx": [25],
"to": [34,39,32,[43,44],3,2,15,28,13,1,22,[21,24,38],[11,45],9,[14,23],[17,35,41],[7,12,16],[0,6,8,20,29],[5,27,33,40],[4,10,18,19,25,26,36],37,[30,31,42]],
"vast": [[32,44]],
"typic": [35],
"v4": [39],
"v5": [[15,39]],
"but": [34,[32,43],13,[3,11,14,15,17,19,28]],
"webapp": [9],
"p-heading6": [18],
"tt": [34],
"p-heading5": [18],
"loader": [36,39],
"express": [32,[34,43]],
"c-code": [21,[16,34]],
"com.xmlmind.w2x.processor.convertstep": [[28,42]],
"remove-pis.x": [[16,34]],
"drawback": [1],
"w2x-app": [3,4,2,[5,25],[7,26,27,39]],
"w2": [[9,16]],
"up": [[15,16,19,22,34]],
"written": [44,32],
"p-heading2": [18],
"p-heading1": [18],
"p-heading4": [18],
"us": [[22,23]],
"p-heading3": [[18,44]],
"sections.max-level": [34],
"p-definit": [[22,34]],
"unstyl": [[1,13,15]],
"this": [34,32,38,[28,43],35,39,26,[13,15,23],[20,22,44],[2,36,40,41,45],[1,3,9,33,37],[5,6,10,11,14,16,24],[4,8,17,18,25,27]],
"verif": [2],
"processor.process": [41],
"com.xmlmind.w2x.docx.image.externalimageconvert": [43],
"substitut": [29],
"opt": [28],
"extract": [1],
"vm": [2],
"hint": [[32,44]],
"support": [3,44,43,[11,28,39],[2,21,22,23,25,26,30,34]],
"vs": [28],
"drop": [[2,44]],
"vv": [[15,28],2],
"edit.metas.keep": [34],
"w2x_app_help": [3],
"extractor": [11],
"we": [23,[15,44],[13,14,38]],
"wh": [40],
"prune.x": [34,22],
"param": [12],
"kit": [11],
"rss.w2x_plugin": [26],
"normal": [13],
"xed_url_or_fil": [28,24],
"org": [23],
"distribut": [2,8,[3,5,27,28]],
"c-abbrev": [21],
"xe": [44],
"behav": [36],
"exclude-result-prefix": [23],
"xi": [29],
"convert.create-mathml-object": [28],
"param-valu": [10],
"succeed": [11],
"redund": [23],
"embed2": [41],
"embed1": [41],
"runtim": [2,3],
"sourc": [[3,14],[1,8,44],[12,38,40]],
"yomi": [44],
"none": [[30,32,35]],
"type": [12,39,[17,19,32,34]],
"convert.set-lang": [32,44],
"problem": [23,42],
"children": [44],
"xed": [34,15,16,23,[20,22],[3,17,24,28],[26,30],[18,19,45],[21,35,36,41]],
"cross-refer": [39],
"filenam": [34,[11,35],[28,32]],
"epub.split-before-level": [[12,14]],
"conv": [12],
"href": [[19,23]],
"xhtml_element_nam": [[21,22]],
"processor.executestep": [41],
"between": [[38,44],[9,14,39]],
"stylesheet": [23,39,24,[26,44],[3,15,21,22,28],[19,34]],
"phase": [26],
"method": [41,20,[42,43]],
"come": [[2,3,8,11,16,34,44]],
"gdi": [43],
"zh": [32,44],
"exist": [32,[1,10,13,28,34,38,39,40]],
"tembed1": [41],
"tembed2": [41],
"imageconverterfactori": [43],
"regist": [[25,27],[3,43]],
"henc": [32,[16,43]],
"copi": [9,[2,3,23,27,32]],
"out": [13,15,14,29,19,[1,3,17,18,20]],
"inlines.tt-el": [34],
"get": [[13,28,31,32,34]],
"manual_restyled_css": [19,20],
"inkscap": [43],
"place": [28,[15,34]],
"packag": [[25,35,43]],
"semi": [43],
"leav": [[22,23]],
"regular": [32,34],
"wh-collapse-toc": [40],
"restart": [[6,9]],
"role-inline-wrapp": [34],
"bigger": [34],
"tmp.xhtml": [26],
"alway": [40,[21,22,35,38,39,44]],
"readabl": [10],
"help": [40,28,3,[14,26],[4,13,31,32,34,38]],
"expect": [[32,34]],
"begin-smarttag": [44],
"c-endnoterefer": [18],
"revis": [44],
"date": [44],
"com.xmlmind.w2x.processor.processstep": [42,[15,28]],
"argument": [[29,44],26],
"whatsoev": [[15,42]],
"data": [[1,12,32]],
"own": [43,[8,15,27,28,44]],
"firefox": [34],
"separ": [34,32,[1,27,43]],
"content-typ": [23,[13,32]],
"save.ind": [41],
"tab": [45,[34,35],44,6],
"plain": [39,[3,26,28]],
"should": [34,14,[4,37,38,39]],
"indexlist": [39],
"tag": [44,[1,3,15,16,21,22,34]],
"replac": [28,29,16,[5,13,23,34]],
"ja-jp": [[32,44]],
"localhost": [[11,12]],
"sens": [[1,29]],
"like": [13,20,[1,15,23,26,30,34,43]],
"onli": [34,39,32,[43,44],[2,3,17,35]],
"generate-xref-text": [39],
"sans-serif": [18],
"person": [5],
"finish-styl": [16,34],
"convert.charset": [28,13],
"ugli": [20],
"openoffic": [43],
"send": [[1,12]],
"emf.svg": [43],
"here": [[26,32,33,34,35,37,38,39,40]],
"note": [23,[32,34],[13,43],[1,2,5,11,14,26,29,36,39,44]],
"com.xmlmind.w2x.processor.deletefilesstep": [[26,28]],
"gif": [44],
"line": [[22,34,43],[12,17,26,41]],
"noth": [[21,22,38,43]],
"link": [19],
"becom": [[20,32]],
"smartart": [44],
"cal": [39,[13,32]],
"can": [[1,2,14,15,34,44]],
"headings.convert": [34],
"cap": [44],
"edit.finish-styles.custom-styles-url-or-fil": [[18,19,20]],
"cat": [34],
"provid": [[27,34]],
"inlines.b-el": [34],
"realli": [45],
"will": [34,[2,11,44],[22,32,36],[10,23,39]],
"match": [[20,23,33,34,39]],
"w2x_servlet_deployment_dir": [9],
"follow": [[23,34],20,15,[12,13,29,31,32,39,43,44],[2,3,5,6,16,17,24,28,30,35,38,40,45]],
"accent": [[11,43]],
"epub.identifi": [12],
"boolean": [38,32,[26,37]],
"topicref": [39,13],
"prune.preserv": [34],
"w2x-app-c.bat": [3],
"disciplin": [1],
"intend": [2]
};
