import java.io.File;
import com.xmlmind.w2x.processor.ConvertStep;
import com.xmlmind.w2x.processor.EditStep;
import com.xmlmind.w2x.processor.SaveStep;
import com.xmlmind.w2x.processor.Processor;

public class Embed2 {
    public static void main(String[] args) 
        throws Exception {
        File inFile = null;
        File outFile = null;
        if (args.length == 2) {
            inFile = new File(args[0]);
            outFile = new File(args[1]);
        } else {
            System.exit(1);
        }

        Processor processor = new Processor();

        ConvertStep convertStep = new ConvertStep("convert");
        processor.stepList.add(convertStep);

        EditStep editStep = new EditStep("edit");
        processor.stepList.add(editStep);

        processor.parameterMap.put("edit.xed-url-or-file", 
                                   "w2x:xed/main-styled.xed");

        SaveStep saveStep = new SaveStep("save");
        processor.stepList.add(saveStep);

        processor.parameterMap.put("save.indent", "yes");

        /*
         * Processor.process() automatically use outFile to set 
         * the following parameters:
         *
         * convert.xhtml-file
         *
         * save.out-file
         *
         */
        processor.process(inFile, outFile, /*progress monitor*/ null);
    }
}
