function Snowball() {

/**@constructor*/
BaseStemmer = function() {
    this.setCurrent = function(value) {
        this.current = value;
        this.cursor = 0;
        this.limit = this.current.length;
        this.limit_backward = 0;
        this.bra = this.cursor;
        this.ket = this.limit;
    };

    this.getCurrent = function() {
        return this.current;
    };

    this.copy_from = function(other) {
        this.current          = other.current;
        this.cursor           = other.cursor;
        this.limit            = other.limit;
        this.limit_backward   = other.limit_backward;
        this.bra              = other.bra;
        this.ket              = other.ket;
    };

    this.in_grouping = function(s, min, max) {
        if (this.cursor >= this.limit) return false;
        var ch = this.current.charCodeAt(this.cursor);
        if (ch > max || ch < min) return false;
        ch -= min;
        if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
        this.cursor++;
        return true;
    };

    this.in_grouping_b = function(s, min, max) {
        if (this.cursor <= this.limit_backward) return false;
        var ch = this.current.charCodeAt(this.cursor - 1);
        if (ch > max || ch < min) return false;
        ch -= min;
        if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
        this.cursor--;
        return true;
    };

    this.out_grouping = function(s, min, max) {
        if (this.cursor >= this.limit) return false;
        var ch = this.current.charCodeAt(this.cursor);
        if (ch > max || ch < min) {
            this.cursor++;
            return true;
        }
        ch -= min;
        if ((s[ch >>> 3] & (0X1 << (ch & 0x7))) == 0) {
            this.cursor++;
            return true;
        }
        return false;
    };

    this.out_grouping_b = function(s, min, max) {
        if (this.cursor <= this.limit_backward) return false;
        var ch = this.current.charCodeAt(this.cursor - 1);
        if (ch > max || ch < min) {
            this.cursor--;
            return true;
        }
        ch -= min;
        if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) {
            this.cursor--;
            return true;
        }
        return false;
    };

    this.eq_s = function(s)
    {
        if (this.limit - this.cursor < s.length) return false;
        if (this.current.slice(this.cursor, this.cursor + s.length) != s)
        {
            return false;
        }
        this.cursor += s.length;
        return true;
    };

    this.eq_s_b = function(s)
    {
        if (this.cursor - this.limit_backward < s.length) return false;
        if (this.current.slice(this.cursor - s.length, this.cursor) != s)
        {
            return false;
        }
        this.cursor -= s.length;
        return true;
    };

    /** @return {number} */ this.find_among = function(v)
    {
        var i = 0;
        var j = v.length;

        var c = this.cursor;
        var l = this.limit;

        var common_i = 0;
        var common_j = 0;

        var first_key_inspected = false;

        while (true)
        {
            var k = i + ((j - i) >>> 1);
            var diff = 0;
            var common = common_i < common_j ? common_i : common_j; // smaller
            // w[0]: string, w[1]: substring_i, w[2]: result, w[3]: function (optional)
            var w = v[k];
            var i2;
            for (i2 = common; i2 < w[0].length; i2++)
            {
                if (c + common == l)
                {
                    diff = -1;
                    break;
                }
                diff = this.current.charCodeAt(c + common) - w[0].charCodeAt(i2);
                if (diff != 0) break;
                common++;
            }
            if (diff < 0)
            {
                j = k;
                common_j = common;
            }
            else
            {
                i = k;
                common_i = common;
            }
            if (j - i <= 1)
            {
                if (i > 0) break; // v->s has been inspected
                if (j == i) break; // only one item in v

                // - but now we need to go round once more to get
                // v->s inspected. This looks messy, but is actually
                // the optimal approach.

                if (first_key_inspected) break;
                first_key_inspected = true;
            }
        }
        do {
            var w = v[i];
            if (common_i >= w[0].length)
            {
                this.cursor = c + w[0].length;
                if (w.length < 4) return w[2];
                var res = w[3](this);
                this.cursor = c + w[0].length;
                if (res) return w[2];
            }
            i = w[1];
        } while (i >= 0);
        return 0;
    };

    // find_among_b is for backwards processing. Same comments apply
    this.find_among_b = function(v)
    {
        var i = 0;
        var j = v.length

        var c = this.cursor;
        var lb = this.limit_backward;

        var common_i = 0;
        var common_j = 0;

        var first_key_inspected = false;

        while (true)
        {
            var k = i + ((j - i) >> 1);
            var diff = 0;
            var common = common_i < common_j ? common_i : common_j;
            var w = v[k];
            var i2;
            for (i2 = w[0].length - 1 - common; i2 >= 0; i2--)
            {
                if (c - common == lb)
                {
                    diff = -1;
                    break;
                }
                diff = this.current.charCodeAt(c - 1 - common) - w[0].charCodeAt(i2);
                if (diff != 0) break;
                common++;
            }
            if (diff < 0)
            {
                j = k;
                common_j = common;
            }
            else
            {
                i = k;
                common_i = common;
            }
            if (j - i <= 1)
            {
                if (i > 0) break;
                if (j == i) break;
                if (first_key_inspected) break;
                first_key_inspected = true;
            }
        }
        do {
            var w = v[i];
            if (common_i >= w[0].length)
            {
                this.cursor = c - w[0].length;
                if (w.length < 4) return w[2];
                var res = w[3](this);
                this.cursor = c - w[0].length;
                if (res) return w[2];
            }
            i = w[1];
        } while (i >= 0);
        return 0;
    };

    /* to replace chars between c_bra and c_ket in this.current by the
     * chars in s.
     */
    this.replace_s = function(c_bra, c_ket, s)
    {
        var adjustment = s.length - (c_ket - c_bra);
        this.current = this.current.slice(0, c_bra) + s + this.current.slice(c_ket);
        this.limit += adjustment;
        if (this.cursor >= c_ket) this.cursor += adjustment;
        else if (this.cursor > c_bra) this.cursor = c_bra;
        return adjustment;
    };

    this.slice_check = function()
    {
        if (this.bra < 0 ||
            this.bra > this.ket ||
            this.ket > this.limit ||
            this.limit > this.current.length)
        {
            return false;
        }
        return true;
    };

    this.slice_from = function(s)
    {
        var result = false;
        if (this.slice_check())
        {
            this.replace_s(this.bra, this.ket, s);
            result = true;
        }
        return result;
    };

    this.slice_del = function()
    {
        return this.slice_from("");
    };

    this.insert = function(c_bra, c_ket, s)
    {
        var adjustment = this.replace_s(c_bra, c_ket, s);
        if (c_bra <= this.bra) this.bra += adjustment;
        if (c_bra <= this.ket) this.ket += adjustment;
    };

    this.slice_to = function()
    {
        var result = '';
        if (this.slice_check())
        {
            result = this.current.slice(this.bra, this.ket);
        }
        return result;
    };

    this.assign_to = function()
    {
        return this.current.slice(0, this.limit);
    };
};


/*==============================================*/

// Generated by Snowball 2.2.0 - https://snowballstem.org/

/**@constructor*/
ArmenianStemmer = function() {
    var base = new BaseStemmer();
    /** @const */ var a_0 = [
        ["\u0580\u0578\u0580\u0564", -1, 1],
        ["\u0565\u0580\u0578\u0580\u0564", 0, 1],
        ["\u0561\u056C\u056B", -1, 1],
        ["\u0561\u056F\u056B", -1, 1],
        ["\u0578\u0580\u0561\u056F", -1, 1],
        ["\u0565\u0572", -1, 1],
        ["\u0561\u056F\u0561\u0576", -1, 1],
        ["\u0561\u0580\u0561\u0576", -1, 1],
        ["\u0565\u0576", -1, 1],
        ["\u0565\u056F\u0565\u0576", 8, 1],
        ["\u0565\u0580\u0565\u0576", 8, 1],
        ["\u0578\u0580\u0567\u0576", -1, 1],
        ["\u056B\u0576", -1, 1],
        ["\u0563\u056B\u0576", 12, 1],
        ["\u0578\u057E\u056B\u0576", 12, 1],
        ["\u056C\u0561\u0575\u0576", -1, 1],
        ["\u057E\u0578\u0582\u0576", -1, 1],
        ["\u057A\u0565\u057D", -1, 1],
        ["\u056B\u057E", -1, 1],
        ["\u0561\u057F", -1, 1],
        ["\u0561\u057E\u0565\u057F", -1, 1],
        ["\u056F\u0578\u057F", -1, 1],
        ["\u0562\u0561\u0580", -1, 1]
    ];

    /** @const */ var a_1 = [
        ["\u0561", -1, 1],
        ["\u0561\u0581\u0561", 0, 1],
        ["\u0565\u0581\u0561", 0, 1],
        ["\u057E\u0565", -1, 1],
        ["\u0561\u0581\u0580\u056B", -1, 1],
        ["\u0561\u0581\u056B", -1, 1],
        ["\u0565\u0581\u056B", -1, 1],
        ["\u057E\u0565\u0581\u056B", 6, 1],
        ["\u0561\u056C", -1, 1],
        ["\u0568\u0561\u056C", 8, 1],
        ["\u0561\u0576\u0561\u056C", 8, 1],
        ["\u0565\u0576\u0561\u056C", 8, 1],
        ["\u0561\u0581\u0576\u0561\u056C", 8, 1],
        ["\u0565\u056C", -1, 1],
        ["\u0568\u0565\u056C", 13, 1],
        ["\u0576\u0565\u056C", 13, 1],
        ["\u0581\u0576\u0565\u056C", 15, 1],
        ["\u0565\u0581\u0576\u0565\u056C", 16, 1],
        ["\u0579\u0565\u056C", 13, 1],
        ["\u057E\u0565\u056C", 13, 1],
        ["\u0561\u0581\u057E\u0565\u056C", 19, 1],
        ["\u0565\u0581\u057E\u0565\u056C", 19, 1],
        ["\u057F\u0565\u056C", 13, 1],
        ["\u0561\u057F\u0565\u056C", 22, 1],
        ["\u0578\u057F\u0565\u056C", 22, 1],
        ["\u056F\u0578\u057F\u0565\u056C", 24, 1],
        ["\u057E\u0561\u056E", -1, 1],
        ["\u0578\u0582\u0574", -1, 1],
        ["\u057E\u0578\u0582\u0574", 27, 1],
        ["\u0561\u0576", -1, 1],
        ["\u0581\u0561\u0576", 29, 1],
        ["\u0561\u0581\u0561\u0576", 30, 1],
        ["\u0561\u0581\u0580\u056B\u0576", -1, 1],
        ["\u0561\u0581\u056B\u0576", -1, 1],
        ["\u0565\u0581\u056B\u0576", -1, 1],
        ["\u057E\u0565\u0581\u056B\u0576", 34, 1],
        ["\u0561\u056C\u056B\u057D", -1, 1],
        ["\u0565\u056C\u056B\u057D", -1, 1],
        ["\u0561\u057E", -1, 1],
        ["\u0561\u0581\u0561\u057E", 38, 1],
        ["\u0565\u0581\u0561\u057E", 38, 1],
        ["\u0561\u056C\u0578\u057E", -1, 1],
        ["\u0565\u056C\u0578\u057E", -1, 1],
        ["\u0561\u0580", -1, 1],
        ["\u0561\u0581\u0561\u0580", 43, 1],
        ["\u0565\u0581\u0561\u0580", 43, 1],
        ["\u0561\u0581\u0580\u056B\u0580", -1, 1],
        ["\u0561\u0581\u056B\u0580", -1, 1],
        ["\u0565\u0581\u056B\u0580", -1, 1],
        ["\u057E\u0565\u0581\u056B\u0580", 48, 1],
        ["\u0561\u0581", -1, 1],
        ["\u0565\u0581", -1, 1],
        ["\u0561\u0581\u0580\u0565\u0581", 51, 1],
        ["\u0561\u056C\u0578\u0582\u0581", -1, 1],
        ["\u0565\u056C\u0578\u0582\u0581", -1, 1],
        ["\u0561\u056C\u0578\u0582", -1, 1],
        ["\u0565\u056C\u0578\u0582", -1, 1],
        ["\u0561\u0584", -1, 1],
        ["\u0581\u0561\u0584", 57, 1],
        ["\u0561\u0581\u0561\u0584", 58, 1],
        ["\u0561\u0581\u0580\u056B\u0584", -1, 1],
        ["\u0561\u0581\u056B\u0584", -1, 1],
        ["\u0565\u0581\u056B\u0584", -1, 1],
        ["\u057E\u0565\u0581\u056B\u0584", 62, 1],
        ["\u0561\u0576\u0584", -1, 1],
        ["\u0581\u0561\u0576\u0584", 64, 1],
        ["\u0561\u0581\u0561\u0576\u0584", 65, 1],
        ["\u0561\u0581\u0580\u056B\u0576\u0584", -1, 1],
        ["\u0561\u0581\u056B\u0576\u0584", -1, 1],
        ["\u0565\u0581\u056B\u0576\u0584", -1, 1],
        ["\u057E\u0565\u0581\u056B\u0576\u0584", 69, 1]
    ];

    /** @const */ var a_2 = [
        ["\u0578\u0580\u0564", -1, 1],
        ["\u0578\u0582\u0575\u0569", -1, 1],
        ["\u0578\u0582\u0570\u056B", -1, 1],
        ["\u0581\u056B", -1, 1],
        ["\u056B\u056C", -1, 1],
        ["\u0561\u056F", -1, 1],
        ["\u0575\u0561\u056F", 5, 1],
        ["\u0561\u0576\u0561\u056F", 5, 1],
        ["\u056B\u056F", -1, 1],
        ["\u0578\u0582\u056F", -1, 1],
        ["\u0561\u0576", -1, 1],
        ["\u057A\u0561\u0576", 10, 1],
        ["\u057D\u057F\u0561\u0576", 10, 1],
        ["\u0561\u0580\u0561\u0576", 10, 1],
        ["\u0565\u0572\u0567\u0576", -1, 1],
        ["\u0575\u0578\u0582\u0576", -1, 1],
        ["\u0578\u0582\u0569\u0575\u0578\u0582\u0576", 15, 1],
        ["\u0561\u056E\u0578", -1, 1],
        ["\u056B\u0579", -1, 1],
        ["\u0578\u0582\u057D", -1, 1],
        ["\u0578\u0582\u057D\u057F", -1, 1],
        ["\u0563\u0561\u0580", -1, 1],
        ["\u057E\u0578\u0580", -1, 1],
        ["\u0561\u057E\u0578\u0580", 22, 1],
        ["\u0578\u0581", -1, 1],
        ["\u0561\u0576\u0585\u0581", -1, 1],
        ["\u0578\u0582", -1, 1],
        ["\u0584", -1, 1],
        ["\u0579\u0565\u0584", 27, 1],
        ["\u056B\u0584", 27, 1],
        ["\u0561\u056C\u056B\u0584", 29, 1],
        ["\u0561\u0576\u056B\u0584", 29, 1],
        ["\u057E\u0561\u056E\u0584", 27, 1],
        ["\u0578\u0582\u0575\u0584", 27, 1],
        ["\u0565\u0576\u0584", 27, 1],
        ["\u0578\u0576\u0584", 27, 1],
        ["\u0578\u0582\u0576\u0584", 27, 1],
        ["\u0574\u0578\u0582\u0576\u0584", 36, 1],
        ["\u056B\u0579\u0584", 27, 1],
        ["\u0561\u0580\u0584", 27, 1]
    ];

    /** @const */ var a_3 = [
        ["\u057D\u0561", -1, 1],
        ["\u057E\u0561", -1, 1],
        ["\u0561\u0574\u0562", -1, 1],
        ["\u0564", -1, 1],
        ["\u0561\u0576\u0564", 3, 1],
        ["\u0578\u0582\u0569\u0575\u0561\u0576\u0564", 4, 1],
        ["\u057E\u0561\u0576\u0564", 4, 1],
        ["\u0578\u057B\u0564", 3, 1],
        ["\u0565\u0580\u0564", 3, 1],
        ["\u0576\u0565\u0580\u0564", 8, 1],
        ["\u0578\u0582\u0564", 3, 1],
        ["\u0568", -1, 1],
        ["\u0561\u0576\u0568", 11, 1],
        ["\u0578\u0582\u0569\u0575\u0561\u0576\u0568", 12, 1],
        ["\u057E\u0561\u0576\u0568", 12, 1],
        ["\u0578\u057B\u0568", 11, 1],
        ["\u0565\u0580\u0568", 11, 1],
        ["\u0576\u0565\u0580\u0568", 16, 1],
        ["\u056B", -1, 1],
        ["\u057E\u056B", 18, 1],
        ["\u0565\u0580\u056B", 18, 1],
        ["\u0576\u0565\u0580\u056B", 20, 1],
        ["\u0561\u0576\u0578\u0582\u0574", -1, 1],
        ["\u0565\u0580\u0578\u0582\u0574", -1, 1],
        ["\u0576\u0565\u0580\u0578\u0582\u0574", 23, 1],
        ["\u0576", -1, 1],
        ["\u0561\u0576", 25, 1],
        ["\u0578\u0582\u0569\u0575\u0561\u0576", 26, 1],
        ["\u057E\u0561\u0576", 26, 1],
        ["\u056B\u0576", 25, 1],
        ["\u0565\u0580\u056B\u0576", 29, 1],
        ["\u0576\u0565\u0580\u056B\u0576", 30, 1],
        ["\u0578\u0582\u0569\u0575\u0561\u0576\u0576", 25, 1],
        ["\u0565\u0580\u0576", 25, 1],
        ["\u0576\u0565\u0580\u0576", 33, 1],
        ["\u0578\u0582\u0576", 25, 1],
        ["\u0578\u057B", -1, 1],
        ["\u0578\u0582\u0569\u0575\u0561\u0576\u057D", -1, 1],
        ["\u057E\u0561\u0576\u057D", -1, 1],
        ["\u0578\u057B\u057D", -1, 1],
        ["\u0578\u057E", -1, 1],
        ["\u0561\u0576\u0578\u057E", 40, 1],
        ["\u057E\u0578\u057E", 40, 1],
        ["\u0565\u0580\u0578\u057E", 40, 1],
        ["\u0576\u0565\u0580\u0578\u057E", 43, 1],
        ["\u0565\u0580", -1, 1],
        ["\u0576\u0565\u0580", 45, 1],
        ["\u0581", -1, 1],
        ["\u056B\u0581", 47, 1],
        ["\u057E\u0561\u0576\u056B\u0581", 48, 1],
        ["\u0578\u057B\u056B\u0581", 48, 1],
        ["\u057E\u056B\u0581", 48, 1],
        ["\u0565\u0580\u056B\u0581", 48, 1],
        ["\u0576\u0565\u0580\u056B\u0581", 52, 1],
        ["\u0581\u056B\u0581", 48, 1],
        ["\u0578\u0581", 47, 1],
        ["\u0578\u0582\u0581", 47, 1]
    ];

    /** @const */ var /** Array<int> */ g_v = [209, 4, 128, 0, 18];

    var /** number */ I_p2 = 0;
    var /** number */ I_pV = 0;


    /** @return {boolean} */
    function r_mark_regions() {
        I_pV = base.limit;
        I_p2 = base.limit;
        var /** number */ v_1 = base.cursor;
        lab0: {
            golab1: while(true)
            {
                lab2: {
                    if (!(base.in_grouping(g_v, 1377, 1413)))
                    {
                        break lab2;
                    }
                    break golab1;
                }
                if (base.cursor >= base.limit)
                {
                    break lab0;
                }
                base.cursor++;
            }
            I_pV = base.cursor;
            golab3: while(true)
            {
                lab4: {
                    if (!(base.out_grouping(g_v, 1377, 1413)))
                    {
                        break lab4;
                    }
                    break golab3;
                }
                if (base.cursor >= base.limit)
                {
                    break lab0;
                }
                base.cursor++;
            }
            golab5: while(true)
            {
                lab6: {
                    if (!(base.in_grouping(g_v, 1377, 1413)))
                    {
                        break lab6;
                    }
                    break golab5;
                }
                if (base.cursor >= base.limit)
                {
                    break lab0;
                }
                base.cursor++;
            }
            golab7: while(true)
            {
                lab8: {
                    if (!(base.out_grouping(g_v, 1377, 1413)))
                    {
                        break lab8;
                    }
                    break golab7;
                }
                if (base.cursor >= base.limit)
                {
                    break lab0;
                }
                base.cursor++;
            }
            I_p2 = base.cursor;
        }
        base.cursor = v_1;
        return true;
    };

    /** @return {boolean} */
    function r_R2() {
        if (!(I_p2 <= base.cursor))
        {
            return false;
        }
        return true;
    };

    /** @return {boolean} */
    function r_adjective() {
        base.ket = base.cursor;
        if (base.find_among_b(a_0) == 0)
        {
            return false;
        }
        base.bra = base.cursor;
        if (!base.slice_del())
        {
            return false;
        }
        return true;
    };

    /** @return {boolean} */
    function r_verb() {
        base.ket = base.cursor;
        if (base.find_among_b(a_1) == 0)
        {
            return false;
        }
        base.bra = base.cursor;
        if (!base.slice_del())
        {
            return false;
        }
        return true;
    };

    /** @return {boolean} */
    function r_noun() {
        base.ket = base.cursor;
        if (base.find_among_b(a_2) == 0)
        {
            return false;
        }
        base.bra = base.cursor;
        if (!base.slice_del())
        {
            return false;
        }
        return true;
    };

    /** @return {boolean} */
    function r_ending() {
        base.ket = base.cursor;
        if (base.find_among_b(a_3) == 0)
        {
            return false;
        }
        base.bra = base.cursor;
        if (!r_R2())
        {
            return false;
        }
        if (!base.slice_del())
        {
            return false;
        }
        return true;
    };

    this.stem = /** @return {boolean} */ function() {
        r_mark_regions();
        base.limit_backward = base.cursor; base.cursor = base.limit;
        if (base.cursor < I_pV)
        {
            return false;
        }
        var /** number */ v_3 = base.limit_backward;
        base.limit_backward = I_pV;
        var /** number */ v_4 = base.limit - base.cursor;
        r_ending();
        base.cursor = base.limit - v_4;
        var /** number */ v_5 = base.limit - base.cursor;
        r_verb();
        base.cursor = base.limit - v_5;
        var /** number */ v_6 = base.limit - base.cursor;
        r_adjective();
        base.cursor = base.limit - v_6;
        var /** number */ v_7 = base.limit - base.cursor;
        r_noun();
        base.cursor = base.limit - v_7;
        base.limit_backward = v_3;
        base.cursor = base.limit_backward;
        return true;
    };

    /**@return{string}*/
    this['stemWord'] = function(/**string*/word) {
        base.setCurrent(word);
        this.stem();
        return base.getCurrent();
    };
};


return new ArmenianStemmer();
}