/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xpath.Converter;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.NullNodeIterator;
import java.util.StringTokenizer;

class ValueIdIterator
implements NodeIterator {
    private XNode node;
    private NodeIterator iter1;
    private ExprContext context;
    private NodeIterator iter2;

    ValueIdIterator(XNode xNode, NodeIterator nodeIterator, ExprContext exprContext) {
        this.node = xNode;
        this.iter1 = nodeIterator;
        this.context = exprContext;
        this.iter2 = NullNodeIterator.INSTANCE;
    }

    @Override
    public XNode next() throws EvalException {
        while (true) {
            XNode xNode;
            if ((xNode = this.iter2.next()) != null) {
                return xNode;
            }
            xNode = this.iter1.next();
            if (xNode == null) break;
            this.iter2 = new Iterator(this.node, Converter.toString(xNode), this.context);
        }
        return null;
    }

    static class Iterator
    implements NodeIterator {
        private XNode node;
        private StringTokenizer ids;
        private ExprContext context;

        Iterator(XNode xNode, String string, ExprContext exprContext) {
            this.node = xNode;
            this.ids = new StringTokenizer(string);
            this.context = exprContext;
        }

        @Override
        public XNode next() throws EvalException {
            while (this.ids.hasMoreTokens()) {
                XNode xNode = this.context.findElementWithId(this.node, this.ids.nextToken());
                if (xNode == null) continue;
                return xNode;
            }
            return null;
        }
    }
}

