/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.product.Product;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleStringExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function1;
import com.xmlmind.xml.xpath.ParseException;

class SystemPropertyFunction
extends Function1 {
    SystemPropertyFunction() {
    }

    @Override
    ConvertibleExpr makeCallExpr(ConvertibleExpr convertibleExpr) throws ParseException {
        final ConvertibleStringExpr convertibleStringExpr = convertibleExpr.makeStringExpr();
        return new ConvertibleStringExpr(){

            @Override
            public String eval(XNode xNode, ExprContext exprContext) throws EvalException {
                String string = convertibleStringExpr.eval(xNode, exprContext);
                Name name = Name.parse(string, true, xNode.namespacePrefixMap());
                if (name == null) {
                    return "";
                }
                String string2 = null;
                Namespace namespace = name.namespace;
                String string3 = name.localPart;
                if (namespace == Namespace.NONE) {
                    string2 = System.getProperty(string3);
                } else if (namespace == Namespace.XSLT) {
                    if ("vendor".equals(string3)) {
                        string2 = "XMLmind";
                    } else if ("vendor-url".equals(string3)) {
                        string2 = "https://www.xmlmind.com/";
                    } else if ("product-name".equals(string3)) {
                        string2 = "XMLmind XML Editor";
                    } else if ("product-version".equals(string3)) {
                        string2 = Product.getVersionString();
                    } else if ("version".equals(string3)) {
                        string2 = "1.0";
                    }
                }
                return string2 == null ? "" : string2;
            }
        };
    }
}

