/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xpath.ConvertibleVariantExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Variant;
import com.xmlmind.xml.xpath.VariantExpr;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class SimpleFunctionCallExpr
extends ConvertibleVariantExpr {
    private final Object object;
    private final Method method;
    private final VariantExpr[] args;

    SimpleFunctionCallExpr(Object object, Method method, VariantExpr[] variantExprArray) {
        this.object = object;
        this.method = method;
        this.args = variantExprArray;
    }

    @Override
    public Variant eval(XNode xNode, ExprContext exprContext) throws EvalException {
        Object[] objectArray = new Object[]{this.args, xNode, exprContext};
        try {
            return (Variant)this.method.invoke(this.object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EvalException("cannot invoke '" + this.methodName() + "': illegal access");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EvalException("cannot invoke '" + this.methodName() + "': illegal arguments");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof EvalException) {
                throw (EvalException)throwable;
            }
            String string = throwable.getMessage();
            if (string == null) {
                string = throwable.getClass().getName();
            }
            throw new EvalException("cannot invoke '" + this.methodName() + "': " + string, throwable);
        }
        catch (ClassCastException classCastException) {
            throw new EvalException("cannot invoke '" + this.methodName() + "': does not return a Variant");
        }
    }

    private String methodName() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }
}

