/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.xpath.Converter;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleNodeSetExpr;
import com.xmlmind.xml.xpath.ConvertibleNumberExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.NumberExpr;
import com.xmlmind.xml.xpath.ParseException;

class MinFunction
implements Function {
    MinFunction() {
    }

    @Override
    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray, PrefixToNamespace prefixToNamespace) throws ParseException {
        if (convertibleExprArray.length < 1) {
            throw new ParseException("expected 1 node-set argument or at least 2 number arguments");
        }
        if (convertibleExprArray.length == 1) {
            final ConvertibleNodeSetExpr convertibleNodeSetExpr = convertibleExprArray[0].makeNodeSetExpr();
            return new ConvertibleNumberExpr(){

                @Override
                public double eval(XNode xNode, ExprContext exprContext) throws EvalException {
                    XNode xNode2;
                    double d = Double.NaN;
                    NodeIterator nodeIterator = convertibleNodeSetExpr.eval(xNode, exprContext);
                    while ((xNode2 = nodeIterator.next()) != null) {
                        String string = Converter.toString(xNode2);
                        double d2 = Converter.toNumber(string.trim());
                        if (Double.isNaN(d2) || !Double.isNaN(d) && !(d2 < d)) continue;
                        d = d2;
                    }
                    return d;
                }
            };
        }
        final NumberExpr[] numberExprArray = new NumberExpr[convertibleExprArray.length];
        for (int i = 0; i < convertibleExprArray.length; ++i) {
            numberExprArray[i] = convertibleExprArray[i].makeNumberExpr();
        }
        return new ConvertibleNumberExpr(){

            @Override
            public double eval(XNode xNode, ExprContext exprContext) throws EvalException {
                double d = Double.NaN;
                for (int i = 0; i < numberExprArray.length; ++i) {
                    double d2 = numberExprArray[i].eval(xNode, exprContext);
                    if (Double.isNaN(d2) || !Double.isNaN(d) && !(d2 < d)) continue;
                    d = d2;
                }
                return d;
            }
        };
    }
}

