/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.xpath.BooleanExpr;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleVariantExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function;
import com.xmlmind.xml.xpath.ParseException;
import com.xmlmind.xml.xpath.Variant;
import com.xmlmind.xml.xpath.VariantExpr;

class IfFunction
implements Function {
    IfFunction() {
    }

    @Override
    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray, PrefixToNamespace prefixToNamespace) throws ParseException {
        if (convertibleExprArray.length % 2 != 1 || convertibleExprArray.length < 3) {
            throw new ParseException("expected an even number, at least 3, arguments");
        }
        int n = convertibleExprArray.length / 2;
        final BooleanExpr[] booleanExprArray = new BooleanExpr[n];
        final VariantExpr[] variantExprArray = new VariantExpr[n];
        for (int i = 0; i < n; ++i) {
            booleanExprArray[i] = convertibleExprArray[2 * i].makeBooleanExpr();
            variantExprArray[i] = convertibleExprArray[2 * i + 1].makeVariantExpr();
        }
        final ConvertibleVariantExpr convertibleVariantExpr = convertibleExprArray[convertibleExprArray.length - 1].makeVariantExpr();
        return new ConvertibleVariantExpr(){

            @Override
            public Variant eval(XNode xNode, ExprContext exprContext) throws EvalException {
                for (int i = 0; i < booleanExprArray.length; ++i) {
                    if (!booleanExprArray[i].eval(xNode, exprContext)) continue;
                    return variantExprArray[i].eval(xNode, exprContext);
                }
                return convertibleVariantExpr.eval(xNode, exprContext);
            }
        };
    }
}

