/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.xpath.EvalException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class ExtensionFunctions {
    private ExtensionFunctions() {
    }

    static Object call(Name name, Object[] objectArray) throws EvalException {
        Class<?> clazz = ExtensionFunctions.loadClass(name);
        String string = ExtensionFunctions.camelCase(name.localPart);
        try {
            if (string.equals("new")) {
                return ExtensionFunctions.callConstructor(clazz, objectArray);
            }
            return ExtensionFunctions.callMethod(clazz, string, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EvalException("cannot invoke '" + ExtensionFunctions.methodName(clazz, string) + "': illegal access");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EvalException("cannot invoke '" + ExtensionFunctions.methodName(clazz, string) + "': illegal arguments");
        }
        catch (InstantiationException instantiationException) {
            throw new EvalException("cannot instantiate class '" + clazz.getName() + "'");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof EvalException) {
                throw (EvalException)throwable;
            }
            String string2 = throwable.getMessage();
            if (string2 == null) {
                string2 = throwable.getClass().getName();
            }
            throw new EvalException("cannot invoke '" + ExtensionFunctions.methodName(clazz, string) + "': " + string2, throwable);
        }
    }

    private static Class<?> loadClass(Name name) throws EvalException {
        String string = name.namespace.uri;
        if (!string.startsWith("java:")) {
            throw new EvalException("'" + string + "' invalid namespace for an extension function: should start with 'java:'");
        }
        string = string.substring(5);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            Object object = throwable.getClass().getName();
            if (throwable.getMessage() != null) {
                object = (String)object + ": " + throwable.getMessage();
            }
            throw new EvalException("cannot load class '" + string + "': " + (String)object);
        }
        return clazz;
    }

    public static String camelCase(String string) {
        int n = string.indexOf(45);
        if (n < 0 || n + 1 == string.length()) {
            return string;
        }
        return string.substring(0, n) + Character.toUpperCase(string.charAt(n + 1)) + ExtensionFunctions.camelCase(string.substring(n + 2));
    }

    private static String methodName(Class<?> clazz, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if ("new".equals(string)) {
            stringBuilder.append("new ");
            stringBuilder.append(clazz.getName());
        } else {
            stringBuilder.append(clazz.getName());
            stringBuilder.append('.');
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object callConstructor(Class<?> clazz, Object[] objectArray) throws EvalException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < constructorArray.length; ++i) {
            if (constructorArray[i].getParameterTypes().length != objectArray.length) {
                constructorArray[i] = null;
                continue;
            }
            ++n;
            if (n2 >= 0) continue;
            n2 = i;
        }
        Constructor<?> constructor = null;
        if (n == 1) {
            constructor = constructorArray[n2];
            return constructor.newInstance(objectArray);
        } else {
            if (n <= true) throw new EvalException("no constructor of '" + clazz.getName() + "' having " + objectArray.length + " parameters");
            n = 0;
            n2 = -1;
            for (int i = 0; i < constructorArray.length; ++i) {
                Constructor<?> constructor2 = constructorArray[i];
                if (constructor2 == null) continue;
                boolean bl = true;
                Class<?>[] classArray = constructor2.getParameterTypes();
                for (int j = 0; j < classArray.length; ++j) {
                    if (classArray[j].isAssignableFrom(objectArray[j].getClass())) continue;
                    bl = false;
                    break;
                }
                if (!bl) {
                    constructorArray[i] = null;
                    continue;
                }
                ++n;
                if (n2 >= 0) continue;
                n2 = i;
            }
            if (n == 1) {
                constructor = constructorArray[n2];
                return constructor.newInstance(objectArray);
            } else {
                if (n <= 1) throw new EvalException("no constructor of '" + clazz.getName() + "' having proper parameters");
                throw new EvalException("ambiguous overloaded constructor of '" + clazz.getName() + "'");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object callMethod(Class<?> clazz, String string, Object[] objectArray) throws EvalException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object object;
        boolean bl = true;
        if (objectArray.length > 0 && clazz.isInstance(objectArray[0])) {
            bl = false;
        }
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().equals(string)) {
                methodArray[i] = null;
                continue;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                if (method.getParameterTypes().length != objectArray.length) {
                    methodArray[i] = null;
                    continue;
                }
            } else if (bl || method.getParameterTypes().length != objectArray.length - 1) {
                methodArray[i] = null;
                continue;
            }
            ++n;
            if (n2 >= 0) continue;
            n2 = i;
        }
        Method method = null;
        if (n == 1) {
            method = methodArray[n2];
        } else {
            if (n <= true) throw new EvalException("no method '" + ExtensionFunctions.methodName(clazz, string) + "' having " + objectArray.length + " parameters");
            n = 0;
            n2 = -1;
            for (int i = 0; i < methodArray.length; ++i) {
                object = methodArray[i];
                if (object == null) continue;
                boolean bl2 = true;
                Class<?>[] classArray = ((Method)object).getParameterTypes();
                int n3 = Modifier.isStatic(((Method)object).getModifiers()) ? 0 : 1;
                for (int j = 0; j < classArray.length; ++j) {
                    if (classArray[j].isAssignableFrom(objectArray[n3 + j].getClass())) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) {
                    methodArray[i] = null;
                    continue;
                }
                ++n;
                if (n2 >= 0) continue;
                n2 = i;
            }
            if (n == 1) {
                method = methodArray[n2];
            } else {
                if (n <= 1) throw new EvalException("no method '" + ExtensionFunctions.methodName(clazz, string) + "' having proper parameters");
                throw new EvalException("ambiguous overloaded method '" + ExtensionFunctions.methodName(clazz, string) + "'");
            }
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return method.invoke(null, objectArray);
        }
        object = objectArray[0];
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
        return method.invoke(object, objectArray2);
    }
}

