/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xinclude;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.LoadText;
import com.xmlmind.util.LocaleUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.InclusionException;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.load.DocumentManager;
import com.xmlmind.xml.load.SimpleInclusion;
import com.xmlmind.xml.load.SpaceTrimmer;
import com.xmlmind.xml.load.XInclusionContext;
import com.xmlmind.xml.load.XInclusionContextImpl;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.save.DocumentWriter;
import com.xmlmind.xml.validate.AttributeUtil;
import com.xmlmind.xml.validate.DocumentTypeUtil;
import com.xmlmind.xml.xinclude.Msg;
import com.xmlmind.xml.xinclude.TextFragmentIdentifier;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContextImpl;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.XPathUtil;
import com.xmlmind.xml.xpointer.ElementXPointer;
import com.xmlmind.xml.xpointer.SimpleXPointer;
import com.xmlmind.xml.xpointer.XPointer;
import com.xmlmind.xml.xpointer.XPointerException;
import com.xmlmind.xml.xpointer.XPointerXPointer;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.InputSource;

public final class XInclude
implements SimpleInclusion {
    public final URL href;
    public final String absoluteHref;
    public final String xpointer;
    public final String fragid;
    public final boolean parseText;
    public final String textEncoding;
    public final Attribute[] attributes;
    public final Element fallback;
    private SimpleXPointer[] pointers;
    private TextFragmentIdentifier textFragmentIdentifier;
    private boolean markedForUpdate;
    private static final Name HREF_ATTR = Name.get(Namespace.NONE, "href");
    private static final Name XPOINTER_ATTR = Name.get(Namespace.NONE, "xpointer");
    private static final Name FRAGID_ATTR = Name.get(Namespace.NONE, "fragid");
    private static final Name PARSE_ATTR = Name.get(Namespace.NONE, "parse");
    private static final Name ENCODING_ATTR = Name.get(Namespace.NONE, "encoding");
    private static final Name SET_XML_ID_ATTR = Name.get(Namespace.NONE, "set-xml-id");
    private static final PrefixEntry[] XI_PREFIXES = new PrefixEntry[]{new PrefixEntry("xi", Namespace.XI), new PrefixEntry("xila", Namespace.XI_LOCAL_ATTRIBUTES), new PrefixEntry("trans", Namespace.DOCBOOK_TRANSCLUSION)};
    private static final SimpleXPointer[] DOCUMENT_CONTENTS_POINTER = new SimpleXPointer[]{new ElementXPointer(null, new int[]{1})};
    private static final PrefixPreferences prefixPrefs = new PrefixPreferences(XI_PREFIXES, false);

    @Override
    public String getSchemeName() {
        return "XInclude";
    }

    public static XInclude fromElement(Element element) throws InclusionException {
        Object object;
        String string;
        Element element2;
        Attribute[] attributeArray;
        String string2;
        boolean bl;
        String string3;
        String string4;
        String string5;
        URL uRL;
        block24: {
            uRL = null;
            string5 = null;
            string4 = null;
            string3 = null;
            bl = false;
            string2 = null;
            attributeArray = null;
            element2 = null;
            string = element.getAttribute(HREF_ATTR);
            if (string != null) {
                if (URIComponent.getFragment(string = string.trim()) != null) {
                    throw new InclusionException(Msg.msg("invalidAttr", string, XInclude.HREF_ATTR.localPart));
                }
                if (string.length() > 0) {
                    try {
                        object = XMLCatalogs.resolveURI(string);
                        if (object != null) {
                            uRL = URLUtil.createURL((String)object);
                            string5 = string;
                            break block24;
                        }
                        try {
                            uRL = URLUtil.createURL(string);
                            string5 = string;
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        if (uRL == null) {
                            uRL = URLUtil.createURL(element.getBaseURL(), string);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new InclusionException(Msg.msg("invalidAttr", string, XInclude.HREF_ATTR.localPart));
                    }
                }
            }
        }
        if (uRL == null) {
            uRL = element.getBaseURL();
        }
        if ((string4 = element.getAttribute(XPOINTER_ATTR)) != null) {
            string4 = string4.trim();
        }
        if ((string3 = element.getAttribute(FRAGID_ATTR)) != null) {
            string3 = string3.trim();
        }
        if ((string = element.getAttribute(PARSE_ATTR)) != null) {
            if ("text".equals(string = string.toLowerCase().trim()) || "text/plain".equals(string) || string.startsWith("text/")) {
                bl = true;
            } else if ("xml".equals(string) || "application/xml".equals(string) || string.endsWith("+xml")) {
                bl = false;
            } else {
                throw new InclusionException(Msg.msg("unsupportedAttr", string, XInclude.PARSE_ATTR.localPart));
            }
        }
        if ((string2 = element.getAttribute(ENCODING_ATTR)) != null) {
            string2 = string2.trim();
            try {
                Charset.forName(string2);
            }
            catch (Exception exception) {
                throw new InclusionException(Msg.msg("invalidAttr", string, XInclude.ENCODING_ATTR.localPart));
            }
        }
        object = null;
        Iterator<Attribute> iterator = element.getAttributes(false);
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (attribute.name != SET_XML_ID_ATTR && (attribute.name.namespace == Namespace.NONE || attribute.name.namespace == Namespace.XML)) continue;
            if (object == null) {
                object = new ArrayList();
            }
            ((ArrayList)object).add(new Attribute(null, attribute.name, attribute.value));
        }
        if (object != null) {
            attributeArray = new Attribute[((ArrayList)object).size()];
            ((ArrayList)object).toArray(attributeArray);
        }
        if ((element2 = XInclude.getChildElementByName(element, Name.XI_FALLBACK)) != null) {
            element2 = (Element)element2.copy();
            SpaceTrimmer.trimSpace(element2);
        }
        return new XInclude(uRL, string5, string4, string3, bl, string2, attributeArray, element2);
    }

    private static Element getChildElementByName(Tree tree, Name name) {
        for (Node node = tree.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT || ((Element)node).getName() != name) continue;
            return (Element)node;
        }
        return null;
    }

    public XInclude(URL uRL, String string, String string2, String string3, boolean bl, String string4, Attribute[] attributeArray, Element element) throws InclusionException {
        assert (uRL != null);
        this.href = uRL;
        this.absoluteHref = string;
        this.xpointer = string2;
        this.fragid = string3;
        this.parseText = bl;
        this.textEncoding = string4;
        this.attributes = attributeArray;
        this.fallback = element;
        this.parsePointers();
    }

    private void parsePointers() throws InclusionException {
        this.pointers = null;
        this.textFragmentIdentifier = null;
        if (this.parseText) {
            if (this.xpointer != null) {
                throw new InclusionException(Msg.msg("xpointerToText"));
            }
            if (this.fragid != null) {
                this.textFragmentIdentifier = TextFragmentIdentifier.parse(this.fragid);
                if (this.textFragmentIdentifier == null) {
                    throw new InclusionException(Msg.msg("invalidAttr", this.fragid, XInclude.FRAGID_ATTR.localPart));
                }
            }
        } else if (this.xpointer == null && this.fragid == null) {
            this.pointers = DOCUMENT_CONTENTS_POINTER;
        } else {
            try {
                this.pointers = XPointer.parse(this.xpointer != null ? this.xpointer : this.fragid);
            }
            catch (XPointerException xPointerException) {
                throw new InclusionException(ThrowableUtil.reason(xPointerException));
            }
        }
    }

    public boolean hasSimpleXPointer() {
        if (this.pointers == null) {
            return true;
        }
        if (this.pointers.length != 1 || !(this.pointers[0] instanceof ElementXPointer)) {
            return false;
        }
        ElementXPointer elementXPointer = (ElementXPointer)this.pointers[0];
        return elementXPointer.isElementID() || elementXPointer.isRootElement();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("<xi:include href=\"");
        stringBuilder.append(this.absoluteHref != null ? this.absoluteHref : this.href);
        stringBuilder.append('\"');
        if (this.parseText) {
            stringBuilder.append("\n  parse=\"text\"");
            if (this.fragid != null) {
                stringBuilder.append(" fragid=\"");
                stringBuilder.append(this.fragid);
                stringBuilder.append('\"');
            }
            if (this.textEncoding != null) {
                stringBuilder.append(" encoding=\"");
                stringBuilder.append(this.textEncoding);
                stringBuilder.append('\"');
            }
        } else if (this.xpointer != null) {
            stringBuilder.append("\n  xpointer=\"");
            stringBuilder.append(this.xpointer);
            stringBuilder.append('\"');
        } else if (this.fragid != null) {
            stringBuilder.append("\n  fragid=\"");
            stringBuilder.append(this.fragid);
            stringBuilder.append('\"');
        }
        if (this.attributes != null) {
            stringBuilder.append("\n ");
            for (Attribute attribute : this.attributes) {
                stringBuilder.append(' ');
                stringBuilder.append(attribute.name.format(true, prefixPrefs));
                stringBuilder.append('=');
                char c = attribute.value.indexOf(34) < 0 ? (char)'\"' : '\'';
                stringBuilder.append(c);
                stringBuilder.append(attribute.value);
                stringBuilder.append(c);
            }
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    public XInclude(String string) throws InclusionException {
        int n;
        String[] stringArray = ProcessingInstruction.parsePseudoAttributes(string);
        if (stringArray == null || (n = stringArray.length) == 0) {
            throw new InclusionException(Msg.msg("invalidClipboardForm", string));
        }
        URL uRL = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        String string5 = null;
        Attribute[] attributeArray = null;
        Element element = null;
        for (int i = 0; i < n; i += 2) {
            Object object;
            Object object2;
            String string6 = stringArray[i];
            String string7 = stringArray[i + 1];
            if ("href".equals(string6)) {
                try {
                    uRL = URLUtil.createURL(string7);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new InclusionException(Msg.msg("invalidPseudoAttr", string7, string6));
                }
            }
            if ("absoluteHref".equals(string6)) {
                string2 = string7;
                continue;
            }
            if ("xpointer".equals(string6)) {
                string3 = string7;
                continue;
            }
            if ("fragid".equals(string6)) {
                string4 = string7;
                continue;
            }
            if ("parse".equals(string6)) {
                bl = "text".equals(string7);
                continue;
            }
            if ("encoding".equals(string6)) {
                string5 = string7;
                continue;
            }
            if ("fallback".equals(string6)) {
                object2 = new InputSource(new StringReader(string7));
                ((InputSource)object2).setSystemId("(string)");
                object = new DocumentLoader();
                try {
                    Document document = ((DocumentLoader)object).load((InputSource)object2);
                    element = document.getRootElement();
                    document.removeChild(element);
                    if (element.getName() != Name.XI_FALLBACK) {
                        element = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (element != null) continue;
                throw new InclusionException(Msg.msg("invalidPseudoAttr", string7, string6));
            }
            object2 = Name.fromString(string6);
            if (object2 == null || object2 != SET_XML_ID_ATTR && (((Name)object2).namespace == Namespace.NONE || ((Name)object2).namespace == Namespace.XML)) continue;
            object = new Attribute(null, (Name)object2, string7);
            attributeArray = attributeArray == null ? new Attribute[]{object} : (Attribute[])ArrayUtil.append(attributeArray, object);
        }
        if (uRL == null) {
            throw new InclusionException(Msg.msg("missingPseudoAttr", "href"));
        }
        this.href = uRL;
        this.absoluteHref = string2;
        this.xpointer = string3;
        this.fragid = string4;
        this.parseText = bl;
        this.textEncoding = string5;
        this.attributes = attributeArray;
        this.fallback = element;
        this.parsePointers();
    }

    @Override
    public void setMarkedForUpdate(boolean bl) {
        this.markedForUpdate = bl;
    }

    @Override
    public boolean isMarkedForUpdate() {
        return this.markedForUpdate;
    }

    @Override
    public Node[] include(Node node, Node node2, boolean bl, XInclusionContext xInclusionContext) throws InclusionException {
        Node[] nodeArray = null;
        if (this.parseText) {
            String string;
            try {
                string = this.textEncoding != null ? URLUtil.loadString(this.href, this.textEncoding) : LoadText.loadText(this.href, null, null, LoadText.ALL_ENCODING_DETECTORS);
            }
            catch (IOException iOException) {
                throw new InclusionException(Msg.msg("cannotLoadText", this.href, ThrowableUtil.reason(iOException)));
            }
            if (this.textFragmentIdentifier != null && (string = this.textFragmentIdentifier.getFragment(string)) == null) {
                throw new InclusionException(Msg.msg("noSuchTextFragment", this.fragid, this.href));
            }
            Text text = new Text(string);
            text.putProperty(Constants.SOURCE_URL_PROPERTY, this.href);
            nodeArray = new Node[]{text};
        } else {
            Document document = xInclusionContext.getDocument(this.href);
            Element element = node.getParentElement();
            nodeArray = this.getIncludedNodes(document, true, element, xInclusionContext);
            this.copyAttributes(nodeArray);
            XInclude.declarePrefixes(nodeArray, document);
        }
        return nodeArray;
    }

    private Node[] getIncludedNodes(Document document, boolean bl, Element element, XInclusionContext xInclusionContext) throws InclusionException {
        int n = this.pointers.length;
        if (n == 1 && this.pointers[0] == DOCUMENT_CONTENTS_POINTER[0]) {
            return XInclude.getDocumentNodes(document, bl);
        }
        Node[] nodeArray = null;
        String string = null;
        for (int i = 0; i < n; ++i) {
            Object object;
            Name[] nameArray;
            SimpleXPointer simpleXPointer = this.pointers[i];
            if (simpleXPointer instanceof ElementXPointer) {
                nameArray = (ElementXPointer)simpleXPointer;
                object = new XIncludeContext(xInclusionContext);
                nodeArray = nameArray.findNodes(document, object);
            } else if (simpleXPointer instanceof XPointerXPointer) {
                nameArray = (XPointerXPointer)simpleXPointer;
                object = new XIncludeExprContext(xInclusionContext);
                try {
                    nodeArray = nameArray.findNodes(document, object);
                }
                catch (XPointerException xPointerException) {
                    string = ThrowableUtil.reason(xPointerException);
                }
            }
            if (nodeArray == null || nodeArray.length <= 0) continue;
            nameArray = XInclude.whichLangAttributes(document);
            nodeArray = XInclude.getNodes(nodeArray, nameArray, bl, element);
            break;
        }
        if (nodeArray == null || nodeArray.length == 0) {
            Object object = Msg.msg("includedNodesNotFound", this.href, this.xpointer != null ? this.xpointer : this.fragid);
            if (string != null) {
                object = (String)object + ": " + string;
            }
            throw new InclusionException((String)object);
        }
        return nodeArray;
    }

    private static Name[] whichLangAttributes(Document document) {
        Element element;
        Name[] nameArray = Name.EMPTY_LIST;
        Element element2 = element = document == null ? null : document.getRootElement();
        if (element != null) {
            if (DocumentTypeUtil.getAttributeType(element, Name.XML_LANG) != null) {
                nameArray = ArrayUtil.append(nameArray, Name.XML_LANG);
            }
            if (DocumentTypeUtil.getAttributeType(element, Name.LANG) != null) {
                nameArray = ArrayUtil.append(nameArray, Name.LANG);
            }
        }
        return nameArray;
    }

    private static Node[] getDocumentNodes(Document document, boolean bl) {
        Node node;
        int n = 0;
        for (node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: 
                case ELEMENT: {
                    ++n;
                }
            }
        }
        Name[] nameArray = XInclude.whichLangAttributes(document);
        Node[] nodeArray = new Node[n];
        n = 0;
        for (node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case COMMENT: 
                case PROCESSING_INSTRUCTION: 
                case ELEMENT: {
                    nodeArray[n++] = XInclude.getNode(node, nameArray, bl, null);
                }
            }
        }
        return nodeArray;
    }

    private static Node[] getNodes(Node[] nodeArray, Name[] nameArray, boolean bl, Element element) {
        if (bl) {
            int n = nodeArray.length;
            for (int i = 0; i < n; ++i) {
                nodeArray[i] = XInclude.getNode(nodeArray[i], nameArray, bl, element);
            }
        }
        return nodeArray;
    }

    private static Node getNode(Node node, Name[] nameArray, boolean bl, Element element) {
        if (bl) {
            Node node2 = node.copy();
            URL uRL = node.getSourceURL();
            if (uRL != null) {
                node2.putProperty(Constants.SOURCE_URL_PROPERTY, uRL);
            }
            if (node.getType() == Node.Type.ELEMENT) {
                String string;
                Element element2 = (Element)node;
                Element element3 = (Element)node2;
                URL uRL2 = element2.getBaseURL();
                if (uRL2 != null) {
                    if (!uRL2.equals(uRL)) {
                        string = uRL == null ? uRL2.toExternalForm() : URLUtil.getRawRelativePath(uRL2, uRL);
                        element3.putAttribute(Name.XML_BASE, string);
                    } else {
                        element3.removeAttribute(Name.XML_BASE);
                    }
                }
                if ((string = XInclude.lookupLang(element2, nameArray)) != null) {
                    String string2 = null;
                    if (element != null) {
                        string2 = XInclude.lookupLang(element, nameArray);
                    }
                    if (!string.equals(string2)) {
                        for (Name name : nameArray) {
                            element3.putAttribute(name, string);
                        }
                    } else {
                        for (Name name : nameArray) {
                            element3.removeAttribute(name);
                        }
                    }
                }
            }
            return node2;
        }
        return node;
    }

    private static String lookupLang(Element element, Name[] nameArray) {
        String string = null;
        if (nameArray.length > 0) {
            string = AttributeUtil.lookupAttribute(element, nameArray, null);
            if (string != null) {
                if ((string = string.trim()).length() > 0) {
                    string = LocaleUtil.normalizeLang(string);
                }
            } else {
                string = "";
            }
        }
        return string;
    }

    private static void declarePrefixes(Node[] nodeArray, Document document) {
        Element element = null;
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i].getType() != Node.Type.ELEMENT) continue;
            element = (Element)nodeArray[i];
            break;
        }
        if (element == null) {
            return;
        }
        PrefixEntry[] prefixEntryArray = document.getPrefixPreferences(false);
        if (prefixEntryArray != null) {
            element.putProperty(Constants.DECLARED_PREFIXES_PROPERTY, prefixEntryArray);
        }
    }

    private void copyAttributes(Node[] nodeArray) {
        if (this.attributes != null) {
            for (Node node : nodeArray) {
                if (node.getType() != Node.Type.ELEMENT) continue;
                Element element = (Element)node;
                for (Attribute attribute : this.attributes) {
                    if (attribute.name == SET_XML_ID_ATTR) {
                        if (attribute.value.length() == 0) {
                            element.removeAttribute(Name.XML_ID);
                            continue;
                        }
                        element.putAttribute(Name.XML_ID, attribute.value);
                        continue;
                    }
                    if (attribute.name.namespace == Namespace.XI_LOCAL_ATTRIBUTES) {
                        element.putAttribute(Name.get(Namespace.NONE, attribute.name.localPart), attribute.value);
                        continue;
                    }
                    element.putAttribute(attribute.name, attribute.value);
                }
            }
        }
    }

    @Override
    public Node[] uninclude(Node node, Node node2) {
        Element element = new Element(Name.XI_INCLUDE);
        element.putProperty(Constants.DECLARED_PREFIXES_PROPERTY, XI_PREFIXES);
        if (this.absoluteHref != null) {
            element.putAttribute(HREF_ATTR, this.absoluteHref);
        } else {
            Attribute[] attributeArray = node.getParent().getBaseURL();
            if (this.href.equals(attributeArray)) {
                element.putAttribute(HREF_ATTR, "");
            } else {
                String string = null;
                if (attributeArray != null) {
                    string = URLUtil.getRawRelativePath(this.href, (URL)attributeArray);
                }
                if (string == null) {
                    string = this.href.toExternalForm();
                }
                element.putAttribute(HREF_ATTR, string);
            }
        }
        if (this.parseText) {
            element.putAttribute(PARSE_ATTR, "text");
            if (this.fragid != null) {
                element.putAttribute(FRAGID_ATTR, this.fragid);
            }
            if (this.textEncoding != null) {
                element.putAttribute(ENCODING_ATTR, this.textEncoding);
            }
        } else if (this.xpointer != null) {
            element.putAttribute(XPOINTER_ATTR, this.xpointer);
        } else if (this.fragid != null) {
            element.putAttribute(FRAGID_ATTR, this.fragid);
        }
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                element.putAttribute(attribute.name, attribute.value);
            }
        }
        if (this.fallback != null) {
            element.appendChild(this.fallback.copy());
        }
        return new Node[]{element};
    }

    @Override
    public String toClipboardForm() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("href");
        arrayList.add(this.href.toExternalForm());
        if (this.absoluteHref != null) {
            arrayList.add("absoluteHref");
            arrayList.add(this.absoluteHref);
        }
        if (this.xpointer != null) {
            arrayList.add("xpointer");
            arrayList.add(this.xpointer);
        }
        if (this.fragid != null) {
            arrayList.add("fragid");
            arrayList.add(this.fragid);
        }
        if (this.parseText) {
            arrayList.add("parse");
            arrayList.add("text");
            if (this.textEncoding != null) {
                arrayList.add("encoding");
                arrayList.add(this.textEncoding);
            }
        }
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                arrayList.add(attribute.name.toString());
                arrayList.add(attribute.value);
            }
        }
        if (this.fallback != null) {
            object = new StringWriter();
            DocumentWriter documentWriter = new DocumentWriter((Writer)object);
            documentWriter.setPrefixPreferences(XI_PREFIXES);
            documentWriter.setPreserveInclusions(false);
            try {
                documentWriter.write(this.fallback);
                documentWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            arrayList.add("fallback");
            arrayList.add(((StringWriter)object).toString());
        }
        object = new String[arrayList.size()];
        arrayList.toArray((T[])object);
        return ProcessingInstruction.formatPseudoAttributes((String[])object);
    }

    @Override
    public URL getSourceURL(Node node) {
        return this.href;
    }

    @Override
    public Node[] getSourceNodes(Document document, Node node) throws InclusionException {
        if (this.parseText) {
            throw new InclusionException(Msg.msg("noSourceNodes"));
        }
        return this.getIncludedNodes(document, false, null, new XInclusionContextImpl(true, document));
    }

    @Override
    public Node[] copySourceNodes(Node node, Node node2) {
        Node[] nodeArray = XInclude.doCopySourceNodes(node, node2);
        this.copyAttributes(nodeArray);
        return nodeArray;
    }

    private static Node[] doCopySourceNodes(Node node, Node node2) {
        Node node3;
        int n;
        if (node != node2) {
            n = 1;
            for (node3 = node; node3 != null; node3 = node3.getNextSibling()) {
                if (node3 != node2) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                node3 = node;
                node = node2;
                node2 = node3;
            }
        }
        n = 0;
        for (node3 = node; node3 != null; node3 = node3.getNextSibling()) {
            ++n;
            if (node3 == node2) break;
        }
        Name[] nameArray = XInclude.whichLangAttributes(node.getDocument());
        Node[] nodeArray = new Node[n];
        n = 0;
        for (node3 = node; node3 != null; node3 = node3.getNextSibling()) {
            Node node4 = XInclude.getNode(node3, nameArray, true, null);
            nodeArray[n++] = node4;
            if (node3 == node2) break;
        }
        return nodeArray;
    }

    public static String toHref(NodeIterator nodeIterator) {
        Element element = XPathUtil.toElement(nodeIterator);
        if (element == null) {
            return "-";
        }
        String string = element.getAttribute(PARSE_ATTR);
        if (!(string == null || "xml".equals(string = string.toLowerCase().trim()) || "application/xml".equals(string) || string.endsWith("+xml"))) {
            return "-";
        }
        String string2 = element.getAttribute(HREF_ATTR);
        string2 = string2 != null ? string2.trim() : "";
        String string3 = element.getAttribute(XPOINTER_ATTR);
        if (string3 == null) {
            string3 = element.getAttribute(FRAGID_ATTR);
        }
        if (string3 != null) {
            int n;
            if ((string3 = string3.trim()).startsWith("element(") && (n = string3.indexOf(41, 8)) > 8) {
                String string4 = string3.substring(8, n);
                if ("/1".equals(string4)) {
                    if (string2.length() > 0) {
                        string3 = null;
                    }
                } else if (string4.indexOf(47) < 0) {
                    string3 = string4;
                }
            }
            string2 = URIComponent.setFragment(string2, string3);
        }
        return string2;
    }

    private static final class XIncludeDocumentManager
    implements DocumentManager {
        private final XInclusionContext context;

        public XIncludeDocumentManager(XInclusionContext xInclusionContext) {
            this.context = xInclusionContext;
        }

        @Override
        public Document getDocument(URL uRL) throws IOException {
            try {
                return this.context.getDocument(uRL);
            }
            catch (InclusionException inclusionException) {
                throw new IOException(ThrowableUtil.reason(inclusionException));
            }
        }
    }

    private static final class XIncludeExprContext
    extends ExprContextImpl {
        private final XInclusionContext context;

        public XIncludeExprContext(XInclusionContext xInclusionContext) {
            super(new XIncludeDocumentManager(xInclusionContext));
            this.context = xInclusionContext;
        }

        @Override
        public XNode findElementWithId(XNode xNode, String string) throws EvalException {
            Document document = (Document)xNode.document();
            return this.context.findElementById(document, string);
        }

        @Override
        public boolean isElementWithId(XNode xNode, String string) throws EvalException {
            Document document = (Document)xNode.document();
            Element element = this.context.findElementById(document, string);
            return element == null ? false : element == xNode;
        }
    }

    private static final class XIncludeContext
    implements ElementXPointer.Context {
        private final XInclusionContext context;

        public XIncludeContext(XInclusionContext xInclusionContext) {
            this.context = xInclusionContext;
        }

        @Override
        public Element findElementById(Document document, String string) {
            return this.context.findElementById(document, string);
        }
    }
}

