/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xed;

import com.xmlmind.util.Console;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.xed.Msg;
import com.xmlmind.xml.xed.Script;
import com.xmlmind.xml.xed.ScriptLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public final class ScriptCache {
    private static final HashMap<URL, Script> cache = new HashMap();

    private ScriptCache() {
    }

    public static Script load(String string, URL uRL, Console console) throws IOException {
        URL uRL2 = null;
        try {
            uRL2 = XMLCatalogs.resolveURI(string, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL2 == null) {
            throw new IOException(Msg.msg("notAnURL", string));
        }
        return ScriptCache.load(uRL2, console);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Script load(URL uRL, Console console) throws IOException {
        HashMap<URL, Script> hashMap = cache;
        synchronized (hashMap) {
            Script script = cache.get(uRL);
            if (script == null) {
                if (console != null) {
                    console.showMessage(Msg.msg("loadingScript", uRL), Console.MessageType.DEBUG);
                }
                try {
                    script = new ScriptLoader().load(uRL);
                }
                catch (Exception exception) {
                    throw new IOException(Msg.msg("cannotLoadScript", uRL, ThrowableUtil.reason(exception)));
                }
                cache.put(uRL, script);
            }
            return script;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        HashMap<URL, Script> hashMap = cache;
        synchronized (hashMap) {
            cache.clear();
        }
    }
}

