/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xed;

import com.xmlmind.util.Console;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.xed.Action;
import com.xmlmind.xml.xed.ActionException;
import com.xmlmind.xml.xed.Command;
import com.xmlmind.xml.xed.MacroExprContext;
import com.xmlmind.xml.xed.Msg;
import com.xmlmind.xml.xed.Script;
import com.xmlmind.xml.xed.ScriptLoadException;
import com.xmlmind.xml.xed.SetVariableCmd;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Variant;

final class MacroCmd
extends Command
implements Comparable<MacroCmd> {
    public final String name;
    public final String[] parameterNames;
    public final Action[] actions;

    public MacroCmd(String string, String[] stringArray, Action[] actionArray) {
        this.name = string;
        this.parameterNames = stringArray;
        this.actions = actionArray;
    }

    public void resolveCommands(Script script) throws ScriptLoadException {
        for (Action action : this.actions) {
            action.resolveCommands(script);
        }
    }

    @Override
    public void executeCommand(Object[] objectArray, XNode xNode, ExprContext exprContext, Script script, Console console) throws RuntimeException, ActionException {
        int n = this.parameterNames.length;
        if (objectArray.length != n) {
            throw new RuntimeException(Msg.msg("wrongNumberOfArguments", objectArray.length, this.name));
        }
        MacroExprContext macroExprContext = new MacroExprContext(exprContext);
        for (int i = 0; i < n; ++i) {
            String string = this.parameterNames[i];
            Variant variant = SetVariableCmd.evaluateArgument(objectArray[i], xNode, exprContext, this.name, string);
            macroExprContext.setLocalVariable(Name.get(string), variant);
        }
        for (Action action : this.actions) {
            try {
                action.performAction(xNode, macroExprContext, script, console);
            }
            catch (ActionException actionException) {
                throw actionException;
            }
            catch (Exception exception) {
                throw new ActionException(action.name, action.scriptURL, action.lineNumber, action.columnNumber, ThrowableUtil.reason(exception));
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("macro ");
        stringBuilder.append(this.name);
        stringBuilder.append("(");
        for (int i = 0; i < this.parameterNames.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.parameterNames[i]);
        }
        stringBuilder.append(") {\n");
        for (Action action : this.actions) {
            action.toString(4, stringBuilder);
            stringBuilder.append('\n');
        }
        stringBuilder.append('}');
    }

    @Override
    public int compareTo(MacroCmd macroCmd) {
        return this.name.compareTo(macroCmd.name);
    }
}

