/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xed;

import com.xmlmind.util.Console;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xed.Action;
import com.xmlmind.xml.xed.ActionException;
import com.xmlmind.xml.xed.Script;
import com.xmlmind.xml.xed.ScriptLoadException;
import com.xmlmind.xml.xed.XPathExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Variant;

final class IfAction
extends Action {
    public final TestCase[] testCases;

    public IfAction(TestCase[] testCaseArray) {
        super("if");
        this.testCases = testCaseArray;
    }

    @Override
    public void resolveCommands(Script script) throws ScriptLoadException {
        for (TestCase testCase : this.testCases) {
            for (Action action : testCase.actions) {
                action.resolveCommands(script);
            }
        }
    }

    @Override
    public void performAction(XNode xNode, ExprContext exprContext, Script script, Console console) throws EvalException, ActionException {
        for (TestCase testCase : this.testCases) {
            boolean bl = true;
            if (testCase.expr != null) {
                Variant variant = testCase.expr.expr.eval(xNode, exprContext);
                bl = variant.convertToBoolean();
            }
            if (!bl) continue;
            for (Action action : testCase.actions) {
                try {
                    action.performAction(xNode, exprContext, script, console);
                }
                catch (ActionException actionException) {
                    throw actionException;
                }
                catch (Exception exception) {
                    throw new ActionException(action.name, action.scriptURL, action.lineNumber, action.columnNumber, IfAction.errorReason(exception));
                }
            }
            break;
        }
    }

    @Override
    public void toString(int n, StringBuilder stringBuilder) {
        int n2 = this.testCases.length - 1;
        for (int i = 0; i <= n2; ++i) {
            TestCase testCase = this.testCases[i];
            IfAction.indent(n, stringBuilder);
            String string = i == 0 ? "if " : (i == n2 ? "} else" : "} elseif ");
            stringBuilder.append(string);
            if (testCase.expr != null) {
                stringBuilder.append(testCase.expr);
            }
            stringBuilder.append(" {\n");
            for (Action action : testCase.actions) {
                action.toString(n + 4, stringBuilder);
                stringBuilder.append('\n');
            }
        }
        IfAction.indent(n, stringBuilder);
        stringBuilder.append('}');
    }

    public static final class TestCase {
        public final XPathExpr expr;
        public final Action[] actions;

        public TestCase(XPathExpr xPathExpr, Action[] actionArray) {
            this.expr = xPathExpr;
            this.actions = actionArray;
        }
    }
}

