/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xed;

import com.xmlmind.util.Console;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xed.Action;
import com.xmlmind.xml.xed.ActionException;
import com.xmlmind.xml.xed.ForEachException;
import com.xmlmind.xml.xed.Script;
import com.xmlmind.xml.xed.ScriptLoadException;
import com.xmlmind.xml.xed.XPathExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.Variant;

final class ForEachAction
extends Action {
    public final XPathExpr expr;
    public final Action[] actions;

    public ForEachAction(XPathExpr xPathExpr, Action[] actionArray) {
        super("for-each");
        this.expr = xPathExpr;
        this.actions = actionArray;
    }

    @Override
    public void resolveCommands(Script script) throws ScriptLoadException {
        for (Action action : this.actions) {
            action.resolveCommands(script);
        }
    }

    @Override
    public void performAction(XNode xNode, ExprContext exprContext, Script script, Console console) throws EvalException, ActionException {
        XNode xNode2;
        Variant variant = this.expr.expr.eval(xNode, exprContext);
        variant = variant.makePermanent();
        NodeIterator nodeIterator = variant.convertToNodeSet();
        while ((xNode2 = nodeIterator.next()) != null) {
            try {
                ForEachAction.performActions(this.actions, xNode2, exprContext, script, console);
            }
            catch (ForEachException forEachException) {
                if (!forEachException.breakForEach) continue;
                break;
            }
        }
    }

    private static void performActions(Action[] actionArray, XNode xNode, ExprContext exprContext, Script script, Console console) throws ActionException {
        for (Action action : actionArray) {
            try {
                action.performAction(xNode, exprContext, script, console);
            }
            catch (ActionException actionException) {
                throw actionException;
            }
            catch (Exception exception) {
                throw new ActionException(action.name, action.scriptURL, action.lineNumber, action.columnNumber, ForEachAction.errorReason(exception));
            }
        }
    }

    @Override
    public void toString(int n, StringBuilder stringBuilder) {
        ForEachAction.indent(n, stringBuilder);
        stringBuilder.append("for-each ");
        stringBuilder.append(this.expr);
        stringBuilder.append(" {\n");
        for (Action action : this.actions) {
            action.toString(n + 4, stringBuilder);
            stringBuilder.append('\n');
        }
        ForEachAction.indent(n, stringBuilder);
        stringBuilder.append('}');
    }
}

