/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.validate.AttributeDefaultValue;
import com.xmlmind.xml.validate.Diagnostic;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.IDDataType;
import com.xmlmind.xml.validate.IdEntry;
import com.xmlmind.xml.validate.IdRefItem;
import com.xmlmind.xml.validate.SchemaKind;
import com.xmlmind.xml.validate.SubDocumentType;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.Value;
import com.xmlmind.xml.wxs.validate.AttributeDeclaration;
import com.xmlmind.xml.wxs.validate.BuiltInType;
import com.xmlmind.xml.wxs.validate.ComplexType;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.ElementTypeImpl;
import com.xmlmind.xml.wxs.validate.IdCollector;
import com.xmlmind.xml.wxs.validate.IdFinder;
import com.xmlmind.xml.wxs.validate.IdentityConstraintChecker;
import com.xmlmind.xml.wxs.validate.Msg;
import com.xmlmind.xml.wxs.validate.Notation;
import com.xmlmind.xml.wxs.validate.SimpleType;
import com.xmlmind.xml.wxs.validate.Type;
import com.xmlmind.xml.wxs.validate.ValidationError;
import com.xmlmind.xml.wxs.validate.ValidationErrors;
import com.xmlmind.xml.wxs.validate.Wildcard;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Schema
implements Serializable,
SubDocumentType {
    private IdentityHashMap<Name, ElementDeclaration> elementDeclarations = new IdentityHashMap();
    private IdentityHashMap<Name, AttributeDeclaration> attributeDeclarations = new IdentityHashMap();
    private IdentityHashMap<Name, Type> types = new IdentityHashMap();
    private IdentityHashMap<Name, Notation> notations = new IdentityHashMap();
    private PrefixEntry[] declaredPrefixes = null;
    private URL[] urls = new URL[0];

    public ElementDeclaration addElementDeclaration(ElementDeclaration elementDeclaration) {
        return this.elementDeclarations.put(elementDeclaration.name, elementDeclaration);
    }

    public AttributeDeclaration addAttributeDeclaration(AttributeDeclaration attributeDeclaration) {
        return this.attributeDeclarations.put(attributeDeclaration.name, attributeDeclaration);
    }

    public Type addType(Type type) {
        return this.types.put(type.name, type);
    }

    public Notation addNotation(Notation notation) {
        return this.notations.put(notation.name, notation);
    }

    public void setDeclaredPrefixes(PrefixEntry[] prefixEntryArray) {
        this.declaredPrefixes = prefixEntryArray;
    }

    public void setURLs(URL[] uRLArray) {
        this.urls = uRLArray == null ? new URL[0] : uRLArray;
    }

    public ElementDeclaration getElementDeclaration(Name name) {
        return this.elementDeclarations.get(name);
    }

    public int getElementDeclarationCount() {
        return this.elementDeclarations.size();
    }

    public Iterator<ElementDeclaration> getElementDeclarations() {
        return this.elementDeclarations.values().iterator();
    }

    public AttributeDeclaration getAttributeDeclaration(Name name) {
        return this.attributeDeclarations.get(name);
    }

    public int getAttributeDeclarationCount() {
        return this.attributeDeclarations.size();
    }

    public Iterator<AttributeDeclaration> getAttributeDeclarations() {
        return this.attributeDeclarations.values().iterator();
    }

    public Type findType(Name name) {
        Type type = BuiltInType.get(name);
        if (type != null) {
            return type;
        }
        return this.types.get(name);
    }

    public Type getType(Name name) {
        return this.types.get(name);
    }

    public int getTypeCount() {
        return this.types.size();
    }

    public Iterator<Type> getTypes() {
        return this.types.values().iterator();
    }

    public Notation getNotation(Name name) {
        return this.notations.get(name);
    }

    public int getNotationCount() {
        return this.notations.size();
    }

    public Iterator<Notation> getNotations() {
        return this.notations.values().iterator();
    }

    public ValidationError[] validate(Document document) {
        ValidationErrors validationErrors = new ValidationErrors();
        this.validate(document.getRootElement(), validationErrors);
        return validationErrors.toArray();
    }

    protected Object validate(Element element, ValidationErrors validationErrors) {
        Type type = this.findElementType(element, element);
        if (type == null) {
            validationErrors.append(element, "cvc-type.1", Msg.msg("elementTypeNotFound"));
            return null;
        }
        Object object = type.validate(element, true, this, validationErrors);
        if (object != null) {
            boolean bl = this.checkIdentityConstraints(element, element, validationErrors);
            boolean bl2 = this.checkIds(element, element, validationErrors);
            if (!bl || !bl2) {
                object = null;
            }
        }
        return object;
    }

    protected boolean checkIds(Element element, Element element2, ValidationErrors validationErrors) {
        HashMap<String, IdEntry> hashMap = new HashMap<String, IdEntry>();
        ArrayList<IdRefItem> arrayList = new ArrayList<IdRefItem>();
        new IdCollector(this).collect(element, element2, hashMap, arrayList);
        boolean bl = true;
        for (IdEntry idEntry : hashMap.values()) {
            if (idEntry.elements.length <= 1) continue;
            Element[] elementArray = idEntry.elements;
            int n = elementArray.length;
            Element object = elementArray[0];
            for (int i = 1; i < n; ++i) {
                ValidationError validationError = validationErrors.append(elementArray[i], "cvc-id.2", Msg.msg("multiplyDefinedID", idEntry.id));
                validationError.detailId = "DUPLICATE_ID";
                validationError.detailValues = new Object[]{idEntry.id, object};
                bl = false;
            }
        }
        int n = arrayList.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                IdRefItem idRefItem = arrayList.get(i);
                for (String string : idRefItem.idRefs) {
                    if (hashMap.containsKey(string)) continue;
                    ValidationError validationError = validationErrors.append(idRefItem.element, "cvc-id.1", Msg.msg("referenceToUndefinedID", string));
                    validationError.detailId = "BROKEN_IDREF";
                    validationError.detailValues = new Object[]{string};
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected boolean checkIdentityConstraints(Element element, Element element2, ValidationErrors validationErrors) {
        return new IdentityConstraintChecker(this).check(element, element2, validationErrors);
    }

    public Type findElementType(Element element, Element element2) {
        return this.findElementType(element, element2, null);
    }

    Type findElementType(Element element, Element element2, boolean[] blArray) {
        Serializable serializable;
        Tree tree;
        if (blArray != null) {
            blArray[0] = false;
        }
        int n = 0;
        for (tree = element; tree != null; tree = tree.getParent()) {
            ++n;
            if (tree == element2) break;
        }
        Element[] elementArray = new Element[n];
        n = 0;
        Type type = null;
        tree = element;
        while (tree instanceof Element) {
            serializable = tree;
            elementArray[n++] = serializable;
            type = this.getElementLocalType((Element)serializable);
            if (type != null || tree == element2) break;
            tree = tree.getParent();
        }
        if (type == null) {
            if (elementArray[n - 1] != element2) {
                throw new IllegalArgumentException(Msg.msg("notAnAncestor", element2.getLabel(), element.getLabel()));
            }
            serializable = this.getElementDeclaration(element2.getName());
            if (serializable == null) {
                return null;
            }
            type = ((ElementDeclaration)serializable).type;
        }
        for (int i = n - 1; i >= 1; --i) {
            Wildcard[] wildcardArray;
            Name name;
            ComplexType complexType;
            ElementDeclaration elementDeclaration = null;
            if (type instanceof ComplexType && (complexType = (ComplexType)type).containsElementField(name = elementArray[i - 1].getName()) && (elementDeclaration = complexType.getElementDeclaration(name)) == null && (elementDeclaration = this.getElementDeclaration(name)) == null && blArray != null && (wildcardArray = complexType.getElementWildcards()) != null) {
                for (Wildcard wildcard : wildcardArray) {
                    if (!wildcard.match(name)) continue;
                    blArray[0] = true;
                    break;
                }
            }
            if (elementDeclaration == null) {
                return null;
            }
            type = elementDeclaration.type;
        }
        return type;
    }

    public Type getElementLocalType(Element element) {
        String string = element.getAttribute(Name.XSI_TYPE);
        if (string == null) {
            return null;
        }
        Name name = Name.parse(string, false, element);
        return name == null ? null : this.findType(name);
    }

    public ElementDeclaration findElementDeclaration(Element element, Element element2) {
        Name name = element.getName();
        if (element == element2) {
            return this.getElementDeclaration(name);
        }
        Tree tree = element.getParent();
        if (tree == null) {
            return null;
        }
        if (tree instanceof Document) {
            return this.getElementDeclaration(name);
        }
        Type type = this.findElementType((Element)tree, element2);
        if (type == null || type instanceof SimpleType) {
            return null;
        }
        ComplexType complexType = (ComplexType)type;
        ElementDeclaration elementDeclaration = null;
        if (complexType.containsElementField(name) && (elementDeclaration = complexType.getElementDeclaration(name)) == null) {
            elementDeclaration = this.getElementDeclaration(name);
        }
        return elementDeclaration;
    }

    public AttributeDeclaration findAttributeDeclaration(Element element, Element element2, Name name) {
        Type type = this.findElementType(element, element2);
        if (type == null || type instanceof SimpleType) {
            return null;
        }
        ComplexType complexType = (ComplexType)type;
        AttributeDeclaration attributeDeclaration = null;
        if (complexType.containsAttributeField(name) && (attributeDeclaration = complexType.getAttributeDeclaration(name)) == null) {
            attributeDeclaration = this.getAttributeDeclaration(name);
        }
        return attributeDeclaration;
    }

    @Override
    public SchemaKind getSchemaKind() {
        return SchemaKind.WXS;
    }

    @Override
    public URL[] getSchemaURLs() {
        return this.urls;
    }

    @Override
    public PrefixEntry[] getSchemaDeclaredPrefixes() {
        return this.declaredPrefixes;
    }

    @Override
    public Diagnostic[] checkDocument(Element element) {
        ValidationErrors validationErrors = new ValidationErrors();
        this.validate(element, validationErrors);
        return validationErrors.toArray();
    }

    @Override
    public Name[] getRootElementNames() {
        int n = this.elementDeclarations.size();
        Name[] nameArray = new Name[n];
        this.elementDeclarations.keySet().toArray(nameArray);
        return nameArray;
    }

    @Override
    public ElementType[] getElementType(Name name) {
        HashSet<ElementDeclEntry> hashSet = new HashSet<ElementDeclEntry>();
        HashSet<ElementDeclEntry> hashSet2 = new HashSet<ElementDeclEntry>();
        Iterator<ElementDeclaration> iterator = this.getElementDeclarations();
        while (iterator.hasNext()) {
            ElementDeclaration elementDeclaration = iterator.next();
            this.doGetElementType(name, elementDeclaration, hashSet, hashSet2);
        }
        int n = hashSet2.size();
        if (n == 0) {
            return null;
        }
        ElementType[] elementTypeArray = new ElementType[n];
        n = 0;
        for (ElementDeclEntry elementDeclEntry : hashSet2) {
            elementTypeArray[n++] = new ElementTypeImpl(this, elementDeclEntry.decl, null);
        }
        return elementTypeArray;
    }

    private void doGetElementType(Name name, ElementDeclaration elementDeclaration, Set<ElementDeclEntry> set, Set<ElementDeclEntry> set2) {
        ElementDeclEntry elementDeclEntry = new ElementDeclEntry(elementDeclaration);
        if (!set.add(elementDeclEntry)) {
            return;
        }
        if (elementDeclaration.name == name) {
            set2.add(elementDeclEntry);
        } else {
            Type type = elementDeclaration.type;
            if (type instanceof ComplexType) {
                Name[] nameArray;
                ComplexType complexType = (ComplexType)type;
                for (Name name2 : nameArray = complexType.getElementFields()) {
                    ElementDeclaration elementDeclaration2 = complexType.getElementDeclaration(name2);
                    if (elementDeclaration2 == null) {
                        elementDeclaration2 = this.getElementDeclaration(name2);
                    }
                    if (elementDeclaration2 == null) continue;
                    this.doGetElementType(name, elementDeclaration2, set, set2);
                }
            }
        }
    }

    @Override
    public ElementType getElementType(Element element, Element element2) {
        ElementDeclaration elementDeclaration = this.findElementDeclaration(element, element2);
        if (elementDeclaration == null) {
            return null;
        }
        return new ElementTypeImpl(this, elementDeclaration, this.getElementLocalType(element));
    }

    @Override
    public String getElementAttribute(Element element, Element element2, Name name, AttributeDefaultValue attributeDefaultValue) {
        Value value;
        AttributeDeclaration attributeDeclaration;
        String string = element.getAttribute(name);
        if (string == null && attributeDefaultValue != null) {
            string = attributeDefaultValue.getAttributeDefaultValue(element, name);
        }
        if (string == null && (attributeDeclaration = this.findAttributeDeclaration(element, element2, name)) != null && (value = attributeDeclaration.defaultValue) != null) {
            string = value.toString(element);
        }
        return string;
    }

    @Override
    public String lookupElementAttribute(Element element, Element element2, Name name, AttributeDefaultValue attributeDefaultValue) {
        Object object;
        Tree tree;
        Object object2 = element.getAttribute(name);
        if (object2 == null && attributeDefaultValue != null) {
            object2 = attributeDefaultValue.getAttributeDefaultValue(element, name);
        }
        if (object2 != null) {
            return object2;
        }
        int n = 0;
        for (tree = element; tree != null; tree = tree.getParent()) {
            ++n;
            if (tree == element2) break;
        }
        Element[] elementArray = new Element[n];
        n = 0;
        tree = element;
        while (tree instanceof Element) {
            elementArray[n++] = tree;
            if (tree == element2) break;
            tree = tree.getParent();
        }
        if (elementArray[n - 1] != element2) {
            throw new IllegalArgumentException(Msg.msg("notAnAncestor", element2.getLabel(), element.getLabel()));
        }
        Type type = this.getElementLocalType(element2);
        if (type == null) {
            object = this.getElementDeclaration(element2.getName());
            type = object == null ? ComplexType.ANY : ((ElementDeclaration)object).type;
        }
        for (int i = n - 1; i >= 1; --i) {
            Type type2;
            object = this.getAttributeDefaulted(elementArray[i], name, attributeDefaultValue, type);
            if (object != null) {
                object2 = object;
            }
            if ((type2 = this.getElementLocalType(elementArray[i - 1])) == null) {
                if (type instanceof SimpleType) {
                    type = ComplexType.ANY;
                }
                ComplexType complexType = (ComplexType)type;
                Name name2 = elementArray[i - 1].getName();
                ElementDeclaration elementDeclaration = null;
                if (complexType.containsElementField(name2) && (elementDeclaration = complexType.getElementDeclaration(name2)) == null) {
                    elementDeclaration = this.getElementDeclaration(name2);
                }
                type2 = elementDeclaration == null ? ComplexType.ANY : elementDeclaration.type;
            }
            type = type2;
        }
        object = this.getAttributeDefaulted(element, name, attributeDefaultValue, type);
        if (object != null) {
            object2 = object;
        }
        return object2;
    }

    private final String getAttributeDefaulted(Element element, Name name, AttributeDefaultValue attributeDefaultValue, Type type) {
        String string = element.getAttribute(name);
        if (string == null && attributeDefaultValue != null) {
            string = attributeDefaultValue.getAttributeDefaultValue(element, name);
        }
        if (string == null && type instanceof ComplexType) {
            Value value;
            ComplexType complexType = (ComplexType)type;
            AttributeDeclaration attributeDeclaration = null;
            if (complexType.getAttributeUse(name) != null && (attributeDeclaration = complexType.getAttributeDeclaration(name)) == null) {
                attributeDeclaration = this.getAttributeDeclaration(name);
            }
            if (attributeDeclaration != null && (value = attributeDeclaration.defaultValue) != null) {
                string = value.toString(element);
            }
        }
        return string;
    }

    @Override
    public Element[] findElementById(Element element, Element element2, String string, boolean bl) {
        IdFinder idFinder = new IdFinder(this){

            @Override
            protected boolean isIDType(DataType dataType) {
                return dataType instanceof IDDataType;
            }
        };
        return idFinder.find(element, element2, string, bl);
    }

    @Override
    public void collectIds(Element element, Element element2, Map<String, IdEntry> map) {
        if (!map.isEmpty()) {
            map.clear();
        }
        IdCollector idCollector = new IdCollector(this){

            @Override
            protected boolean isIDType(DataType dataType) {
                return dataType instanceof IDDataType;
            }
        };
        idCollector.collect(element, element2, map, null);
    }

    @Override
    public void collectIdRefs(Element element, Element element2, List<IdRefItem> list) {
        if (!list.isEmpty()) {
            list.clear();
        }
        new IdCollector(this).collect(element, element2, null, list);
    }

    private static final class ElementDeclEntry {
        public final ElementDeclaration decl;

        public ElementDeclEntry(ElementDeclaration elementDeclaration) {
            this.decl = elementDeclaration;
        }

        public int hashCode() {
            return System.identityHashCode(this.decl.name) ^ System.identityHashCode(this.decl.type);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ElementDeclEntry)) {
                return false;
            }
            ElementDeclEntry elementDeclEntry = (ElementDeclEntry)object;
            return this.decl.name == elementDeclEntry.decl.name && this.decl.type == elementDeclEntry.decl.type;
        }
    }
}

