/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.validate.NameClass;
import com.xmlmind.xml.wxs.validate.Msg;
import java.io.Serializable;

public class NameWildcard
implements NameClass,
Serializable {
    public static final NameWildcard ANY = new NameWildcard();
    public static final NameWildcard NAMESPACE_NOT_NONE = new NameWildcard(Namespace.NONE);
    protected Namespace excludedNamespace;
    protected Namespace[] includedNamespaces;
    protected static final Name A_NAME = Name.get(Namespace.get("http://www.xmlmind.com/xmleditor/namespace/private"), "x");

    public NameWildcard() {
        this.excludedNamespace = null;
        this.includedNamespaces = null;
    }

    public NameWildcard(Namespace namespace) {
        this.excludedNamespace = namespace;
        this.includedNamespaces = null;
    }

    public NameWildcard(Namespace[] namespaceArray) {
        this.includedNamespaces = namespaceArray;
        this.excludedNamespace = null;
    }

    public int getSpecificity() {
        if (this.excludedNamespace != null) {
            return 1;
        }
        if (this.includedNamespaces != null) {
            return Integer.MAX_VALUE - this.includedNamespaces.length;
        }
        return 0;
    }

    public boolean match(Name name) {
        if (this.excludedNamespace != null) {
            Namespace namespace = name.namespace;
            return namespace != this.excludedNamespace && namespace != Namespace.NONE;
        }
        if (this.includedNamespaces != null) {
            Namespace namespace = name.namespace;
            for (int i = 0; i < this.includedNamespaces.length; ++i) {
                if (namespace != this.includedNamespaces[i]) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.excludedNamespace != null) {
            return System.identityHashCode(this.excludedNamespace);
        }
        if (this.includedNamespaces != null) {
            int n = 0;
            for (int i = 0; i < this.includedNamespaces.length; ++i) {
                n ^= System.identityHashCode(this.includedNamespaces[i]);
            }
            return n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof NameWildcard)) {
            return false;
        }
        NameWildcard nameWildcard = (NameWildcard)object;
        if (this.excludedNamespace != null) {
            return nameWildcard.excludedNamespace == this.excludedNamespace;
        }
        if (this.includedNamespaces != null) {
            if (nameWildcard.includedNamespaces == null || nameWildcard.includedNamespaces.length != this.includedNamespaces.length) {
                return false;
            }
            int n = this.includedNamespaces.length;
            for (int i = 0; i < n; ++i) {
                Namespace namespace = this.includedNamespaces[i];
                boolean bl = false;
                for (int j = 0; j < n; ++j) {
                    if (nameWildcard.includedNamespaces[j] != namespace) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        return nameWildcard.excludedNamespace == null && nameWildcard.includedNamespaces == null;
    }

    public NameWildcard union(NameWildcard nameWildcard) {
        if (this.equals(nameWildcard)) {
            return this;
        }
        if (this.excludedNamespace == null && this.includedNamespaces == null || nameWildcard.excludedNamespace == null && nameWildcard.includedNamespaces == null) {
            return ANY;
        }
        if (this.includedNamespaces != null && nameWildcard.includedNamespaces != null) {
            Namespace[] namespaceArray = new Namespace[this.includedNamespaces.length + nameWildcard.includedNamespaces.length];
            int n = this.includedNamespaces.length;
            System.arraycopy(this.includedNamespaces, 0, namespaceArray, 0, n);
            for (int i = 0; i < nameWildcard.includedNamespaces.length; ++i) {
                Namespace namespace = nameWildcard.includedNamespaces[i];
                boolean bl = false;
                for (int j = 0; j < this.includedNamespaces.length; ++j) {
                    if (namespace != this.includedNamespaces[j]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                namespaceArray[n++] = namespace;
            }
            if (n != namespaceArray.length) {
                Namespace[] namespaceArray2 = new Namespace[n];
                System.arraycopy(namespaceArray, 0, namespaceArray2, 0, n);
                namespaceArray = namespaceArray2;
            }
            return new NameWildcard(namespaceArray);
        }
        if (this.excludedNamespace != null && nameWildcard.excludedNamespace != null) {
            return NAMESPACE_NOT_NONE;
        }
        if (this.excludedNamespace != null && nameWildcard.includedNamespaces != null || this.includedNamespaces != null && nameWildcard.excludedNamespace != null) {
            NameWildcard nameWildcard2;
            NameWildcard nameWildcard3;
            if (this.excludedNamespace != null) {
                nameWildcard3 = this;
                nameWildcard2 = nameWildcard;
            } else {
                nameWildcard3 = nameWildcard;
                nameWildcard2 = this;
            }
            if (nameWildcard3.excludedNamespace != Namespace.NONE) {
                boolean bl = false;
                boolean bl2 = false;
                for (int i = 0; i < nameWildcard2.includedNamespaces.length; ++i) {
                    Namespace namespace = nameWildcard2.includedNamespaces[i];
                    if (nameWildcard3.excludedNamespace == namespace) {
                        bl = true;
                        continue;
                    }
                    if (Namespace.NONE != namespace) continue;
                    bl2 = true;
                }
                if (bl) {
                    if (bl2) {
                        return ANY;
                    }
                    return NAMESPACE_NOT_NONE;
                }
                if (bl2) {
                    return null;
                }
                return nameWildcard3;
            }
            boolean bl = false;
            for (int i = 0; i < nameWildcard2.includedNamespaces.length; ++i) {
                if (Namespace.NONE != nameWildcard2.includedNamespaces[i]) continue;
                bl = true;
                break;
            }
            return bl ? ANY : NAMESPACE_NOT_NONE;
        }
        return null;
    }

    public NameWildcard intersection(NameWildcard nameWildcard) {
        if (this.equals(nameWildcard)) {
            return this;
        }
        if (this.excludedNamespace == null && this.includedNamespaces == null) {
            return nameWildcard;
        }
        if (nameWildcard.excludedNamespace == null && nameWildcard.includedNamespaces == null) {
            return this;
        }
        if (this.excludedNamespace != null && nameWildcard.includedNamespaces != null || this.includedNamespaces != null && nameWildcard.excludedNamespace != null) {
            NameWildcard nameWildcard2;
            NameWildcard nameWildcard3;
            if (this.excludedNamespace != null) {
                nameWildcard3 = this;
                nameWildcard2 = nameWildcard;
            } else {
                nameWildcard3 = nameWildcard;
                nameWildcard2 = this;
            }
            Namespace[] namespaceArray = new Namespace[nameWildcard2.includedNamespaces.length];
            int n = 0;
            for (int i = 0; i < nameWildcard2.includedNamespaces.length; ++i) {
                Namespace namespace = nameWildcard2.includedNamespaces[i];
                if (namespace == nameWildcard3.excludedNamespace || namespace == Namespace.NONE) continue;
                namespaceArray[n++] = namespace;
            }
            if (n != namespaceArray.length) {
                Namespace[] namespaceArray2 = new Namespace[n];
                System.arraycopy(namespaceArray, 0, namespaceArray2, 0, n);
                namespaceArray = namespaceArray2;
            }
            return new NameWildcard(namespaceArray);
        }
        if (this.includedNamespaces != null && nameWildcard.includedNamespaces != null) {
            Namespace[] namespaceArray = new Namespace[Math.min(this.includedNamespaces.length, nameWildcard.includedNamespaces.length)];
            int n = 0;
            for (int i = 0; i < nameWildcard.includedNamespaces.length; ++i) {
                Namespace namespace = nameWildcard.includedNamespaces[i];
                boolean bl = false;
                for (int j = 0; j < this.includedNamespaces.length; ++j) {
                    if (namespace != this.includedNamespaces[j]) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                namespaceArray[n++] = namespace;
            }
            if (n == 0) {
                return null;
            }
            if (n != namespaceArray.length) {
                Namespace[] namespaceArray3 = new Namespace[n];
                System.arraycopy(namespaceArray, 0, namespaceArray3, 0, n);
                namespaceArray = namespaceArray3;
            }
            return new NameWildcard(namespaceArray);
        }
        if (this.excludedNamespace != null && this.excludedNamespace != Namespace.NONE && nameWildcard.excludedNamespace == Namespace.NONE) {
            return this;
        }
        if (nameWildcard.excludedNamespace != null && nameWildcard.excludedNamespace != Namespace.NONE && this.excludedNamespace == Namespace.NONE) {
            return nameWildcard;
        }
        return null;
    }

    public boolean isSubsetOf(NameWildcard nameWildcard) {
        if (nameWildcard.excludedNamespace == null && nameWildcard.includedNamespaces == null) {
            return true;
        }
        if (this.excludedNamespace != null && this.excludedNamespace == nameWildcard.excludedNamespace) {
            return true;
        }
        if (this.includedNamespaces != null) {
            if (nameWildcard.includedNamespaces != null) {
                for (int i = 0; i < this.includedNamespaces.length; ++i) {
                    Namespace namespace = this.includedNamespaces[i];
                    boolean bl = false;
                    for (int j = 0; j < nameWildcard.includedNamespaces.length; ++j) {
                        if (namespace != nameWildcard.includedNamespaces[j]) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < this.includedNamespaces.length; ++i) {
                    Namespace namespace = this.includedNamespaces[i];
                    if (nameWildcard.excludedNamespace != namespace && Namespace.NONE != namespace) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Name getSampleName() {
        if (this.includedNamespaces != null && this.includedNamespaces.length > 0) {
            return Name.get(this.includedNamespaces[0], "x");
        }
        return A_NAME;
    }

    public String getLabel(NamespaceToPrefixes namespaceToPrefixes) {
        Namespace namespace = this.excludedNamespace;
        if (namespace != null) {
            if (namespace == Namespace.NONE) {
                return Msg.msg("anyQualified");
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Msg.msg("not"));
            stringBuilder.append(' ');
            stringBuilder.append(NameWildcard.formatWildcard(namespace, namespaceToPrefixes));
            return stringBuilder.toString();
        }
        Namespace[] namespaceArray = this.includedNamespaces;
        if (namespaceArray == null) {
            return "*";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        for (int i = 0; i < namespaceArray.length; ++i) {
            namespace = namespaceArray[i];
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
                if (string == null) {
                    string = Msg.msg("or");
                }
                stringBuilder.append(string);
                stringBuilder.append(' ');
            }
            if (namespace == Namespace.NONE) {
                stringBuilder.append(Msg.msg("anyUnqualified"));
                continue;
            }
            stringBuilder.append(NameWildcard.formatWildcard(namespace, namespaceToPrefixes));
        }
        return stringBuilder.toString();
    }

    protected static final String formatWildcard(Namespace namespace, NamespaceToPrefixes namespaceToPrefixes) {
        String string = Name.get(namespace, "x").format(true, namespaceToPrefixes);
        int n = string.length();
        if (n == 1) {
            return "*";
        }
        return string.substring(0, n - 1) + "*";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("namespace='");
        if (this.excludedNamespace != null) {
            stringBuilder.append("##other");
        } else if (this.includedNamespaces != null) {
            for (int i = 0; i < this.includedNamespaces.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(' ');
                }
                if (this.includedNamespaces[i] == Namespace.NONE) {
                    stringBuilder.append("##local");
                    continue;
                }
                stringBuilder.append(this.includedNamespaces[i]);
            }
        } else {
            stringBuilder.append("##any");
        }
        stringBuilder.append('\'');
    }

    public String getHTMLDescription(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getHTMLDescription(bl, stringBuilder);
        return stringBuilder.toString();
    }

    public void getHTMLDescription(boolean bl, StringBuilder stringBuilder) {
        String string;
        String string2 = string = bl ? Msg.msg("attribute") : Msg.msg("element");
        if (this.excludedNamespace != null) {
            if (this.excludedNamespace == Namespace.NONE) {
                XMLText.escapeXML(Msg.msg("wildcard1", string), stringBuilder);
            } else {
                XMLText.escapeXML(Msg.msg("wildcard2", string), stringBuilder);
                stringBuilder.append(": \"");
                XMLText.escapeXML(this.excludedNamespace.uri, stringBuilder);
                stringBuilder.append('\"');
            }
        } else if (this.includedNamespaces != null) {
            boolean bl2 = true;
            boolean bl3 = false;
            for (int i = 0; i < this.includedNamespaces.length; ++i) {
                if (this.includedNamespaces[i] == Namespace.NONE) {
                    bl3 = true;
                    continue;
                }
                if (bl2) {
                    bl2 = false;
                    XMLText.escapeXML(Msg.msg("wildcard3", string), stringBuilder);
                    stringBuilder.append(": ");
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append('\"');
                XMLText.escapeXML(this.includedNamespaces[i].uri, stringBuilder);
                stringBuilder.append('\"');
            }
            if (bl3) {
                if (this.includedNamespaces.length > 1) {
                    stringBuilder.append("<br>\n");
                }
                XMLText.escapeXML(Msg.msg("wildcard4", string), stringBuilder);
            }
        } else {
            XMLText.escapeXML(Msg.msg("wildcard5", string), stringBuilder);
        }
    }

    @Override
    public boolean containsName(Name name) {
        return this.match(name);
    }

    @Override
    public boolean containsAnyName() {
        return this.excludedNamespace == null && this.includedNamespaces == null;
    }
}

