/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.wxs.validate.AllParticle;
import com.xmlmind.xml.wxs.validate.ChoiceParticle;
import com.xmlmind.xml.wxs.validate.ElementParticle;
import com.xmlmind.xml.wxs.validate.Msg;
import com.xmlmind.xml.wxs.validate.NameWildcard;
import com.xmlmind.xml.wxs.validate.Particle;
import com.xmlmind.xml.wxs.validate.SequenceParticle;
import com.xmlmind.xml.wxs.validate.WildcardParticle;
import java.util.HashMap;

public final class NameRE {
    private static final int MATCH_NAME = 0;
    private static final int MATCH_WILDCARD = 1;
    private static final int MATCH_ALL_NAMES = 2;
    private static final int CHOICE = 3;
    private static final int INIT_UNCONDITIONAL_LOOP = 4;
    private static final int UNCONDITIONAL_LOOP = 5;
    private static final int NOTHING = 6;
    private static final int INIT_LOOP = 7;
    private static final int LOOP = 8;
    private static final int FAIL = 9;
    private static final String[] opcodeNames = new String[]{"MATCH_NAME", "MATCH_WILDCARD", "MATCH_ALL_NAMES", "CHOICE", "INIT_UNCONDITIONAL_LOOP", "UNCONDITIONAL_LOOP", "NOTHING", "INIT_LOOP", "LOOP", "FAIL"};
    private Program program;
    private boolean[] matched = null;

    public NameRE(Particle particle) throws InvalidParticleException {
        this.program = NameRE.compile(particle);
        int n = NameRE.matchedArrayLength(this.program, null, 0);
        if (n > 0) {
            this.matched = new boolean[n];
        }
    }

    private static int matchedArrayLength(Program program, Program program2, int n) {
        while (program != program2) {
            switch (program.opcode) {
                case 2: {
                    int n2 = ((MatchAllNames)program).list.length;
                    if (n2 <= n) break;
                    n = n2;
                    break;
                }
                case 3: {
                    Program[] programArray = ((Choice)program).choices;
                    Program program3 = program.next;
                    for (int i = 0; i < programArray.length; ++i) {
                        int n3 = NameRE.matchedArrayLength(programArray[i], program3, n);
                        if (n3 <= n) continue;
                        n = n3;
                    }
                    break;
                }
            }
            program = program.next;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<Program, String> hashMap = new HashMap<Program, String>();
        Program.toString(this.program, null, stringBuilder, hashMap, 0);
        return stringBuilder.toString();
    }

    private static Program compile(Particle particle) throws InvalidParticleException {
        Program program = NameRE.doCompile(particle);
        NameRE.fixUpChoices(program, null);
        return program;
    }

    private static void fixUpChoices(Program program, Program program2) {
        while (program != program2) {
            if (program.opcode == 3) {
                NameRE.fixUpChoice((Choice)program);
            }
            program = program.next;
        }
    }

    private static void fixUpChoice(Choice choice) {
        int n;
        Program[] programArray = choice.choices;
        Program program = choice.next;
        for (n = 0; n < programArray.length; ++n) {
            programArray[n].tail().next = program;
        }
        for (n = 0; n < programArray.length; ++n) {
            NameRE.fixUpChoices(programArray[n], program);
        }
    }

    private static Program doCompile(Particle particle) throws InvalidParticleException {
        Program program;
        Program program2;
        Program program3;
        int n = particle.getMinOccurs();
        int n2 = particle.getMaxOccurs();
        if (n < 0 || n2 == 0 || n2 != -1 && n > n2) {
            throw new InvalidParticleException(particle, Msg.msg("NRE.invalidMinMaxOccurs"));
        }
        Program program4 = null;
        if (n > 0) {
            program3 = NameRE.compileParticle(particle);
            if (n == 1) {
                program4 = program3;
            } else {
                program2 = new InitLoop();
                program4 = program2;
                program4.next = program3;
                program = new Loop(n - 1, program3);
                ((InitLoop)program2).loop = program;
                program3.tail().next = program;
            }
        }
        program3 = null;
        if (n2 == -1) {
            UnconditionalLoop unconditionalLoop;
            program2 = new InitUnconditionalLoop();
            program3 = program2;
            program3.next = program = new Choice();
            Program program5 = NameRE.compileParticle(particle);
            program2.loop = unconditionalLoop = new UnconditionalLoop(program);
            program5.tail().next = unconditionalLoop;
            ((Choice)program).add(program5);
            ((Choice)program).add(new Program(6));
        } else {
            int n3 = n2 - n;
            if (n3 == 1) {
                program3 = program = new Choice();
                ((Choice)program).add(NameRE.compileParticle(particle));
                ((Choice)program).add(new Program(6));
            } else if (n3 > 1) {
                Loop loop;
                program3 = program = new InitLoop();
                Choice choice = new Choice();
                program3.next = choice;
                Program program6 = NameRE.compileParticle(particle);
                ((InitLoop)program).loop = loop = new Loop(n3, choice);
                loop.next = new Program(9);
                program6.tail().next = loop;
                choice.add(program6);
                choice.add(new Program(6));
            }
        }
        if (program4 == null) {
            program4 = program3;
        } else {
            program4.tail().next = program3;
        }
        return program4;
    }

    private static Program compileParticle(Particle particle) throws InvalidParticleException {
        switch (particle.getType()) {
            case CHOICE: {
                return NameRE.compileChoiceParticle((ChoiceParticle)particle);
            }
            case SEQUENCE: {
                return NameRE.compileSequenceParticle((SequenceParticle)particle);
            }
            case ALL: {
                return NameRE.compileAllParticle((AllParticle)particle);
            }
            case ELEMENT: {
                return new MatchName(((ElementParticle)particle).elementName);
            }
            case WILDCARD: {
                return new MatchWildcard(((WildcardParticle)particle).wildcard.nameWildcard);
            }
        }
        throw new RuntimeException("internal error: unknown particle " + String.valueOf((Object)particle.getType()));
    }

    private static Program compileChoiceParticle(ChoiceParticle choiceParticle) throws InvalidParticleException {
        Particle[] particleArray = choiceParticle.getParticles();
        int n = particleArray.length;
        if (n == 0) {
            return new Program(6);
        }
        if (n == 1) {
            return NameRE.doCompile(particleArray[0]);
        }
        Choice choice = new Choice();
        for (int i = 0; i < n; ++i) {
            choice.add(NameRE.doCompile(particleArray[i]));
        }
        return choice;
    }

    private static Program compileSequenceParticle(SequenceParticle sequenceParticle) throws InvalidParticleException {
        Particle[] particleArray = sequenceParticle.getParticles();
        int n = particleArray.length;
        if (n == 0) {
            return new Program(6);
        }
        Program program = NameRE.doCompile(particleArray[0]);
        Program program2 = program.tail();
        for (int i = 1; i < n; ++i) {
            Program program3;
            program2.next = program3 = NameRE.doCompile(particleArray[i]);
            program2 = program3.tail();
        }
        return program;
    }

    private static Program compileAllParticle(AllParticle allParticle) throws InvalidParticleException {
        Particle[] particleArray = allParticle.getParticles();
        int n = particleArray.length;
        if (n == 0) {
            return new Program(6);
        }
        Name[] nameArray = new Name[n];
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            Particle particle = particleArray[i];
            int n2 = particle.getMinOccurs();
            int n3 = particle.getMaxOccurs();
            if (particle.getType() != Particle.Type.ELEMENT || n2 > 1 || n3 != 1) {
                throw new InvalidParticleException(allParticle, Msg.msg("NRE.badAllParticle"));
            }
            nameArray[i] = ((ElementParticle)particle).elementName;
            blArray[i] = n2 == 0;
        }
        return new MatchAllNames(nameArray, blArray);
    }

    public boolean match(Name[] nameArray, int n) {
        return this.match(nameArray, 0, n, this.program);
    }

    private boolean match(Name[] nameArray, int n, int n2, Program program) {
        while (program != null) {
            Program program2 = program.next;
            switch (program.opcode) {
                case 0: {
                    if (n == n2 || ((MatchName)program).name != nameArray[n]) {
                        return false;
                    }
                    ++n;
                    break;
                }
                case 1: {
                    if (n == n2 || !((MatchWildcard)program).wildcard.match(nameArray[n])) {
                        return false;
                    }
                    ++n;
                    break;
                }
                case 2: {
                    int n3;
                    Object object = (MatchAllNames)program;
                    Name[] nameArray2 = object.list;
                    int n4 = nameArray2.length;
                    Object object2 = object.optional;
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.matched[n3] = false;
                    }
                    for (n3 = 0; n3 < n4 && n != n2; ++n, ++n3) {
                        Name name = nameArray[n];
                        boolean bl = false;
                        for (int i = 0; i < n4; ++i) {
                            if (this.matched[i] || nameArray2[i] != name) continue;
                            bl = true;
                            this.matched[i] = true;
                            break;
                        }
                        if (!bl) break;
                    }
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (this.matched[n3] || object2[n3]) continue;
                        return false;
                    }
                    break;
                }
                case 3: {
                    Object object2;
                    int n4;
                    Object object = ((Choice)program).choices;
                    boolean bl = true;
                    for (n4 = 0; n4 < ((Program[])object).length; ++n4) {
                        if (object[n4].opcode == 0 && object[n4].next == program2) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        n4 = 0;
                        for (int i = 0; i < ((Program[])object).length; ++i) {
                            if (n == n2 || ((MatchName)object[i]).name != nameArray[n]) continue;
                            n4 = 1;
                            break;
                        }
                        if (n4 != 0) {
                            ++n;
                            break;
                        }
                        return false;
                    }
                    for (n4 = 0; n4 < ((Program[])object).length; ++n4) {
                        object2 = object[n4];
                        if (object2.opcode == 0 && (n == n2 || ((MatchName)object2).name != nameArray[n]) || !this.match(nameArray, n, n2, (Program)object2)) continue;
                        return true;
                    }
                    return false;
                }
                case 5: {
                    Object object = (UnconditionalLoop)program;
                    if (n <= object.start) break;
                    object.start = n;
                    program2 = object.begin;
                    break;
                }
                case 4: {
                    ((InitUnconditionalLoop)program).loop.start = n;
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    Object object = ((InitLoop)program).loop;
                    object.start = n;
                    object.counter = 0;
                    break;
                }
                case 8: {
                    Object object = (Loop)program;
                    if (n <= object.start || object.counter >= object.maxCounter) break;
                    object.start = n;
                    ++object.counter;
                    program2 = object.begin;
                    break;
                }
                case 9: {
                    return false;
                }
                default: {
                    throw new RuntimeException("internal error: unknown opcode " + program.opcode);
                }
            }
            program = program2;
        }
        return n == n2;
    }

    private static final class InitLoop
    extends Program {
        public Loop loop;

        public InitLoop() {
            super(7);
        }

        @Override
        protected void toString(StringBuilder stringBuilder, HashMap<Program, String> hashMap, int n) {
            super.toString(stringBuilder, hashMap, n);
            InitLoop.appendSpace(stringBuilder, 8 + n);
            stringBuilder.append("loop=");
            stringBuilder.append(InitLoop.getLabel(this.loop, hashMap));
            stringBuilder.append('\n');
        }
    }

    private static final class Loop
    extends Program {
        public int counter;
        public int maxCounter;
        public int start;
        public Program begin;

        public Loop(int n, Program program) {
            super(8);
            this.maxCounter = n;
            this.begin = program;
        }

        @Override
        protected void toString(StringBuilder stringBuilder, HashMap<Program, String> hashMap, int n) {
            super.toString(stringBuilder, hashMap, n);
            Loop.appendSpace(stringBuilder, 8 + n);
            stringBuilder.append("max=");
            stringBuilder.append(this.maxCounter);
            stringBuilder.append(" begin=");
            stringBuilder.append(Loop.getLabel(this.begin, hashMap));
            stringBuilder.append('\n');
        }
    }

    private static final class InitUnconditionalLoop
    extends Program {
        public UnconditionalLoop loop;

        public InitUnconditionalLoop() {
            super(4);
        }

        @Override
        protected void toString(StringBuilder stringBuilder, HashMap<Program, String> hashMap, int n) {
            super.toString(stringBuilder, hashMap, n);
            InitUnconditionalLoop.appendSpace(stringBuilder, 8 + n);
            stringBuilder.append("loop=");
            stringBuilder.append(InitUnconditionalLoop.getLabel(this.loop, hashMap));
            stringBuilder.append('\n');
        }
    }

    private static final class UnconditionalLoop
    extends Program {
        public int start;
        public Program begin;

        public UnconditionalLoop(Program program) {
            super(5);
            this.begin = program;
        }

        @Override
        protected void toString(StringBuilder stringBuilder, HashMap<Program, String> hashMap, int n) {
            super.toString(stringBuilder, hashMap, n);
            UnconditionalLoop.appendSpace(stringBuilder, 8 + n);
            stringBuilder.append("begin=");
            stringBuilder.append(UnconditionalLoop.getLabel(this.begin, hashMap));
            stringBuilder.append('\n');
        }
    }

    private static final class Choice
    extends Program {
        public Program[] choices = new Program[0];

        public Choice() {
            super(3);
        }

        public void add(Program program) {
            Program[] programArray = new Program[this.choices.length + 1];
            System.arraycopy(this.choices, 0, programArray, 0, this.choices.length);
            programArray[this.choices.length] = program;
            this.choices = programArray;
        }

        @Override
        protected void toString(StringBuilder stringBuilder, HashMap<Program, String> hashMap, int n) {
            super.toString(stringBuilder, hashMap, n);
            for (int i = 0; i < this.choices.length; ++i) {
                Program.toString(this.choices[i], this.next, stringBuilder, hashMap, n + 4);
            }
        }
    }

    private static final class MatchAllNames
    extends Program {
        public Name[] list;
        public boolean[] optional;

        public MatchAllNames(Name[] nameArray, boolean[] blArray) {
            super(2);
            this.list = nameArray;
            this.optional = blArray;
        }

        @Override
        protected void toString(StringBuilder stringBuilder, HashMap<Program, String> hashMap, int n) {
            super.toString(stringBuilder, hashMap, n);
            MatchAllNames.appendSpace(stringBuilder, 8 + n);
            for (int i = 0; i < this.list.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.list[i]);
                if (!this.optional[i]) continue;
                stringBuilder.append('?');
            }
            stringBuilder.append('\n');
        }
    }

    private static final class MatchWildcard
    extends Program {
        public NameWildcard wildcard;

        public MatchWildcard(NameWildcard nameWildcard) {
            super(1);
            this.wildcard = nameWildcard;
        }

        @Override
        protected void toString(StringBuilder stringBuilder, HashMap<Program, String> hashMap, int n) {
            super.toString(stringBuilder, hashMap, n);
            MatchWildcard.appendSpace(stringBuilder, 8 + n);
            stringBuilder.append(this.wildcard);
            stringBuilder.append('\n');
        }
    }

    private static final class MatchName
    extends Program {
        public Name name;

        public MatchName(Name name) {
            super(0);
            this.name = name;
        }

        @Override
        protected void toString(StringBuilder stringBuilder, HashMap<Program, String> hashMap, int n) {
            super.toString(stringBuilder, hashMap, n);
            MatchName.appendSpace(stringBuilder, 8 + n);
            stringBuilder.append(this.name);
            stringBuilder.append('\n');
        }
    }

    public static class Program {
        public byte opcode;
        public Program next;

        public Program(int n) {
            this.opcode = (byte)n;
        }

        public final Program tail() {
            Program program = this;
            while (program.next != null) {
                program = program.next;
            }
            return program;
        }

        protected static void toString(Program program, Program program2, StringBuilder stringBuilder, HashMap<Program, String> hashMap, int n) {
            while (program != program2) {
                program.toString(stringBuilder, hashMap, n);
                program = program.next;
            }
        }

        protected void toString(StringBuilder stringBuilder, HashMap<Program, String> hashMap, int n) {
            String string = Program.getLabel(this, hashMap);
            stringBuilder.append(string);
            Program.appendSpace(stringBuilder, 8 - string.length() + n);
            stringBuilder.append(opcodeNames[this.opcode]);
            stringBuilder.append(" -> ");
            stringBuilder.append(Program.getLabel(this.next, hashMap));
            stringBuilder.append('\n');
        }

        protected static String getLabel(Program program, HashMap<Program, String> hashMap) {
            if (program == null) {
                return "/";
            }
            String string = hashMap.get(program);
            if (string == null) {
                string = Integer.toString(hashMap.size());
                hashMap.put(program, string);
            }
            return string;
        }

        protected static void appendSpace(StringBuilder stringBuilder, int n) {
            while (n > 0) {
                stringBuilder.append(' ');
                --n;
            }
        }
    }

    public static class InvalidParticleException
    extends Exception {
        private Particle particle;

        public InvalidParticleException(Particle particle, String string) {
            super(string);
            this.particle = particle;
        }

        public Particle getParticle() {
            return this.particle;
        }
    }
}

