/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.validate.AttributeType;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Value;
import com.xmlmind.xml.wxs.validate.Msg;
import com.xmlmind.xml.wxs.validate.Schema;
import com.xmlmind.xml.wxs.validate.ValidationError;
import com.xmlmind.xml.wxs.validate.ValidationErrors;
import java.io.Serializable;

public final class AttributeDeclaration
implements Serializable,
AttributeType {
    public final Name name;
    public final com.xmlmind.xml.wxs.datatype.DataType dataType;
    public final Value defaultValue;
    public final boolean isFixedValue;

    public AttributeDeclaration(Name name, com.xmlmind.xml.wxs.datatype.DataType dataType, Value value, boolean bl) {
        this.name = name;
        this.dataType = dataType;
        this.defaultValue = value;
        this.isFixedValue = bl;
    }

    public ValidationError validate(String string, Element element, Schema schema) {
        ValidationErrors validationErrors = new ValidationErrors();
        Value value = this.validate(string, element, schema, validationErrors);
        if (value == null) {
            return validationErrors.getLast();
        }
        return null;
    }

    public Value validate(String string, Element element, Schema schema, ValidationErrors validationErrors) {
        Value value;
        try {
            value = this.dataType.valueOf(string, element);
        }
        catch (InvalidDataException invalidDataException) {
            validationErrors.append(null, "cvc-attribute.3", Msg.msg("attributeHasInvalidValue", this.name.format(true, element), string, invalidDataException.getMessage(), invalidDataException.getConstraint()));
            return null;
        }
        if (this.isFixedValue && !this.defaultValue.equals(value)) {
            validationErrors.append(null, "cvc-attribute.4", Msg.msg("attributeDifferentFromFixedValue", this.name.format(true, element), value, this.defaultValue));
            return null;
        }
        return value;
    }

    @Override
    public DataType getAttributeDataType() {
        return this.dataType;
    }

    @Override
    public Data getAttributeDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Data getAttributeFixedValue() {
        return this.isFixedValue ? this.defaultValue : null;
    }
}

