/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.load.NamespaceURLPair;
import com.xmlmind.xml.load.WXSLoader;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.wxs.load.AttributeInfo;
import com.xmlmind.xml.wxs.load.ComplexTypeInfo;
import com.xmlmind.xml.wxs.load.ElementInfo;
import com.xmlmind.xml.wxs.load.IdentityConstraintInfo;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.InfoLoader;
import com.xmlmind.xml.wxs.load.KeyInfo;
import com.xmlmind.xml.wxs.load.KeyrefInfo;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.LoadState;
import com.xmlmind.xml.wxs.load.NamedComponent;
import com.xmlmind.xml.wxs.load.NotationInfo;
import com.xmlmind.xml.wxs.load.SchemaError;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import com.xmlmind.xml.wxs.load.SimpleTypeInfo;
import com.xmlmind.xml.wxs.load.TypeInfo;
import com.xmlmind.xml.wxs.load.UniqueInfo;
import com.xmlmind.xml.wxs.validate.AttributeDeclaration;
import com.xmlmind.xml.wxs.validate.ComplexType;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.MultiWXSchema;
import com.xmlmind.xml.wxs.validate.Notation;
import com.xmlmind.xml.wxs.validate.Schema;
import com.xmlmind.xml.wxs.validate.Type;
import com.xmlmind.xml.wxs.validate.ValidationError;
import com.xmlmind.xml.wxs.validate.WXSchema;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class WXSLoaderImpl
implements WXSLoader {
    private SchemaError[] errorList;
    private SchemaError[] warningList;

    public WXSchema loadSubDocumentType(File file) throws IOException {
        return this.loadSubDocumentType(FileUtil.fileToURL(file));
    }

    @Override
    public WXSchema loadSubDocumentType(URL uRL) throws IOException {
        Document document;
        DocumentLoader documentLoader = InfoLoader.createDocumentLoader();
        try {
            document = documentLoader.load(uRL);
        }
        catch (SAXParseException sAXParseException) {
            throw new IOException(DocumentLoader.format(sAXParseException));
        }
        catch (SAXException sAXException) {
            throw new IOException(ThrowableUtil.reason(sAXException));
        }
        WXSchema wXSchema = this.loadSubDocumentType(document);
        if (wXSchema == null) {
            return null;
        }
        wXSchema.setURLs(new URL[]{uRL});
        return wXSchema;
    }

    @Override
    public MultiWXSchema loadSubDocumentType(NamespaceURLPair[] namespaceURLPairArray) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Namespace[] namespaceArray;
        Document document = new Document();
        Element element = new Element(Info.XSD_SCHEMA);
        element.putAttribute(Info._TARGET_NAMESPACE, "not:a:target:namespace");
        document.appendChild(element);
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
        URL[] uRLArray = new URL[namespaceURLPairArray.length];
        for (int i = 0; i < namespaceURLPairArray.length; ++i) {
            namespaceArray = namespaceURLPairArray[i];
            if (!arrayList.contains(namespaceArray.namespace)) {
                arrayList.add(namespaceArray.namespace);
            }
            serializable = new Element(Info.XSD_IMPORT);
            if (namespaceArray.namespace != Namespace.NONE) {
                ((Element)serializable).putAttribute(Info._NAMESPACE, namespaceArray.namespace.uri);
            }
            ((Element)serializable).putAttribute(Info._SCHEMA_LOCATION, namespaceArray.url.toExternalForm());
            element.appendChild((Node)serializable);
            uRLArray[i] = namespaceArray.url;
        }
        WXSchema wXSchema = this.loadSubDocumentType(document);
        if (wXSchema == null) {
            return null;
        }
        namespaceArray = new Namespace[arrayList.size()];
        arrayList.toArray(namespaceArray);
        serializable = new MultiWXSchema(namespaceArray);
        Iterator<ElementDeclaration> iterator = wXSchema.getElementDeclarations();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            ((Schema)serializable).addElementDeclaration((ElementDeclaration)object3);
        }
        object3 = wXSchema.getAttributeDeclarations();
        while (object3.hasNext()) {
            object2 = (AttributeDeclaration)object3.next();
            ((Schema)serializable).addAttributeDeclaration((AttributeDeclaration)object2);
        }
        object2 = wXSchema.getTypes();
        while (object2.hasNext()) {
            object = (Type)object2.next();
            ((Schema)serializable).addType((Type)object);
        }
        object = wXSchema.getNotations();
        while (object.hasNext()) {
            Notation notation = (Notation)object.next();
            ((Schema)serializable).addNotation(notation);
        }
        ((Schema)serializable).setDeclaredPrefixes(wXSchema.getSchemaDeclaredPrefixes());
        ((Schema)serializable).setURLs(uRLArray);
        return serializable;
    }

    @Override
    public WXSchema loadSubDocumentType(Document document) {
        this.errorList = SchemaErrors.NO_ERRORS;
        this.warningList = SchemaErrors.NO_ERRORS;
        InfoLoader infoLoader = new InfoLoader();
        LoadContext loadContext = new LoadContext();
        SchemaInfo schemaInfo = infoLoader.load(document, null, loadContext);
        if (schemaInfo == null) {
            this.warningList = infoLoader.getWarnings();
            this.errorList = infoLoader.getErrors();
            return null;
        }
        LoadState loadState = new LoadState(schemaInfo);
        SchemaError[] schemaErrorArray = infoLoader.getWarnings();
        for (int i = 0; i < schemaErrorArray.length; ++i) {
            loadState.warnings.append(schemaErrorArray[i]);
        }
        this.load(loadState);
        WXSchema wXSchema = loadState.schema;
        this.warningList = loadState.warnings.toArray();
        this.errorList = loadState.errors.toArray();
        if (this.errorList.length > 0) {
            return null;
        }
        URL uRL = document.getSourceURL();
        if (uRL != null) {
            wXSchema.setURLs(new URL[]{uRL});
        }
        return wXSchema;
    }

    public SchemaError[] getLoadErrors() {
        return this.errorList;
    }

    public SchemaError[] getLoadWarnings() {
        return this.warningList;
    }

    private void load(LoadState loadState) {
        Serializable serializable;
        Serializable serializable2;
        SchemaInfo schemaInfo = loadState.schemaInfo;
        WXSchema wXSchema = loadState.schema;
        wXSchema.setDeclaredPrefixes(schemaInfo.declaredPrefixes);
        for (NotationInfo object2 : schemaInfo.notationInfo.values()) {
            Notation notation = object2.toNotation(loadState);
            if (notation == null) continue;
            wXSchema.addNotation(notation);
        }
        for (TypeInfo typeInfo : schemaInfo.typeInfo.values()) {
            if (typeInfo instanceof SimpleTypeInfo) {
                Type type = loadState.getType(typeInfo.name, typeInfo, "st-props-correct.1");
                continue;
            }
            Type type = loadState.getType(typeInfo.name, typeInfo, "ct-props-correct.1");
        }
        for (TypeInfo typeInfo : schemaInfo.typeInfo.values()) {
            ComplexType complexType;
            if (!(typeInfo instanceof ComplexTypeInfo) || (complexType = (ComplexType)loadState.getType(typeInfo.name, typeInfo, "ct-props-correct.1")) == null || complexType == ComplexType.ANY || ((ComplexTypeInfo)typeInfo).toComplexType2(complexType, loadState)) continue;
            loadState.addBadComponent(NamedComponent.Type.TYPE, typeInfo.name, "invalidComponent", typeInfo, "ct-props-correct.1");
        }
        for (AttributeInfo attributeInfo : schemaInfo.attributeInfo.values()) {
            loadState.getAttributeDeclaration(attributeInfo.name, attributeInfo, "a-props-correct.1");
        }
        for (ElementInfo elementInfo : schemaInfo.elementInfo.values()) {
            loadState.getElementDeclaration(elementInfo.name, elementInfo, "e-props-correct.1");
        }
        for (ElementInfo elementInfo : schemaInfo.elementInfo.values()) {
            serializable2 = loadState.getElementDeclaration(elementInfo.name, elementInfo, "e-props-correct.1");
            if (serializable2 == null) continue;
            elementInfo.toElementDeclaration2((ElementDeclaration)serializable2, loadState);
        }
        for (TypeInfo typeInfo : schemaInfo.typeInfo.values()) {
            if (!(typeInfo instanceof ComplexTypeInfo) || (serializable2 = (ComplexType)loadState.getType(typeInfo.name, typeInfo, "ct-props-correct.1")) == null || serializable2 == ComplexType.ANY) continue;
            ((ComplexTypeInfo)typeInfo).toComplexType3((ComplexType)serializable2, loadState);
        }
        ArrayList<Object> arrayList = loadState.localComplexTypes;
        int n = arrayList.size();
        for (int i = 0; i < n; i += 2) {
            ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)arrayList.get(i);
            serializable = (ComplexType)arrayList.get(i + 1);
            complexTypeInfo.toComplexType3((ComplexType)serializable, loadState);
        }
        for (IdentityConstraintInfo identityConstraintInfo : loadState.identityConstraints.values()) {
            if (!(identityConstraintInfo instanceof KeyrefInfo)) continue;
            serializable = ((KeyrefInfo)identityConstraintInfo).refer;
            IdentityConstraintInfo identityConstraintInfo2 = loadState.identityConstraints.get(serializable);
            if (identityConstraintInfo2 == null || !(identityConstraintInfo2 instanceof KeyInfo) && !(identityConstraintInfo2 instanceof UniqueInfo)) {
                loadState.errors.append(identityConstraintInfo, "c-props-correct.2", "badKeyref1");
                continue;
            }
            if (identityConstraintInfo2.fields.length == identityConstraintInfo.fields.length) continue;
            loadState.errors.append(identityConstraintInfo, "c-props-correct.2", "badKeyref2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        int n;
        File file = null;
        File file2 = null;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            object = stringArray[n];
            if ("-out".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    bl = true;
                    break;
                }
                file = new File(stringArray[++n]);
                continue;
            }
            if ("-ser".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    bl = true;
                    break;
                }
                file2 = new File(stringArray[++n]);
                continue;
            }
            if (!((String)object).startsWith("-")) break;
            bl = true;
            break;
        }
        if (!bl && n == stringArray.length) {
            bl = true;
        }
        if (bl) {
            System.err.println("usage: java com.xmlmind.xml.wxs.load.WXSLoaderImpl ?-out report_file? ?-ser serialize_schema? schema doc*");
            System.exit(1);
        }
        object = new File(stringArray[n++]);
        OutputStream outputStream = null;
        if (file == null) {
            outputStream = System.out;
        } else {
            try {
                outputStream = new FileOutputStream(file);
            }
            catch (IOException iOException) {
                System.err.println("cannot create '" + String.valueOf(file) + "': " + iOException.getMessage());
                System.exit(1);
            }
        }
        PrintWriter printWriter = new PrintWriter(outputStream);
        WXSchema wXSchema = null;
        WXSLoaderImpl wXSLoaderImpl = new WXSLoaderImpl();
        try {
            wXSchema = wXSLoaderImpl.loadSubDocumentType((File)object);
            WXSLoaderImpl.reportSchemaErrors(wXSLoaderImpl, printWriter);
        }
        catch (IOException iOException) {
            System.err.println("cannot load schema '" + String.valueOf(object) + "': " + iOException.getMessage());
        }
        if (wXSchema == null) {
            printWriter.flush();
            if (file != null) {
                printWriter.close();
            }
            System.exit(2);
        }
        if (file2 != null) {
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file2), 65536));){
                objectOutputStream.writeObject(wXSchema);
                objectOutputStream.flush();
            }
            catch (Exception exception) {
                System.err.println("cannot serialize schema '" + String.valueOf(object) + "' to '" + String.valueOf(file2) + "': " + exception.getClass().getName() + ": " + exception.getMessage());
                printWriter.flush();
                if (file != null) {
                    printWriter.close();
                }
                System.exit(3);
            }
        }
        int n2 = 0;
        if (n < stringArray.length) {
            boolean bl2 = stringArray.length - n > 1;
            DocumentLoader documentLoader = new DocumentLoader();
            documentLoader.setOptions(2);
            while (n < stringArray.length) {
                ValidationError[] validationErrorArray;
                File file3 = new File(stringArray[n]);
                if (bl2) {
                    printWriter.println(file3);
                    printWriter.println("------------------------------------------");
                }
                Document document = null;
                try {
                    document = documentLoader.load(file3);
                }
                catch (Exception exception) {
                    System.err.println("cannot load '" + String.valueOf(file3) + "': " + exception.getMessage());
                    n2 = 4;
                }
                if (document != null && (validationErrorArray = wXSchema.validate(document)).length > 0) {
                    for (int i = 0; i < validationErrorArray.length; ++i) {
                        WXSLoaderImpl.reportValidationError(validationErrorArray[i], printWriter);
                    }
                    n2 = 5;
                }
                ++n;
            }
        }
        printWriter.flush();
        if (file != null) {
            printWriter.close();
        }
        System.exit(n2);
    }

    private static void reportSchemaErrors(WXSLoaderImpl wXSLoaderImpl, PrintWriter printWriter) {
        SchemaError[] schemaErrorArray = wXSLoaderImpl.getLoadErrors();
        for (int i = 0; i < schemaErrorArray.length; ++i) {
            WXSLoaderImpl.reportSchemaError(schemaErrorArray[i], 'E', printWriter);
        }
        SchemaError[] schemaErrorArray2 = wXSLoaderImpl.getLoadWarnings();
        for (int i = 0; i < schemaErrorArray2.length; ++i) {
            WXSLoaderImpl.reportSchemaError(schemaErrorArray2[i], 'W', printWriter);
        }
    }

    private static void reportSchemaError(SchemaError schemaError, char c, PrintWriter printWriter) {
        printWriter.print(schemaError.getLocation());
        printWriter.print(':');
        printWriter.print(c);
        printWriter.print(':');
        printWriter.print(schemaError.getLineNumber());
        printWriter.print(':');
        printWriter.print(schemaError.getColumnNumber());
        printWriter.print(": ");
        printWriter.print(schemaError.message);
        if (schemaError.constraint != null) {
            printWriter.print(" [");
            printWriter.print(schemaError.constraint);
            printWriter.println(']');
        }
    }

    private static void reportValidationError(ValidationError validationError, PrintWriter printWriter) {
        String string;
        String string2;
        Element element = validationError.element;
        URL uRL = element.getSourceURL();
        String string3 = uRL == null ? "" : uRL.toString();
        int[] nArray = (int[])element.getProperty(Constants.LINE_COLUMN_PROPERTY);
        if (nArray == null) {
            string2 = "";
            string = "";
        } else {
            string = Integer.toString(nArray[0]);
            string2 = Integer.toString(nArray[1]);
        }
        printWriter.print(string3);
        printWriter.print(":E:");
        printWriter.print(string);
        printWriter.print(':');
        printWriter.print(string2);
        printWriter.print(": ");
        printWriter.print(validationError.message);
        if (validationError.constraint != null) {
            printWriter.print(" [");
            printWriter.print(validationError.constraint);
            printWriter.println(']');
        }
    }
}

