/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.util.IdentityLinearHashtable;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Traversal;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.wxs.load.AttributeGroupInfo;
import com.xmlmind.xml.wxs.load.AttributeInfo;
import com.xmlmind.xml.wxs.load.ComplexTypeInfo;
import com.xmlmind.xml.wxs.load.ElementInfo;
import com.xmlmind.xml.wxs.load.GroupInfo;
import com.xmlmind.xml.wxs.load.ImportInfo;
import com.xmlmind.xml.wxs.load.IncludeInfo;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.NotationInfo;
import com.xmlmind.xml.wxs.load.RedefineInfo;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SimpleTypeInfo;
import com.xmlmind.xml.wxs.load.TypeInfo;
import java.net.URL;
import java.util.IdentityHashMap;
import java.util.Iterator;

final class SchemaInfo
extends Info {
    public Namespace targetNamespace;
    public boolean inheritsTargetNamespace;
    public boolean attributeFormQualified = false;
    public boolean elementFormQualified = false;
    public int blockDefault = 0;
    public int finalDefault = 0;
    public IdentityHashMap<Name, TypeInfo> typeInfo = new IdentityHashMap();
    public IdentityHashMap<Name, ElementInfo> elementInfo = new IdentityHashMap();
    public IdentityHashMap<Name, AttributeInfo> attributeInfo = new IdentityHashMap();
    public IdentityHashMap<Name, GroupInfo> groupInfo = new IdentityHashMap();
    public IdentityHashMap<Name, AttributeGroupInfo> attributeGroupInfo = new IdentityHashMap();
    public IdentityHashMap<Name, NotationInfo> notationInfo = new IdentityHashMap();
    public PrefixEntry[] declaredPrefixes = null;
    public URL[] sourceURLs = null;
    public IdentityHashMap<Namespace, Namespace> importedNamespaces = null;

    public SchemaInfo(Namespace namespace) {
        super(null);
        this.targetNamespace = namespace;
        this.inheritsTargetNamespace = namespace != Namespace.NONE;
    }

    @Override
    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.declaredPrefixes = SchemaInfo.loadDeclaredPrefixes(element);
        URL uRL = element.getSourceURL();
        this.sourceURLs = uRL != null ? new URL[]{uRL} : new URL[0];
        String string = SchemaInfo.getNamespaceURIAttribute(element, _TARGET_NAMESPACE, null);
        if (string != null) {
            this.targetNamespace = Namespace.get(string);
            this.inheritsTargetNamespace = false;
        }
        this.elementFormQualified = SchemaInfo.getFormAttribute(element, _ELEMENT_FORM_DEFAULT, false);
        this.attributeFormQualified = SchemaInfo.getFormAttribute(element, _ATTRIBUTE_FORM_DEFAULT, false);
        this.blockDefault = SchemaInfo.getBlockAttribute(element, _BLOCK_DEFAULT, 0);
        this.finalDefault = SchemaInfo.getFinalAttribute(element, _FINAL_DEFAULT, 0);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Info info;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == XSD_ELEMENT) {
                info = new ElementInfo(this);
                ((ElementInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                if (((ElementInfo)info).name == null || this.elementInfo.put(((ElementInfo)info).name, (ElementInfo)info) == null) continue;
                schemaErrors2.append(info, "sch-props-correct.2", "duplicateElement", ((ElementInfo)info).name.format(false, info));
                continue;
            }
            if (name == XSD_ATTRIBUTE) {
                info = new AttributeInfo(this);
                ((AttributeInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                if (((AttributeInfo)info).name == null || this.attributeInfo.put(((AttributeInfo)info).name, (AttributeInfo)info) == null) continue;
                schemaErrors2.append(info, "sch-props-correct.2", "duplicateAttribute", ((AttributeInfo)info).name.format(false, info));
                continue;
            }
            if (name == XSD_SIMPLE_TYPE) {
                info = new SimpleTypeInfo(this);
                ((SimpleTypeInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                if (((SimpleTypeInfo)info).name == null || schemaInfo.typeInfo.put(((SimpleTypeInfo)info).name, (TypeInfo)info) == null) continue;
                schemaErrors2.append(info, "sch-props-correct.2", "duplicateType", ((SimpleTypeInfo)info).name.format(false, info));
                continue;
            }
            if (name == XSD_COMPLEX_TYPE) {
                info = new ComplexTypeInfo(this);
                ((ComplexTypeInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                if (((ComplexTypeInfo)info).name == null || this.typeInfo.put(((ComplexTypeInfo)info).name, (TypeInfo)info) == null) continue;
                schemaErrors2.append(info, "sch-props-correct.2", "duplicateType", ((ComplexTypeInfo)info).name.format(false, info));
                continue;
            }
            if (name == XSD_GROUP) {
                info = new GroupInfo(this);
                ((GroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                if (((GroupInfo)info).name == null || this.groupInfo.put(((GroupInfo)info).name, (GroupInfo)info) == null) continue;
                schemaErrors2.append(info, "sch-props-correct.2", "duplicateGroup", ((GroupInfo)info).name.format(false, info));
                continue;
            }
            if (name == XSD_ATTRIBUTE_GROUP) {
                info = new AttributeGroupInfo(this);
                ((AttributeGroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                if (((AttributeGroupInfo)info).name == null || this.attributeGroupInfo.put(((AttributeGroupInfo)info).name, (AttributeGroupInfo)info) == null) continue;
                schemaErrors2.append(info, "sch-props-correct.2", "duplicateAttributeGroup", ((AttributeGroupInfo)info).name.format(false, info));
                continue;
            }
            if (name == XSD_NOTATION) {
                info = new NotationInfo(this);
                ((NotationInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                if (((NotationInfo)info).name == null || this.notationInfo.put(((NotationInfo)info).name, (NotationInfo)info) == null) continue;
                schemaErrors2.append(info, "sch-props-correct.2", "duplicateNotation", ((NotationInfo)info).name.format(false, info));
                continue;
            }
            if (name == XSD_INCLUDE) {
                info = new IncludeInfo(this);
                ((IncludeInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                continue;
            }
            if (name == XSD_IMPORT) {
                info = new ImportInfo(this);
                ((ImportInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                continue;
            }
            if (name != XSD_REDEFINE) continue;
            info = new RedefineInfo(this);
            ((RedefineInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        }
    }

    private static PrefixEntry[] loadDeclaredPrefixes(Element element) {
        PrefixPreferences prefixPreferences = new PrefixPreferences();
        SchemaInfo.collectPrefixes(element, false, false, prefixPreferences);
        return prefixPreferences.getAll();
    }

    private static final void collectPrefixes(Element element, boolean bl, final boolean bl2, final PrefixPreferences prefixPreferences) {
        final IdentityLinearHashtable identityLinearHashtable = new IdentityLinearHashtable();
        final Namespace[] namespaceArray = new Namespace[1];
        Traversal.traverse(element, new Traversal.HandlerBase(){

            @Override
            public Object enterElement(Element element) {
                PrefixEntry[] prefixEntryArray = (PrefixEntry[])element.getProperty(Constants.DECLARED_PREFIXES_PROPERTY);
                if (prefixEntryArray != null) {
                    for (int i = 0; i < prefixEntryArray.length; ++i) {
                        PrefixEntry prefixEntry = prefixEntryArray[i];
                        Namespace namespace = prefixEntry.namespace;
                        String string = prefixEntry.prefix;
                        if (prefixPreferences.add(namespace, string) == null) {
                            identityLinearHashtable.put(namespace, namespace);
                        }
                        if (namespaceArray[0] != null || string.length() != 0 || namespace == Namespace.NONE || namespace == Namespace.XML) continue;
                        namespaceArray[0] = namespace;
                    }
                    if (bl2) {
                        element.removeProperty(Constants.DECLARED_PREFIXES_PROPERTY);
                    }
                }
                return null;
            }
        });
        if (identityLinearHashtable.size() > 0) {
            Iterator iterator = identityLinearHashtable.elements();
            while (iterator.hasNext()) {
                Namespace namespace = (Namespace)iterator.next();
                prefixPreferences.add(namespace, null);
            }
        }
        if (bl && namespaceArray[0] != null) {
            prefixPreferences.setDefaultNamespace(namespaceArray[0]);
        }
    }

    public void addImportedNamespace(Namespace namespace) {
        if (this.importedNamespaces == null) {
            this.importedNamespaces = new IdentityHashMap();
        }
        this.importedNamespaces.put(namespace, namespace);
    }

    public boolean isImportedNamespace(Namespace namespace) {
        if (this.importedNamespaces == null) {
            return false;
        }
        return this.importedNamespaces.containsKey(namespace);
    }
}

