/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.Msg;
import com.xmlmind.xml.wxs.load.SchemaError;
import java.util.Arrays;
import java.util.Comparator;

public final class SchemaErrors {
    private SchemaError[] list = new SchemaError[10];
    private int size = 0;
    public static final SchemaError[] NO_ERRORS = new SchemaError[0];
    private static final SchemaErrorCompare schemaErrorCompare = new SchemaErrorCompare();

    public void append(Info info, String string, String string2) {
        this.append(new SchemaError(info.peerElement, string, Msg.msg(string2)));
    }

    public void append(Info info, String string, String string2, Object ... objectArray) {
        this.append(new SchemaError(info.peerElement, string, Msg.msg(string2, objectArray)));
    }

    public void append(SchemaError schemaError) {
        if (this.size >= this.list.length) {
            SchemaError[] schemaErrorArray = new SchemaError[2 * this.list.length];
            System.arraycopy(this.list, 0, schemaErrorArray, 0, this.size);
            this.list = schemaErrorArray;
        }
        this.list[this.size++] = schemaError;
    }

    public SchemaError[] toArray() {
        SchemaError[] schemaErrorArray;
        if (this.size > 0) {
            schemaErrorArray = new SchemaError[this.size];
            System.arraycopy(this.list, 0, schemaErrorArray, 0, this.size);
            if (this.size > 1) {
                Arrays.sort(schemaErrorArray, schemaErrorCompare);
            }
        } else {
            schemaErrorArray = NO_ERRORS;
        }
        return schemaErrorArray;
    }

    private static class SchemaErrorCompare
    implements Comparator<SchemaError> {
        private SchemaErrorCompare() {
        }

        @Override
        public int compare(SchemaError schemaError, SchemaError schemaError2) {
            int n;
            int n2;
            int n3 = schemaError.getLineNumber();
            if (n3 != (n2 = schemaError2.getLineNumber())) {
                return n3 - n2;
            }
            int n4 = schemaError.getColumnNumber();
            if (n4 != (n = schemaError2.getColumnNumber())) {
                return n4 - n;
            }
            return schemaError.message.compareTo(schemaError2.message);
        }
    }
}

