/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.wxs.load.AttributeGroupInfo;
import com.xmlmind.xml.wxs.load.ComplexTypeInfo;
import com.xmlmind.xml.wxs.load.GroupInfo;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.ModelGroupInfo;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import com.xmlmind.xml.wxs.load.SimpleTypeInfo;
import com.xmlmind.xml.wxs.load.TypeInfo;
import java.net.URL;
import org.xml.sax.SAXParseException;

final class RedefineInfo
extends Info {
    public URL schemaLocation = null;
    private static int redefineCounter = 0;

    public RedefineInfo(Info info) {
        super(info);
    }

    @Override
    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.schemaLocation = RedefineInfo.getResolvedURLAttribute(element, _SCHEMA_LOCATION, this.getLocation(), null);
        if (this.schemaLocation == null) {
            schemaErrors2.append(this, "x-src-redefine.1", "invalidSchemaLocation");
            return;
        }
        if (loadContext.isSchemaBeingLoaded(this.schemaLocation)) {
            return;
        }
        SchemaInfo schemaInfo2 = null;
        try {
            schemaInfo2 = RedefineInfo.loadSchema(this.schemaLocation, schemaInfo.targetNamespace, loadContext, schemaErrors, schemaErrors2);
        }
        catch (Exception exception) {
            String string = exception instanceof SAXParseException ? DocumentLoader.format((SAXParseException)exception) : ThrowableUtil.reason(exception);
            schemaErrors2.append(this, "x-src-redefine.1", "cannotLoadSchema", this.schemaLocation, string);
            return;
        }
        if (schemaInfo2 != null && schemaInfo2.targetNamespace != schemaInfo.targetNamespace) {
            schemaErrors2.append(this, "src-redefine.2", "unexpectedTargetNamespace", schemaInfo.targetNamespace, this.schemaLocation, schemaInfo2.targetNamespace);
            schemaInfo2 = null;
        }
        boolean bl = false;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Info info;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == XSD_SIMPLE_TYPE) {
                info = new SimpleTypeInfo(this);
                ((SimpleTypeInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                if (schemaInfo2 == null || RedefineInfo.redefineSimpleType(schemaInfo2, (SimpleTypeInfo)info, schemaErrors2)) continue;
                bl = true;
                continue;
            }
            if (name == XSD_COMPLEX_TYPE) {
                info = new ComplexTypeInfo(this);
                ((ComplexTypeInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                if (schemaInfo2 == null || RedefineInfo.redefineComplexType(schemaInfo2, (ComplexTypeInfo)info, schemaErrors2)) continue;
                bl = true;
                continue;
            }
            if (name == XSD_GROUP) {
                info = new GroupInfo(this);
                ((GroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                if (schemaInfo2 == null || RedefineInfo.redefineGroup(schemaInfo2, (GroupInfo)info, schemaErrors2)) continue;
                bl = true;
                continue;
            }
            if (name != XSD_ATTRIBUTE_GROUP) continue;
            info = new AttributeGroupInfo(this);
            ((AttributeGroupInfo)info).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            if (schemaInfo2 == null || RedefineInfo.redefineAttributeGroup(schemaInfo2, (AttributeGroupInfo)info, schemaErrors2)) continue;
            bl = true;
        }
        if (schemaInfo2 != null && !bl) {
            RedefineInfo.moveInfo(schemaInfo2, schemaInfo, schemaErrors2);
        }
    }

    private static boolean redefineSimpleType(SchemaInfo schemaInfo, SimpleTypeInfo simpleTypeInfo, SchemaErrors schemaErrors) {
        Name name;
        Name name2 = simpleTypeInfo.name;
        if (name2 == null) {
            return false;
        }
        TypeInfo typeInfo = schemaInfo.typeInfo.get(name2);
        if (typeInfo == null) {
            schemaErrors.append(simpleTypeInfo, "src-expredef.1", "missingRedefinedComponent", "simpleType", name2.format(false, simpleTypeInfo), schemaInfo.getLocation());
            return false;
        }
        if (simpleTypeInfo.derivation != 2 || simpleTypeInfo.base != name2) {
            schemaErrors.append(simpleTypeInfo, "src-redefine.5", "invalidSimpleTypeRedefinition", name2.format(false, simpleTypeInfo));
            return false;
        }
        schemaInfo.typeInfo.remove(name2);
        typeInfo.name = name = RedefineInfo.redefinedName(name2);
        schemaInfo.typeInfo.put(name, typeInfo);
        simpleTypeInfo.base = name;
        schemaInfo.typeInfo.put(name2, simpleTypeInfo);
        return true;
    }

    private static boolean redefineComplexType(SchemaInfo schemaInfo, ComplexTypeInfo complexTypeInfo, SchemaErrors schemaErrors) {
        Name name;
        Name name2 = complexTypeInfo.name;
        if (name2 == null) {
            return false;
        }
        TypeInfo typeInfo = schemaInfo.typeInfo.get(name2);
        if (typeInfo == null) {
            schemaErrors.append(complexTypeInfo, "src-expredef.1", "missingRedefinedComponent", "simpleType|complexType", name2.format(false, complexTypeInfo), schemaInfo.getLocation());
            return false;
        }
        if (complexTypeInfo.base != name2) {
            schemaErrors.append(complexTypeInfo, "src-redefine.5", "invalidComplexTypeRedefinition", name2.format(false, complexTypeInfo));
            return false;
        }
        schemaInfo.typeInfo.remove(name2);
        typeInfo.name = name = RedefineInfo.redefinedName(name2);
        schemaInfo.typeInfo.put(name, typeInfo);
        complexTypeInfo.base = name;
        schemaInfo.typeInfo.put(name2, complexTypeInfo);
        return true;
    }

    private static boolean redefineGroup(SchemaInfo schemaInfo, GroupInfo groupInfo, SchemaErrors schemaErrors) {
        Name name = groupInfo.name;
        if (name == null) {
            return false;
        }
        GroupInfo groupInfo2 = schemaInfo.groupInfo.get(name);
        GroupSelfReference groupSelfReference = new GroupSelfReference();
        if (groupInfo.modelGroupInfo != null) {
            RedefineInfo.findGroupSelfReference(name, groupInfo.modelGroupInfo, groupSelfReference);
            if (groupSelfReference.count > 0) {
                Name name2;
                if (groupSelfReference.count > 1) {
                    schemaErrors.append(groupInfo, "src-redefine.6.1.1", "severalSelfReferences", "group", name.format(false, groupInfo));
                    return false;
                }
                if (groupSelfReference.groupInfo.minOccurs != 1 || groupSelfReference.groupInfo.maxOccurs != 1) {
                    schemaErrors.append(groupInfo, "src-redefine.6.1.2", "invalidGroupSelfReference", name.format(false, groupInfo));
                    return false;
                }
                if (groupInfo2 == null) {
                    schemaErrors.append(groupInfo, "src-expredef.2", "missingRedefinedComponent", "group", name.format(false, groupInfo), schemaInfo.getLocation());
                    return false;
                }
                schemaInfo.groupInfo.remove(name);
                groupInfo2.name = name2 = RedefineInfo.redefinedName(name);
                schemaInfo.groupInfo.put(name2, groupInfo2);
                groupSelfReference.groupInfo.ref = name2;
            }
        }
        if (groupSelfReference.count == 0 && groupInfo2 == null) {
            schemaErrors.append(groupInfo, "src-redefine.6.2.1", "missingRedefinedComponent", "group", name.format(false, groupInfo), schemaInfo.getLocation());
            return false;
        }
        schemaInfo.groupInfo.put(name, groupInfo);
        return true;
    }

    private static void findGroupSelfReference(Name name, ModelGroupInfo modelGroupInfo, GroupSelfReference groupSelfReference) {
        Info[] infoArray = modelGroupInfo.particleInfo;
        if (infoArray == null) {
            return;
        }
        for (int i = 0; i < infoArray.length; ++i) {
            Info info = infoArray[i];
            if (info instanceof GroupInfo) {
                GroupInfo groupInfo = (GroupInfo)info;
                if (groupInfo.ref != name) continue;
                groupSelfReference.groupInfo = groupInfo;
                ++groupSelfReference.count;
                continue;
            }
            if (!(info instanceof ModelGroupInfo)) continue;
            RedefineInfo.findGroupSelfReference(name, (ModelGroupInfo)info, groupSelfReference);
        }
    }

    private static boolean redefineAttributeGroup(SchemaInfo schemaInfo, AttributeGroupInfo attributeGroupInfo, SchemaErrors schemaErrors) {
        Name name = attributeGroupInfo.name;
        if (name == null) {
            return false;
        }
        AttributeGroupInfo attributeGroupInfo2 = schemaInfo.attributeGroupInfo.get(name);
        int n = 0;
        if (attributeGroupInfo.attributeGroupInfo != null) {
            AttributeGroupInfo[] attributeGroupInfoArray = attributeGroupInfo.attributeGroupInfo;
            AttributeGroupInfo attributeGroupInfo3 = null;
            for (int i = 0; i < attributeGroupInfoArray.length; ++i) {
                if (attributeGroupInfoArray[i].ref != name) continue;
                attributeGroupInfo3 = attributeGroupInfoArray[i];
                ++n;
            }
            if (n > 0) {
                Name name2;
                if (n > 1) {
                    schemaErrors.append(attributeGroupInfo, "src-redefine.7.1", "severalSelfReferences", "attributeGroup", name.format(false, attributeGroupInfo));
                    return false;
                }
                if (attributeGroupInfo2 == null) {
                    schemaErrors.append(attributeGroupInfo, "src-expredef.2", "missingRedefinedComponent", "attributeGroup", name.format(false, attributeGroupInfo), schemaInfo.getLocation());
                    return false;
                }
                schemaInfo.attributeGroupInfo.remove(name);
                attributeGroupInfo2.name = name2 = RedefineInfo.redefinedName(name);
                schemaInfo.attributeGroupInfo.put(name2, attributeGroupInfo2);
                attributeGroupInfo3.ref = name2;
            }
        }
        if (n == 0 && attributeGroupInfo2 == null) {
            schemaErrors.append(attributeGroupInfo, "src-redefine.7.2.1", "missingRedefinedComponent", "attributeGroup", name.format(false, attributeGroupInfo), schemaInfo.getLocation());
            return false;
        }
        schemaInfo.attributeGroupInfo.put(name, attributeGroupInfo);
        return true;
    }

    private static Name redefinedName(Name name) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("__");
        stringBuilder.append(redefineCounter++);
        stringBuilder.append("__");
        stringBuilder.append(name.localPart);
        return Name.get(name.namespace, stringBuilder.toString());
    }

    private static class GroupSelfReference {
        public int count;
        public GroupInfo groupInfo;

        private GroupSelfReference() {
        }
    }
}

