/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.util.FileUtil;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.Msg;
import com.xmlmind.xml.wxs.load.SchemaError;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import com.xmlmind.xml.wxs.validate.ValidationError;
import com.xmlmind.xml.wxs.validate.WXSchemaForWXSchema;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.SAXException;

final class InfoLoader {
    private SchemaError[] warningList;
    private SchemaError[] errorList;

    InfoLoader() {
    }

    public SchemaInfo load(File file, Namespace namespace, LoadContext loadContext) throws IOException, SAXException {
        return this.load(FileUtil.fileToURL(file), namespace, loadContext);
    }

    public SchemaInfo load(URL uRL, Namespace namespace, LoadContext loadContext) throws IOException, SAXException {
        DocumentLoader documentLoader = InfoLoader.createDocumentLoader();
        Document document = documentLoader.load(uRL);
        return this.load(document, namespace, loadContext);
    }

    public static DocumentLoader createDocumentLoader() {
        DocumentLoader documentLoader = new DocumentLoader();
        documentLoader.setOptions(3);
        return documentLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaInfo load(Document document, Namespace namespace, LoadContext loadContext) {
        URL uRL = document.getSourceURL();
        if (uRL != null) {
            loadContext.pushSchemaBeingLoaded(uRL);
        }
        SchemaInfo schemaInfo = null;
        try {
            schemaInfo = this.doLoad(document, namespace, loadContext);
        }
        finally {
            if (uRL != null) {
                loadContext.popSchemaBeingLoaded();
            }
        }
        return schemaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaInfo doLoad(Document document, Namespace namespace, LoadContext loadContext) {
        ValidationError[] validationErrorArray;
        this.warningList = SchemaErrors.NO_ERRORS;
        this.errorList = SchemaErrors.NO_ERRORS;
        WXSchemaForWXSchema wXSchemaForWXSchema = WXSchemaForWXSchema.getInstance();
        if (wXSchemaForWXSchema != null) {
            WXSchemaForWXSchema wXSchemaForWXSchema2 = wXSchemaForWXSchema;
            synchronized (wXSchemaForWXSchema2) {
                validationErrorArray = wXSchemaForWXSchema.validate(document);
            }
            int n = validationErrorArray.length;
            if (n > 0) {
                this.errorList = new SchemaError[n];
                for (int i = 0; i < n; ++i) {
                    ValidationError validationError = validationErrorArray[i];
                    this.errorList[i] = new SchemaError(validationError.element, validationError.constraint, validationError.message);
                }
                return null;
            }
        }
        validationErrorArray = new SchemaErrors();
        SchemaErrors schemaErrors = new SchemaErrors();
        SchemaInfo schemaInfo = new SchemaInfo(namespace == null ? Namespace.NONE : namespace);
        Element element = document.getRootElement();
        if (element.getName() == Info.XSD_SCHEMA) {
            schemaInfo.init(element, schemaInfo, loadContext, (SchemaErrors)validationErrorArray, schemaErrors);
        } else {
            schemaErrors.append(new SchemaError(element, null, Msg.msg("notASchemaElement")));
        }
        this.warningList = validationErrorArray.toArray();
        this.errorList = schemaErrors.toArray();
        if (this.errorList.length > 0) {
            return null;
        }
        return schemaInfo;
    }

    public SchemaError[] getWarnings() {
        return this.warningList;
    }

    public SchemaError[] getErrors() {
        return this.errorList;
    }
}

