/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.util.IdentityLinearHashtable;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespacePrefixMap;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.load.AttributeGroupInfo;
import com.xmlmind.xml.wxs.load.AttributeInfo;
import com.xmlmind.xml.wxs.load.ElementInfo;
import com.xmlmind.xml.wxs.load.GroupInfo;
import com.xmlmind.xml.wxs.load.InfoLoader;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.LoadState;
import com.xmlmind.xml.wxs.load.NotationInfo;
import com.xmlmind.xml.wxs.load.RedefineInfo;
import com.xmlmind.xml.wxs.load.SchemaError;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import com.xmlmind.xml.wxs.load.TypeInfo;
import com.xmlmind.xml.wxs.load.Use;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.NameWildcard;
import com.xmlmind.xml.wxs.validate.Particle;
import com.xmlmind.xml.wxs.validate.Wildcard;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.IdentityHashMap;
import org.xml.sax.SAXException;

abstract class Info
implements NamespacePrefixMap {
    public static final int EXTENSION = 1;
    public static final int RESTRICTION = 2;
    public static final int SUBSTITUTION = 4;
    public static final int LIST = 8;
    public static final int UNION = 16;
    public Info parent;
    public Element peerElement;
    public Name name;
    private static final Name NAME_WILDCARD_ATTR = Name.get(Namespace.get("http://www.xmlmind.com/xmleditor/namespace/extension"), "NameWildcard");
    public static final Name XSD_ALL = Name.get(Namespace.XSD, "all");
    public static final Name XSD_ANNOTATION = Name.get(Namespace.XSD, "annotation");
    public static final Name XSD_APPINFO = Name.get(Namespace.XSD, "appinfo");
    public static final Name XSD_ANY_ATTRIBUTE = Name.get(Namespace.XSD, "anyAttribute");
    public static final Name XSD_ATTRIBUTE = Name.get(Namespace.XSD, "attribute");
    public static final Name XSD_ATTRIBUTE_GROUP = Name.get(Namespace.XSD, "attributeGroup");
    public static final Name XSD_CHOICE = Name.get(Namespace.XSD, "choice");
    public static final Name XSD_COMPLEX_TYPE = Name.get(Namespace.XSD, "complexType");
    public static final Name XSD_ELEMENT = Name.get(Namespace.XSD, "element");
    public static final Name XSD_GROUP = Name.get(Namespace.XSD, "group");
    public static final Name XSD_IMPORT = Name.get(Namespace.XSD, "import");
    public static final Name XSD_INCLUDE = Name.get(Namespace.XSD, "include");
    public static final Name XSD_NOTATION = Name.get(Namespace.XSD, "notation");
    public static final Name XSD_REDEFINE = Name.get(Namespace.XSD, "redefine");
    public static final Name XSD_SCHEMA = Name.get(Namespace.XSD, "schema");
    public static final Name XSD_SEQUENCE = Name.get(Namespace.XSD, "sequence");
    public static final Name XSD_SIMPLE_TYPE = Name.get(Namespace.XSD, "simpleType");
    public static final Name XSD_UNIQUE = Name.get(Namespace.XSD, "unique");
    public static final Name XSD_KEY = Name.get(Namespace.XSD, "key");
    public static final Name XSD_KEYREF = Name.get(Namespace.XSD, "keyref");
    public static final Name XSD_SELECTOR = Name.get(Namespace.XSD, "selector");
    public static final Name XSD_FIELD = Name.get(Namespace.XSD, "field");
    public static final Name XSD_COMPLEX_CONTENT = Name.get(Namespace.XSD, "complexContent");
    public static final Name XSD_SIMPLE_CONTENT = Name.get(Namespace.XSD, "simpleContent");
    public static final Name XSD_RESTRICTION = Name.get(Namespace.XSD, "restriction");
    public static final Name XSD_EXTENSION = Name.get(Namespace.XSD, "extension");
    public static final Name XSD_LIST = Name.get(Namespace.XSD, "list");
    public static final Name XSD_UNION = Name.get(Namespace.XSD, "union");
    public static final Name XSD_LENGTH = Name.get(Namespace.XSD, "length");
    public static final Name XSD_MIN_LENGTH = Name.get(Namespace.XSD, "minLength");
    public static final Name XSD_MAX_LENGTH = Name.get(Namespace.XSD, "maxLength");
    public static final Name XSD_PATTERN = Name.get(Namespace.XSD, "pattern");
    public static final Name XSD_ENUMERATION = Name.get(Namespace.XSD, "enumeration");
    public static final Name XSD_WHITE_SPACE = Name.get(Namespace.XSD, "whiteSpace");
    public static final Name XSD_MAX_INCLUSIVE = Name.get(Namespace.XSD, "maxInclusive");
    public static final Name XSD_MAX_EXCLUSIVE = Name.get(Namespace.XSD, "maxExclusive");
    public static final Name XSD_MIN_EXCLUSIVE = Name.get(Namespace.XSD, "minExclusive");
    public static final Name XSD_MIN_INCLUSIVE = Name.get(Namespace.XSD, "minInclusive");
    public static final Name XSD_TOTAL_DIGITS = Name.get(Namespace.XSD, "totalDigits");
    public static final Name XSD_FRACTION_DIGITS = Name.get(Namespace.XSD, "fractionDigits");
    public static final Name XSD_ANY = Name.get(Namespace.XSD, "any");
    public static final Name XSD_ANY_TYPE = Name.get(Namespace.XSD, "anyType");
    public static final Name _ATTRIBUTE_FORM_DEFAULT = Name.get(Namespace.NONE, "attributeFormDefault");
    public static final Name _BLOCK_DEFAULT = Name.get(Namespace.NONE, "blockDefault");
    public static final Name _DEFAULT = Name.get(Namespace.NONE, "default");
    public static final Name _ELEMENT_FORM_DEFAULT = Name.get(Namespace.NONE, "elementFormDefault");
    public static final Name _FINAL_DEFAULT = Name.get(Namespace.NONE, "finalDefault");
    public static final Name _FIXED = Name.get(Namespace.NONE, "fixed");
    public static final Name _FORM = Name.get(Namespace.NONE, "form");
    public static final Name _MAX_OCCURS = Name.get(Namespace.NONE, "maxOccurs");
    public static final Name _MIN_OCCURS = Name.get(Namespace.NONE, "minOccurs");
    public static final Name _NAME = Name.get(Namespace.NONE, "name");
    public static final Name _NAMESPACE = Name.get(Namespace.NONE, "namespace");
    public static final Name _PROCESS_CONTENTS = Name.get(Namespace.NONE, "processContents");
    public static final Name _PUBLIC = Name.get(Namespace.NONE, "public");
    public static final Name _REF = Name.get(Namespace.NONE, "ref");
    public static final Name _SCHEMA_LOCATION = Name.get(Namespace.NONE, "schemaLocation");
    public static final Name _SYSTEM = Name.get(Namespace.NONE, "system");
    public static final Name _TARGET_NAMESPACE = Name.get(Namespace.NONE, "targetNamespace");
    public static final Name _TYPE = Name.get(Namespace.NONE, "type");
    public static final Name _USE = Name.get(Namespace.NONE, "use");
    public static final Name _REFER = Name.get(Namespace.NONE, "refer");
    public static final Name _XPATH = Name.get(Namespace.NONE, "xpath");
    public static final Name _ABSTRACT = Name.get(Namespace.NONE, "abstract");
    public static final Name _BLOCK = Name.get(Namespace.NONE, "block");
    public static final Name _FINAL = Name.get(Namespace.NONE, "final");
    public static final Name _NILLABLE = Name.get(Namespace.NONE, "nillable");
    public static final Name _SUBSTITUTION_GROUP = Name.get(Namespace.NONE, "substitutionGroup");
    public static final Name _BASE = Name.get(Namespace.NONE, "base");
    public static final Name _ITEM_TYPE = Name.get(Namespace.NONE, "itemType");
    public static final Name _MEMBER_TYPES = Name.get(Namespace.NONE, "memberTypes");
    public static final Name _VALUE = Name.get(Namespace.NONE, "value");
    public static final Name _MIXED = Name.get(Namespace.NONE, "mixed");
    protected static IdentityLinearHashtable<Name, NameToFacetEntry> nameToFacet = new IdentityLinearHashtable();

    protected Info(Info info) {
        this.parent = info;
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        this.peerElement = element;
    }

    public final String getType() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46) + 1;
        return Character.toLowerCase(string.charAt(n)) + string.substring(n + 1, string.length() - 4);
    }

    public final URL getLocation() {
        return this.peerElement.getSourceURL();
    }

    @Override
    public Namespace prefixToNamespace(String string) {
        return this.peerElement.prefixToNamespace(string);
    }

    @Override
    public String[] namespaceToPrefixes(Namespace namespace) {
        return this.peerElement.namespaceToPrefixes(namespace);
    }

    public final SchemaInfo getSchema() {
        Info info = this;
        while (info.parent != null) {
            info = info.parent;
        }
        return (SchemaInfo)info;
    }

    public final URL getSchemaURL() {
        return this.getSchema().getLocation();
    }

    protected static SchemaInfo loadSchema(URL uRL, Namespace namespace, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) throws IOException, SAXException {
        InfoLoader infoLoader = new InfoLoader();
        SchemaInfo schemaInfo = null;
        schemaInfo = infoLoader.load(uRL, namespace, loadContext);
        SchemaError[] schemaErrorArray = infoLoader.getWarnings();
        for (int i = 0; i < schemaErrorArray.length; ++i) {
            schemaErrors.append(schemaErrorArray[i]);
        }
        if (schemaInfo == null) {
            SchemaError[] schemaErrorArray2 = infoLoader.getErrors();
            for (int i = 0; i < schemaErrorArray2.length; ++i) {
                schemaErrors2.append(schemaErrorArray2[i]);
            }
        }
        return schemaInfo;
    }

    protected static void moveInfo(SchemaInfo schemaInfo, SchemaInfo schemaInfo2, SchemaErrors schemaErrors) {
        schemaInfo2.declaredPrefixes = PrefixPreferences.merge(schemaInfo2.declaredPrefixes, schemaInfo.declaredPrefixes);
        schemaInfo2.sourceURLs = Info.mergeURLs(schemaInfo2.sourceURLs, schemaInfo.sourceURLs);
        for (ElementInfo object : schemaInfo.elementInfo.values()) {
            ElementInfo elementInfo = schemaInfo2.elementInfo.put(object.name, object);
            if (elementInfo == null || elementInfo.getSchemaURL().equals(object.getSchemaURL())) continue;
            schemaErrors.append(schemaInfo2, "sch-props-correct.2", "duplicateElement", object.name.format(false, object));
        }
        schemaInfo.elementInfo.clear();
        for (AttributeInfo attributeInfo : schemaInfo.attributeInfo.values()) {
            AttributeInfo attributeInfo2 = schemaInfo2.attributeInfo.put(attributeInfo.name, attributeInfo);
            if (attributeInfo2 == null || attributeInfo2.getSchemaURL().equals(attributeInfo.getSchemaURL())) continue;
            schemaErrors.append(schemaInfo2, "sch-props-correct.2", "duplicateAttribute", attributeInfo.name.format(false, attributeInfo));
        }
        schemaInfo.attributeInfo.clear();
        for (TypeInfo typeInfo : schemaInfo.typeInfo.values()) {
            TypeInfo typeInfo2 = schemaInfo2.typeInfo.put(typeInfo.name, typeInfo);
            if (typeInfo2 == null || typeInfo2.getSchemaURL().equals(typeInfo.getSchemaURL())) continue;
            schemaErrors.append(schemaInfo2, "sch-props-correct.2", "duplicateType", typeInfo.name.format(false, typeInfo));
        }
        schemaInfo.typeInfo.clear();
        for (GroupInfo groupInfo : schemaInfo.groupInfo.values()) {
            GroupInfo groupInfo2 = schemaInfo2.groupInfo.put(groupInfo.name, groupInfo);
            if (groupInfo2 == null || groupInfo2.getSchemaURL().equals(groupInfo.getSchemaURL())) continue;
            schemaErrors.append(schemaInfo2, "sch-props-correct.2", "duplicateGroup", groupInfo.name.format(false, groupInfo));
        }
        schemaInfo.groupInfo.clear();
        for (AttributeGroupInfo attributeGroupInfo : schemaInfo.attributeGroupInfo.values()) {
            AttributeGroupInfo attributeGroupInfo2 = schemaInfo2.attributeGroupInfo.put(attributeGroupInfo.name, attributeGroupInfo);
            if (attributeGroupInfo2 == null || attributeGroupInfo2.getSchemaURL().equals(attributeGroupInfo.getSchemaURL())) continue;
            schemaErrors.append(schemaInfo2, "sch-props-correct.2", "duplicateAttributeGroup", attributeGroupInfo.name.format(false, attributeGroupInfo));
        }
        schemaInfo.attributeGroupInfo.clear();
        for (NotationInfo notationInfo : schemaInfo.notationInfo.values()) {
            NotationInfo notationInfo2 = schemaInfo2.notationInfo.put(notationInfo.name, notationInfo);
            if (notationInfo2 == null || notationInfo2.getSchemaURL().equals(notationInfo.getSchemaURL())) continue;
            schemaErrors.append(schemaInfo2, "sch-props-correct.2", "duplicateNotation", notationInfo.name.format(false, notationInfo));
        }
        schemaInfo.notationInfo.clear();
    }

    private static final URL[] mergeURLs(URL[] uRLArray, URL[] uRLArray2) {
        if (uRLArray == null || uRLArray.length == 0) {
            return uRLArray2;
        }
        if (uRLArray2 == null || uRLArray2.length == 0) {
            return uRLArray;
        }
        URL[] uRLArray3 = new URL[uRLArray.length + uRLArray2.length];
        System.arraycopy(uRLArray, 0, uRLArray3, 0, uRLArray.length);
        int n = uRLArray.length;
        for (int i = 0; i < uRLArray2.length; ++i) {
            URL uRL = uRLArray2[i];
            boolean bl = true;
            for (int j = 0; j < uRLArray.length; ++j) {
                if (!uRLArray[j].equals(uRL)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            uRLArray3[n++] = uRL;
        }
        if (n != uRLArray3.length) {
            URL[] uRLArray4 = new URL[n];
            System.arraycopy(uRLArray3, 0, uRLArray4, 0, n);
            uRLArray3 = uRLArray4;
        }
        return uRLArray3;
    }

    protected static Element getChild(Element element, Name name) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() != name) continue;
            return element2;
        }
        return null;
    }

    protected Namespace getTargetNamespace(Element element, boolean bl, SchemaInfo schemaInfo) {
        String string = element.getAttribute(_FORM);
        boolean bl2 = false;
        if (string != null) {
            bl2 = Info.getFormAttribute(element, _FORM, false);
        }
        Namespace namespace = this.parent instanceof SchemaInfo || this.parent instanceof RedefineInfo || element.hasAttribute(_REF) ? schemaInfo.targetNamespace : (string != null && bl2 || string == null && (!bl && schemaInfo.elementFormQualified || bl && schemaInfo.attributeFormQualified) ? schemaInfo.targetNamespace : Namespace.NONE);
        return namespace;
    }

    protected static Name getNCNameAttribute(Element element, Name name, Namespace namespace, Name name2) {
        String string = element.getAttribute(name);
        if (string == null) {
            return name2;
        }
        if (!XMLText.isNCName(string = string.trim())) {
            return name2;
        }
        return Name.get(namespace, string);
    }

    protected static String getNamespaceURIAttribute(Element element, Name name, String string) {
        String string2 = element.getAnyURIAttribute(name, null);
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string2;
    }

    protected static URL getResolvedURLAttribute(Element element, Name name, URL uRL, URL uRL2) {
        String string = element.getAnyURIAttribute(name, null);
        if (string == null) {
            return uRL2;
        }
        URL uRL3 = null;
        try {
            uRL3 = XMLCatalogs.resolveURI(string, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL3 == null ? uRL2 : uRL3;
    }

    protected static NameWildcard getNameWildcardAttribute(Element element, Name name, Namespace namespace, NameWildcard nameWildcard) {
        NameWildcard nameWildcard2 = Info.createCustomNameWildcard(element);
        if (nameWildcard2 != null) {
            return nameWildcard2;
        }
        String string = element.getAttribute(name);
        if (string == null) {
            return nameWildcard;
        }
        String[] stringArray = XMLText.splitList(string);
        if (stringArray.length == 0) {
            return nameWildcard;
        }
        if (stringArray.length == 1 && "##any".equals(stringArray[0])) {
            return NameWildcard.ANY;
        }
        if (stringArray.length == 1 && "##other".equals(stringArray[0])) {
            return new NameWildcard(namespace);
        }
        IdentityLinearHashtable<Namespace, Namespace> identityLinearHashtable = new IdentityLinearHashtable<Namespace, Namespace>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if ("##targetNamespace".equals(string2)) {
                identityLinearHashtable.put(namespace, namespace);
                continue;
            }
            if ("##local".equals(string2)) {
                identityLinearHashtable.put(Namespace.NONE, Namespace.NONE);
                continue;
            }
            Namespace namespace2 = Namespace.get(string2);
            identityLinearHashtable.put(namespace2, namespace2);
        }
        Namespace[] namespaceArray = new Namespace[identityLinearHashtable.size()];
        identityLinearHashtable.copyElementsInto(namespaceArray);
        return new NameWildcard(namespaceArray);
    }

    private static NameWildcard createCustomNameWildcard(Element element) {
        Element element2 = element.getChildElement(0);
        if (element2 != null && element2.getName() == XSD_ANNOTATION) {
            for (Node node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
                String string;
                Element element3;
                if (node.getType() != Node.Type.ELEMENT || (element3 = (Element)node).getName() != XSD_APPINFO || (string = element3.getAttribute(NAME_WILDCARD_ATTR)) == null) continue;
                NameWildcard nameWildcard = null;
                try {
                    nameWildcard = (NameWildcard)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return nameWildcard;
            }
        }
        return null;
    }

    protected static Wildcard.ProcessContents getProcessContentsAttribute(Element element, Name name, Wildcard.ProcessContents processContents) {
        String string = element.getAttribute(name);
        if (string == null) {
            return processContents;
        }
        if ("skip".equals(string = string.trim())) {
            return Wildcard.ProcessContents.SKIP;
        }
        if ("lax".equals(string)) {
            return Wildcard.ProcessContents.LAX;
        }
        if ("strict".equals(string)) {
            return Wildcard.ProcessContents.STRICT;
        }
        return processContents;
    }

    protected static int getNonNegativeIntAttribute(Element element, Name name, int n) {
        int n2;
        String string = element.getAttribute(name);
        if (string == null) {
            return n;
        }
        string = string.trim();
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        return n2 < 0 ? n : n2;
    }

    protected static int getMaxOccursAttribute(Element element, Name name, int n) {
        int n2;
        String string = element.getAttribute(name);
        if (string == null) {
            return n;
        }
        if ("unbounded".equals(string = string.trim())) {
            return -1;
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        return n2 < 0 ? n : n2;
    }

    protected Name getQNameAttribute(Element element, Name name, Name name2) {
        String string = element.getAttribute(name);
        if (string == null) {
            return name2;
        }
        Name name3 = Name.parse(string = string.trim(), false, element);
        if (name3 == null) {
            return name2;
        }
        if (name3.namespace == Namespace.NONE) {
            SchemaInfo schemaInfo = this.getSchema();
            if (schemaInfo.inheritsTargetNamespace) {
                name3 = Name.get(schemaInfo.targetNamespace, name3.localPart);
            }
        }
        return name3;
    }

    protected Name[] getQNamesAttribute(Element element, Name name, Name[] nameArray) {
        String string = element.getAttribute(name);
        if (string == null) {
            return nameArray;
        }
        String[] stringArray = XMLText.splitList(string);
        if (stringArray.length == 0) {
            return nameArray;
        }
        Name[] nameArray2 = new Name[stringArray.length];
        SchemaInfo schemaInfo = null;
        for (int i = 0; i < stringArray.length; ++i) {
            Name name2 = Name.parse(stringArray[i], false, element);
            if (name2 == null) {
                return nameArray;
            }
            if (name2.namespace == Namespace.NONE) {
                if (schemaInfo == null) {
                    schemaInfo = this.getSchema();
                }
                if (schemaInfo.inheritsTargetNamespace) {
                    name2 = Name.get(schemaInfo.targetNamespace, name2.localPart);
                }
            }
            nameArray2[i] = name2;
        }
        return nameArray2;
    }

    protected boolean checkImportedNamespaces(Name[] nameArray, SchemaInfo schemaInfo, SchemaErrors schemaErrors) {
        boolean bl = true;
        for (int i = 0; i < nameArray.length; ++i) {
            if (this.checkImportedNamespaces(nameArray[i], schemaInfo, schemaErrors)) continue;
            bl = false;
        }
        return bl;
    }

    protected boolean checkImportedNamespaces(Name name, SchemaInfo schemaInfo, SchemaErrors schemaErrors) {
        Namespace namespace = name.namespace;
        if (namespace != Namespace.XSD && namespace != schemaInfo.targetNamespace && !schemaInfo.isImportedNamespace(namespace)) {
            schemaErrors.append(this, "src-resolve.4", "cannotResolveQNameToComponent", name.format(false, this), namespace, name.localPart);
            return false;
        }
        return true;
    }

    protected static Use getUseAttribute(Element element, Name name, Use use) {
        String string = element.getAttribute(name);
        if (string == null) {
            return use;
        }
        if ("optional".equals(string = string.trim())) {
            return Use.OPTIONAL;
        }
        if ("required".equals(string)) {
            return Use.REQUIRED;
        }
        if ("prohibited".equals(string)) {
            return Use.PROHIBITED;
        }
        return use;
    }

    protected static boolean getFormAttribute(Element element, Name name, boolean bl) {
        String string = element.getAttribute(name);
        if (string == null) {
            return bl;
        }
        if ("qualified".equals(string = string.trim())) {
            return true;
        }
        if ("unqualified".equals(string)) {
            return false;
        }
        return bl;
    }

    protected static int getBlockAttribute(Element element, Name name, int n) {
        String string = element.getAttribute(name);
        if (string == null) {
            return n;
        }
        String[] stringArray = XMLText.splitList(string);
        if (stringArray.length == 0) {
            return n;
        }
        if (stringArray.length == 1 && "#all".equals(stringArray[0])) {
            return 7;
        }
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if ("extension".equals(string2)) {
                n2 |= 1;
                continue;
            }
            if ("restriction".equals(string2)) {
                n2 |= 2;
                continue;
            }
            if ("substitution".equals(string2)) {
                n2 |= 4;
                continue;
            }
            return n;
        }
        return n2;
    }

    protected static int getFinalAttribute(Element element, Name name, int n) {
        String string = element.getAttribute(name);
        if (string == null) {
            return n;
        }
        String[] stringArray = XMLText.splitList(string);
        if (stringArray.length == 0) {
            return n;
        }
        if (stringArray.length == 1 && "#all".equals(stringArray[0])) {
            return 27;
        }
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if ("extension".equals(string2)) {
                n2 |= 1;
                continue;
            }
            if ("restriction".equals(string2)) {
                n2 |= 2;
                continue;
            }
            if ("list".equals(string2)) {
                n2 |= 8;
                continue;
            }
            if ("union".equals(string2)) {
                n2 |= 0x10;
                continue;
            }
            return n;
        }
        return n2;
    }

    protected static boolean getBooleanAttribute(Element element, Name name, boolean bl) {
        String string = element.getAttribute(name);
        if (string == null) {
            return bl;
        }
        if ("true".equals(string = string.trim())) {
            return true;
        }
        if ("false".equals(string)) {
            return false;
        }
        if ("1".equals(string)) {
            return true;
        }
        if ("0".equals(string)) {
            return false;
        }
        return bl;
    }

    public boolean toParticle(Particle[] particleArray, int n, LoadState loadState) {
        loadState.errors.append(this, null, "notAParticleInfo", this.getType());
        return false;
    }

    protected boolean checkOccurs(int n, int n2, LoadState loadState) {
        if (n2 == -1) {
            return true;
        }
        if (n > n2) {
            loadState.errors.append(this, "p-props-correct.2.1", "minOccursGTMaxOccurs", n, n2);
            return false;
        }
        return true;
    }

    public boolean toParticle2(IdentityHashMap<Name, ElementDeclaration> identityHashMap, LoadState loadState) {
        loadState.errors.append(this, null, "notAParticleInfo", this.getType());
        return false;
    }

    static {
        String[] stringArray = DataType.facetNames;
        int[] nArray = DataType.facetMasks;
        for (int i = 0; i < stringArray.length; ++i) {
            NameToFacetEntry nameToFacetEntry = new NameToFacetEntry(stringArray[i], nArray[i]);
            nameToFacet.put(nameToFacetEntry.name, nameToFacetEntry);
        }
    }

    protected static class NameToFacetEntry {
        public final Name name;
        public final int facet;

        public NameToFacetEntry(String string, int n) {
            this.name = Name.get(Namespace.XSD, string);
            this.facet = n;
        }
    }
}

