/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.IDType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.InvalidTypeException;
import com.xmlmind.xml.wxs.datatype.ListType;
import com.xmlmind.xml.wxs.datatype.NOTATIONType;
import com.xmlmind.xml.wxs.datatype.Restriction;
import com.xmlmind.xml.wxs.datatype.UnionType;
import com.xmlmind.xml.wxs.load.AllInfo;
import com.xmlmind.xml.wxs.load.AnyAttributeInfo;
import com.xmlmind.xml.wxs.load.AttributeGroupInfo;
import com.xmlmind.xml.wxs.load.AttributeInfo;
import com.xmlmind.xml.wxs.load.ChoiceInfo;
import com.xmlmind.xml.wxs.load.ComplexContentInfo;
import com.xmlmind.xml.wxs.load.ElementInfo;
import com.xmlmind.xml.wxs.load.ExtensionInfo;
import com.xmlmind.xml.wxs.load.FacetInfo;
import com.xmlmind.xml.wxs.load.GroupInfo;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.LoadState;
import com.xmlmind.xml.wxs.load.Msg;
import com.xmlmind.xml.wxs.load.RestrictionInfo;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import com.xmlmind.xml.wxs.load.SequenceInfo;
import com.xmlmind.xml.wxs.load.SimpleContentInfo;
import com.xmlmind.xml.wxs.load.SimpleTypeInfo;
import com.xmlmind.xml.wxs.load.TypeInfo;
import com.xmlmind.xml.wxs.validate.AllParticle;
import com.xmlmind.xml.wxs.validate.AttributeDeclaration;
import com.xmlmind.xml.wxs.validate.AttributeUse;
import com.xmlmind.xml.wxs.validate.ChoiceParticle;
import com.xmlmind.xml.wxs.validate.ComplexType;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.ElementParticle;
import com.xmlmind.xml.wxs.validate.NameWildcard;
import com.xmlmind.xml.wxs.validate.Particle;
import com.xmlmind.xml.wxs.validate.Schema;
import com.xmlmind.xml.wxs.validate.SequenceParticle;
import com.xmlmind.xml.wxs.validate.SimpleType;
import com.xmlmind.xml.wxs.validate.Type;
import com.xmlmind.xml.wxs.validate.Wildcard;
import com.xmlmind.xml.wxs.validate.WildcardParticle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;

final class ComplexTypeInfo
extends TypeInfo {
    public boolean abstract_ = false;
    public int block = 0;
    public int final_ = 0;
    public boolean mixed = false;
    public boolean isSimpleContent = false;
    public boolean isExtension = false;
    public Name base = null;
    public SimpleTypeInfo baseTypeInfo = null;
    public FacetInfo[] facetInfo = null;
    public Info particleInfo = null;
    public AttributeInfo[] attributeInfo = null;
    public AttributeGroupInfo[] attributeGroupInfo = null;
    public AnyAttributeInfo anyAttributeInfo = null;
    private static final Name[] NO_NAMES = new Name[0];
    private static final SequenceParticle EMPTY_SEQUENCE = new SequenceParticle(new Particle[0], 1, 1);
    private ComplexType created = null;
    private Name[] prohibitedAttributeNames = NO_NAMES;
    private Name[] referencedGlobalElementNames = NO_NAMES;
    private byte finished = (byte)-1;

    public ComplexTypeInfo(Info info) {
        super(info);
    }

    public void add(AttributeInfo attributeInfo) {
        if (this.attributeInfo == null) {
            this.attributeInfo = new AttributeInfo[]{attributeInfo};
        } else {
            AttributeInfo[] attributeInfoArray = new AttributeInfo[this.attributeInfo.length + 1];
            System.arraycopy(this.attributeInfo, 0, attributeInfoArray, 0, this.attributeInfo.length);
            attributeInfoArray[this.attributeInfo.length] = attributeInfo;
            this.attributeInfo = attributeInfoArray;
        }
    }

    public void add(AttributeGroupInfo attributeGroupInfo) {
        if (this.attributeGroupInfo == null) {
            this.attributeGroupInfo = new AttributeGroupInfo[]{attributeGroupInfo};
        } else {
            AttributeGroupInfo[] attributeGroupInfoArray = new AttributeGroupInfo[this.attributeGroupInfo.length + 1];
            System.arraycopy(this.attributeGroupInfo, 0, attributeGroupInfoArray, 0, this.attributeGroupInfo.length);
            attributeGroupInfoArray[this.attributeGroupInfo.length] = attributeGroupInfo;
            this.attributeGroupInfo = attributeGroupInfoArray;
        }
    }

    public void add(FacetInfo facetInfo) {
        if (this.facetInfo == null) {
            this.facetInfo = new FacetInfo[]{facetInfo};
        } else {
            FacetInfo[] facetInfoArray = new FacetInfo[this.facetInfo.length + 1];
            System.arraycopy(this.facetInfo, 0, facetInfoArray, 0, this.facetInfo.length);
            facetInfoArray[this.facetInfo.length] = facetInfo;
            this.facetInfo = facetInfoArray;
        }
    }

    @Override
    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.name = ComplexTypeInfo.getNCNameAttribute(element, _NAME, schemaInfo.targetNamespace, null);
        this.abstract_ = ComplexTypeInfo.getBooleanAttribute(element, _ABSTRACT, false);
        this.block = ComplexTypeInfo.getBlockAttribute(element, _BLOCK, schemaInfo.blockDefault);
        this.final_ = ComplexTypeInfo.getFinalAttribute(element, _FINAL, schemaInfo.finalDefault);
        this.mixed = ComplexTypeInfo.getBooleanAttribute(element, _MIXED, false);
        boolean bl = true;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == XSD_SEQUENCE) {
                this.particleInfo = new SequenceInfo(this);
                this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                break;
            }
            if (name == XSD_CHOICE) {
                this.particleInfo = new ChoiceInfo(this);
                this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                break;
            }
            if (name == XSD_ALL) {
                this.particleInfo = new AllInfo(this);
                this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                break;
            }
            if (name == XSD_GROUP) {
                this.particleInfo = new GroupInfo(this);
                this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                break;
            }
            if (name == XSD_COMPLEX_CONTENT) {
                bl = false;
                this.isSimpleContent = false;
                this.initComplexContent(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                break;
            }
            if (name != XSD_SIMPLE_CONTENT) continue;
            bl = false;
            this.isSimpleContent = true;
            this.initSimpleContent(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            break;
        }
        if (bl) {
            this.isSimpleContent = false;
            this.isExtension = false;
            this.base = XSD_ANY_TYPE;
            this.initAttributeUse(this, element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        }
    }

    private void initSimpleContent(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        SimpleContentInfo simpleContentInfo = new SimpleContentInfo(this);
        simpleContentInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        Element element2 = ComplexTypeInfo.getChild(element, XSD_RESTRICTION);
        if (element2 != null) {
            this.isExtension = false;
            this.initSimpleRestriction(simpleContentInfo, element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        } else {
            element2 = ComplexTypeInfo.getChild(element, XSD_EXTENSION);
            if (element2 != null) {
                this.isExtension = true;
                this.initSimpleExtension(simpleContentInfo, element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            }
        }
    }

    private void initSimpleRestriction(SimpleContentInfo simpleContentInfo, Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        RestrictionInfo restrictionInfo = new RestrictionInfo(simpleContentInfo);
        restrictionInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.base = this.getQNameAttribute(element, _BASE, null);
        if (this.base != null) {
            this.checkImportedNamespaces(this.base, schemaInfo, schemaErrors2);
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == XSD_SIMPLE_TYPE) {
                this.baseTypeInfo = new SimpleTypeInfo(restrictionInfo);
                this.baseTypeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                continue;
            }
            Info.NameToFacetEntry nameToFacetEntry = (Info.NameToFacetEntry)nameToFacet.get(name);
            if (nameToFacetEntry == null || (string = element2.getAttribute(_VALUE)) == null) continue;
            boolean bl = ComplexTypeInfo.getBooleanAttribute(element2, _FIXED, false);
            FacetInfo facetInfo = new FacetInfo(restrictionInfo, nameToFacetEntry.facet, string, bl);
            facetInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            this.add(facetInfo);
        }
        this.initAttributeUse(restrictionInfo, element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
    }

    private void initSimpleExtension(SimpleContentInfo simpleContentInfo, Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        ExtensionInfo extensionInfo = new ExtensionInfo(simpleContentInfo);
        extensionInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.base = this.getQNameAttribute(element, _BASE, null);
        if (this.base != null) {
            this.checkImportedNamespaces(this.base, schemaInfo, schemaErrors2);
        }
        this.initAttributeUse(extensionInfo, element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
    }

    private void initComplexContent(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        ComplexContentInfo complexContentInfo = new ComplexContentInfo(this);
        complexContentInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.mixed = ComplexTypeInfo.getBooleanAttribute(element, _MIXED, false);
        Element element2 = ComplexTypeInfo.getChild(element, XSD_RESTRICTION);
        if (element2 != null) {
            this.isExtension = false;
            this.initComplexRestriction(complexContentInfo, element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        } else {
            element2 = ComplexTypeInfo.getChild(element, XSD_EXTENSION);
            if (element2 != null) {
                this.isExtension = true;
                this.initComplexExtension(complexContentInfo, element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            }
        }
    }

    private void initComplexExtension(ComplexContentInfo complexContentInfo, Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        ExtensionInfo extensionInfo = new ExtensionInfo(complexContentInfo);
        extensionInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.doInitComplexContent(extensionInfo, element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
    }

    private void initComplexRestriction(ComplexContentInfo complexContentInfo, Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        RestrictionInfo restrictionInfo = new RestrictionInfo(complexContentInfo);
        restrictionInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.doInitComplexContent(restrictionInfo, element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
    }

    private void doInitComplexContent(Info info, Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        this.base = this.getQNameAttribute(element, _BASE, null);
        if (this.base != null) {
            this.checkImportedNamespaces(this.base, schemaInfo, schemaErrors2);
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == XSD_SEQUENCE) {
                this.particleInfo = new SequenceInfo(info);
                this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                break;
            }
            if (name == XSD_CHOICE) {
                this.particleInfo = new ChoiceInfo(info);
                this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                break;
            }
            if (name == XSD_ALL) {
                this.particleInfo = new AllInfo(info);
                this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                break;
            }
            if (name != XSD_GROUP) continue;
            this.particleInfo = new GroupInfo(info);
            this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            break;
        }
        this.initAttributeUse(info, element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
    }

    private void initAttributeUse(Info info, Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Info info2;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == XSD_ATTRIBUTE) {
                info2 = new AttributeInfo(info);
                ((AttributeInfo)info2).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                this.add((AttributeInfo)info2);
                continue;
            }
            if (name == XSD_ATTRIBUTE_GROUP) {
                info2 = new AttributeGroupInfo(info);
                ((AttributeGroupInfo)info2).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                this.add((AttributeGroupInfo)info2);
                continue;
            }
            if (name != XSD_ANY_ATTRIBUTE) continue;
            this.anyAttributeInfo = new AnyAttributeInfo(info);
            this.anyAttributeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            break;
        }
    }

    @Override
    public Type toType(LoadState loadState) {
        ComplexType complexType = this.toComplexType(loadState);
        if (complexType == null || !this.toComplexType2(complexType, loadState)) {
            return null;
        }
        loadState.localComplexTypes.add(this);
        loadState.localComplexTypes.add(complexType);
        return complexType;
    }

    public ComplexType toComplexType(LoadState loadState) {
        if (this.created == null) {
            this.created = this.toComplexType1(loadState);
        }
        return this.created;
    }

    private ComplexType toComplexType1(LoadState loadState) {
        Type type = loadState.getType(this.base, this, "ct-props-correct.1");
        if (type == null) {
            return null;
        }
        int n = 0;
        if ((this.final_ & 2) != 0) {
            n |= 2;
        }
        if ((this.final_ & 1) != 0) {
            n |= 1;
        }
        int n2 = 0;
        if ((this.block & 2) != 0) {
            n2 |= 2;
        }
        if ((this.block & 1) != 0) {
            n2 |= 1;
        }
        ComplexType complexType = new ComplexType(this.name, type, this.isExtension ? 1 : 2, this.abstract_, n, n2);
        if (this.isSimpleContent ? !this.setSimpleContentType(complexType, loadState) : !this.setComplexContentType(complexType, loadState)) {
            return null;
        }
        return complexType;
    }

    private boolean setSimpleContentType(ComplexType complexType, LoadState loadState) {
        Type type = complexType.baseType;
        boolean bl = type instanceof SimpleType;
        if (this.isExtension) {
            if (!bl && type.getDataType() == null) {
                loadState.errors.append(this, "src-ct.2.1", "baseTypeHasNoDataType", type.name.format(false, this));
                return false;
            }
            complexType.setContentType(type.getDataType());
        } else {
            DataType dataType;
            Serializable serializable;
            if (bl) {
                loadState.errors.append(this, "ct-props-correct.2", "cannotBeDerivedByRestriction", type.name.format(false, this));
                return false;
            }
            ComplexType complexType2 = (ComplexType)type;
            DataType dataType2 = null;
            if (complexType2.getDataType() == null) {
                if (complexType2.getContentType() != ComplexType.ContentType.MIXED || (serializable = complexType2.getParticle()) != null && !((Particle)serializable).isEmptiable()) {
                    loadState.errors.append(this, "src-ct.2.1.2", "shouldBeAnEmptiableMixed", type.name.format(false, this));
                    return false;
                }
                dataType2 = this.getBaseDataTypeFromBaseTypeInfo(loadState);
                if (dataType2 == null) {
                    loadState.errors.append(this, "src-ct.2.2", "noSimpleTypeInRestriction", type.name.format(false, this));
                    return false;
                }
            } else {
                dataType2 = this.getBaseDataTypeFromBaseTypeInfo(loadState);
                if (dataType2 == null) {
                    dataType2 = complexType2.getDataType();
                }
            }
            if ((dataType = this.deriveDataType(dataType2, (SimpleType)(serializable = new SimpleType(null, (SimpleType)dataType2.getProperties(), 2, false, 0, 0)), loadState)) == null || dataType instanceof NOTATIONType && !ComplexTypeInfo.checkNotations(dataType, this, "ct-props-correct.1", loadState)) {
                return false;
            }
            ((SimpleType)serializable).setDataType(dataType);
            complexType.setContentType(dataType);
        }
        return true;
    }

    private DataType getBaseDataTypeFromBaseTypeInfo(LoadState loadState) {
        SimpleType simpleType;
        DataType dataType = null;
        if (this.baseTypeInfo != null && (simpleType = (SimpleType)this.baseTypeInfo.toType(loadState)) != null) {
            dataType = simpleType.getDataType();
        }
        return dataType;
    }

    private DataType deriveDataType(DataType dataType, SimpleType simpleType, LoadState loadState) {
        DataType dataType2 = null;
        Restriction restriction = new Restriction(dataType);
        try {
            if (this.facetInfo != null) {
                ComplexTypeInfo.applyFacets(restriction, this.facetInfo);
            }
            dataType2 = restriction.derive(simpleType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            loadState.errors.append(this, "ct-props-correct.1", "cannotDeriveByRestriction", illegalArgumentException.getMessage());
            return null;
        }
        catch (InvalidDataException invalidDataException) {
            loadState.errors.append(this, "ct-props-correct.1", "cannotDeriveByRestriction2", invalidDataException.getMessage(), invalidDataException.getConstraint());
            return null;
        }
        catch (InvalidTypeException invalidTypeException) {
            loadState.errors.append(this, "ct-props-correct.1", "cannotDeriveByRestriction2", invalidTypeException.getMessage(), invalidTypeException.getConstraint());
            return null;
        }
        return dataType2;
    }

    private boolean setComplexContentType(ComplexType complexType, LoadState loadState) {
        Object object;
        Type type = complexType.baseType;
        if (type instanceof SimpleType) {
            loadState.errors.append(this, "src-ct.1", "baseTypeIsSimple", type.name.format(false, this));
            return false;
        }
        Object object2 = null;
        if (this.particleInfo != null) {
            object = new Particle[1];
            if (!this.particleInfo.toParticle((Particle[])object, 0, loadState)) {
                return false;
            }
            object2 = object[0];
            if (object2 != null) {
                object2 = ((Particle)object2).simplify();
            }
        }
        if (this.mixed && object2 == null) {
            object2 = EMPTY_SEQUENCE;
        }
        if (this.isExtension) {
            object = (ComplexType)type;
            ComplexType.ContentType contentType = ((ComplexType)object).getContentType();
            if (object2 == null) {
                switch (contentType) {
                    case EMPTY: {
                        break;
                    }
                    case DATA: {
                        complexType.setContentType(((ComplexType)object).getDataType());
                        break;
                    }
                    default: {
                        complexType.setContentType(((ComplexType)object).getParticle(), contentType == ComplexType.ContentType.MIXED);
                        break;
                    }
                }
            } else {
                switch (contentType) {
                    case EMPTY: 
                    case DATA: {
                        complexType.setContentType((Particle)object2, this.mixed);
                        break;
                    }
                    default: {
                        SequenceParticle sequenceParticle = new SequenceParticle(new Particle[]{((ComplexType)object).getParticle(), object2}, 1, 1);
                        complexType.setContentType(sequenceParticle, this.mixed);
                    }
                }
            }
        } else if (object2 != null) {
            complexType.setContentType((Particle)object2, this.mixed);
        }
        return true;
    }

    public boolean toComplexType2(ComplexType complexType, LoadState loadState) {
        if (this.particleInfo != null) {
            if (!this.checkAllModelGroup(complexType, loadState)) {
                return false;
            }
            IdentityHashMap<Name, ElementDeclaration> identityHashMap = new IdentityHashMap<Name, ElementDeclaration>();
            if (!this.particleInfo.toParticle2(identityHashMap, loadState)) {
                return false;
            }
            ArrayList<Name> arrayList = new ArrayList<Name>();
            for (ElementDeclaration elementDeclaration : identityHashMap.values()) {
                if (elementDeclaration.type == null) {
                    arrayList.add(elementDeclaration.name);
                    continue;
                }
                complexType.addElementDeclaration(elementDeclaration);
            }
            int n = arrayList.size();
            if (n > 0) {
                this.referencedGlobalElementNames = new Name[n];
                arrayList.toArray(this.referencedGlobalElementNames);
            }
        }
        return this.setAttributeUses(complexType, loadState) && this.setAttributeWildcard(complexType, loadState);
    }

    private boolean checkAllModelGroup(ComplexType complexType, LoadState loadState) {
        boolean bl = true;
        Particle particle = complexType.getParticle();
        if (particle != null) {
            boolean bl2 = false;
            switch (particle.getType()) {
                case SEQUENCE: {
                    bl2 = ComplexTypeInfo.containsAnAllParticle(((SequenceParticle)particle).getParticles());
                    break;
                }
                case CHOICE: {
                    bl2 = ComplexTypeInfo.containsAnAllParticle(((ChoiceParticle)particle).getParticles());
                    break;
                }
                case ALL: {
                    if (particle.getMaxOccurs() != 1) {
                        loadState.errors.append(this, "cos-all-limited.1", "allGroupLimited2");
                        bl = false;
                    }
                    Particle[] particleArray = ((AllParticle)particle).getParticles();
                    for (int i = 0; i < particleArray.length; ++i) {
                        if (particleArray[i].getMaxOccurs() == 1) continue;
                        loadState.errors.append(this, "cos-all-limited.2", "allGroupLimited3");
                        bl = false;
                    }
                    bl2 = ComplexTypeInfo.containsAnAllParticle(particleArray);
                }
            }
            if (bl2) {
                loadState.errors.append(this, "cos-all-limited.1", "allGroupLimited1");
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean containsAnAllParticle(Particle[] particleArray) {
        block5: for (int i = 0; i < particleArray.length; ++i) {
            Particle particle = particleArray[i];
            switch (particle.getType()) {
                case SEQUENCE: {
                    if (!ComplexTypeInfo.containsAnAllParticle(((SequenceParticle)particle).getParticles())) continue block5;
                    return true;
                }
                case CHOICE: {
                    if (!ComplexTypeInfo.containsAnAllParticle(((ChoiceParticle)particle).getParticles())) continue block5;
                    return true;
                }
                case ALL: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean setAttributeUses(ComplexType complexType, LoadState loadState) {
        int n;
        if (this.attributeInfo == null && this.attributeGroupInfo == null) {
            return true;
        }
        ArrayList<AttributeUse> arrayList = new ArrayList<AttributeUse>();
        ArrayList<Name> arrayList2 = new ArrayList<Name>();
        if (this.attributeInfo != null) {
            for (n = 0; n < this.attributeInfo.length; ++n) {
                if (this.attributeInfo[n].toAttributeUse(arrayList, arrayList2, complexType, loadState)) continue;
                return false;
            }
        }
        if (this.attributeGroupInfo != null) {
            for (n = 0; n < this.attributeGroupInfo.length; ++n) {
                if (this.attributeGroupInfo[n].toAttributeUse(arrayList, arrayList2, complexType, loadState)) continue;
                return false;
            }
        }
        this.prohibitedAttributeNames = new Name[arrayList2.size()];
        arrayList2.toArray(this.prohibitedAttributeNames);
        AttributeUse[] attributeUseArray = new AttributeUse[arrayList.size()];
        arrayList.toArray(attributeUseArray);
        complexType.setAttributeUses(attributeUseArray);
        return this.checkDuplicateAttributes(complexType, loadState) && this.checkIDAttributes(complexType, loadState);
    }

    private boolean checkDuplicateAttributes(ComplexType complexType, LoadState loadState) {
        AttributeUse[] attributeUseArray = complexType.getAttributeUses();
        for (int i = 0; i < attributeUseArray.length; ++i) {
            AttributeUse attributeUse = attributeUseArray[i];
            Name name = attributeUse.name;
            boolean bl = false;
            for (int j = i + 1; j < attributeUseArray.length; ++j) {
                if (name != attributeUseArray[j].name) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            loadState.errors.append(this, "ct-props-correct.4", "duplicateAttributeUse", name.format(false, this));
            return false;
        }
        return true;
    }

    private boolean checkIDAttributes(ComplexType complexType, LoadState loadState) {
        AttributeUse[] attributeUseArray = complexType.getAttributeUses();
        Name name = null;
        for (int i = 0; i < attributeUseArray.length; ++i) {
            AttributeUse attributeUse = attributeUseArray[i];
            Name name2 = attributeUse.name;
            AttributeDeclaration attributeDeclaration = complexType.getAttributeDeclaration(name2);
            if (attributeDeclaration == null) {
                attributeDeclaration = loadState.schema.getAttributeDeclaration(name2);
            }
            if (!(attributeDeclaration.dataType instanceof IDType)) continue;
            if (name == null) {
                name = name2;
                continue;
            }
            loadState.errors.append(this, "ct-props-correct.5", "severalIDAttributes", name2.format(false, this), name.format(false, this));
            return false;
        }
        return true;
    }

    private boolean setAttributeWildcard(ComplexType complexType, LoadState loadState) {
        if (this.anyAttributeInfo == null && this.attributeGroupInfo == null) {
            return true;
        }
        ArrayList<Wildcard> arrayList = new ArrayList<Wildcard>();
        if (this.anyAttributeInfo != null) {
            arrayList.add(this.anyAttributeInfo.wildcard);
        }
        if (this.attributeGroupInfo != null) {
            for (int i = 0; i < this.attributeGroupInfo.length; ++i) {
                if (this.attributeGroupInfo[i].toAttributeWildcard(arrayList, loadState)) continue;
                return false;
            }
        }
        Wildcard wildcard = null;
        int n = arrayList.size();
        if (n > 0) {
            NameWildcard nameWildcard = null;
            Wildcard.ProcessContents processContents = Wildcard.ProcessContents.UNSPECIFIED;
            for (int i = 0; i < n; ++i) {
                Wildcard wildcard2 = arrayList.get(i);
                if (nameWildcard == null) {
                    nameWildcard = wildcard2.nameWildcard;
                    processContents = wildcard2.processContents;
                    continue;
                }
                if ((nameWildcard = wildcard2.nameWildcard.intersection(nameWildcard)) == null) break;
            }
            if (nameWildcard == null) {
                loadState.errors.append(this, "src-ct.4", "badAttributeWilcardIntersection");
                return false;
            }
            wildcard = new Wildcard(nameWildcard, processContents);
        }
        if (wildcard != null) {
            complexType.setAttributeWildcard(wildcard);
        }
        return true;
    }

    public boolean toComplexType3(ComplexType complexType, LoadState loadState) {
        Object object;
        if (this.finished != -1) {
            return this.finished == 1;
        }
        Type type = complexType.baseType;
        if (type == ComplexType.ANY) {
            this.finished = 1;
            return true;
        }
        if (type instanceof ComplexType && ((object = (ComplexTypeInfo)loadState.getTypeInfo(this.base, this, "ct-props-correct.1")) == null || !((ComplexTypeInfo)object).toComplexType3((ComplexType)type, loadState))) {
            this.finished = 0;
            return false;
        }
        if ((type.prohibitedDerivations & complexType.derivationMethod) != 0) {
            if (this.isExtension) {
                loadState.errors.append(this, "cos-ct-extends", "prohibitedExtension");
            } else {
                loadState.errors.append(this, "derivation-ok-restriction", "prohibitedRestriction");
            }
            this.finished = 0;
            return false;
        }
        if (type instanceof ComplexType) {
            object = (ComplexType)type;
            if (this.isExtension && !this.checkExtension(complexType, (ComplexType)object, loadState) || !this.isExtension && !this.checkRestriction(complexType, (ComplexType)object, loadState)) {
                this.finished = 0;
                return false;
            }
        }
        this.finished = 1;
        return true;
    }

    private boolean checkExtension(ComplexType complexType, ComplexType complexType2, LoadState loadState) {
        Wildcard wildcard;
        Serializable serializable;
        AttributeUse[] attributeUseArray;
        Object object;
        Comparable<Name>[] comparableArray;
        ComplexType.ContentType contentType = complexType2.getContentType();
        if (complexType.getParticle() != null && contentType != ComplexType.ContentType.EMPTY && (complexType2.getParticle() == null || contentType != complexType.getContentType())) {
            loadState.errors.append(this, "cos-ct-extends.1.4.2", "invalidExtension");
            return false;
        }
        switch (contentType) {
            case EMPTY: 
            case DATA: {
                break;
            }
            default: {
                comparableArray = complexType2.getElementFields();
                for (int i = 0; i < comparableArray.length; ++i) {
                    object = comparableArray[i];
                    attributeUseArray = complexType2.getElementDeclaration((Name)object);
                    serializable = complexType.getElementDeclaration((Name)object);
                    Object object2 = attributeUseArray == null ? new ElementDeclaration((Name)object, null, null, false, false, 0, false) : attributeUseArray;
                    Serializable serializable2 = serializable == null ? (ComplexTypeInfo.containsName(this.referencedGlobalElementNames, (Name)object) ? new ElementDeclaration((Name)object, null, null, false, false, 0, false) : object2) : serializable;
                    if (!ElementInfo.checkConsistent(this, serializable2, object2, loadState)) {
                        return false;
                    }
                    if (serializable != null || attributeUseArray == null) continue;
                    complexType.addElementDeclaration((ElementDeclaration)attributeUseArray);
                }
            }
        }
        comparableArray = complexType2.getAttributeUses();
        if (comparableArray.length > 0) {
            Iterator<AttributeDeclaration> iterator = complexType2.getAttributeDeclarations();
            while (iterator.hasNext()) {
                object = iterator.next();
                complexType.addAttributeDeclaration((AttributeDeclaration)object);
            }
            object = complexType.getAttributeUses();
            if (((AttributeUse[])object).length == 0) {
                complexType.setAttributeUses((AttributeUse[])comparableArray);
            } else {
                attributeUseArray = new AttributeUse[comparableArray.length + ((AttributeUse[])object).length];
                System.arraycopy(comparableArray, 0, attributeUseArray, 0, comparableArray.length);
                System.arraycopy(object, 0, attributeUseArray, comparableArray.length, ((AttributeUse[])object).length);
                complexType.setAttributeUses(attributeUseArray);
                if (!this.checkDuplicateAttributes(complexType, loadState) || !this.checkIDAttributes(complexType, loadState)) {
                    return false;
                }
            }
        }
        if ((wildcard = complexType2.getAttributeWildcard()) != null) {
            object = complexType.getAttributeWildcard();
            if (object == null) {
                complexType.setAttributeWildcard(wildcard);
            } else {
                attributeUseArray = object.processContents;
                serializable = object.nameWildcard.union(wildcard.nameWildcard);
                if (serializable == null) {
                    loadState.errors.append(this, "src-ct.4", "badAttributeWilcardUnion");
                    return false;
                }
                complexType.setAttributeWildcard(new Wildcard((NameWildcard)serializable, (Wildcard.ProcessContents)attributeUseArray));
            }
        }
        return true;
    }

    private boolean checkRestriction(ComplexType complexType, ComplexType complexType2, LoadState loadState) {
        return this.checkRestrictionAttributes(complexType, complexType2, loadState) && this.checkRestrictionContent(complexType, complexType2, loadState);
    }

    private boolean checkRestrictionAttributes(ComplexType complexType, ComplexType complexType2, LoadState loadState) {
        int n;
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Object object;
        AttributeUse[] attributeUseArray = complexType2.getAttributeUses();
        Wildcard wildcard = complexType2.getAttributeWildcard();
        NameWildcard nameWildcard = wildcard == null ? null : wildcard.nameWildcard;
        AttributeUse[] attributeUseArray2 = complexType.getAttributeUses();
        for (int i = 0; i < attributeUseArray2.length; ++i) {
            AttributeUse attributeUse = attributeUseArray2[i];
            object = attributeUse.name;
            serializable3 = ComplexTypeInfo.findAttributeUse(attributeUseArray, (Name)object);
            if (serializable3 != null) {
                SimpleType simpleType;
                if (((AttributeUse)serializable3).isRequired && !attributeUse.isRequired) {
                    loadState.errors.append(this, "derivation-ok-restriction.2.1.1", "invalidRestriction1", object.format(false, this));
                    return false;
                }
                serializable2 = complexType2.getAttributeDeclaration((Name)object);
                if (serializable2 == null) {
                    serializable2 = loadState.schema.getAttributeDeclaration((Name)object);
                }
                serializable = (SimpleType)((AttributeDeclaration)serializable2).dataType.getProperties();
                AttributeDeclaration attributeDeclaration = complexType.getAttributeDeclaration((Name)object);
                if (attributeDeclaration == null) {
                    attributeDeclaration = loadState.schema.getAttributeDeclaration((Name)object);
                }
                if (!(simpleType = (SimpleType)attributeDeclaration.dataType.getProperties()).isValidDerivation((Type)serializable, 0)) {
                    loadState.errors.append(this, "derivation-ok-restriction.2.1.2", "invalidRestriction2", object.format(false, this));
                    return false;
                }
                if (!((AttributeDeclaration)serializable2).isFixedValue || attributeDeclaration.defaultValue != null && attributeDeclaration.isFixedValue && ((AttributeDeclaration)serializable2).defaultValue.equals(attributeDeclaration.defaultValue)) continue;
                loadState.errors.append(this, "derivation-ok-restriction.2.1.3", "invalidRestriction3", object.format(false, this), ((AttributeDeclaration)serializable2).defaultValue);
                return false;
            }
            if (nameWildcard != null && nameWildcard.match((Name)object)) continue;
            loadState.errors.append(this, "derivation-ok-restriction.2.2", "invalidRestriction4", object.format(false, this));
            return false;
        }
        ArrayList<AttributeUse[]> arrayList = new ArrayList<AttributeUse[]>();
        for (n = 0; n < attributeUseArray.length; ++n) {
            object = attributeUseArray[n];
            serializable3 = object.name;
            if (ComplexTypeInfo.containsName(this.prohibitedAttributeNames, (Name)serializable3) || ComplexTypeInfo.findAttributeUse(attributeUseArray2, (Name)serializable3) != null) continue;
            serializable2 = complexType2.getAttributeDeclaration((Name)serializable3);
            if (serializable2 != null) {
                complexType.addAttributeDeclaration((AttributeDeclaration)serializable2);
            }
            arrayList.add((AttributeUse[])object);
        }
        n = arrayList.size();
        if (n > 0) {
            object = new AttributeUse[n + attributeUseArray2.length];
            arrayList.toArray((T[])object);
            System.arraycopy(attributeUseArray2, 0, object, n, attributeUseArray2.length);
            complexType.setAttributeUses((AttributeUse[])object);
            if (!this.checkIDAttributes(complexType, loadState)) {
                return false;
            }
            attributeUseArray2 = object;
        }
        for (int i = 0; i < attributeUseArray.length; ++i) {
            serializable3 = attributeUseArray[i];
            if (!((AttributeUse)serializable3).isRequired || (serializable = ComplexTypeInfo.findAttributeUse(attributeUseArray2, (Name)(serializable2 = ((AttributeUse)serializable3).name))) != null && ((AttributeUse)serializable).isRequired) continue;
            loadState.errors.append(this, "derivation-ok-restriction.3", "invalidRestriction5", ((Name)serializable2).format(false, this));
            return false;
        }
        Wildcard wildcard2 = complexType.getAttributeWildcard();
        Serializable serializable4 = serializable3 = wildcard2 == null ? null : wildcard2.nameWildcard;
        if (!(serializable3 == null || nameWildcard != null && ((NameWildcard)serializable3).isSubsetOf(nameWildcard))) {
            loadState.errors.append(this, "derivation-ok-restriction.4", "invalidRestriction6");
            return false;
        }
        return true;
    }

    private static AttributeUse findAttributeUse(AttributeUse[] attributeUseArray, Name name) {
        for (int i = 0; i < attributeUseArray.length; ++i) {
            if (attributeUseArray[i].name != name) continue;
            return attributeUseArray[i];
        }
        return null;
    }

    private static boolean containsName(Name[] nameArray, Name name) {
        for (int i = 0; i < nameArray.length; ++i) {
            if (nameArray[i] != name) continue;
            return true;
        }
        return false;
    }

    private boolean checkRestrictionContent(ComplexType complexType, ComplexType complexType2, LoadState loadState) {
        ComplexType.ContentType contentType = complexType2.getContentType();
        ComplexType.ContentType contentType2 = complexType.getContentType();
        switch (contentType2) {
            case DATA: {
                String string = "";
                switch (contentType) {
                    case DATA: {
                        SimpleType simpleType = (SimpleType)complexType2.getDataType().getProperties();
                        SimpleType simpleType2 = (SimpleType)complexType.getDataType().getProperties();
                        string = ComplexTypeInfo.validateSimpleTypeRestriction(simpleType2, simpleType);
                        break;
                    }
                    case MIXED: {
                        string = complexType2.getParticle().isEmptiable() ? null : Msg.msg("baseTypeParticleNotEmptiable");
                    }
                }
                if (string == null) break;
                if (string.length() == 0) {
                    loadState.errors.append(this, "derivation-ok-restriction.5.1", "invalidRestriction7");
                } else {
                    loadState.errors.append(this, "derivation-ok-restriction.5.1", "invalidRestriction", string);
                }
                return false;
            }
            case EMPTY: {
                String string = "";
                switch (contentType) {
                    case EMPTY: {
                        string = null;
                        break;
                    }
                    case MIXED: 
                    case ELEMENT_ONLY: {
                        string = complexType2.getParticle().isEmptiable() ? null : Msg.msg("baseTypeParticleNotEmptiable");
                    }
                }
                if (string == null) break;
                if (string.length() == 0) {
                    loadState.errors.append(this, "derivation-ok-restriction.5.2", "invalidRestriction8");
                } else {
                    loadState.errors.append(this, "derivation-ok-restriction.5.2", "invalidRestriction", string);
                }
                return false;
            }
            default: {
                Object object = "";
                if (contentType == ComplexType.ContentType.MIXED || contentType2 == ComplexType.ContentType.ELEMENT_ONLY) {
                    String string;
                    Particle particle = complexType.getParticle();
                    Particle particle2 = complexType2.getParticle();
                    object = particle2 == null ? Msg.msg("baseTypeHasNoParticle") : ((string = ComplexTypeInfo.checkParticleRestriction(particle, particle2, complexType, complexType2, loadState.schema)) == null ? null : (string.length() == 0 ? Msg.msg("forbiddenParticleRestriction", new Object[]{particle.getType(), particle2.getType()}) : Msg.msg("invalidParticleRestriction", new Object[]{particle.getType(), particle2.getType(), string})));
                }
                if (object == null) break;
                if (((String)object).length() == 0) {
                    loadState.errors.append(this, "derivation-ok-restriction.5.3", "invalidRestriction9");
                } else {
                    loadState.errors.append(this, "derivation-ok-restriction.5.3", "invalidRestriction", object);
                }
                return false;
            }
        }
        return true;
    }

    private static String validateSimpleTypeRestriction(SimpleType simpleType, SimpleType simpleType2) {
        if (simpleType2 == SimpleType.ANY) {
            return null;
        }
        if ((simpleType2.prohibitedDerivations & 2) != 0) {
            return Msg.msg("prohibitedRestriction");
        }
        DataType dataType = simpleType.getDataType();
        DataType dataType2 = simpleType2.getDataType();
        if (dataType instanceof ListType) {
            if (!(dataType2 instanceof ListType)) {
                return Msg.msg("wrongVariety", "list");
            }
            String string = ComplexTypeInfo.findMissingFacet(dataType2, dataType);
            if (string != null) {
                return Msg.msg("missingFacet", string);
            }
        } else if (dataType instanceof UnionType) {
            if (!(dataType2 instanceof UnionType)) {
                return Msg.msg("wrongVariety", "union");
            }
            String string = ComplexTypeInfo.findMissingFacet(dataType2, dataType);
            if (string != null) {
                return Msg.msg("missingFacet", string);
            }
        } else {
            if (dataType2 instanceof ListType || dataType2 instanceof UnionType) {
                return Msg.msg("wrongVariety", "atomic");
            }
            String string = ComplexTypeInfo.findMissingFacet(dataType2, dataType);
            if (string != null) {
                return Msg.msg("missingFacet", string);
            }
        }
        return null;
    }

    private static String findMissingFacet(DataType dataType, DataType dataType2) {
        int[] nArray = DataType.facetMasks;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (!dataType.hasFacet(n) || dataType2.hasFacet(n)) continue;
            return DataType.getFacetName(n);
        }
        return null;
    }

    private static String checkParticleRestriction(Particle particle, Particle particle2, ComplexType complexType, ComplexType complexType2, Schema schema) {
        String string = ComplexTypeInfo.doCheckParticleRestriction(particle, false, particle2, complexType, complexType2, schema);
        if (string != null) {
            Particle particle3;
            SequenceParticle sequenceParticle = new SequenceParticle(new Particle[]{particle}, 1, 1);
            if (ComplexTypeInfo.doCheckParticleRestriction(sequenceParticle, true, particle2, complexType, complexType2, schema) == null) {
                return null;
            }
            switch (particle.getType()) {
                case ELEMENT: {
                    particle3 = new ElementParticle(((ElementParticle)particle).elementName, 1, 1);
                    break;
                }
                case WILDCARD: {
                    particle3 = new WildcardParticle(((WildcardParticle)particle).wildcard, 1, 1);
                    break;
                }
                case ALL: {
                    particle3 = new AllParticle(((AllParticle)particle).getParticles(), 1, 1);
                    break;
                }
                case CHOICE: {
                    particle3 = new ChoiceParticle(((ChoiceParticle)particle).getParticles(), 1, 1);
                    break;
                }
                case SEQUENCE: {
                    particle3 = new SequenceParticle(((SequenceParticle)particle).getParticles(), 1, 1);
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
            sequenceParticle = new SequenceParticle(new Particle[]{particle3}, particle.getMinOccurs(), particle.getMaxOccurs());
            if (ComplexTypeInfo.doCheckParticleRestriction(sequenceParticle, true, particle2, complexType, complexType2, schema) == null) {
                return null;
            }
        }
        return string;
    }

    private static String doCheckParticleRestriction(Particle particle, boolean bl, Particle particle2, ComplexType complexType, ComplexType complexType2, Schema schema) {
        String string = null;
        block0 : switch (particle.getType()) {
            case ELEMENT: {
                switch (particle2.getType()) {
                    case ELEMENT: {
                        string = ComplexTypeInfo.nameAndTypeOK((ElementParticle)particle, (ElementParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case WILDCARD: {
                        string = ComplexTypeInfo.nsCompat((ElementParticle)particle, (WildcardParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case SEQUENCE: 
                    case CHOICE: 
                    case ALL: {
                        string = ComplexTypeInfo.recurseAsIfGroup((ElementParticle)particle, particle2, complexType, complexType2, schema);
                        break block0;
                    }
                }
                throw new RuntimeException("internal error");
            }
            case WILDCARD: {
                switch (particle2.getType()) {
                    case WILDCARD: {
                        string = ComplexTypeInfo.nsSubset((WildcardParticle)particle, (WildcardParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case SEQUENCE: 
                    case CHOICE: 
                    case ALL: 
                    case ELEMENT: {
                        string = "";
                        break block0;
                    }
                }
                throw new RuntimeException("internal error");
            }
            case ALL: {
                switch (particle2.getType()) {
                    case WILDCARD: {
                        string = ComplexTypeInfo.nsRecurseCheckCardinality(particle, bl, (WildcardParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case ALL: {
                        string = ComplexTypeInfo.recurse(particle, bl, particle2, false, complexType, complexType2, schema);
                        break block0;
                    }
                    case SEQUENCE: 
                    case CHOICE: 
                    case ELEMENT: {
                        string = "";
                        break block0;
                    }
                }
                throw new RuntimeException("internal error");
            }
            case CHOICE: {
                switch (particle2.getType()) {
                    case WILDCARD: {
                        string = ComplexTypeInfo.nsRecurseCheckCardinality(particle, bl, (WildcardParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case CHOICE: {
                        string = ComplexTypeInfo.recurse(particle, bl, particle2, true, complexType, complexType2, schema);
                        break block0;
                    }
                    case SEQUENCE: 
                    case ALL: 
                    case ELEMENT: {
                        string = "";
                        break block0;
                    }
                }
                throw new RuntimeException("internal error");
            }
            case SEQUENCE: {
                switch (particle2.getType()) {
                    case ELEMENT: {
                        string = "";
                        break block0;
                    }
                    case WILDCARD: {
                        string = ComplexTypeInfo.nsRecurseCheckCardinality(particle, bl, (WildcardParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case ALL: {
                        string = ComplexTypeInfo.recurseUnordered((SequenceParticle)particle, bl, (AllParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case CHOICE: {
                        string = ComplexTypeInfo.mapAndSum((SequenceParticle)particle, bl, (ChoiceParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case SEQUENCE: {
                        string = ComplexTypeInfo.recurse(particle, bl, particle2, false, complexType, complexType2, schema);
                        break block0;
                    }
                }
                throw new RuntimeException("internal error");
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        return string;
    }

    private static String nameAndTypeOK(ElementParticle elementParticle, ElementParticle elementParticle2, ComplexType complexType, ComplexType complexType2, Schema schema) {
        Object object;
        ElementDeclaration elementDeclaration;
        Name name = elementParticle.elementName;
        if (name != elementParticle2.elementName) {
            return "rcase-NameAndTypeOK.1";
        }
        ElementDeclaration elementDeclaration2 = complexType.getElementDeclaration(name);
        if (elementDeclaration2 == null) {
            elementDeclaration2 = schema.getElementDeclaration(name);
        }
        if ((elementDeclaration = complexType2.getElementDeclaration(name)) == null) {
            elementDeclaration = schema.getElementDeclaration(name);
        }
        if (!elementDeclaration.isNillable && elementDeclaration2.isNillable) {
            return "rcase-NameAndTypeOK.2";
        }
        if (!ComplexTypeInfo.occurenceRangeOK(elementParticle, elementParticle2)) {
            return "rcase-NameAndTypeOK.3";
        }
        if (elementDeclaration.isFixedValue && !elementDeclaration2.isFixedValue) {
            return "rcase-NameAndTypeOK.4";
        }
        Object object2 = elementDeclaration.defaultValue;
        if (!(object2 == null || (object = elementDeclaration2.defaultValue) != null && object2.equals(object))) {
            return "rcase-NameAndTypeOK.4";
        }
        int n = elementDeclaration2.disallowedSubstitutions;
        if ((n | elementDeclaration.disallowedSubstitutions) != n) {
            return "rcase-NameAndTypeOK.6";
        }
        if (!elementDeclaration2.type.isValidDerivation(elementDeclaration.type, 13)) {
            return "rcase-NameAndTypeOK.7";
        }
        return null;
    }

    private static boolean occurenceRangeOK(Particle particle, Particle particle2) {
        return ComplexTypeInfo.occurenceRangeOK(particle.getMinOccurs(), particle.getMaxOccurs(), particle2.getMinOccurs(), particle2.getMaxOccurs());
    }

    private static boolean occurenceRangeOK(int n, int n2, int n3, int n4) {
        if (n < n3) {
            return false;
        }
        if (n4 == -1) {
            return true;
        }
        return n2 != -1 && n2 <= n4;
    }

    private static String nsCompat(ElementParticle elementParticle, WildcardParticle wildcardParticle, ComplexType complexType, ComplexType complexType2, Schema schema) {
        if (!wildcardParticle.wildcard.nameWildcard.match(elementParticle.elementName)) {
            return "rcase-NSCompat.1";
        }
        if (!ComplexTypeInfo.occurenceRangeOK(elementParticle, wildcardParticle)) {
            return "rcase-NSCompat.2";
        }
        return null;
    }

    private static String recurseAsIfGroup(ElementParticle elementParticle, Particle particle, ComplexType complexType, ComplexType complexType2, Schema schema) {
        Particle particle2;
        switch (particle.getType()) {
            case SEQUENCE: {
                particle2 = new SequenceParticle(new Particle[]{elementParticle}, 1, 1);
                break;
            }
            case ALL: {
                particle2 = new AllParticle(new Particle[]{elementParticle}, 1, 1);
                break;
            }
            case CHOICE: {
                particle2 = new ChoiceParticle(new Particle[]{elementParticle}, 1, 1);
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        return ComplexTypeInfo.checkParticleRestriction(particle2, particle, complexType, complexType2, schema);
    }

    private static String nsSubset(WildcardParticle wildcardParticle, WildcardParticle wildcardParticle2, ComplexType complexType, ComplexType complexType2, Schema schema) {
        if (!ComplexTypeInfo.occurenceRangeOK(wildcardParticle, wildcardParticle2)) {
            return "rcase-NSSubset.1";
        }
        if (!wildcardParticle.wildcard.nameWildcard.isSubsetOf(wildcardParticle2.wildcard.nameWildcard)) {
            return "rcase-NSSubset.2";
        }
        return null;
    }

    private static String nsRecurseCheckCardinality(Particle particle, boolean bl, WildcardParticle wildcardParticle, ComplexType complexType, ComplexType complexType2, Schema schema) {
        int n;
        int n2;
        Particle[] particleArray;
        switch (particle.getType()) {
            case SEQUENCE: {
                particleArray = ((SequenceParticle)particle).getParticles();
                break;
            }
            case ALL: {
                particleArray = ((AllParticle)particle).getParticles();
                break;
            }
            case CHOICE: {
                particleArray = ((ChoiceParticle)particle).getParticles();
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        for (n2 = 0; n2 < particleArray.length; ++n2) {
            String string = bl ? ComplexTypeInfo.doCheckParticleRestriction(particleArray[n2], false, wildcardParticle, complexType, complexType2, schema) : ComplexTypeInfo.checkParticleRestriction(particleArray[n2], wildcardParticle, complexType, complexType2, schema);
            if (string == null) continue;
            return "rcase-NSRecurseCheckCardinality.1";
        }
        n2 = particle.rangeMin();
        if (!ComplexTypeInfo.occurenceRangeOK(n2, n = particle.rangeMax(), wildcardParticle.getMinOccurs(), wildcardParticle.getMaxOccurs())) {
            return "rcase-NSRecurseCheckCardinality.2";
        }
        return null;
    }

    private static String recurse(Particle particle, boolean bl, Particle particle2, boolean bl2, ComplexType complexType, ComplexType complexType2, Schema schema) {
        Particle[] particleArray;
        Particle[] particleArray2;
        if (!ComplexTypeInfo.occurenceRangeOK(particle, particle2)) {
            return "rcase-Recurse.1";
        }
        switch (particle.getType()) {
            case SEQUENCE: {
                particleArray2 = ((SequenceParticle)particle).getParticles();
                particleArray = ((SequenceParticle)particle2).getParticles();
                break;
            }
            case ALL: {
                particleArray2 = ((AllParticle)particle).getParticles();
                particleArray = ((AllParticle)particle2).getParticles();
                break;
            }
            case CHOICE: {
                particleArray2 = ((ChoiceParticle)particle).getParticles();
                particleArray = ((ChoiceParticle)particle2).getParticles();
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        int n = 0;
        for (int i = 0; i < particleArray2.length; ++i) {
            Particle particle3 = particleArray2[i];
            boolean bl3 = false;
            while (n < particleArray.length) {
                Particle particle4 = particleArray[n];
                String string = bl ? ComplexTypeInfo.doCheckParticleRestriction(particle3, false, particle4, complexType, complexType2, schema) : ComplexTypeInfo.checkParticleRestriction(particle3, particle4, complexType, complexType2, schema);
                if (string == null) {
                    bl3 = true;
                    ++n;
                    break;
                }
                if (!bl2 && !particle4.isEmptiable()) {
                    return "rcase-Recurse.2.2";
                }
                ++n;
            }
            if (bl3) continue;
            return "rcase-Recurse.2.1";
        }
        if (!bl2) {
            while (n < particleArray.length) {
                if (!particleArray[n].isEmptiable()) {
                    return "rcase-Recurse.2.2";
                }
                ++n;
            }
        }
        return null;
    }

    private static String recurseUnordered(SequenceParticle sequenceParticle, boolean bl, AllParticle allParticle, ComplexType complexType, ComplexType complexType2, Schema schema) {
        int n;
        if (!ComplexTypeInfo.occurenceRangeOK(sequenceParticle, allParticle)) {
            return "rcase-RecurseUnordered.1";
        }
        Particle[] particleArray = sequenceParticle.getParticles();
        Particle[] particleArray2 = allParticle.getParticles();
        ArrayList<Particle> arrayList = new ArrayList<Particle>();
        for (n = 0; n < particleArray2.length; ++n) {
            arrayList.add(particleArray2[n]);
        }
        for (n = 0; n < particleArray.length; ++n) {
            Particle particle = particleArray[n];
            boolean bl2 = false;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Particle particle2 = (Particle)arrayList.get(i);
                String string = bl ? ComplexTypeInfo.doCheckParticleRestriction(particle, false, particle2, complexType, complexType2, schema) : ComplexTypeInfo.checkParticleRestriction(particle, particle2, complexType, complexType2, schema);
                if (string != null) continue;
                bl2 = true;
                arrayList.remove(i);
                break;
            }
            if (bl2) continue;
            return "rcase-RecurseUnordered.2.2";
        }
        n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Particle particle = (Particle)arrayList.get(i);
            if (particle.isEmptiable()) continue;
            return "rcase-RecurseUnordered.2.3";
        }
        return null;
    }

    private static String mapAndSum(SequenceParticle sequenceParticle, boolean bl, ChoiceParticle choiceParticle, ComplexType complexType, ComplexType complexType2, Schema schema) {
        int n;
        Particle[] particleArray = sequenceParticle.getParticles();
        Particle[] particleArray2 = choiceParticle.getParticles();
        for (n = 0; n < particleArray.length; ++n) {
            Particle particle = particleArray[n];
            boolean bl2 = false;
            for (int i = 0; i < particleArray2.length; ++i) {
                Particle particle2 = particleArray2[i];
                String string = bl ? ComplexTypeInfo.doCheckParticleRestriction(particle, false, particle2, complexType, complexType2, schema) : ComplexTypeInfo.checkParticleRestriction(particle, particle2, complexType, complexType2, schema);
                if (string != null) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return "rcase-MapAndSum.1";
        }
        n = sequenceParticle.getMinOccurs() * particleArray.length;
        int n2 = sequenceParticle.getMaxOccurs();
        if (n2 != -1) {
            n2 *= particleArray.length;
        }
        if (!ComplexTypeInfo.occurenceRangeOK(n, n2, choiceParticle.getMinOccurs(), choiceParticle.getMaxOccurs())) {
            return "rcase-MapAndSum.2";
        }
        return null;
    }
}

