/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.validate.UnparsedEntities;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.Value;
import java.util.ArrayList;

public class UnionType
extends DataType {
    protected final DataType[] memberTypes;

    public UnionType(DataType[] dataTypeArray) {
        ArrayList<DataType> arrayList = new ArrayList<DataType>();
        this.expandMemberTypes(dataTypeArray, arrayList);
        dataTypeArray = new DataType[arrayList.size()];
        arrayList.toArray(dataTypeArray);
        this.memberTypes = dataTypeArray;
    }

    private void expandMemberTypes(DataType[] dataTypeArray, ArrayList<DataType> arrayList) {
        for (int i = 0; i < dataTypeArray.length; ++i) {
            DataType dataType = dataTypeArray[i];
            if (dataType instanceof UnionType) {
                this.expandMemberTypes(((UnionType)dataType).memberTypes, arrayList);
                continue;
            }
            if (arrayList.contains(dataType)) continue;
            arrayList.add(dataType);
        }
    }

    public DataType[] getMemberTypes() {
        return this.memberTypes;
    }

    @Override
    public int getSupportedFacets() {
        return 24;
    }

    @Override
    protected int rootTypeHashCode() {
        int n = this.memberTypes[0].hashCode();
        for (int i = 1; i < this.memberTypes.length; ++i) {
            n ^= this.memberTypes[i].hashCode();
        }
        return n;
    }

    @Override
    protected boolean sameRootType(DataType dataType) {
        if (!(dataType instanceof UnionType)) {
            return false;
        }
        UnionType unionType = (UnionType)dataType;
        int n = this.memberTypes.length;
        if (n != unionType.memberTypes.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.memberTypes[i].equals(unionType.memberTypes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Value doParse(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities) throws InvalidDataException {
        for (int i = 0; i < this.memberTypes.length; ++i) {
            Value value;
            DataType dataType = this.memberTypes[i];
            try {
                value = dataType.valueOf(string, prefixToNamespace, unparsedEntities);
            }
            catch (InvalidDataException invalidDataException) {
                value = null;
            }
            if (value == null) continue;
            return value;
        }
        throw new InvalidDataException("cvc-datatype-valid.1.2.3", Msg.msg("unionMemberSyntax", string));
    }

    @Override
    public boolean isContextDependentDataType() {
        for (int i = 0; i < this.memberTypes.length; ++i) {
            if (!this.memberTypes[i].isContextDependentDataType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDataTypeLabel(NamespaceToPrefixes namespaceToPrefixes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Msg.msg("union"));
        for (int i = 0; i < this.memberTypes.length; ++i) {
            DataType dataType = this.memberTypes[i];
            if (i > 0) {
                stringBuilder.append(", ");
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(dataType.getDataTypeLabel(namespaceToPrefixes));
            UnionType.appendEnumeration(dataType, namespaceToPrefixes, stringBuilder);
        }
        return stringBuilder.toString();
    }

    static final void appendEnumeration(DataType dataType, NamespaceToPrefixes namespaceToPrefixes, StringBuilder stringBuilder) {
        if (dataType.hasFacet(16) && !dataType.getRootType().hasFacet(16)) {
            Value[] valueArray = dataType.getEnumeration();
            stringBuilder.append('{');
            for (int i = 0; i < valueArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("\"");
                stringBuilder.append(valueArray[i].toString(namespaceToPrefixes));
                stringBuilder.append("\"");
            }
            stringBuilder.append('}');
        }
    }
}

