/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.NumericValue;
import com.xmlmind.xml.wxs.datatype.Value;
import java.math.BigDecimal;

public class LongValue
extends NumericValue {
    private final long number;

    public static LongValue parseLong(String string) throws InvalidDataException {
        long l;
        if (string.length() > 0 && string.charAt(0) == '+') {
            string = string.substring(1);
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("longSyntax", string));
        }
        return new LongValue(l);
    }

    public LongValue(long l) {
        this.number = l;
    }

    public long getLong() {
        return this.number;
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(Long.toString(this.number));
    }

    @Override
    public String toString() {
        return Long.toString(this.number);
    }

    @Override
    public int hashCode() {
        return (int)this.number;
    }

    @Override
    public int compareTo(Value value) {
        if (value == null || !(value instanceof NumericValue)) {
            return -2;
        }
        if (value instanceof LongValue) {
            long l = ((LongValue)value).number;
            return this.number < l ? -1 : (this.number > l ? 1 : 0);
        }
        return this.toBigDecimal().compareTo(((NumericValue)value).toBigDecimal());
    }

    @Override
    public int totalDigits() {
        return Long.toString(this.number).length();
    }

    @Override
    public int fractionDigits() {
        return 0;
    }
}

