/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataFormatException;
import com.xmlmind.xml.validate.UncheckedUnparsedEntities;
import com.xmlmind.xml.validate.UnparsedEntities;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.InvalidTypeException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.Pattern;
import com.xmlmind.xml.wxs.datatype.Value;
import java.io.Serializable;

public abstract class DataType
implements com.xmlmind.xml.validate.DataType,
Cloneable,
Serializable {
    public static final int LENGTH = 1;
    public static final int MIN_LENGTH = 2;
    public static final int MAX_LENGTH = 4;
    public static final int PATTERN = 8;
    public static final int ENUMERATION = 16;
    public static final int WHITE_SPACE = 32;
    public static final int MAX_INCLUSIVE = 64;
    public static final int MAX_EXCLUSIVE = 128;
    public static final int MIN_EXCLUSIVE = 256;
    public static final int MIN_INCLUSIVE = 512;
    public static final int TOTAL_DIGITS = 1024;
    public static final int FRACTION_DIGITS = 2048;
    public static final int[] facetMasks = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048};
    public static final String[] facetNames = new String[]{"length", "minLength", "maxLength", "pattern", "enumeration", "whiteSpace", "maxInclusive", "maxExclusive", "minExclusive", "minInclusive", "totalDigits", "fractionDigits"};
    protected DataType baseType;
    protected int facets;
    protected int fixedFacets;
    protected int length;
    protected int minLength;
    protected int maxLength;
    protected Pattern[] pattern;
    protected Value[] enumeration;
    protected WhiteSpace whiteSpace;
    protected Value maxInclusive;
    protected Value maxExclusive;
    protected Value minExclusive;
    protected Value minInclusive;
    protected int totalDigits;
    protected int fractionDigits;
    protected Object properties;

    public static String getFacetName(int n) {
        int n2 = 0;
        while ((n & 1) == 0) {
            n >>>= 1;
            ++n2;
        }
        return n2 >= 0 && n2 < facetNames.length ? facetNames[n2] : "???";
    }

    protected DataType() {
    }

    protected DataType copy() {
        DataType dataType;
        try {
            dataType = (DataType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            dataType = null;
        }
        return dataType;
    }

    public DataType getBaseType() {
        return this.baseType;
    }

    public DataType getRootType() {
        DataType dataType = this;
        while (dataType.baseType != null) {
            dataType = dataType.baseType;
        }
        return dataType;
    }

    public Object getProperties() {
        return this.properties;
    }

    public abstract int getSupportedFacets();

    public void checkFacets() throws InvalidTypeException {
    }

    public boolean hasFacet(int n) {
        return (this.facets & n) != 0;
    }

    public int getLength() {
        return this.length;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public Pattern[] getPattern() {
        return this.pattern;
    }

    public Value[] getEnumeration() {
        return this.enumeration;
    }

    public WhiteSpace getWhiteSpace() {
        return this.whiteSpace;
    }

    public Value getMaxInclusive() {
        return this.maxInclusive;
    }

    public Value getMaxExclusive() {
        return this.maxExclusive;
    }

    public Value getMinExclusive() {
        return this.minExclusive;
    }

    public Value getMinInclusive() {
        return this.minInclusive;
    }

    public int getTotalDigits() {
        return this.totalDigits;
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    public boolean isFixedFacet(int n) {
        return (this.fixedFacets & n) != 0;
    }

    public int hashCode() {
        int n;
        int n2;
        int n3 = n2 = this.baseType == null ? this.rootTypeHashCode() : this.baseType.hashCode();
        if ((this.facets & 1) != 0) {
            n2 ^= this.length;
        }
        if ((this.facets & 2) != 0) {
            n2 ^= this.minLength;
        }
        if ((this.facets & 4) != 0) {
            n2 ^= this.maxLength;
        }
        if ((this.facets & 8) != 0) {
            for (n = 0; n < this.pattern.length; ++n) {
                n2 ^= this.pattern[n].hashCode();
            }
        }
        if ((this.facets & 0x10) != 0) {
            for (n = 0; n < this.enumeration.length; ++n) {
                n2 ^= this.enumeration[n].hashCode();
            }
        }
        if ((this.facets & 0x20) != 0) {
            n2 ^= this.whiteSpace.hashCode();
        }
        if ((this.facets & 0x40) != 0) {
            n2 ^= this.maxInclusive.hashCode();
        }
        if ((this.facets & 0x80) != 0) {
            n2 ^= this.maxExclusive.hashCode();
        }
        if ((this.facets & 0x100) != 0) {
            n2 ^= this.minExclusive.hashCode();
        }
        if ((this.facets & 0x200) != 0) {
            n2 ^= this.minInclusive.hashCode();
        }
        if ((this.facets & 0x400) != 0) {
            n2 ^= this.totalDigits;
        }
        if ((this.facets & 0x800) != 0) {
            n2 ^= this.fractionDigits;
        }
        n2 ^= this.fixedFacets;
        if (this.properties != null) {
            n2 ^= this.properties.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || !(object instanceof DataType)) {
            return false;
        }
        DataType dataType = (DataType)object;
        if (this.baseType == null && (dataType.baseType != null || !this.sameRootType(dataType)) || this.baseType != null && !this.baseType.equals(dataType.baseType)) {
            return false;
        }
        if ((this.facets & 1) != 0 && this.length != dataType.length) {
            return false;
        }
        if ((this.facets & 2) != 0 && this.minLength != dataType.minLength) {
            return false;
        }
        if ((this.facets & 4) != 0 && this.maxLength != dataType.maxLength) {
            return false;
        }
        if ((this.facets & 8) != 0) {
            if ((dataType.facets & 8) == 0 || this.pattern.length != dataType.pattern.length) {
                return false;
            }
            for (n = 0; n < this.pattern.length; ++n) {
                if (this.pattern[n].equals(dataType.pattern[n])) continue;
                return false;
            }
        }
        if ((this.facets & 0x10) != 0) {
            if ((dataType.facets & 0x10) == 0 || this.enumeration.length != dataType.enumeration.length) {
                return false;
            }
            for (n = 0; n < this.enumeration.length; ++n) {
                if (this.enumeration[n].equals(dataType.enumeration[n])) continue;
                return false;
            }
        }
        if ((this.facets & 0x20) != 0 && this.whiteSpace != dataType.whiteSpace) {
            return false;
        }
        if ((this.facets & 0x40) != 0 && !this.maxInclusive.equals(dataType.maxInclusive)) {
            return false;
        }
        if ((this.facets & 0x80) != 0 && !this.maxExclusive.equals(dataType.maxExclusive)) {
            return false;
        }
        if ((this.facets & 0x100) != 0 && !this.minExclusive.equals(dataType.minExclusive)) {
            return false;
        }
        if ((this.facets & 0x200) != 0 && !this.minInclusive.equals(dataType.minInclusive)) {
            return false;
        }
        if ((this.facets & 0x400) != 0 && this.totalDigits != dataType.totalDigits) {
            return false;
        }
        if ((this.facets & 0x800) != 0 && this.fractionDigits != dataType.fractionDigits) {
            return false;
        }
        if (this.fixedFacets != dataType.fixedFacets) {
            return false;
        }
        return (this.properties != null || dataType.properties == null) && (this.properties == null || this.properties.equals(dataType.properties));
    }

    protected int rootTypeHashCode() {
        return this.getClass().hashCode();
    }

    protected boolean sameRootType(DataType dataType) {
        return this.getClass().equals(dataType.getClass());
    }

    public Value valueOf(String string) throws InvalidDataException {
        return this.valueOf(string, null, UncheckedUnparsedEntities.INSTANCE);
    }

    public Value valueOf(String string, PrefixToNamespace prefixToNamespace) throws InvalidDataException {
        return this.valueOf(string, prefixToNamespace, UncheckedUnparsedEntities.INSTANCE);
    }

    public Value valueOf(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities) throws InvalidDataException {
        return this.parse(this.normalizeWhiteSpace(string), prefixToNamespace, unparsedEntities);
    }

    @Override
    public String normalizeWhiteSpace(String string) {
        WhiteSpace whiteSpace = (this.facets & 0x20) != 0 ? this.whiteSpace : WhiteSpace.PRESERVE;
        switch (whiteSpace) {
            case REPLACE: {
                string = XMLText.replaceWhiteSpace(string);
                break;
            }
            case COLLAPSE: {
                string = XMLText.collapseWhiteSpace(string);
            }
        }
        return string;
    }

    public Value parse(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities) throws InvalidDataException {
        int n;
        if ((this.facets & 8) != 0) {
            for (Pattern pattern : this.pattern) {
                if (pattern.matches(string)) continue;
                throw new InvalidDataException("cvc-pattern-valid", Msg.msg("patternFacet", string, pattern));
            }
        }
        Value value = this.doParse(string, prefixToNamespace, unparsedEntities);
        int n2 = -1;
        if ((this.facets & 1) != 0 && (n2 = value.length()) != this.length) {
            throw new InvalidDataException("cvc-length-valid", Msg.msg("lengthFacet", string, this.length));
        }
        if ((this.facets & 2) != 0) {
            if (n2 < 0) {
                n2 = value.length();
            }
            if (n2 < this.minLength) {
                throw new InvalidDataException("cvc-minLength-valid", Msg.msg("minLengthFacet", string, this.minLength));
            }
        }
        if ((this.facets & 4) != 0) {
            if (n2 < 0) {
                n2 = value.length();
            }
            if (n2 > this.maxLength) {
                throw new InvalidDataException("cvc-maxLength-valid", Msg.msg("maxLengthFacet", string, this.maxLength));
            }
        }
        if ((this.facets & 0x10) != 0) {
            n = 0;
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!value.equals(this.enumeration[i])) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                throw new InvalidDataException("cvc-enumeration-valid", Msg.msg("enumerationFacet", string));
            }
        }
        if ((this.facets & 0x40) != 0 && (n = value.compareTo(this.maxInclusive)) != -1 && n != 0) {
            throw new InvalidDataException("cvc-maxInclusive-valid", Msg.msg("maxInclusiveFacet", string, this.maxInclusive));
        }
        if ((this.facets & 0x80) != 0 && (n = value.compareTo(this.maxExclusive)) != -1) {
            throw new InvalidDataException("cvc-maxExclusive-valid", Msg.msg("maxExclusiveFacet", string, this.maxExclusive));
        }
        if ((this.facets & 0x100) != 0 && (n = value.compareTo(this.minExclusive)) != 1) {
            throw new InvalidDataException("cvc-minExclusive-valid", Msg.msg("minExclusiveFacet", string, this.minExclusive));
        }
        if ((this.facets & 0x200) != 0 && (n = value.compareTo(this.minInclusive)) != 0 && n != 1) {
            throw new InvalidDataException("cvc-minInclusive-valid", Msg.msg("minInclusiveFacet", string, this.minInclusive));
        }
        if ((this.facets & 0x400) != 0 && value.totalDigits() > this.totalDigits) {
            throw new InvalidDataException("cvc-totalDigits-valid", Msg.msg("totalDigitsFacet", string, this.totalDigits));
        }
        if ((this.facets & 0x800) != 0 && value.fractionDigits() > this.fractionDigits) {
            throw new InvalidDataException("cvc-fractionDigits-valid", Msg.msg("fractionDigitsFacet", string, this.fractionDigits));
        }
        return value;
    }

    protected abstract Value doParse(String var1, PrefixToNamespace var2, UnparsedEntities var3) throws InvalidDataException;

    @Override
    public Data parseData(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities) throws DataFormatException {
        try {
            return this.valueOf(string, prefixToNamespace, unparsedEntities);
        }
        catch (InvalidDataException invalidDataException) {
            throw new DataFormatException(invalidDataException.getMessage(), invalidDataException);
        }
    }

    @Override
    public boolean isContextDependentDataType() {
        return false;
    }

    @Override
    public Data[] getEnumeratedValues() {
        return this.enumeration;
    }

    public static enum WhiteSpace {
        PRESERVE,
        REPLACE,
        COLLAPSE;


        public String toString() {
            switch (this) {
                case PRESERVE: {
                    return "preserve";
                }
                case REPLACE: {
                    return "replace";
                }
                case COLLAPSE: {
                    return "collapse";
                }
            }
            return "???";
        }
    }
}

