/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.validate;

import com.xmlmind.util.ObjectUtil;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.validate.Diagnostic;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;

public final class DiagnosticImpl
implements Diagnostic {
    public static final DiagnosticImpl[] NO_DIAGNOSTICS = new DiagnosticImpl[0];
    public final Element element;
    public final String message;
    public final Diagnostic.Severity severity;
    public final String detailId;
    public final Object[] detailValues;
    public static final DiagnosticComparator compareDiagnostics = new DiagnosticComparator();

    public DiagnosticImpl(Element element, String string, Diagnostic.Severity severity) {
        this(element, string, severity, null, null);
    }

    public DiagnosticImpl(Element element, String string, Diagnostic.Severity severity, String string2, Object object) {
        this(element, string, severity, string2, new Object[]{object});
    }

    public DiagnosticImpl(Element element, String string, Diagnostic.Severity severity, String string2, Object[] objectArray) {
        this.element = element;
        this.message = string;
        this.severity = severity;
        this.detailId = string2;
        this.detailValues = objectArray;
    }

    @Override
    public Element getDiagnosedElement() {
        return this.element;
    }

    @Override
    public String getDiagnosticMessage() {
        return this.message;
    }

    @Override
    public Diagnostic.Severity getDiagnosticSeverity() {
        return this.severity;
    }

    @Override
    public String getDiagnosticDetailId() {
        return this.detailId;
    }

    @Override
    public Object[] getDiagnosticDetailValues() {
        return this.detailValues;
    }

    public static String format(Diagnostic[] diagnosticArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = diagnosticArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append('\n');
            }
            DiagnosticImpl.format(diagnosticArray[i], stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static String format(Diagnostic diagnostic) {
        StringBuilder stringBuilder = new StringBuilder();
        DiagnosticImpl.format(diagnostic, stringBuilder);
        return stringBuilder.toString();
    }

    public static void format(Diagnostic diagnostic, StringBuilder stringBuilder) {
        Element element = diagnostic.getDiagnosedElement();
        String string = diagnostic.getDiagnosticMessage();
        Diagnostic.Severity severity = diagnostic.getDiagnosticSeverity();
        URL uRL = element.getSourceURL();
        if (uRL != null) {
            stringBuilder.append(uRL.toExternalForm());
            int n = -1;
            int n2 = -1;
            int[] nArray = (int[])element.getProperty(Constants.LINE_COLUMN_PROPERTY);
            if (nArray != null) {
                n = nArray[0];
                n2 = nArray[1];
            }
            stringBuilder.append(':');
            if (n > 0) {
                stringBuilder.append(n);
            }
            stringBuilder.append(':');
            if (n2 > 0) {
                stringBuilder.append(n2);
            }
        } else if (element != null) {
            stringBuilder.append(element.getXPath());
        }
        stringBuilder.append(':');
        stringBuilder.append((Object)severity);
        stringBuilder.append(": ");
        if (string.indexOf(10) >= 0) {
            string = string.replace('\n', ' ');
        }
        stringBuilder.append(string);
    }

    public static final boolean equals(Diagnostic diagnostic, Diagnostic diagnostic2) {
        return diagnostic.getDiagnosticSeverity() == diagnostic2.getDiagnosticSeverity() && diagnostic.getDiagnosedElement() == diagnostic2.getDiagnosedElement() && ObjectUtil.equals(diagnostic.getDiagnosticMessage(), diagnostic2.getDiagnosticMessage()) && ObjectUtil.equals(diagnostic.getDiagnosticDetailId(), diagnostic2.getDiagnosticDetailId()) && Arrays.equals(diagnostic.getDiagnosticDetailValues(), diagnostic2.getDiagnosticDetailValues());
    }

    public static final class DiagnosticComparator
    implements Comparator<Diagnostic> {
        @Override
        public int compare(Diagnostic diagnostic, Diagnostic diagnostic2) {
            int n = diagnostic.getDiagnosedElement().compareTo(diagnostic2.getDiagnosedElement());
            if (n == 0 && (n = diagnostic2.getDiagnosticSeverity().getImportance() - diagnostic.getDiagnosticSeverity().getImportance()) == 0 && (n = DiagnosticComparator.diagnosticDetailWeight(diagnostic) - DiagnosticComparator.diagnosticDetailWeight(diagnostic2)) == 0) {
                n = diagnostic.getDiagnosticMessage().compareTo(diagnostic2.getDiagnosticMessage());
            }
            return n;
        }

        private static int diagnosticDetailWeight(Diagnostic diagnostic) {
            String string = diagnostic.getDiagnosticDetailId();
            if (string == "DUPLICATE_ID") {
                return 1;
            }
            if (string == "ORIGINAL_ID") {
                return 2;
            }
            if (string == "BROKEN_IDREF") {
                return 3;
            }
            if (string == "DUPLICATE_ANCHOR") {
                return 4;
            }
            if (string == "ORIGINAL_ANCHOR") {
                return 5;
            }
            if (string == "BROKEN_LINK") {
                return 6;
            }
            return 100;
        }
    }
}

