/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.sxpath;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.sxpath.Path;
import com.xmlmind.xml.sxpath.Step;
import com.xmlmind.xml.sxpath.XPath;
import java.util.IdentityHashMap;

public final class ElementMatcher {
    public final XPath[] xpaths;
    private final IdentityHashMap<Name, Entry> entries;

    public ElementMatcher(XPath[] xPathArray) {
        this.xpaths = xPathArray;
        this.entries = new IdentityHashMap();
        for (XPath xPath : xPathArray) {
            for (Path path : xPath.getPaths()) {
                Step[] stepArray = path.getSteps();
                Step step = stepArray[stepArray.length - 1];
                if (step.getAxis() != Step.Axis.CHILD || step.getTest() != Step.Test.NAME) continue;
                Name name = step.getTestedName();
                Entry entry = this.entries.get(name);
                if (entry == null) {
                    entry = new Entry(name);
                    this.entries.put(name, entry);
                }
                entry.addPath(path, stepArray.length == 1);
            }
        }
    }

    public boolean match(Element element) {
        boolean bl = false;
        Entry entry = this.entries.get(element.getName());
        if (entry != null) {
            if (entry.basicTest) {
                bl = true;
            } else {
                for (Path path : entry.paths) {
                    if (!path.match(element)) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    private static final class Entry {
        public final Name elementName;
        public Path[] paths;
        public boolean basicTest;

        public Entry(Name name) {
            this.elementName = name;
            this.paths = new Path[0];
            this.basicTest = false;
        }

        public void addPath(Path path, boolean bl) {
            if (this.basicTest) {
                return;
            }
            if (bl) {
                this.basicTest = true;
            } else {
                int n = this.paths.length;
                Path[] pathArray = new Path[n + 1];
                System.arraycopy(this.paths, 0, pathArray, 0, n);
                pathArray[n] = path;
                this.paths = pathArray;
            }
        }
    }
}

