/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.schematron;

import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.xml.load.LoadError;
import com.xmlmind.xml.load.LoadErrorImpl;
import com.xmlmind.xml.rng.validate.RNGLoaderImpl;
import com.xmlmind.xml.schematron.Schematron;
import com.xmlmind.xml.schematron.SchematronError;
import com.xmlmind.xml.schematron.SchematronLoader;
import com.xmlmind.xml.validate.SubDocumentType;
import java.net.URL;

public final class SchematronForSchematron {
    private static final boolean[] GRAMMAR_LOADED = new boolean[1];
    private static SubDocumentType GRAMMAR = null;
    private static final boolean[] SCHEMATRON_LOADED = new boolean[1];
    private static Schematron SCHEMATRON = null;

    private SchematronForSchematron() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubDocumentType getGrammar() {
        boolean[] blArray = GRAMMAR_LOADED;
        synchronized (GRAMMAR_LOADED) {
            if (!GRAMMAR_LOADED[0]) {
                SchematronForSchematron.GRAMMAR_LOADED[0] = true;
                GRAMMAR = SchematronForSchematron.doGetGrammar();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return GRAMMAR;
        }
    }

    public static SubDocumentType doGetGrammar() {
        SubDocumentType subDocumentType = null;
        try {
            URL uRL = SchematronForSchematron.class.getResource("iso-schematron.rnc");
            if (uRL == null) {
                throw new RuntimeException("'iso-schematron.rnc' not found");
            }
            RNGLoaderImpl rNGLoaderImpl = new RNGLoaderImpl();
            subDocumentType = rNGLoaderImpl.loadSubDocumentType(uRL);
            if (subDocumentType == null) {
                String string = "'iso-schematron.rnc' has errors";
                LoadError[] loadErrorArray = rNGLoaderImpl.getLoadErrors();
                if (loadErrorArray != null && loadErrorArray.length > 0) {
                    string = LoadErrorImpl.format(loadErrorArray[0], false);
                }
                throw new RuntimeException(string);
            }
        }
        catch (Exception exception) {
            System.err.println("Internal error:cannot load 'iso-schematron.rnc':\n" + ThrowableUtil.detailedReason(exception));
        }
        return subDocumentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schematron getSchematron() {
        boolean[] blArray = SCHEMATRON_LOADED;
        synchronized (SCHEMATRON_LOADED) {
            if (!SCHEMATRON_LOADED[0]) {
                SchematronForSchematron.SCHEMATRON_LOADED[0] = true;
                SCHEMATRON = SchematronForSchematron.doGetSchematron();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SCHEMATRON;
        }
    }

    public static Schematron doGetSchematron() {
        Schematron schematron = null;
        try {
            URL uRL = SchematronForSchematron.class.getResource("iso-schematron.sch");
            if (uRL == null) {
                throw new RuntimeException("'iso-schematron.sch' not found");
            }
            SchematronLoader schematronLoader = new SchematronLoader();
            schematron = schematronLoader.load(uRL);
            if (schematron == null) {
                String string = "'iso-schematron.sch' has errors";
                SchematronError[] schematronErrorArray = schematronLoader.getErrors();
                if (schematronErrorArray != null && schematronErrorArray.length > 0) {
                    string = schematronErrorArray[0].getMessageWithLocation();
                }
                throw new RuntimeException(string);
            }
        }
        catch (Exception exception) {
            System.err.println("Internal error: cannot load 'iso-schematron.sch':\n" + ThrowableUtil.detailedReason(exception));
        }
        return schematron;
    }
}

