/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.schematron;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.schematron.ValidateExprContext;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.NodeSetExpr;
import com.xmlmind.xml.xpath.StringExpr;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;

final class Message {
    public final Part[] parts;
    public final URL msgURL;

    public Message(Part[] partArray, URL uRL) {
        this.parts = partArray;
        this.msgURL = uRL;
    }

    public String format(XNode xNode, ValidateExprContext validateExprContext) throws EvalException {
        StringBuilder stringBuilder = new StringBuilder();
        validateExprContext.defaultBaseURL = this.msgURL;
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].format(xNode, validateExprContext, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public void writeXML(Writer writer) throws IOException {
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].writeXML(writer);
        }
    }

    public static final class ValueOf
    implements Part {
        public final StringExpr selectExpr;
        public final String selectString;

        public ValueOf(StringExpr stringExpr, String string) {
            this.selectExpr = stringExpr;
            this.selectString = string;
        }

        @Override
        public void format(XNode xNode, ValidateExprContext validateExprContext, StringBuilder stringBuilder) throws EvalException {
            stringBuilder.append(this.selectExpr.eval(xNode, validateExprContext));
        }

        @Override
        public void writeXML(Writer writer) throws IOException {
            writer.write("<sch:value-of select=");
            writer.write(XMLText.quoteXML(this.selectString));
            writer.write("/>");
        }
    }

    public static final class Name
    implements Part {
        public final NodeSetExpr pathExpr;
        public final String pathString;

        public Name(NodeSetExpr nodeSetExpr, String string) {
            this.pathExpr = nodeSetExpr;
            this.pathString = string;
        }

        @Override
        public void format(XNode xNode, ValidateExprContext validateExprContext, StringBuilder stringBuilder) throws EvalException {
            Object object;
            com.xmlmind.xml.name.Name name;
            if (this.pathExpr == null) {
                name = xNode.name();
            } else {
                object = this.pathExpr.eval(xNode, validateExprContext);
                name = object.next().name();
            }
            object = name == null ? "" : name.format(true, xNode.namespacePrefixMap());
            stringBuilder.append((String)object);
        }

        @Override
        public void writeXML(Writer writer) throws IOException {
            writer.write("<sch:name");
            if (this.pathString != null) {
                writer.write(" path=");
                writer.write(XMLText.quoteXML(this.pathString));
            }
            writer.write("/>");
        }
    }

    public static final class Text
    implements Part {
        public final String text;

        public Text(String string) {
            this.text = string;
        }

        @Override
        public void format(XNode xNode, ValidateExprContext validateExprContext, StringBuilder stringBuilder) throws EvalException {
            stringBuilder.append(this.text);
        }

        @Override
        public void writeXML(Writer writer) throws IOException {
            writer.write(XMLText.escapeXML(this.text));
        }
    }

    public static interface Part {
        public void format(XNode var1, ValidateExprContext var2, StringBuilder var3) throws EvalException;

        public void writeXML(Writer var1) throws IOException;
    }
}

