/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.save;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringList;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Inclusion;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.load.CharEntities;
import com.xmlmind.xml.load.Entities;
import com.xmlmind.xml.load.SimpleInclusion;
import com.xmlmind.xml.load.XIncluder;
import com.xmlmind.xml.load.XInclusionScheme;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.save.DocumentIndenter;
import com.xmlmind.xml.save.DocumentWriter;
import com.xmlmind.xml.save.ResourceSelector;
import com.xmlmind.xml.save.SaveOptions;
import com.xmlmind.xml.validate.AnyDocumentType;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.DocumentTypeUtil;
import com.xmlmind.xml.validate.SchemaKind;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;

public final class SaveDocument {
    private static final String[] documentWriterClassName = new String[1];
    private static final String[] documentIndenterClassName = new String[1];

    private SaveDocument() {
    }

    public static void save(Document document, File file) throws IOException {
        SaveDocument.save(document, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Document document, File file, SaveOptions saveOptions) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            SaveDocument.save(document, (OutputStream)fileOutputStream, saveOptions);
        }
    }

    public static void save(Document document, OutputStream outputStream, SaveOptions saveOptions) throws IOException {
        boolean[] blArray = new boolean[1];
        String[] stringArray = SaveDocument.xmlDecl(document, saveOptions, blArray);
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = string2 == null ? "UTF-8" : string2;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string4));
        if (!blArray[0]) {
            SaveDocument.writeXMLDeclaration(string, string2, string3, bufferedWriter);
            bufferedWriter.write(10);
        }
        DocumentWriter documentWriter = SaveDocument.createDocumentWriter(bufferedWriter, string4, saveOptions, document);
        documentWriter.write(document);
    }

    public static void save(Document document, Writer writer, SaveOptions saveOptions) throws IOException {
        String string;
        boolean[] blArray = new boolean[1];
        String[] stringArray = SaveDocument.xmlDecl(document, saveOptions, blArray);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        String string5 = string = string3 == null ? "UTF-8" : string3;
        if (!blArray[0]) {
            SaveDocument.writeXMLDeclaration(string2, string3, string4, writer);
            writer.write(10);
        }
        DocumentWriter documentWriter = SaveDocument.createDocumentWriter(writer, string, saveOptions, document);
        documentWriter.write(document);
    }

    private static String[] xmlDecl(Document document, SaveOptions saveOptions, boolean[] blArray) {
        String[] stringArray;
        if (saveOptions == null) {
            saveOptions = SaveOptions.INSTANCE;
        }
        String string = saveOptions.version;
        String string2 = saveOptions.encoding;
        String string3 = saveOptions.standalone;
        if (saveOptions.omitXMLDeclaration == null) {
            stringArray = SaveDocument.getHTMLContentType(document);
            if (stringArray == null) {
                blArray[0] = false;
            } else {
                String string4 = stringArray[0];
                String string5 = stringArray[1];
                if ("text/html".equalsIgnoreCase(string4) && "utf-8".equalsIgnoreCase(string5)) {
                    blArray[0] = true;
                    string2 = "UTF-8";
                } else {
                    blArray[0] = false;
                    if (string5 != null && StringList.containsIgnoreCase(SystemUtil.listEncodings(), string5)) {
                        string2 = string5;
                    }
                }
            }
        } else {
            blArray[0] = saveOptions.omitXMLDeclaration;
        }
        if (blArray[0]) {
            return new String[]{null, "UTF-8", null};
        }
        if (string == "ORIGINAL_VERSION" || string2 == "ORIGINAL_ENCODING" || string3 == "ORIGINAL_STANDALONE") {
            stringArray = null;
            if (document != null) {
                stringArray = (String[])document.getProperty(Constants.XML_DECLARATION_PROPERTY);
            }
            if (stringArray != null) {
                if (string == "ORIGINAL_VERSION") {
                    string = stringArray[0];
                }
                if (string2 == "ORIGINAL_ENCODING") {
                    string2 = stringArray[1];
                }
                if (string3 == "ORIGINAL_STANDALONE") {
                    string3 = stringArray[2];
                }
            } else {
                if (string == "ORIGINAL_VERSION") {
                    string = null;
                }
                if (string2 == "ORIGINAL_ENCODING") {
                    string2 = null;
                }
                if (string3 == "ORIGINAL_STANDALONE") {
                    string3 = null;
                }
            }
        }
        return new String[]{string, string2, string3};
    }

    private static String[] getHTMLContentType(Document document) {
        Element element = document.getRootElement();
        if (element.getName() != Name.HTML) {
            return null;
        }
        if ((element = element.getChildElement(0)) == null || element.getName() != Name.get(Namespace.XHTML, "head")) {
            return null;
        }
        Name name = Name.get(Namespace.XHTML, "meta");
        Name name2 = Name.get("charset");
        Name name3 = Name.get("http-equiv");
        Name name4 = Name.get("content");
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            Element element2;
            if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() != name) continue;
            String string2 = null;
            String string3 = SaveDocument.getTokenAttr(element2, name2);
            if (string3 != null) {
                string2 = "text/html";
            } else if ("content-type".equals(SaveDocument.getTokenAttr(element2, name3)) && (string = SaveDocument.getTokenAttr(element2, name4)) != null) {
                string2 = URLUtil.contentTypeToMedia(string);
                string3 = URLUtil.contentTypeToCharset(string);
            }
            if (string2 == null) continue;
            return new String[]{string2, string3};
        }
        return null;
    }

    private static String getTokenAttr(Element element, Name name) {
        String string = element.getAttribute(name);
        if (string != null && (string = string.trim().toLowerCase()).length() == 0) {
            string = null;
        }
        return string;
    }

    public static void writeXMLDeclaration(String string, String string2, String string3, Writer writer) throws IOException {
        writer.write("<?xml version=\"");
        if (string == null) {
            string = "1.0";
        }
        writer.write(string);
        writer.write(34);
        if (string2 != null) {
            writer.write(" encoding=\"");
            writer.write(string2);
            writer.write(34);
        }
        if (string3 != null) {
            writer.write(" standalone=\"");
            writer.write(string3);
            writer.write(34);
        }
        writer.write("?>");
    }

    public static DocumentWriter createDocumentWriter(Writer writer, String string, SaveOptions saveOptions, Document document) throws UnsupportedEncodingException {
        CharEntities charEntities;
        Object object;
        if (saveOptions == null) {
            saveOptions = SaveOptions.INSTANCE;
        }
        DocumentWriter documentWriter = null;
        DocumentType documentType = (DocumentType)document.getProperty(Constants.DOCUMENT_TYPE_PROPERTY);
        if (documentType != null && documentType instanceof AnyDocumentType) {
            documentType = null;
        }
        if (saveOptions.indent != -1 && (saveOptions.indent >= 0 || saveOptions.indent < 0 && documentType != null)) {
            object = SaveDocument.createDocumentIndenter(writer);
            documentWriter = object;
            ((DocumentIndenter)object).setDocumentType(documentType);
            ((DocumentIndenter)object).setIndent(saveOptions.indent >= 0 ? saveOptions.indent : -2 - saveOptions.indent);
            ((DocumentIndenter)object).setMaxLineLength(saveOptions.maxLineLength);
            ((DocumentIndenter)object).setAddOpenLines(saveOptions.addOpenLines);
        }
        if (documentWriter == null) {
            documentWriter = SaveDocument.createDocumentWriter(writer);
        }
        documentWriter.setFavorInteroperability(saveOptions.favorInteroperability);
        documentWriter.setPredeclarePrefixPreferences(saveOptions.predeclarePrefixPreferences);
        if (documentWriter.getDocumentType() == null && documentType != null) {
            documentWriter.setDocumentType(documentType);
        }
        documentWriter.setEncoding(string);
        documentWriter.setPreserveInclusions(saveOptions.preserveInclusions);
        documentWriter.setFilterDuplicateIDs(saveOptions.filterDuplicateIDs);
        if (saveOptions.saveCharsAsEntityRefs && (object = (Entities)document.getProperty(Constants.ENTITIES_PROPERTY)) != null && (charEntities = ((Entities)object).getCharEntities()) != null && charEntities.size() > 0) {
            documentWriter.setCharEntities(charEntities);
        }
        documentWriter.setCharsSavedAsEntityRefs(saveOptions.charsSavedAsEntityRefs);
        documentWriter.setCdataSectionElements(saveOptions.cdataSectionElements);
        boolean bl = saveOptions.useOriginalPrefixes;
        boolean bl2 = saveOptions.useDefaultNamespace;
        if (documentType != null && documentType.getSchemaKind() == SchemaKind.DTD) {
            bl2 = true;
            bl = true;
        }
        PrefixEntry[] prefixEntryArray = null;
        prefixEntryArray = bl ? document.getPrefixPreferences(bl2) : saveOptions.preferredPrefixes;
        if (prefixEntryArray != null) {
            documentWriter.setPrefixPreferences(prefixEntryArray);
        }
        return documentWriter;
    }

    public static void save(Element element, File file) throws IOException {
        SaveDocument.save(element, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Element element, File file, String string) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            SaveDocument.save(element, (OutputStream)fileOutputStream, string);
        }
    }

    public static void save(Element element, OutputStream outputStream, String string) throws IOException {
        if (string == null) {
            string = "UTF-8";
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string));
        DocumentWriter documentWriter = SaveDocument.createDocumentWriter(bufferedWriter);
        documentWriter.setEncoding(string);
        documentWriter.setPreserveInclusions(false);
        PrefixEntry[] prefixEntryArray = SaveDocument.getPrefixPreferences(element);
        if (prefixEntryArray != null) {
            documentWriter.setPrefixPreferences(prefixEntryArray);
        }
        SaveDocument.writeXMLDeclaration(null, string, null, bufferedWriter);
        bufferedWriter.write(10);
        documentWriter.write(element);
        documentWriter.flush();
    }

    public static void save(Element element, Writer writer, String string) throws IOException {
        if (string == null) {
            string = "UTF-8";
        }
        DocumentWriter documentWriter = SaveDocument.createDocumentWriter(writer);
        documentWriter.setEncoding(string);
        documentWriter.setPreserveInclusions(false);
        PrefixEntry[] prefixEntryArray = SaveDocument.getPrefixPreferences(element);
        if (prefixEntryArray != null) {
            documentWriter.setPrefixPreferences(prefixEntryArray);
        }
        SaveDocument.writeXMLDeclaration(null, string, null, writer);
        writer.write(10);
        documentWriter.write(element);
        documentWriter.flush();
    }

    private static PrefixEntry[] getPrefixPreferences(Element element) {
        Namespace namespace;
        PrefixEntry[] prefixEntryArray = null;
        Document document = element.getDocument();
        if (document != null && (prefixEntryArray = document.getPrefixPreferences(false)) != null && (namespace = element.getNamespace()) != Namespace.NONE && namespace != Namespace.XML) {
            String string = null;
            int n = prefixEntryArray.length;
            for (int i = 0; i < n; ++i) {
                if (prefixEntryArray[i].namespace != namespace) continue;
                string = prefixEntryArray[i].prefix;
                break;
            }
            if (string != null && string.length() > 0) {
                PrefixEntry[] prefixEntryArray2 = new PrefixEntry[n + 1];
                System.arraycopy(prefixEntryArray, 0, prefixEntryArray2, 0, n);
                prefixEntryArray2[n] = new PrefixEntry("", namespace);
                prefixEntryArray = prefixEntryArray2;
            }
        }
        return prefixEntryArray;
    }

    public static String toString(Element element, int n) {
        return SaveDocument.toString(element, element, n);
    }

    public static String toString(Element element, Element element2, int n) {
        DocumentWriter documentWriter;
        PrefixEntry[] prefixEntryArray;
        StringWriter stringWriter = new StringWriter();
        if (n > 0) {
            prefixEntryArray = SaveDocument.createDocumentIndenter(stringWriter);
            prefixEntryArray.setIndent(n);
            prefixEntryArray.setAddOpenLines(false);
            documentWriter = prefixEntryArray;
        } else {
            documentWriter = SaveDocument.createDocumentWriter(stringWriter);
        }
        documentWriter.setDocumentType(DocumentTypeUtil.getDocumentType(element2));
        documentWriter.setPreserveInclusions(false);
        prefixEntryArray = SaveDocument.getPrefixPreferences(element2);
        if (prefixEntryArray != null) {
            documentWriter.setPrefixPreferences(prefixEntryArray);
        }
        documentWriter.setPredeclarePrefixPreferences(Boolean.FALSE);
        try {
            documentWriter.write(element);
            documentWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDocumentWriterClassName(String string) {
        String[] stringArray = documentWriterClassName;
        synchronized (documentWriterClassName) {
            SaveDocument.documentWriterClassName[0] = string;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDocumentWriterClassName() {
        String[] stringArray = documentWriterClassName;
        synchronized (documentWriterClassName) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return documentWriterClassName[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentWriter createDocumentWriter(Writer writer) {
        String[] stringArray = documentWriterClassName;
        synchronized (documentWriterClassName) {
            if (documentWriterClassName[0] != null) {
                try {
                    Class<?> clazz = Class.forName(documentWriterClassName[0]);
                    Constructor<?> constructor = clazz.getConstructor(Writer.class);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return (DocumentWriter)constructor.newInstance(writer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new DocumentWriter(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDocumentIndenterClassName(String string) {
        String[] stringArray = documentIndenterClassName;
        synchronized (documentIndenterClassName) {
            SaveDocument.documentIndenterClassName[0] = string;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDocumentIndenterClassName() {
        String[] stringArray = documentIndenterClassName;
        synchronized (documentIndenterClassName) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return documentIndenterClassName[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentIndenter createDocumentIndenter(Writer writer) {
        String[] stringArray = documentIndenterClassName;
        synchronized (documentIndenterClassName) {
            if (documentIndenterClassName[0] != null) {
                try {
                    Class<?> clazz = Class.forName(documentIndenterClassName[0]);
                    Constructor<?> constructor = clazz.getConstructor(Writer.class);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return (DocumentIndenter)constructor.newInstance(writer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new DocumentIndenter(writer);
        }
    }

    public static void saveAs(Document document, File file) throws IOException {
        SaveDocument.prepareSaveAs(document, FileUtil.fileToURL(file));
        SaveDocument.save(document, file);
    }

    public static boolean prepareSaveAs(Document document, URL uRL) {
        Object object;
        URL uRL2 = document.getSourceURL();
        if (uRL2 == null) {
            throw new IllegalArgumentException("document has no sourceURL property");
        }
        if (uRL2.equals(uRL)) {
            return false;
        }
        URL uRL3 = URLUtil.getParent(uRL2);
        if (uRL3 == null) {
            throw new IllegalArgumentException("'" + String.valueOf(uRL2) + "', invalid document URL");
        }
        URL uRL4 = URLUtil.getParent(uRL);
        if (uRL4 == null) {
            throw new IllegalArgumentException("'" + String.valueOf(uRL) + "', invalid saveURL");
        }
        boolean[] blArray = new boolean[1];
        boolean bl = false;
        XInclusionScheme[] xInclusionSchemeArray = (XInclusionScheme[])document.getProperty(Constants.XINCLUSION_SCHEMES_PROPERTY);
        if (xInclusionSchemeArray != null) {
            SaveDocument.prepareSaveAs1(document, document, uRL2, blArray);
            bl = blArray[0];
        }
        if (!uRL3.equals(uRL4) && (object = (ResourceSelector[])document.getProperty(Constants.DOCUMENT_RESOURCES_PROPERTY)) != null) {
            SaveDocument.prepareSaveAs2(document, (ResourceSelector[])object, uRL2, uRL, blArray);
        }
        document.putProperty(Constants.SOURCE_URL_PROPERTY, uRL);
        if (bl) {
            object = new XIncluder(xInclusionSchemeArray);
            ((XIncluder)object).process(document, null, null, null, null);
        }
        if (blArray[0]) {
            document.endEdit();
        }
        return blArray[0];
    }

    private static void prepareSaveAs1(Tree tree, Document document, URL uRL, boolean[] blArray) {
        Node node = tree.getFirstChild();
        while (node != null) {
            Node node2;
            Inclusion inclusion = node.getInclusion();
            if (inclusion != null) {
                Node[] nodeArray;
                SimpleInclusion simpleInclusion;
                Node node3 = node;
                Node node4 = node;
                for (node2 = node.getNextSibling(); node2 != null && node2.getInclusion() == inclusion; node2 = node2.getNextSibling()) {
                    node4 = node2;
                }
                if (inclusion instanceof SimpleInclusion && uRL.equals((simpleInclusion = (SimpleInclusion)inclusion).getSourceURL(node3)) && (nodeArray = simpleInclusion.uninclude(node3, node4)) != null && nodeArray.length > 0) {
                    if (!blArray[0]) {
                        blArray[0] = true;
                        document.beginEdit();
                    }
                    SaveDocument.replaceNodes(node3, node4, nodeArray);
                }
            } else if (node.getType() == Node.Type.ELEMENT) {
                SaveDocument.prepareSaveAs1((Element)node, document, uRL, blArray);
            }
            node = node2;
        }
    }

    private static void replaceNodes(Node object, Node node, Node[] nodeArray) {
        Tree tree = ((Node)object).getParent();
        Node node2 = node.getNextSibling();
        Object object2 = object;
        while (object2 != node2) {
            Node object3 = ((Node)object2).getNextSibling();
            tree.removeChild((Node)object2);
            object2 = object3;
        }
        for (Node node3 : nodeArray) {
            tree.insertChild(node2, node3);
        }
    }

    public static void prepareSaveAs2(Document document, ResourceSelector[] resourceSelectorArray, URL uRL, URL uRL2, boolean[] blArray) {
        for (ResourceSelector resourceSelector : resourceSelectorArray) {
            XNode[] xNodeArray;
            for (XNode xNode : xNodeArray = resourceSelector.selectResource(document)) {
                String string;
                boolean bl;
                URL uRL3;
                URL uRL4;
                Object object;
                Element element;
                Attribute attribute;
                block22: {
                    attribute = null;
                    element = null;
                    URL uRL5 = null;
                    object = null;
                    uRL4 = null;
                    if (xNode instanceof Attribute) {
                        attribute = (Attribute)xNode;
                        if (attribute.element.lookupInclusion() != null) continue;
                        object = attribute.value;
                        uRL5 = attribute.element.getBaseURL();
                        if (uRL5 == null) {
                            uRL5 = uRL;
                        }
                        if (uRL2 != null && (uRL4 = attribute.element.doGetBaseURL(uRL2)) == null) {
                            uRL4 = uRL2;
                        }
                    } else if (xNode instanceof Element) {
                        element = (Element)xNode;
                        if (element.lookupInclusion() != null) continue;
                        object = element.getText();
                        uRL5 = element.getBaseURL();
                        if (uRL5 == null) {
                            uRL5 = uRL;
                        }
                        if (uRL2 != null && (uRL4 = element.doGetBaseURL(uRL2)) == null) {
                            uRL4 = uRL2;
                        }
                    }
                    if (object != null && (((String)(object = ((String)object).trim())).length() == 0 || ((String)object).equals("???"))) {
                        object = null;
                    }
                    if (object == null) continue;
                    uRL3 = null;
                    bl = false;
                    try {
                        string = XMLCatalogs.resolveURI((String)object);
                        if (string != null) {
                            uRL3 = URLUtil.createURL(string);
                            bl = true;
                            break block22;
                        }
                        try {
                            uRL3 = URLUtil.createURL((String)object);
                            bl = true;
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        if (uRL3 == null) {
                            uRL3 = URLUtil.createURL(uRL5, (String)object);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (bl || uRL3 == null) continue;
                string = uRL3.getRef();
                if (string != null) {
                    int n = ((String)object).length() - string.length() - 1;
                    if (n == 0) continue;
                    object = ((String)object).substring(0, n);
                    uRL3 = URLUtil.setFragment(uRL3, null);
                }
                Object object2 = null;
                if (uRL4 != null) {
                    object2 = URLUtil.getRawRelativePath(uRL3, uRL4);
                }
                if (object2 == null) {
                    object2 = uRL3.toExternalForm();
                }
                if (string != null) {
                    object2 = (String)object2 + "#" + string;
                    object = (String)object + "#" + string;
                }
                if (((String)object2).equals(object)) continue;
                if (blArray != null && !blArray[0]) {
                    blArray[0] = true;
                    document.beginEdit();
                }
                if (attribute != null) {
                    attribute.element.putAttribute(attribute.name, (String)object2);
                    continue;
                }
                element.setText((String)object2);
            }
        }
    }
}

