/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.rng.validate.AnyDataPattern;
import com.xmlmind.xml.rng.validate.Builder;
import com.xmlmind.xml.rng.validate.EmptyPattern;
import com.xmlmind.xml.rng.validate.NotAllowedPattern;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.PatternStack;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataFormatException;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.UnparsedEntities;

final class ValuePattern
extends AnyDataPattern {
    public Data value;
    public DataType dataType;

    public ValuePattern(Data data, DataType dataType) {
        this.value = data;
        this.dataType = dataType;
    }

    public ValuePattern() {
    }

    @Override
    public boolean samePatternAs(Pattern pattern, PatternStack patternStack) {
        return this.equals(pattern);
    }

    @Override
    public void toString(int n, NamespaceToPrefixes namespaceToPrefixes, StringBuilder stringBuilder) {
        stringBuilder.append(this.dataType.getDataTypeLabel(namespaceToPrefixes));
        stringBuilder.append(" \"");
        stringBuilder.append(this.value.formatData(namespaceToPrefixes));
        stringBuilder.append('\"');
    }

    public int hashCode() {
        return this.value.hashCode() ^ this.dataType.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ValuePattern)) {
            return false;
        }
        ValuePattern valuePattern = (ValuePattern)object;
        return this.value.equals(valuePattern.value) && this.dataType.equals(valuePattern.dataType);
    }

    @Override
    public Pattern textDeriv(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities, Builder builder) {
        try {
            Data data = this.dataType.parseData(string, prefixToNamespace, unparsedEntities);
            if (this.value.equals(data)) {
                return EmptyPattern.INSTANCE;
            }
            return NotAllowedPattern.INSTANCE;
        }
        catch (DataFormatException dataFormatException) {
            return NotAllowedPattern.INSTANCE;
        }
    }
}

