/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.TextNode;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.rng.validate.SAXTraversalException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

final class SAXTraversal
implements XMLReader,
Locator {
    public static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String NAMESPACE_PREFIX_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    public static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    public static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    public static final String PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/lexical-handler/parameter-entities";
    public static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    public static final String DECLARATION_HANDLER_PROPERTY = "http://xml.org/sax/properties/declaration-handler";
    private Document boundDocument;
    private List<Element> traversedElements;
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private DefaultHandler defaultHandler = new DefaultHandler();
    private ContentHandler handleContent = this.defaultHandler;
    private ErrorHandler handleError = this.defaultHandler;
    private Element tree;
    private PrefixPreferences prefixPreferences;
    private List<Element> elements = null;
    private AttributesImpl attributes = new AttributesImpl();
    private int[] lineNumbers = new int[10];
    private int lineNumberCount = 0;

    public SAXTraversal() {
        this(null, null);
    }

    public SAXTraversal(Document document) {
        this(document, null);
    }

    public SAXTraversal(Document document, List<Element> list) {
        this.boundDocument = document;
        this.traversedElements = list;
    }

    public Document getBoundDocument() {
        return this.boundDocument;
    }

    public List<Element> getTraversedElements() {
        return this.traversedElements;
    }

    public void traverse(Document document) throws SAXException {
        this.traverse(document, null);
    }

    public void traverse(Document document, List<Element> list) throws SAXException {
        this.traverse(document.getRootElement(), list);
    }

    public void traverse(Element element, List<Element> list) throws SAXException {
        this.tree = element;
        if (list != null) {
            list.clear();
            this.elements = list;
        } else {
            this.elements = new ArrayList<Element>();
        }
        try {
            this.doTraverse(element);
        }
        finally {
            element = null;
            this.prefixPreferences = null;
            this.elements = null;
            this.attributes.clear();
            this.popAllLineNumbers();
            this.handleContent = this.contentHandler;
            if (this.handleContent == null) {
                this.handleContent = this.defaultHandler;
            }
            this.handleError = this.errorHandler;
            if (this.handleError == null) {
                this.handleError = this.defaultHandler;
            }
        }
    }

    private void doTraverse(Element element) throws SAXException {
        int n;
        Object object;
        this.handleContent.setDocumentLocator(this);
        this.handleContent.startDocument();
        PrefixEntry[] prefixEntryArray = null;
        Document document = element.getDocument();
        if (document != null && (object = document.getProperty(Constants.NAMESPACE_PREFIX_MAP_PROPERTY)) != null && object instanceof PrefixPreferences) {
            this.prefixPreferences = (PrefixPreferences)object;
            prefixEntryArray = this.prefixPreferences.getAll();
        }
        if (prefixEntryArray == null) {
            object = new SAXTraversalException("cannot traverse tree '" + String.valueOf(element.getSourceURL()) + "': it is not attached to a document or its document has no NAMESPACE_PREFIX_MAP_PROPERTY property or the value of this property is not a PrefixPreferences)", this);
            this.handleError.fatalError((SAXParseException)object);
            throw object;
        }
        int n2 = prefixEntryArray.length;
        for (n = 0; n < n2; ++n) {
            void var6_7 = prefixEntryArray[n];
            this.handleContent.startPrefixMapping(var6_7.prefix, var6_7.namespace.uri);
        }
        this.traverse(element);
        for (n = n2 - 1; n >= 0; --n) {
            this.handleContent.endPrefixMapping(prefixEntryArray[n].prefix);
        }
        this.handleContent.endDocument();
    }

    private void traverse(Element element) throws SAXException {
        Comparable<Namespace> comparable;
        XNode xNode;
        this.elements.add(element);
        this.pushLineNumber(this.elements.size());
        Name name = element.getName();
        Namespace namespace = name.namespace;
        String string = namespace.uri;
        String string2 = name.localPart;
        String string3 = this.makeQName(namespace, string2);
        this.attributes.clear();
        Iterator<Attribute> iterator = element.getAttributes();
        while (iterator.hasNext()) {
            xNode = iterator.next();
            comparable = ((Attribute)xNode).name.namespace;
            String string4 = ((Attribute)xNode).name.localPart;
            String string5 = this.makeQName((Namespace)comparable, string4);
            this.attributes.addAttribute(((Namespace)comparable).uri, string4, string5, "CDATA", ((Attribute)xNode).value);
        }
        this.handleContent.startElement(string, string2, string3, this.attributes);
        block6: for (xNode = element.getFirstChild(); xNode != null; xNode = ((Node)xNode).getNextSibling()) {
            switch (((Node)xNode).getType()) {
                case TEXT: {
                    comparable = (Text)xNode;
                    this.handleContent.characters(((TextNode)comparable).getTextChars(), 0, ((TextNode)comparable).getTextLength());
                    continue block6;
                }
                case PROCESSING_INSTRUCTION: {
                    comparable = (ProcessingInstruction)xNode;
                    this.handleContent.processingInstruction(((ProcessingInstruction)comparable).getTarget(), ((TextNode)comparable).getText());
                    continue block6;
                }
                case ELEMENT: {
                    this.traverse((Element)xNode);
                }
            }
        }
        this.handleContent.endElement(string, string2, string3);
        this.popLineNumber();
    }

    private String makeQName(Namespace namespace, String string) throws SAXException {
        Object object;
        if (namespace == Namespace.NONE) {
            object = string;
        } else if (namespace == Namespace.XML) {
            object = "xml:" + string;
        } else {
            String string2 = this.prefixPreferences.get(namespace);
            if (string2 == null) {
                SAXTraversalException sAXTraversalException = new SAXTraversalException("don't find a prefix for namespace '" + String.valueOf(namespace) + "'", this);
                this.handleError.fatalError(sAXTraversalException);
                throw sAXTraversalException;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(':');
            stringBuilder.append(string);
            object = stringBuilder.toString();
        }
        return object;
    }

    private void pushLineNumber(int n) {
        if (this.lineNumberCount == this.lineNumbers.length) {
            int[] nArray = new int[2 * this.lineNumberCount];
            System.arraycopy(this.lineNumbers, 0, nArray, 0, this.lineNumberCount);
            this.lineNumbers = nArray;
        }
        this.lineNumbers[this.lineNumberCount++] = n;
    }

    private void popLineNumber() {
        --this.lineNumberCount;
    }

    private void popAllLineNumbers() {
        this.lineNumberCount = 0;
    }

    public Document getDocument() {
        return this.tree == null ? null : this.tree.getDocument();
    }

    public Element getElementAt(int n) {
        if (this.elements == null) {
            return null;
        }
        return SAXTraversal.getElementAt(this.elements, n);
    }

    public static Element getElementAt(List<Element> list, int n) {
        if (n > 0 && n <= list.size()) {
            return list.get(n - 1);
        }
        return null;
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE.equals(string)) {
            return true;
        }
        if (NAMESPACE_PREFIX_FEATURE.equals(string)) {
            return false;
        }
        if (VALIDATION_FEATURE.equals(string)) {
            return false;
        }
        if (EXTERNAL_GENERAL_ENTITIES_FEATURE.equals(string)) {
            return false;
        }
        if (EXTERNAL_PARAMETER_ENTITIES_FEATURE.equals(string)) {
            return false;
        }
        if (PARAMETER_ENTITIES_FEATURE.equals(string)) {
            return false;
        }
        throw new SAXNotRecognizedException("unknown feature " + string);
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE.equals(string)) {
            if (!bl) {
                throw new SAXNotSupportedException("unsupported value for feature " + string);
            }
        } else if (NAMESPACE_PREFIX_FEATURE.equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException("unsupported value for feature " + string);
            }
        } else if (VALIDATION_FEATURE.equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException("unsupported value for feature " + string);
            }
        } else if (EXTERNAL_GENERAL_ENTITIES_FEATURE.equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException("unsupported value for feature " + string);
            }
        } else if (EXTERNAL_PARAMETER_ENTITIES_FEATURE.equals(string)) {
            if (bl) {
                throw new SAXNotSupportedException(string);
            }
        } else if (PARAMETER_ENTITIES_FEATURE.equals("unsupported value for feature " + string)) {
            if (bl) {
                throw new SAXNotSupportedException("unsupported value for feature " + string);
            }
        } else {
            throw new SAXNotRecognizedException("unknown feature " + string);
        }
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROPERTY.equals(string) || DECLARATION_HANDLER_PROPERTY.equals(string)) {
            return null;
        }
        throw new SAXNotRecognizedException("unknown property " + string);
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROPERTY.equals(string) || DECLARATION_HANDLER_PROPERTY.equals(string)) {
            if (object != null) {
                throw new SAXNotSupportedException("unsupported value for property " + string);
            }
        } else {
            throw new SAXNotRecognizedException("unknown property " + string);
        }
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = this.handleContent = contentHandler;
        if (this.handleContent == null) {
            this.handleContent = this.defaultHandler;
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = this.handleError = errorHandler;
        if (this.handleError == null) {
            this.handleError = this.defaultHandler;
        }
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(String string) throws IOException, SAXException {
        this.parse((InputSource)null);
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.boundDocument == null) {
            throw new UnsupportedOperationException("no bound document, please directly use traverse(Document)");
        }
        this.traverse(this.boundDocument, this.traversedElements);
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        URL uRL;
        if (this.tree == null || (uRL = this.tree.getSourceURL()) == null) {
            return null;
        }
        return uRL.toExternalForm();
    }

    @Override
    public int getLineNumber() {
        return this.lineNumberCount > 0 ? this.lineNumbers[this.lineNumberCount - 1] : -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }
}

