/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.thaiopensource.relaxng.impl.CompactSchemaReader;
import com.thaiopensource.relaxng.impl.RngProperty;
import com.thaiopensource.relaxng.impl.SAXSchemaReader;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.URLUtil;
import com.xmlmind.util.XMLUtil;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.load.LoadError;
import com.xmlmind.xml.load.LoadErrorImpl;
import com.xmlmind.xml.load.RNGLoader;
import com.xmlmind.xml.resolve.XMLCatalogs;
import com.xmlmind.xml.rng.datatype.LibraryFactoryImpl;
import com.xmlmind.xml.rng.validate.DTDCompatibilityException;
import com.xmlmind.xml.rng.validate.SAXTraversal;
import com.xmlmind.xml.rng.validate.SAXTraversalException;
import com.xmlmind.xml.rng.validate.SubDocumentTypeImpl;
import com.xmlmind.xml.rng.validate.TranslatorException;
import com.xmlmind.xml.validate.SubDocumentType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class RNGLoaderImpl
implements RNGLoader,
ErrorHandler,
XMLReaderCreator {
    private static final EntityResolverImpl RESOLVER_INSTANCE = new EntityResolverImpl();
    private static final XMLReaderCreatorImpl READER_CREATOR_INSTANCE = new XMLReaderCreatorImpl();
    private PropertyMap props1;
    private PropertyMap props2;
    private SAXTraversal saxTraversal;
    private boolean passSAXTraversal;
    private URL traversedGrammarFile;
    private Document traversedGrammarDoc;
    private ArrayList<LoadErrorImpl> errorList = new ArrayList();
    private ArrayList<LoadErrorImpl> warningList = new ArrayList();
    private LoadErrorImpl[] errors;
    private LoadErrorImpl[] warnings;

    public RNGLoaderImpl() {
        LibraryFactoryImpl libraryFactoryImpl = new LibraryFactoryImpl();
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        RngProperty.DATATYPE_LIBRARY_FACTORY.put(propertyMapBuilder, (DatatypeLibraryFactory)libraryFactoryImpl);
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, (ErrorHandler)this);
        ValidateProperty.XML_READER_CREATOR.put(propertyMapBuilder, (XMLReaderCreator)READER_CREATOR_INSTANCE);
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        this.props1 = propertyMapBuilder.toPropertyMap();
        propertyMapBuilder = new PropertyMapBuilder();
        RngProperty.DATATYPE_LIBRARY_FACTORY.put(propertyMapBuilder, (DatatypeLibraryFactory)libraryFactoryImpl);
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, (ErrorHandler)this);
        ValidateProperty.XML_READER_CREATOR.put(propertyMapBuilder, (XMLReaderCreator)this);
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        this.props2 = propertyMapBuilder.toPropertyMap();
    }

    @Override
    public SubDocumentType loadSubDocumentType(URL uRL) throws IOException {
        String string = URLUtil.getExtension(uRL);
        if (string == null) {
            string = "";
        }
        return this.loadSubDocumentType(uRL, "rnc".equalsIgnoreCase(string), null);
    }

    @Override
    public SubDocumentType loadSubDocumentType(URL uRL, boolean bl, String string) throws IOException {
        this.initLoading(null, false, uRL, null);
        SchemaReader schemaReader = bl ? CompactSchemaReader.getInstance() : SAXSchemaReader.getInstance();
        InputSource inputSource = new InputSource(uRL.toExternalForm());
        if (bl && string != null) {
            inputSource.setEncoding(string);
        }
        try {
            Schema schema = schemaReader.createSchema(inputSource, this.props1);
            return this.createSubDocumentType(schema, uRL);
        }
        catch (SAXException sAXException) {
        }
        catch (IncorrectSchemaException incorrectSchemaException) {
        }
        catch (DTDCompatibilityException dTDCompatibilityException) {
            DTDCompatibilityException.Error[] errorArray = dTDCompatibilityException.getErrors();
            for (int i = 0; i < errorArray.length; ++i) {
                DTDCompatibilityException.Error error = errorArray[i];
                this.errorList.add(this.createLoadError(error.systemId, error.lineNumber, error.columnNumber, error.message));
            }
        }
        catch (TranslatorException translatorException) {
            this.errorList.add(new LoadErrorImpl(LoadError.Type.DOCUMENT_TYPE, uRL, -1, -1, translatorException.getMessage()));
        }
        this.finishLoading();
        return null;
    }

    private void initLoading(SAXTraversal sAXTraversal, boolean bl, URL uRL, Document document) {
        this.saxTraversal = sAXTraversal;
        this.passSAXTraversal = bl;
        this.traversedGrammarFile = uRL;
        this.traversedGrammarDoc = document;
        this.errorList.clear();
        this.warningList.clear();
        this.errors = LoadErrorImpl.NO_ERRORS;
        this.warnings = LoadErrorImpl.NO_ERRORS;
    }

    private void finishLoading() {
        this.errors = this.errorList.toArray(LoadErrorImpl.NO_ERRORS);
        this.warnings = this.warningList.toArray(LoadErrorImpl.NO_ERRORS);
        this.errorList.clear();
        this.warningList.clear();
        this.saxTraversal = null;
        this.passSAXTraversal = false;
        this.traversedGrammarFile = null;
        this.traversedGrammarDoc = null;
    }

    protected SubDocumentTypeImpl createSubDocumentType(Schema schema, URL uRL) throws TranslatorException {
        return new SubDocumentTypeImpl(schema, uRL);
    }

    @Override
    public LoadError[] getLoadErrors() {
        return this.errors;
    }

    @Override
    public LoadError[] getLoadWarnings() {
        return this.warnings;
    }

    @Override
    public SubDocumentType loadSubDocumentType(Document document) {
        SAXTraversal sAXTraversal = new SAXTraversal(document, new ArrayList<Element>());
        sAXTraversal.setEntityResolver(new EntityResolverImpl());
        this.initLoading(sAXTraversal, true, null, document);
        try {
            Schema schema = SAXSchemaReader.getInstance().createSchema(new InputSource(), this.props2);
            return new SubDocumentTypeImpl(schema, document.getSourceURL());
        }
        catch (IOException iOException) {
            this.errorList.add(new LoadErrorImpl(LoadError.Type.DOCUMENT_TYPE, document.getRootElement(), ThrowableUtil.reason(iOException)));
        }
        catch (SAXTraversalException sAXTraversalException) {
            Element element = this.getElementInError(sAXTraversalException.getSystemId(), sAXTraversalException.getLineNumber());
            if (element != null) {
                this.errorList.add(new LoadErrorImpl(LoadError.Type.DOCUMENT_TYPE, element, sAXTraversalException.getMessage()));
            }
        }
        catch (SAXException sAXException) {
        }
        catch (IncorrectSchemaException incorrectSchemaException) {
        }
        catch (DTDCompatibilityException dTDCompatibilityException) {
            DTDCompatibilityException.Error[] errorArray = dTDCompatibilityException.getErrors();
            for (int i = 0; i < errorArray.length; ++i) {
                DTDCompatibilityException.Error error = errorArray[i];
                Element element = this.getElementInError(error.systemId, error.lineNumber);
                if (element == null) continue;
                this.errorList.add(new LoadErrorImpl(LoadError.Type.DOCUMENT_TYPE, element, error.message));
            }
        }
        catch (TranslatorException translatorException) {
            this.errorList.add(new LoadErrorImpl(LoadError.Type.DOCUMENT_TYPE, document.getRootElement(), translatorException.getMessage()));
        }
        this.finishLoading();
        return null;
    }

    public XMLReader createXMLReader() throws SAXException {
        if (this.passSAXTraversal) {
            this.passSAXTraversal = false;
            return this.saxTraversal;
        }
        return READER_CREATOR_INSTANCE.createXMLReader();
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.addError(sAXParseException, true);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.addError(sAXParseException, false);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.addError(sAXParseException, false);
        throw sAXParseException;
    }

    private void addError(SAXParseException sAXParseException, boolean bl) {
        String string = sAXParseException.getSystemId();
        int n = sAXParseException.getLineNumber();
        String string2 = sAXParseException.getMessage();
        LoadErrorImpl loadErrorImpl = null;
        if (this.saxTraversal == null) {
            loadErrorImpl = this.createLoadError(string, n, sAXParseException.getColumnNumber(), string2);
        } else {
            Element element = this.getElementInError(string, n);
            if (element != null) {
                loadErrorImpl = new LoadErrorImpl(LoadError.Type.DOCUMENT_TYPE, element, string2);
            }
        }
        if (loadErrorImpl != null) {
            if (bl) {
                this.warningList.add(loadErrorImpl);
            } else {
                this.errorList.add(loadErrorImpl);
            }
        }
    }

    private LoadErrorImpl createLoadError(String string, int n, int n2, String string2) {
        if (this.saxTraversal != null) {
            return null;
        }
        URL uRL = null;
        if (string != null) {
            try {
                uRL = URLUtil.newURL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL == null) {
            uRL = this.traversedGrammarFile;
            n2 = -1;
            n = -1;
        }
        return new LoadErrorImpl(LoadError.Type.DOCUMENT_TYPE, uRL, n, n2, string2);
    }

    private Element getElementInError(String string, int n) {
        if (this.saxTraversal == null) {
            return null;
        }
        if (string == null) {
            return this.traversedGrammarDoc.getRootElement();
        }
        List<Element> list = this.traversedGrammarDoc.getSourceURL().toExternalForm();
        if (!string.equals(list)) {
            return null;
        }
        list = this.saxTraversal.getTraversedElements();
        if (list == null) {
            return null;
        }
        return SAXTraversal.getElementAt(list, n);
    }

    private static final class XMLReaderCreatorImpl
    implements XMLReaderCreator {
        private XMLReaderCreatorImpl() {
        }

        public XMLReader createXMLReader() throws SAXException {
            try {
                XMLReader xMLReader = XMLUtil.newSAXParser().getXMLReader();
                xMLReader.setEntityResolver(RESOLVER_INSTANCE);
                return xMLReader;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException(parserConfigurationException);
            }
        }
    }

    private static final class EntityResolverImpl
    implements EntityResolver {
        private EntityResolverImpl() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            String string3 = XMLCatalogs.resolveURI(string2);
            if (string3 == null) {
                string3 = string2;
            }
            string3 = URIComponent.encode(string3);
            return new InputSource(string3);
        }
    }
}

