/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.TextNode;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.rng.validate.AttributeField;
import com.xmlmind.xml.rng.validate.Builder;
import com.xmlmind.xml.rng.validate.ChoicePattern;
import com.xmlmind.xml.rng.validate.EmptyPattern;
import com.xmlmind.xml.rng.validate.FieldBase;
import com.xmlmind.xml.rng.validate.FieldSet;
import com.xmlmind.xml.rng.validate.InterleavePattern;
import com.xmlmind.xml.rng.validate.ItemList;
import com.xmlmind.xml.rng.validate.Matcher;
import com.xmlmind.xml.rng.validate.NameClassBase;
import com.xmlmind.xml.rng.validate.NotAllowedPattern;
import com.xmlmind.xml.rng.validate.Occurrence;
import com.xmlmind.xml.rng.validate.OneOrMorePattern;
import com.xmlmind.xml.rng.validate.OverlapDetector;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.PatternList;
import com.xmlmind.xml.rng.validate.PatternStack;
import com.xmlmind.xml.rng.validate.SingleNameClass;
import com.xmlmind.xml.rng.validate.TextPattern;
import com.xmlmind.xml.validate.AttributeType;
import com.xmlmind.xml.validate.CommentItem;
import com.xmlmind.xml.validate.ContentType;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataFormatException;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.DocumentTypeUtil;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.Item;
import com.xmlmind.xml.validate.NameClass;
import com.xmlmind.xml.validate.Structure;
import com.xmlmind.xml.validate.TextItem;
import com.xmlmind.xml.validate.UncheckedUnparsedEntities;
import com.xmlmind.xml.wxs.datatype.IDType;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class ElementField
extends FieldBase
implements ElementType {
    public ContentType contentType;
    public AttributeField[] attributeFields;
    public boolean[] attributeIsRequired;
    public ElementField[] childElementFields;
    public boolean[] childElementIsRequired;
    public boolean hasAttributeDefaultValues;
    private IdentityHashMap<Field, Field[]> ambiguousFields;
    public static final int TEST_CREATE_INSTANCE = 0x40000000;

    public ElementField(NameClassBase nameClassBase, Pattern pattern, Builder builder) {
        this.initialize(nameClassBase, pattern, builder);
        this.prepare();
    }

    public ElementField() {
    }

    @Override
    protected void prepare() {
        boolean bl;
        FieldBase fieldBase;
        PatternStack patternStack = new PatternStack();
        IdentityHashMap<AttributeField, Boolean> identityHashMap = new IdentityHashMap<AttributeField, Boolean>();
        IdentityHashMap<ElementField, Boolean> identityHashMap2 = new IdentityHashMap<ElementField, Boolean>();
        this.contentType = this.pattern.scan(patternStack, identityHashMap, identityHashMap2);
        int n = identityHashMap.size();
        this.attributeFields = new AttributeField[n];
        this.attributeIsRequired = new boolean[n];
        this.hasAttributeDefaultValues = false;
        if (n > 0) {
            n = 0;
            for (Map.Entry<AttributeField, Boolean> entry : identityHashMap.entrySet()) {
                fieldBase = entry.getKey();
                bl = entry.getValue() == Boolean.TRUE;
                this.attributeFields[n] = fieldBase;
                this.attributeIsRequired[n] = bl;
                ++n;
                if (this.hasAttributeDefaultValues || fieldBase.defaultValueAnnotation == null) continue;
                this.hasAttributeDefaultValues = true;
            }
        }
        n = identityHashMap2.size();
        this.childElementFields = new ElementField[n];
        this.childElementIsRequired = new boolean[n];
        if (n > 0) {
            n = 0;
            for (Map.Entry<FieldBase, Boolean> entry : identityHashMap2.entrySet()) {
                fieldBase = (ElementField)entry.getKey();
                bl = entry.getValue() == Boolean.TRUE;
                this.childElementFields[n] = fieldBase;
                this.childElementIsRequired[n] = bl;
                ++n;
            }
        }
        switch (this.contentType) {
            case DATA: {
                this.initDataType();
                break;
            }
            case MIXED1: {
                this.contentType = this.getMixedContentType();
            }
        }
        ArrayList arrayList = new ArrayList();
        this.ambiguousFields = new IdentityHashMap();
        if (this.attributeFields.length > 0) {
            ElementField.checkAmbiguity(this.attributeFields, arrayList, this.ambiguousFields);
        }
        if (this.childElementFields.length > 0) {
            ElementField.checkAmbiguity(this.childElementFields, arrayList, this.ambiguousFields);
        }
        if (this.ambiguousFields.size() == 0) {
            this.ambiguousFields = null;
        }
    }

    @Override
    protected Pattern doFactorize(Builder builder, FieldSet fieldSet, FieldSet fieldSet2, IdentityHashMap<Pattern, Pattern> identityHashMap) {
        ElementField elementField = (ElementField)fieldSet2.add(this);
        if (elementField == this) {
            ElementField elementField2 = new ElementField();
            identityHashMap.put(this, elementField2);
            elementField2.initialize(this.nameClass, this.pattern.factorize(builder, fieldSet, fieldSet2, identityHashMap), builder);
            return elementField2;
        }
        return identityHashMap.get(elementField);
    }

    @Override
    protected ContentType scan(PatternStack patternStack, IdentityHashMap<AttributeField, Boolean> identityHashMap, IdentityHashMap<ElementField, Boolean> identityHashMap2) {
        int n;
        boolean bl = true;
        for (n = patternStack.size - 1; n >= 0; --n) {
            Pattern pattern = patternStack.list[n];
            if (!(pattern instanceof ChoicePattern)) continue;
            bl = false;
            break;
        }
        n = identityHashMap2.get(this) == Boolean.TRUE ? 1 : 0;
        bl = n != 0 || bl;
        identityHashMap2.put(this, bl ? Boolean.TRUE : Boolean.FALSE);
        return ContentType.ELEMENT_ONLY;
    }

    private ContentType getMixedContentType() {
        int n;
        Pattern pattern = this.pattern;
        if (this.attributeFields.length > 0) {
            if (pattern.attributesSeparatedFromElements() > 2) {
                return ContentType.OTHER;
            }
            pattern = pattern.withoutAttributes(this.builder);
        }
        if (!pattern.nullable) {
            return ContentType.OTHER;
        }
        if (pattern == TextPattern.INSTANCE) {
            return ContentType.MIXED2;
        }
        PatternList patternList = new PatternList();
        Occurrence occurrence = Occurrence.which(pattern);
        if (occurrence.pattern instanceof InterleavePattern) {
            InterleavePattern interleavePattern = (InterleavePattern)occurrence.pattern;
            interleavePattern.getInterleaved(patternList);
        } else {
            patternList.add(pattern);
        }
        boolean bl = false;
        block6: for (n = 0; n < patternList.size; ++n) {
            Pattern pattern2 = patternList.list[n];
            switch (ElementField.scanMix(pattern2)) {
                case EMPTY: {
                    continue block6;
                }
                case TEXT: {
                    bl = true;
                    continue block6;
                }
                case ELEMENT_ONLY: {
                    occurrence = Occurrence.which(pattern2);
                    if (occurrence.occurrence == Occurrence.Op.ZERO_OR_MORE || occurrence.occurrence == Occurrence.Op.ONE_OR_MORE && occurrence.pattern.nullable) continue block6;
                    break block6;
                }
                case MIXED: {
                    occurrence = Occurrence.which(pattern2);
                    if (occurrence.occurrence != Occurrence.Op.ZERO_OR_MORE && occurrence.occurrence != Occurrence.Op.ONE_OR_MORE) break block6;
                    bl = true;
                    continue block6;
                }
            }
        }
        if (bl && n == patternList.size) {
            return ContentType.MIXED2;
        }
        return ContentType.OTHER;
    }

    private static final Mix scanMix(Pattern pattern) {
        if (pattern == EmptyPattern.INSTANCE) {
            return Mix.EMPTY;
        }
        if (pattern == TextPattern.INSTANCE) {
            return Mix.TEXT;
        }
        if (pattern instanceof ElementField) {
            return Mix.ELEMENT_ONLY;
        }
        if (pattern instanceof OneOrMorePattern) {
            OneOrMorePattern oneOrMorePattern = (OneOrMorePattern)pattern;
            return ElementField.scanMix(oneOrMorePattern.pattern);
        }
        if (pattern instanceof ChoicePattern) {
            ChoicePattern choicePattern = (ChoicePattern)pattern;
            Mix mix = ElementField.scanMix(choicePattern.pattern1);
            Mix mix2 = ElementField.scanMix(choicePattern.pattern2);
            if (mix == Mix.TEXT && mix2 == Mix.ELEMENT_ONLY || mix == Mix.ELEMENT_ONLY && mix2 == Mix.TEXT) {
                return Mix.MIXED;
            }
            if (mix.ordinal() >= mix2.ordinal()) {
                return mix;
            }
            return mix2;
        }
        return Mix.OTHER;
    }

    private static final void checkAmbiguity(Field[] fieldArray, ArrayList<Field> arrayList, IdentityHashMap<Field, Field[]> identityHashMap) {
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field[] fieldArray2;
            int n2;
            Field field = fieldArray[i];
            Name name = field.getFieldName();
            arrayList.clear();
            for (n2 = 0; n2 < n; ++n2) {
                NameClass nameClass;
                if (n2 == i) continue;
                fieldArray2 = fieldArray[n2];
                Name name2 = fieldArray2.getFieldName();
                if (name != null) {
                    if (name2 != null) {
                        if (name != name2) continue;
                        arrayList.add((Field)fieldArray2);
                        continue;
                    }
                    if (!fieldArray2.getFieldNameClass().containsName(name)) continue;
                    arrayList.add((Field)fieldArray2);
                    continue;
                }
                if (name2 != null) {
                    if (!field.getFieldNameClass().containsName(name2)) continue;
                    arrayList.add((Field)fieldArray2);
                    continue;
                }
                NameClass nameClass2 = field.getFieldNameClass();
                if (!OverlapDetector.overlap((NameClassBase)nameClass2, (NameClassBase)(nameClass = fieldArray2.getFieldNameClass()))) continue;
                arrayList.add((Field)fieldArray2);
            }
            n2 = arrayList.size();
            if (n2 <= 0) continue;
            fieldArray2 = new Field[n2];
            arrayList.toArray(fieldArray2);
            identityHashMap.put(field, fieldArray2);
        }
    }

    @Override
    public boolean samePatternAs(Pattern pattern, PatternStack patternStack) {
        int n;
        if (pattern == null || !(pattern instanceof ElementField)) {
            return false;
        }
        ElementField elementField = (ElementField)pattern;
        if (!this.nameClass.equals(elementField.nameClass)) {
            return false;
        }
        Pattern[] patternArray = patternStack.list;
        for (n = patternStack.size - 2; n >= 0; n -= 2) {
            if (patternArray[n] != this || patternArray[n + 1] != pattern) continue;
            return true;
        }
        patternStack.push(this, pattern);
        n = ElementField.samePattern(this.pattern, elementField.pattern, patternStack) ? 1 : 0;
        patternStack.pop2();
        return n != 0;
    }

    @Override
    public void toString(int n, NamespaceToPrefixes namespaceToPrefixes, StringBuilder stringBuilder) {
        boolean bl;
        boolean bl2 = bl = stringBuilder.length() == 0;
        if (!bl) {
            n = -1;
        }
        stringBuilder.append("element ");
        this.nameClass.toLabel(false, namespaceToPrefixes, stringBuilder);
        stringBuilder.append(" {");
        if (n >= 0) {
            stringBuilder.append('\n');
            ElementField.indent(n + 2, stringBuilder);
        }
        if (bl) {
            this.pattern.toString(n >= 0 ? n + 2 : -1, namespaceToPrefixes, stringBuilder);
        } else {
            stringBuilder.append("...");
        }
        if (n >= 0) {
            stringBuilder.append('\n');
            ElementField.indent(n, stringBuilder);
        }
        stringBuilder.append("}");
    }

    public int hashCode() {
        return this.nameClass.hashCode() ^ System.identityHashCode(this.pattern);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ElementField)) {
            return false;
        }
        ElementField elementField = (ElementField)object;
        return this.nameClass.equals(elementField.nameClass) && this.pattern == elementField.pattern;
    }

    @Override
    public Pattern elementDeriv(ElementField elementField, Builder builder) {
        if (elementField == this) {
            return EmptyPattern.INSTANCE;
        }
        return NotAllowedPattern.INSTANCE;
    }

    @Override
    public Pattern elementDeriv(Element element, IdentityHashMap<Field, Field[]> identityHashMap, boolean bl, FieldBase[] fieldBaseArray, Builder builder) {
        if (this.nameClass.containsName(element.getName())) {
            Field[] fieldArray;
            if (identityHashMap != null && (fieldArray = identityHashMap.get(this)) != null) {
                Structure structure;
                if (!this.matchContent(element)) {
                    return NotAllowedPattern.INSTANCE;
                }
                boolean bl2 = false;
                int n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    ElementField elementField = (ElementField)fieldArray[i];
                    if (!elementField.matchContent(element)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 && !Matcher.match(this.pattern, this.ambiguousFields, element, bl, structure = new Structure(), builder)) {
                    return NotAllowedPattern.INSTANCE;
                }
            }
            fieldBaseArray[0] = this;
            return EmptyPattern.INSTANCE;
        }
        return NotAllowedPattern.INSTANCE;
    }

    private boolean matchContent(Element element) {
        int n;
        Comparable<XNode> comparable;
        Object object;
        int n2 = this.attributeFields.length;
        if (n2 > 0) {
            object = (boolean[])this.attributeIsRequired.clone();
            if (element.getAttributeCount() > 0) {
                Iterator<Attribute> iterator = element.getAttributes();
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    comparable = attribute.name;
                    boolean bl = false;
                    for (int i = 0; i < n2; ++i) {
                        AttributeField attributeField = this.attributeFields[i];
                        if (!attributeField.nameClass.containsName((Name)comparable)) continue;
                        n = 1;
                        if (attributeField.fixedValue != null && !ElementField.sameFixedValue(attribute, attributeField)) {
                            n = 0;
                        }
                        if (n == 0) continue;
                        bl = true;
                        object[i] = false;
                        break;
                    }
                    if (bl) continue;
                    return false;
                }
            }
            for (int i = 0; i < n2; ++i) {
                if (!object[i]) continue;
                return false;
            }
        } else if (element.getAttributeCount() > 0) {
            return false;
        }
        if (this.dataType != null) {
            object = element.getText();
            if (object == null) {
                return false;
            }
            Data data = null;
            try {
                data = this.dataType.parseData((String)object, element, UncheckedUnparsedEntities.INSTANCE);
            }
            catch (DataFormatException dataFormatException) {
                return false;
            }
            if (this.fixedValue != null && !this.fixedValue.equals(data)) {
                return false;
            }
        } else {
            int n3 = this.childElementFields.length;
            boolean[] blArray = (boolean[])this.childElementIsRequired.clone();
            boolean bl = false;
            block12: for (comparable = element.getFirstChild(); comparable != null; comparable = ((Node)comparable).getNextSibling()) {
                switch (((Node)comparable).getType()) {
                    case TEXT: {
                        if (((Text)comparable).isXMLSpace()) continue block12;
                        bl = true;
                        continue block12;
                    }
                    case ELEMENT: {
                        Element element2 = (Element)comparable;
                        Name name = element2.getName();
                        boolean bl2 = false;
                        for (n = 0; n < n3; ++n) {
                            ElementField elementField = this.childElementFields[n];
                            if (!elementField.nameClass.containsName(name)) continue;
                            boolean bl3 = true;
                            if (elementField.fixedValue != null && !ElementField.sameFixedValue(element2, elementField)) {
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            bl2 = true;
                            blArray[n] = false;
                            break;
                        }
                        if (bl2) continue block12;
                        return false;
                    }
                }
            }
            if (bl) {
                switch (this.contentType) {
                    case MIXED1: 
                    case MIXED2: 
                    case OTHER: {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            for (int i = 0; i < n3; ++i) {
                if (!blArray[i]) continue;
                return false;
            }
        }
        return true;
    }

    private static final boolean sameFixedValue(Attribute attribute, AttributeField attributeField) {
        Data data = null;
        try {
            data = attributeField.dataType.parseData(attribute.value, attribute.element, UncheckedUnparsedEntities.INSTANCE);
        }
        catch (DataFormatException dataFormatException) {
            return false;
        }
        return attributeField.fixedValue.equals(data);
    }

    private static final boolean sameFixedValue(Element element, ElementField elementField) {
        String string = element.getText();
        if (string == null) {
            return false;
        }
        Data data = null;
        try {
            data = elementField.dataType.parseData(string, element, UncheckedUnparsedEntities.INSTANCE);
        }
        catch (DataFormatException dataFormatException) {
            return false;
        }
        return elementField.fixedValue.equals(data);
    }

    @Override
    public ContentType getElementContentType() {
        return this.contentType;
    }

    @Override
    public DataType getElementDataType() {
        return this.dataType;
    }

    @Override
    public Object getElementFixedValue() {
        return this.fixedValue;
    }

    @Override
    public Object getElementDefaultValue() {
        return null;
    }

    @Override
    public Field[] getAttributeFields() {
        return this.attributeFields;
    }

    @Override
    public void getAttributeFields(Name name, List<Field> list) {
        list.clear();
        for (AttributeField attributeField : this.attributeFields) {
            Name name2 = attributeField.getFieldName();
            if (name2 == null) {
                if (!attributeField.getFieldNameClass().containsName(name)) continue;
                list.add(attributeField);
                continue;
            }
            if (name != name2) continue;
            list.add(attributeField);
        }
    }

    @Override
    public boolean isRequiredAttribute(Field field) {
        int n = this.attributeFields.length;
        for (int i = 0; i < n; ++i) {
            if (this.attributeFields[i] != field) continue;
            return this.attributeIsRequired[i];
        }
        return false;
    }

    @Override
    public Data getAttributeDefaultValue(Name name) {
        for (AttributeField attributeField : this.attributeFields) {
            if (name != attributeField.getFieldName()) continue;
            return attributeField.getAttributeDefaultValue();
        }
        return null;
    }

    @Override
    public Field[] getChildElementFields() {
        return this.childElementFields;
    }

    @Override
    public void getChildElementFields(Name name, List<Field> list) {
        list.clear();
        for (ElementField elementField : this.childElementFields) {
            Name name2 = elementField.getFieldName();
            if (name2 == null) {
                if (!elementField.getFieldNameClass().containsName(name)) continue;
                list.add(elementField);
                continue;
            }
            if (name != name2) continue;
            list.add(elementField);
        }
    }

    @Override
    public boolean canCheckAttributeStructure() {
        return false;
    }

    @Override
    public boolean checkStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        return Matcher.match(this.pattern, fieldArray, n, itemArray, n2, this.builder);
    }

    @Override
    public boolean checkAttributeStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        return this.checkStructure(fieldArray, n, itemArray, n2);
    }

    @Override
    public boolean checkElementStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        return this.checkStructure(fieldArray, n, itemArray, n2);
    }

    @Override
    public boolean getStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        return Matcher.match(this.pattern, this.ambiguousFields, attributeArray, n, nodeArray, n2, bl, structure, this.builder);
    }

    @Override
    public boolean getStructure(Element element, boolean bl, Structure structure) {
        return Matcher.match(this.pattern, this.ambiguousFields, element, bl, structure, this.builder);
    }

    @Override
    public boolean getAttributeStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        return this.getStructure(attributeArray, n, nodeArray, n2, bl, structure);
    }

    @Override
    public boolean getAttributeStructure(Element element, boolean bl, Structure structure) {
        return this.getStructure(element, bl, structure);
    }

    @Override
    public boolean getElementStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        return this.getStructure(attributeArray, n, nodeArray, n2, bl, structure);
    }

    @Override
    public boolean getElementStructure(Element element, boolean bl, Structure structure) {
        return this.getStructure(element, bl, structure);
    }

    @Override
    public AttributeType getAttributeType(Field field, Name name) {
        return (AttributeField)field;
    }

    @Override
    public ElementType getChildElementType(Field field, Name name) {
        return (ElementField)field;
    }

    @Override
    public ElementType getChildElementType(Field field, Element element) {
        return (ElementField)field;
    }

    @Override
    public Element createInstance(Name name, int n) {
        Element element = new Element(name);
        ItemList itemList = new ItemList();
        if (!this.expand(n, itemList)) {
            return element;
        }
        this.initElement(n, itemList.list, 1, itemList.size, element);
        if (this.fixedValue != null) {
            ElementField.initFixedValue(this, element);
        }
        ElementField.initText(this, n, element);
        return element;
    }

    private int initElement(int n, Item[] itemArray, int n2, int n3, Element element) {
        Item item;
        int n4;
        for (n4 = n2; n4 < n3 && (item = itemArray[n4]) != CommentItem.INSTANCE; ++n4) {
            Object object;
            Name name;
            Object object2;
            if (item == TextItem.INSTANCE) {
                object2 = new Text();
                if ((n & 0x40000000) != 0) {
                    ((TextNode)object2).setText("#text");
                }
                element.appendChild((Node)object2);
                continue;
            }
            if (item instanceof AttributeField) {
                object2 = (AttributeField)item;
                name = ((AttributeField)object2).nameClass.getInstance();
                object = null;
                if ((n & 0x20) != 0) {
                    object = "";
                } else if ((n & 2) != 0 && ((AttributeField)object2).dataType instanceof IDType) {
                    object = DocumentTypeUtil.generateUniqueId();
                }
                if (object == null) {
                    object = ((AttributeField)object2).fixedValue != null ? ((AttributeField)object2).fixedValue.formatData(null) : "???";
                }
                if (name == null) continue;
                element.putAttribute(name, (String)object);
                continue;
            }
            object2 = (ElementField)item;
            name = ((ElementField)object2).nameClass.getInstance();
            object = new Element(name == null ? Name.get("x") : name);
            n4 = this.initElement(n, itemArray, n4 + 1, n3, (Element)object);
            if (name == null) continue;
            if (((ElementField)object2).fixedValue != null) {
                ElementField.initFixedValue((ElementField)object2, (Element)object);
            }
            ElementField.initText((ElementField)object2, n, (Element)object);
            element.appendChild((Node)object);
        }
        return n4;
    }

    private static final void initFixedValue(ElementField elementField, Element element) {
        Text text = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Text)) continue;
            if (text == null) {
                text = (Text)node;
                continue;
            }
            text = null;
            break;
        }
        if (text != null) {
            text.setText(elementField.fixedValue.formatData(null));
        }
    }

    private static final void initText(ElementField elementField, int n, Element element) {
        switch (elementField.contentType) {
            case DATA: 
            case MIXED1: 
            case MIXED2: 
            case OTHER: {
                if (!element.hasNoContent() || elementField.contentType == ContentType.OTHER && element.getAttributeCount() != 0) break;
                Text text = new Text();
                if ((n & 0x40000000) != 0) {
                    text.setText("#text");
                }
                element.appendChild(text);
            }
        }
    }

    @Override
    protected int getComplexity(boolean bl) {
        int n = 200;
        n = this.nameClass instanceof SingleNameClass ? (n += ((SingleNameClass)this.nameClass).name.localPart.length()) : (n += 1000);
        if (bl) {
            n += this.pattern.getComplexity(false);
        }
        return n;
    }

    @Override
    protected boolean expand(int n, ItemList itemList) {
        if ((n & 4) != 0 || itemList.size == 0) {
            if (!ElementField.checkRecursion(itemList, this)) {
                return false;
            }
            int n2 = itemList.size;
            itemList.add(this);
            if (!this.pattern.expand(n, itemList)) {
                itemList.setSize(n2);
                return false;
            }
            itemList.add(CommentItem.INSTANCE);
        }
        return true;
    }

    private static boolean checkRecursion(ItemList itemList, ElementField elementField) {
        int n = 0;
        for (int i = itemList.size - 1; i >= 0; --i) {
            Item item = itemList.list[i];
            if (item == CommentItem.INSTANCE) {
                ++n;
                continue;
            }
            if (!(item instanceof ElementField)) continue;
            if (n > 0) {
                --n;
                continue;
            }
            if (item != elementField) continue;
            return false;
        }
        return true;
    }

    public boolean isAmbiguousField(Field field) {
        return this.ambiguousFields != null && this.ambiguousFields.containsKey(field);
    }

    public boolean hasAmbiguousFields() {
        return this.ambiguousFields != null;
    }

    private static enum Mix {
        EMPTY,
        TEXT,
        ELEMENT_ONLY,
        MIXED,
        OTHER;

    }
}

