/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.rng.validate.AnyDataPattern;
import com.xmlmind.xml.rng.validate.Builder;
import com.xmlmind.xml.rng.validate.EmptyPattern;
import com.xmlmind.xml.rng.validate.NotAllowedPattern;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.PatternStack;
import com.xmlmind.xml.validate.DataFormatException;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.UnparsedEntities;

final class DataPattern
extends AnyDataPattern {
    public DataType dataType;

    public DataPattern(DataType dataType) {
        this.dataType = dataType;
    }

    public DataPattern() {
    }

    @Override
    public boolean samePatternAs(Pattern pattern, PatternStack patternStack) {
        return this.equals(pattern);
    }

    public int hashCode() {
        return this.dataType.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DataPattern)) {
            return false;
        }
        return this.dataType.equals(((DataPattern)object).dataType);
    }

    @Override
    public void toString(int n, NamespaceToPrefixes namespaceToPrefixes, StringBuilder stringBuilder) {
        stringBuilder.append(this.dataType.getDataTypeLabel(namespaceToPrefixes));
    }

    @Override
    public Pattern textDeriv(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities, Builder builder) {
        try {
            this.dataType.parseData(string, prefixToNamespace, unparsedEntities);
            return EmptyPattern.INSTANCE;
        }
        catch (DataFormatException dataFormatException) {
            return NotAllowedPattern.INSTANCE;
        }
    }
}

