/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.rng.validate.AnyDataPattern;
import com.xmlmind.xml.rng.validate.Builder;
import com.xmlmind.xml.rng.validate.EmptyPattern;
import com.xmlmind.xml.rng.validate.NotAllowedPattern;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.PatternStack;
import com.xmlmind.xml.validate.DataFormatException;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.UnparsedEntities;

final class DataExceptPattern
extends AnyDataPattern {
    public DataType dataType;
    public Pattern pattern;

    public DataExceptPattern(DataType dataType, Pattern pattern) {
        this.dataType = dataType;
        this.pattern = pattern;
    }

    public DataExceptPattern() {
    }

    @Override
    public boolean samePatternAs(Pattern pattern, PatternStack patternStack) {
        if (pattern == null || !(pattern instanceof DataExceptPattern)) {
            return false;
        }
        DataExceptPattern dataExceptPattern = (DataExceptPattern)pattern;
        return this.dataType.equals(dataExceptPattern.dataType) && DataExceptPattern.samePattern(this.pattern, dataExceptPattern.pattern, patternStack);
    }

    @Override
    public void toString(int n, NamespaceToPrefixes namespaceToPrefixes, StringBuilder stringBuilder) {
        stringBuilder.append('(');
        stringBuilder.append(this.dataType.getDataTypeLabel(namespaceToPrefixes));
        stringBuilder.append(" - ");
        if (n >= 0) {
            stringBuilder.append('\n');
            DataExceptPattern.indent(n + 1, stringBuilder);
        }
        this.pattern.toString(n >= 0 ? n + 1 : -1, namespaceToPrefixes, stringBuilder);
        stringBuilder.append(')');
    }

    public int hashCode() {
        return this.dataType.hashCode() ^ System.identityHashCode(this.pattern);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DataExceptPattern)) {
            return false;
        }
        DataExceptPattern dataExceptPattern = (DataExceptPattern)object;
        return this.dataType.equals(dataExceptPattern.dataType) && this.pattern == dataExceptPattern.pattern;
    }

    @Override
    public Pattern textDeriv(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities, Builder builder) {
        boolean bl;
        try {
            this.dataType.parseData(string, prefixToNamespace, unparsedEntities);
            bl = true;
        }
        catch (DataFormatException dataFormatException) {
            bl = false;
        }
        if (bl && !this.pattern.textDeriv((String)string, (PrefixToNamespace)prefixToNamespace, (UnparsedEntities)unparsedEntities, (Builder)builder).nullable) {
            return EmptyPattern.INSTANCE;
        }
        return NotAllowedPattern.INSTANCE;
    }
}

