/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.rng.validate.AttributeField;
import com.xmlmind.xml.rng.validate.BinaryPattern;
import com.xmlmind.xml.rng.validate.Builder;
import com.xmlmind.xml.rng.validate.ElementField;
import com.xmlmind.xml.rng.validate.EmptyPattern;
import com.xmlmind.xml.rng.validate.FieldBase;
import com.xmlmind.xml.rng.validate.FieldSet;
import com.xmlmind.xml.rng.validate.ItemList;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.PatternList;
import com.xmlmind.xml.rng.validate.PatternStack;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.UnparsedEntities;
import java.util.IdentityHashMap;

final class ChoicePattern
extends BinaryPattern {
    public ChoicePattern(Pattern pattern, Pattern pattern2) {
        super(pattern, pattern2, pattern.nullable || pattern2.nullable);
    }

    public ChoicePattern() {
    }

    public void getChoices(PatternList patternList) {
        if (this.pattern1 instanceof ChoicePattern) {
            ((ChoicePattern)this.pattern1).getChoices(patternList);
        } else if (!patternList.contains(this.pattern1)) {
            patternList.add(this.pattern1);
        }
        if (this.pattern2 instanceof ChoicePattern) {
            ((ChoicePattern)this.pattern2).getChoices(patternList);
        } else if (!patternList.contains(this.pattern2)) {
            patternList.add(this.pattern2);
        }
    }

    @Override
    public void toString(int n, NamespaceToPrefixes namespaceToPrefixes, StringBuilder stringBuilder) {
        stringBuilder.append('(');
        this.pattern1.toString(n >= 0 ? n + 1 : -1, namespaceToPrefixes, stringBuilder);
        stringBuilder.append(" | ");
        if (n >= 0) {
            stringBuilder.append('\n');
            ChoicePattern.indent(n + 1, stringBuilder);
        }
        this.pattern2.toString(n >= 0 ? n + 1 : -1, namespaceToPrefixes, stringBuilder);
        stringBuilder.append(')');
    }

    @Override
    public boolean samePatternAs(Pattern pattern, PatternStack patternStack) {
        if (pattern == null || !(pattern instanceof ChoicePattern)) {
            return false;
        }
        ChoicePattern choicePattern = (ChoicePattern)pattern;
        return ChoicePattern.samePattern(this.pattern1, choicePattern.pattern1, patternStack) && ChoicePattern.samePattern(this.pattern2, choicePattern.pattern2, patternStack);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ChoicePattern)) {
            return false;
        }
        ChoicePattern choicePattern = (ChoicePattern)object;
        return this.pattern1 == choicePattern.pattern1 && this.pattern2 == choicePattern.pattern2;
    }

    @Override
    public Pattern attributeDeriv(AttributeField attributeField, Builder builder) {
        return builder.makeChoice(this.pattern1.attributeDeriv(attributeField, builder), this.pattern2.attributeDeriv(attributeField, builder));
    }

    @Override
    public Pattern attributeDeriv(Attribute attribute, IdentityHashMap<Field, Field[]> identityHashMap, FieldBase[] fieldBaseArray, Builder builder) {
        return builder.makeChoice(this.pattern1.attributeDeriv(attribute, identityHashMap, fieldBaseArray, builder), this.pattern2.attributeDeriv(attribute, identityHashMap, fieldBaseArray, builder));
    }

    @Override
    public Pattern elementDeriv(ElementField elementField, Builder builder) {
        return builder.makeChoice(this.pattern1.elementDeriv(elementField, builder), this.pattern2.elementDeriv(elementField, builder));
    }

    @Override
    public Pattern elementDeriv(Element element, IdentityHashMap<Field, Field[]> identityHashMap, boolean bl, FieldBase[] fieldBaseArray, Builder builder) {
        return builder.makeChoice(this.pattern1.elementDeriv(element, identityHashMap, bl, fieldBaseArray, builder), this.pattern2.elementDeriv(element, identityHashMap, bl, fieldBaseArray, builder));
    }

    @Override
    public Pattern textDeriv(Builder builder) {
        return builder.makeChoice(this.pattern1.textDeriv(builder), this.pattern2.textDeriv(builder));
    }

    @Override
    public Pattern textDeriv(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities, Builder builder) {
        return builder.makeChoice(this.pattern1.textDeriv(string, prefixToNamespace, unparsedEntities, builder), this.pattern2.textDeriv(string, prefixToNamespace, unparsedEntities, builder));
    }

    @Override
    protected Pattern doFactorize(Builder builder, FieldSet fieldSet, FieldSet fieldSet2, IdentityHashMap<Pattern, Pattern> identityHashMap) {
        return builder.makeChoice(this.pattern1.factorize(builder, fieldSet, fieldSet2, identityHashMap), this.pattern2.factorize(builder, fieldSet, fieldSet2, identityHashMap));
    }

    @Override
    protected int attributesSeparatedFromElements() {
        int n;
        int n2 = this.pattern1.attributesSeparatedFromElements();
        return n2 == (n = this.pattern2.attributesSeparatedFromElements()) ? n2 : n2 + n;
    }

    @Override
    protected Pattern withoutAttributes(Builder builder) {
        return builder.makeChoice(this.pattern1.withoutAttributes(builder), this.pattern2.withoutAttributes(builder));
    }

    @Override
    protected Pattern findDataPattern() {
        Pattern pattern = this.pattern1.findDataPattern();
        Pattern pattern2 = this.pattern2.findDataPattern();
        if (pattern == null) {
            return pattern2;
        }
        if (pattern2 == null) {
            return pattern;
        }
        return this;
    }

    @Override
    protected int getComplexity(boolean bl) {
        return Math.min(this.pattern1.getComplexity(bl), this.pattern2.getComplexity(bl));
    }

    @Override
    protected boolean expand(int n, ItemList itemList) {
        if (this.pattern1 == EmptyPattern.INSTANCE || this.pattern2 == EmptyPattern.INSTANCE) {
            return true;
        }
        if ((n & 8) != 0) {
            int n2;
            int n3;
            Pattern pattern = this.pattern1;
            Pattern pattern2 = this.pattern2;
            if ((n & 0x10) != 0 && (n3 = this.pattern1.getComplexity(true)) > (n2 = this.pattern2.getComplexity(true))) {
                pattern = this.pattern2;
                pattern2 = this.pattern1;
            }
            if (pattern.expand(n, itemList)) {
                return true;
            }
            return pattern2.expand(n, itemList);
        }
        return true;
    }
}

