/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.name;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;

public final class Name
implements Serializable,
Comparable<Name> {
    public static final Name XML_LANG;
    public static final Name LANG;
    public static final Name XML_SPACE;
    public static final Name XML_BASE;
    public static final Name XML_ID;
    public static final Name XSI_TYPE;
    public static final Name XSI_NIL;
    public static final Name XSI_SCHEMA_LOCATION;
    public static final Name XSI_NO_NAMESPACE_SCHEMA_LOCATION;
    public static final Name XI_INCLUDE;
    public static final Name XI_FALLBACK;
    public static final Name HTML;
    public static final Name SCRIPT;
    public static final Name STYLE;
    public static final Name SVG;
    public static final Name MATH;
    public static final Name ANY_NAME;
    public static final String ANY_LOCAL_PART;
    public static final Name NOT_A_NAME;
    public static final String NOT_A_LOCAL_PART;
    private static final HashMap<Name, Name> names;
    public static final Name[] EMPTY_LIST;
    public final Namespace namespace;
    public final String localPart;

    public static Name get(String string) {
        return Name.get(Namespace.NONE, string);
    }

    public static Name get(String string, String string2) {
        return Name.get(Namespace.get(string), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Name get(Namespace namespace, String string) {
        if (namespace == null) {
            throw new IllegalArgumentException("null namespace");
        }
        if (string == null) {
            throw new IllegalArgumentException("null localPart");
        }
        Name name = new Name(namespace, string);
        HashMap<Name, Name> hashMap = names;
        synchronized (hashMap) {
            Name name2 = names.get(name);
            if (name2 == null) {
                name2 = name;
                names.put(name, name);
            }
            return name2;
        }
    }

    private Name(Namespace namespace, String string) {
        this.namespace = namespace;
        this.localPart = string;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Name)) {
            return false;
        }
        Name name = (Name)object;
        return this.namespace == name.namespace && this.localPart.equals(name.localPart);
    }

    public int hashCode() {
        return System.identityHashCode(this.namespace) ^ this.localPart.hashCode();
    }

    public static Name fromString(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        if (string.charAt(0) == '{' && (n = string.lastIndexOf(125)) > 0) {
            if (n + 1 == n2) {
                return null;
            }
            String string2 = string.substring(1, n);
            String string3 = string.substring(n + 1);
            if (string2.length() == 0) {
                if (!XMLText.isName(string3)) {
                    return null;
                }
                return Name.get(string3);
            }
            if (string2.trim().length() == 0 || !XMLText.isNCName(string3)) {
                return null;
            }
            return Name.get(string2, string3);
        }
        if (string.startsWith("xml:")) {
            String string4 = string.substring(4);
            if (!XMLText.isNCName(string4)) {
                return null;
            }
            return Name.get(Namespace.XML, string4);
        }
        if (!XMLText.isName(string)) {
            return null;
        }
        return Name.get(string);
    }

    public String toString() {
        if (this.namespace == Namespace.NONE) {
            return this.localPart;
        }
        if (this.namespace == Namespace.XML) {
            return "xml:" + this.localPart;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        stringBuilder.append(this.namespace.uri);
        stringBuilder.append('}');
        stringBuilder.append(this.localPart);
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Name name) {
        if (this.namespace == name.namespace) {
            return this.localPart.compareTo(name.localPart);
        }
        return this.namespace.compareTo(name.namespace);
    }

    public static Name parse(String string, boolean bl, PrefixToNamespace prefixToNamespace) {
        Namespace namespace;
        String string2;
        String string3;
        int n = string.indexOf(58);
        if (n < 0) {
            string3 = "";
            string2 = string;
            if (!XMLText.isNCName(string2)) {
                return null;
            }
        } else {
            if (n == 0 || n == string.length() - 1) {
                return null;
            }
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
            if (!XMLText.isNCName(string3) || !XMLText.isNCName(string2)) {
                return null;
            }
        }
        if (string3.length() == 0) {
            if (bl) {
                namespace = Namespace.NONE;
            } else {
                Namespace namespace2 = namespace = prefixToNamespace == null ? null : prefixToNamespace.prefixToNamespace("");
                if (namespace == null) {
                    namespace = Namespace.NONE;
                }
            }
        } else if ("xml".equals(string3)) {
            namespace = Namespace.XML;
        } else {
            Namespace namespace3 = namespace = prefixToNamespace == null ? null : prefixToNamespace.prefixToNamespace(string3);
            if (namespace == null) {
                return null;
            }
        }
        return Name.get(namespace, string2);
    }

    public String format(boolean bl, NamespaceToPrefixes namespaceToPrefixes) {
        Object object;
        Object object2;
        if (this.namespace == Namespace.NONE) {
            return this.localPart;
        }
        if (this.namespace == Namespace.XML) {
            object2 = "xml";
        } else {
            object = namespaceToPrefixes == null ? null : namespaceToPrefixes.namespaceToPrefixes(this.namespace);
            object2 = null;
            if (object != null) {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    Object object3 = object[i];
                    if (((String)object3).length() <= 0 && bl) continue;
                    object2 = object3;
                    break;
                }
            }
            if (object2 == null) {
                return this.toString();
            }
        }
        object = new StringBuilder();
        if (((String)object2).length() > 0) {
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append(':');
        }
        ((StringBuilder)object).append(this.localPart);
        return ((StringBuilder)object).toString();
    }

    private Object readResolve() throws ObjectStreamException {
        return Name.get(Namespace.get(this.namespace.uri), this.localPart);
    }

    static {
        names = new HashMap();
        XML_LANG = new Name(Namespace.XML, "lang");
        names.put(XML_LANG, XML_LANG);
        LANG = new Name(Namespace.NONE, "lang");
        names.put(LANG, LANG);
        XML_SPACE = new Name(Namespace.XML, "space");
        names.put(XML_SPACE, XML_SPACE);
        XML_BASE = new Name(Namespace.XML, "base");
        names.put(XML_BASE, XML_BASE);
        XML_ID = new Name(Namespace.XML, "id");
        names.put(XML_ID, XML_ID);
        XSI_TYPE = new Name(Namespace.XSI, "type");
        names.put(XSI_TYPE, XSI_TYPE);
        XSI_NIL = new Name(Namespace.XSI, "nil");
        names.put(XSI_NIL, XSI_NIL);
        XSI_SCHEMA_LOCATION = new Name(Namespace.XSI, "schemaLocation");
        names.put(XSI_SCHEMA_LOCATION, XSI_SCHEMA_LOCATION);
        XSI_NO_NAMESPACE_SCHEMA_LOCATION = new Name(Namespace.XSI, "noNamespaceSchemaLocation");
        names.put(XSI_NO_NAMESPACE_SCHEMA_LOCATION, XSI_NO_NAMESPACE_SCHEMA_LOCATION);
        XI_INCLUDE = new Name(Namespace.XI, "include");
        names.put(XI_INCLUDE, XI_INCLUDE);
        XI_FALLBACK = new Name(Namespace.XI, "fallback");
        names.put(XI_FALLBACK, XI_FALLBACK);
        HTML = new Name(Namespace.XHTML, "html");
        names.put(HTML, HTML);
        SCRIPT = new Name(Namespace.XHTML, "script");
        names.put(SCRIPT, SCRIPT);
        STYLE = new Name(Namespace.XHTML, "style");
        names.put(STYLE, STYLE);
        SVG = new Name(Namespace.SVG, "svg");
        names.put(SVG, SVG);
        MATH = new Name(Namespace.MATHML, "math");
        names.put(MATH, MATH);
        ANY_LOCAL_PART = "*";
        ANY_NAME = new Name(Namespace.ANY_NAMESPACE, ANY_LOCAL_PART);
        names.put(ANY_NAME, ANY_NAME);
        NOT_A_LOCAL_PART = "-";
        NOT_A_NAME = new Name(Namespace.NONE, NOT_A_LOCAL_PART);
        names.put(NOT_A_NAME, NOT_A_NAME);
        EMPTY_LIST = new Name[0];
    }
}

