/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.LoadText;
import com.xmlmind.xml.doc.ProcessingInstruction;
import java.io.File;
import java.io.IOException;

public final class XXERelaxngSchemaToXMLModel {
    private XXERelaxngSchemaToXMLModel() {
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0 || stringArray[0].startsWith("-")) {
            System.err.println("usage: java com.xmlmind.xml.load.XXERelaxngSchemaToXMLModel xml_file ... xml_file\nTranslates <?xxe-relaxng-schema?> to <?xml-model?> in specified XML files.\nBackups are created for the original XML files.\nThe backup files are given names which end with '.BAK'.");
            System.exit(1);
        }
        String[] stringArray2 = new String[1];
        for (String string : stringArray) {
            File file = new File(string).getCanonicalFile();
            String string2 = LoadText.loadText(file, "UTF-8", stringArray2, LoadText.XML_ENCODING_DETECTOR);
            if ((string2 = XXERelaxngSchemaToXMLModel.translatePI(string2)) == null) continue;
            File file2 = new File(file.getParentFile(), file.getName() + ".BAK");
            FileUtil.checkedRename(file, file2);
            FileUtil.saveString(string2, file, stringArray2[0]);
        }
    }

    private static String translatePI(String string) {
        int n;
        if (string.indexOf("<?xxe-relaxng-schema") < 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while ((n = string.indexOf("<?xxe-relaxng-schema", n2)) >= 0) {
            int n3;
            if (n > n2) {
                stringBuilder.append(string.substring(n2, n));
            }
            if ((n3 = string.indexOf("?>", n + 20)) > n + 20) {
                stringBuilder.append("<?xml-model");
                XXERelaxngSchemaToXMLModel.translatePI(string.substring(n + 20, n3), stringBuilder);
                stringBuilder.append("?>");
                n2 = n3 + 2;
                continue;
            }
            stringBuilder.append("<?xxe-relaxng-schema");
            n2 = n + 20;
        }
        if (n2 < string.length()) {
            stringBuilder.append(string.substring(n2));
        }
        return stringBuilder.toString();
    }

    private static void translatePI(String string, StringBuilder stringBuilder) {
        boolean bl = false;
        boolean bl2 = true;
        String[] stringArray = ProcessingInstruction.parsePseudoAttributes(string);
        for (int i = 0; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            String string3 = stringArray[i + 1].trim();
            if (string3.length() == 0) continue;
            if ("location".equals(string2)) {
                stringBuilder.append(" href=\"");
                stringBuilder.append(string3);
                stringBuilder.append('\"');
                bl = string3.endsWith(".rnc");
                continue;
            }
            if ("compactSyntax".equals(string2)) {
                if ("true".equals(string3)) {
                    stringBuilder.append(" type=\"application/relax-ng-compact-syntax\"");
                } else {
                    stringBuilder.append(" schematypens=\"http://relaxng.org/ns/structure/1.0\"");
                }
                bl2 = false;
                continue;
            }
            if (!"encoding".equals(string2)) continue;
            stringBuilder.append(" charset=\"");
            stringBuilder.append(string3);
            stringBuilder.append('\"');
        }
        if (bl2) {
            if (bl) {
                stringBuilder.append(" type=\"application/relax-ng-compact-syntax\"");
            } else {
                stringBuilder.append(" schematypens=\"http://relaxng.org/ns/structure/1.0\"");
            }
        }
    }
}

