/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.InclusionException;
import com.xmlmind.xml.load.DocumentCache;
import com.xmlmind.xml.load.Msg;
import com.xmlmind.xml.load.XInclusionContext;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.DocumentTypeUtil;
import java.io.IOException;
import java.net.URL;

public class XInclusionContextImpl
implements XInclusionContext {
    public final boolean xptrSemantics;
    public final Document preloadedDoc;
    protected DocumentCache docCache;

    public XInclusionContextImpl(boolean bl, Document document) {
        this.xptrSemantics = bl;
        this.preloadedDoc = document;
    }

    @Override
    public Document getDocument(URL uRL) throws InclusionException {
        if (this.preloadedDoc != null && uRL.equals(this.preloadedDoc.getSourceURL())) {
            return this.preloadedDoc;
        }
        if (this.docCache == null) {
            this.docCache = this.createDocumentCache();
        }
        try {
            return this.docCache.get(uRL);
        }
        catch (IOException iOException) {
            throw new InclusionException(Msg.msg("XICI.cannotLoadDocument", URLUtil.toLabel(uRL), ThrowableUtil.reason(iOException)));
        }
    }

    protected DocumentCache createDocumentCache() {
        return new DocumentCache(3, 4352);
    }

    @Override
    public Element findElementById(Document document, String string) {
        DocumentType documentType = DocumentTypeUtil.getDocumentType(document);
        Element[] elementArray = DocumentTypeUtil.findElementById(documentType, document.getRootElement(), string, this.xptrSemantics);
        if (elementArray != null && elementArray.length > 0) {
            return elementArray[0];
        }
        return null;
    }
}

