/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.xml.load.DTDSpec;
import com.xmlmind.xml.load.NamespaceURLPair;
import com.xmlmind.xml.load.XInclusionScheme;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.sxpath.ElementMatcher;
import com.xmlmind.xml.validate.SchemaKind;
import com.xmlmind.xml.validate.SubDocumentType;
import java.net.URL;

public final class SubDocumentTypeSpec {
    public final SchemaKind schemaKind;
    public final DTDSpec dtdSpec;
    public final URL dtdSystemId;
    public final String dtdPublicId;
    public final URL wxsURL;
    public final NamespaceURLPair[] wxsURLs;
    public final URL rngURL;
    public final boolean isCompactSyntax;
    public final String compactSyntaxEncoding;
    public final SubDocumentType subDocumentType;
    public ElementMatcher preserveSpaceElements;
    public XInclusionScheme[] xInclusionSchemes;

    public SubDocumentTypeSpec(DTDSpec dTDSpec) {
        this.schemaKind = SchemaKind.DTD;
        this.dtdSpec = dTDSpec;
        this.dtdPublicId = null;
        this.dtdSystemId = null;
        this.wxsURL = null;
        this.wxsURLs = null;
        this.rngURL = null;
        this.isCompactSyntax = false;
        this.compactSyntaxEncoding = null;
        this.subDocumentType = null;
    }

    public SubDocumentTypeSpec(String string, URL uRL) {
        this.schemaKind = SchemaKind.DTD;
        this.dtdPublicId = string;
        this.dtdSystemId = uRL;
        this.dtdSpec = null;
        this.wxsURL = null;
        this.wxsURLs = null;
        this.rngURL = null;
        this.isCompactSyntax = false;
        this.compactSyntaxEncoding = null;
        this.subDocumentType = null;
    }

    public SubDocumentTypeSpec(URL uRL) {
        this.schemaKind = SchemaKind.WXS;
        this.wxsURL = uRL;
        this.dtdSpec = null;
        this.dtdPublicId = null;
        this.dtdSystemId = null;
        this.wxsURLs = null;
        this.rngURL = null;
        this.isCompactSyntax = false;
        this.compactSyntaxEncoding = null;
        this.subDocumentType = null;
    }

    public SubDocumentTypeSpec(NamespaceURLPair[] namespaceURLPairArray) {
        this.schemaKind = SchemaKind.WXS;
        this.wxsURLs = namespaceURLPairArray;
        this.dtdSpec = null;
        this.dtdPublicId = null;
        this.dtdSystemId = null;
        this.wxsURL = null;
        this.rngURL = null;
        this.isCompactSyntax = false;
        this.compactSyntaxEncoding = null;
        this.subDocumentType = null;
    }

    public SubDocumentTypeSpec(URL uRL, boolean bl, String string) {
        this.schemaKind = SchemaKind.RNG;
        this.rngURL = uRL;
        this.isCompactSyntax = bl;
        this.compactSyntaxEncoding = string;
        this.dtdSpec = null;
        this.dtdPublicId = null;
        this.dtdSystemId = null;
        this.wxsURL = null;
        this.wxsURLs = null;
        this.subDocumentType = null;
    }

    public SubDocumentTypeSpec(SubDocumentType subDocumentType) {
        this.subDocumentType = subDocumentType;
        this.schemaKind = subDocumentType.getSchemaKind();
        this.dtdSpec = null;
        this.dtdPublicId = null;
        this.dtdSystemId = null;
        this.wxsURL = null;
        this.wxsURLs = null;
        this.rngURL = null;
        this.isCompactSyntax = false;
        this.compactSyntaxEncoding = null;
    }

    public String toString() {
        int n;
        URL[] uRLArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.schemaKind);
        if (this.dtdSpec != null) {
            uRLArray = this.dtdSpec.getExternalSubsetURL();
            if (uRLArray != null) {
                if (this.dtdSpec.publicId != null) {
                    stringBuilder.append(" PUBLIC \"");
                    stringBuilder.append(this.dtdSpec.publicId);
                    stringBuilder.append("\"");
                } else {
                    stringBuilder.append(" SYSTEM");
                }
                stringBuilder.append(" \"");
                stringBuilder.append(uRLArray);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append(" internal subset");
            }
        }
        if (this.dtdSystemId != null) {
            if (this.dtdPublicId != null) {
                stringBuilder.append(" PUBLIC \"");
                stringBuilder.append(this.dtdPublicId);
                stringBuilder.append("\" \"");
                stringBuilder.append(this.dtdSystemId);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append(" SYSTEM \"");
                stringBuilder.append(this.dtdSystemId);
                stringBuilder.append('\"');
            }
        }
        if (this.wxsURL != null) {
            stringBuilder.append(" \"");
            stringBuilder.append(this.wxsURL);
            stringBuilder.append('\"');
        }
        if (this.wxsURLs != null) {
            boolean bl = false;
            for (n = 0; n < this.wxsURLs.length; ++n) {
                NamespaceURLPair namespaceURLPair = this.wxsURLs[n];
                if (namespaceURLPair.namespace == Namespace.NONE) continue;
                if (!bl) {
                    bl = true;
                    stringBuilder.append(" xsi:schemaLocation=\"");
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(namespaceURLPair.namespace.uri);
                stringBuilder.append(' ');
                stringBuilder.append(namespaceURLPair.url);
            }
            if (bl) {
                stringBuilder.append('\"');
            }
            n = 0;
            for (int i = 0; i < this.wxsURLs.length; ++i) {
                NamespaceURLPair namespaceURLPair = this.wxsURLs[i];
                if (namespaceURLPair.namespace != Namespace.NONE) continue;
                if (n == 0) {
                    n = 1;
                    stringBuilder.append(" xsi:noNamespaceSchemaLocation=\"");
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(namespaceURLPair.url);
            }
            if (n != 0) {
                stringBuilder.append('\"');
            }
        }
        if (this.rngURL != null) {
            stringBuilder.append(" \"");
            stringBuilder.append(this.rngURL);
            stringBuilder.append('\"');
        }
        if (this.subDocumentType != null && (uRLArray = this.subDocumentType.getSchemaURLs()) != null) {
            for (n = 0; n < uRLArray.length; ++n) {
                stringBuilder.append(" \"");
                stringBuilder.append(uRLArray[n]);
                stringBuilder.append('\"');
            }
        }
        return stringBuilder.toString();
    }
}

