/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.load.Msg;
import com.xmlmind.xml.load.SubDocumentTypeCache;
import com.xmlmind.xml.validate.SubDocumentType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;

public final class SubDocumentTypeCacheImpl
implements SubDocumentTypeCache {
    public final int capacity;
    public final File cacheDir;
    public final long buildDate;
    private Entry first;
    private Entry last;
    private int size;

    public SubDocumentTypeCacheImpl(int n, File file) throws IOException {
        this(n, file, 1762160425376L);
    }

    protected SubDocumentTypeCacheImpl(int n, File file, long l) throws IOException {
        if (n <= 0) {
            n = 1;
        }
        if (!(file == null || (file = file.getCanonicalFile()).isDirectory() && file.canRead() && file.canWrite())) {
            throw new IOException(Msg.msg("unusableCacheDir", file));
        }
        this.capacity = n;
        this.cacheDir = file;
        this.buildDate = l;
        this.last = null;
        this.first = null;
        this.size = 0;
        this.loadEntries(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SubDocumentType fetchSubDocumentType(URL[] uRLArray, Console console) {
        Entry entry = this.find(uRLArray);
        if (entry == null) {
            return null;
        }
        this.detach(entry);
        if (entry.isObsolete()) {
            if (entry.serialFile != null) {
                this.deleteFile(entry.serialFile, console);
            }
            this.saveEntries(console);
            return null;
        }
        if (entry.subDocumentType == null) {
            assert (entry.serialFile != null);
            this.reportInfo(Msg.msg("deserializingEntry", entry), console);
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(entry.serialFile), 65536));){
                entry.subDocumentType = (SubDocumentType)objectInputStream.readObject();
            }
            catch (Throwable throwable) {
                this.reportError(Msg.msg("cannotDeserializeEntry", entry, entry.serialFile, ThrowableUtil.reason(throwable)), console);
            }
            if (entry.subDocumentType == null) {
                this.deleteFile(entry.serialFile, console);
                this.saveEntries(console);
                return null;
            }
        }
        this.attach(entry);
        this.reportInfo(Msg.msg("entryFetched", entry), console);
        return entry.subDocumentType;
    }

    private Entry find(URL[] uRLArray) {
        Entry entry = this.last;
        while (entry != null) {
            if (Arrays.equals(entry.schemaURLs, uRLArray)) {
                return entry;
            }
            entry = entry.previous;
        }
        return null;
    }

    private void detach(Entry entry) {
        assert (entry.previous != null || entry.next != null || entry == this.last);
        Entry entry2 = entry.previous;
        Entry entry3 = entry.next;
        entry.previous = null;
        entry.next = null;
        if (entry2 == null) {
            this.first = entry3;
        } else {
            entry2.next = entry3;
        }
        if (entry3 == null) {
            this.last = entry2;
        } else {
            entry3.previous = entry2;
        }
        --this.size;
    }

    private void attach(Entry entry) {
        assert (entry.previous == null && entry.next == null && entry != this.last);
        if (this.last == null) {
            this.first = this.last = entry;
        } else {
            this.last.next = entry;
            entry.previous = this.last;
            this.last = entry;
        }
        ++this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean cacheSubDocumentType(URL[] uRLArray, SubDocumentType subDocumentType, Console console) {
        Entry entry;
        block12: {
            if (uRLArray == null || uRLArray.length == 0) {
                return false;
            }
            entry = this.find(uRLArray);
            if (entry != null) {
                this.uncache(entry, console);
            }
            if (this.size >= this.capacity) {
                this.uncache(this.first, console);
            }
            if (subDocumentType instanceof Serializable && this.cacheDir != null) {
                File file = null;
                String string = URLUtil.getBaseName(uRLArray[0]);
                string = URIComponent.setExtension(string, null);
                for (int i = 0; i < 100; ++i) {
                    StringBuilder stringBuilder = new StringBuilder(string);
                    if (i > 0) {
                        stringBuilder.append('-');
                        stringBuilder.append(Integer.toString(1 + i));
                    }
                    stringBuilder.append(".ser");
                    File file2 = new File(this.cacheDir, stringBuilder.toString());
                    if (file2.exists()) continue;
                    file = file2;
                    break;
                }
                entry = new Entry(uRLArray, subDocumentType, file);
                if (file == null) {
                    this.reportError(Msg.msg("noMoreSerialFiles", entry, this.cacheDir), console);
                    return false;
                }
                this.reportInfo(Msg.msg("serializingEntry", entry), console);
                try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file), 65536));){
                    objectOutputStream.writeObject(subDocumentType);
                    objectOutputStream.flush();
                    break block12;
                }
                catch (Throwable throwable) {
                    this.reportError(Msg.msg("cannotSerializeEntry", entry, file, ThrowableUtil.reason(throwable)), console);
                    return false;
                }
            }
            entry = new Entry(uRLArray, subDocumentType, null);
        }
        this.attach(entry);
        this.saveEntries(console);
        this.reportInfo(Msg.msg("entryCached", entry), console);
        return true;
    }

    private void uncache(Entry entry, Console console) {
        this.detach(entry);
        if (entry.serialFile != null) {
            this.deleteFile(entry.serialFile, console);
        }
        this.saveEntries(console);
    }

    @Override
    public synchronized void uncacheSubDocumentTypes(Console console) {
        this.last = null;
        this.first = null;
        this.size = 0;
        if (this.cacheDir != null) {
            this.emptyDir(this.cacheDir, console);
        }
        this.reportInfo(Msg.msg("cacheCleared"), console);
    }

    private boolean emptyDir(File file, Console console) {
        boolean bl = FileUtil.doEmptyDir(file);
        if (!bl) {
            this.reportError(Msg.msg("cannotEmptyDir", file), console);
        }
        return bl;
    }

    private boolean deleteFile(File file, Console console) {
        boolean bl = file.delete();
        if (!bl) {
            this.reportError(Msg.msg("cannotDeleteFile", file), console);
        }
        return bl;
    }

    private void reportError(String string, Console console) {
        if (console != null) {
            console.showMessage(string, Console.MessageType.ERROR);
        }
    }

    private void reportInfo(String string, Console console) {
        if (console != null) {
            console.showMessage(string, Console.MessageType.INFO);
        }
    }

    private void loadEntries(Console console) {
        if (this.cacheDir == null) {
            return;
        }
        File file = new File(this.cacheDir, "directory.txt");
        if (!file.isFile()) {
            this.emptyDir(this.cacheDir, console);
            return;
        }
        long l = -1L;
        boolean bl = false;
        try {
            l = this.doLoadEntries(file);
        }
        catch (IOException iOException) {
            this.reportError(Msg.msg("cannotLoadEntries", file, ThrowableUtil.reason(iOException)), console);
            bl = true;
        }
        if (bl || l != this.buildDate) {
            this.emptyDir(this.cacheDir, console);
            this.last = null;
            this.first = null;
            this.size = 0;
        }
    }

    private long doLoadEntries(File file) throws IOException {
        String string = FileUtil.loadString(file, "UTF-8");
        String[] stringArray = StringUtil.split(string, '\n');
        long l = -1L;
        int n = -1;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            String string2 = stringArray[i];
            if (string2.length() == 0) continue;
            if (string2.startsWith("#")) {
                if (i != 0) continue;
                try {
                    l = Long.parseLong(string2.substring(1));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if ("{".equals(string2)) {
                if (n >= 0) {
                    bl = true;
                    break;
                }
                n = i + 1;
                continue;
            }
            if (!"}".equals(string2)) continue;
            int n2 = i - 1;
            if (n < 0 || n2 - n <= 0) {
                bl = true;
                break;
            }
            Entry entry = Entry.parse(stringArray, n, n2, this.cacheDir);
            if (entry == null) {
                bl = true;
                break;
            }
            n = -1;
            this.attach(entry);
        }
        if (n >= 0) {
            bl = true;
        }
        if (bl) {
            throw new IOException(Msg.msg("cannotParseEntries", file));
        }
        return l;
    }

    private void saveEntries(Console console) {
        if (this.cacheDir == null) {
            return;
        }
        File file = new File(this.cacheDir, "directory.txt");
        try {
            this.doSaveEntries(file);
        }
        catch (IOException iOException) {
            this.reportError(Msg.msg("cannotSaveEntries", file, ThrowableUtil.reason(iOException)), console);
        }
    }

    private void doSaveEntries(File file) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('#');
        stringBuilder.append(Long.toString(this.buildDate));
        stringBuilder.append('\n');
        stringBuilder.append("# Created by com.xmlmind.xml.load.SubDocumentTypeCacheImpl.\n# PLEASE DO NOT EDIT!\n");
        Entry entry = this.first;
        while (entry != null) {
            if (entry.serialFile != null) {
                stringBuilder.append("{\n");
                entry.format(stringBuilder);
                stringBuilder.append("}\n");
            }
            entry = entry.next;
        }
        FileUtil.saveString(stringBuilder.toString(), file, "UTF-8");
    }

    private static final class Entry {
        public Entry previous;
        public Entry next;
        public final URL[] schemaURLs;
        public SubDocumentType subDocumentType;
        public final File serialFile;
        private final File[] sourceFiles;
        private final long[] sourceDates;
        private String stringForm;

        public Entry(URL[] uRLArray, SubDocumentType subDocumentType, File file) {
            this.schemaURLs = uRLArray;
            this.subDocumentType = subDocumentType;
            this.serialFile = file;
            int n = uRLArray.length;
            this.sourceFiles = new File[n];
            this.sourceDates = new long[n];
            for (int i = 0; i < n; ++i) {
                this.sourceFiles[i] = URLUtil.urlToFile(uRLArray[i]);
                if (this.sourceFiles[i] == null) continue;
                this.sourceDates[i] = this.sourceFiles[i].lastModified();
            }
        }

        private Entry(URL[] uRLArray, File file, File[] fileArray, long[] lArray) {
            this.schemaURLs = uRLArray;
            this.subDocumentType = null;
            this.serialFile = file;
            this.sourceFiles = fileArray;
            this.sourceDates = lArray;
        }

        public boolean isObsolete() {
            int n = this.sourceFiles.length;
            for (int i = 0; i < n; ++i) {
                long l;
                File file = this.sourceFiles[i];
                if (file == null || (l = this.sourceDates[i]) <= 0L || file.isFile() && file.lastModified() == l) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            if (this.stringForm == null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < this.schemaURLs.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(this.schemaURLs[i]);
                }
                this.stringForm = stringBuilder.toString();
            }
            return this.stringForm;
        }

        public static Entry parse(String[] stringArray, int n, int n2, File file) {
            String string;
            File file2;
            if (!(file2 = new File(file, string = stringArray[n++])).isFile()) {
                return null;
            }
            int n3 = (n2 - n + 1) / 2;
            if (n3 <= 0) {
                return null;
            }
            URL[] uRLArray = new URL[n3];
            File[] fileArray = new File[n3];
            long[] lArray = new long[n3];
            n3 = 0;
            while (n <= n2) {
                try {
                    uRLArray[n3] = URLUtil.newURL(stringArray[n]);
                    fileArray[n3] = URLUtil.urlToFile(uRLArray[n3]);
                    lArray[n3] = Long.parseLong(stringArray[n + 1]);
                }
                catch (Exception exception) {
                    return null;
                }
                ++n3;
                n += 2;
            }
            return new Entry(uRLArray, file2, fileArray, lArray);
        }

        public void format(StringBuilder stringBuilder) {
            stringBuilder.append(this.serialFile.getName());
            stringBuilder.append('\n');
            for (int i = 0; i < this.schemaURLs.length; ++i) {
                stringBuilder.append(this.schemaURLs[i].toExternalForm());
                stringBuilder.append('\n');
                stringBuilder.append(Long.toString(this.sourceDates[i]));
                stringBuilder.append('\n');
            }
        }
    }
}

