/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.Console;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.IdentityLinearHashtable;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.load.BuiltInSubDocumentType;
import com.xmlmind.xml.load.DTDAccelerator;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.load.DocumentTypeDetector;
import com.xmlmind.xml.load.DocumentTypeDetectorImpl;
import com.xmlmind.xml.load.DocumentTypeLoader;
import com.xmlmind.xml.load.DocumentTypeSpec;
import com.xmlmind.xml.load.LoadDocumentStep;
import com.xmlmind.xml.load.LoadError;
import com.xmlmind.xml.load.LoadOptions;
import com.xmlmind.xml.load.Msg;
import com.xmlmind.xml.load.SpaceNormalizer;
import com.xmlmind.xml.load.SpaceProcessor;
import com.xmlmind.xml.load.SpaceTrimmer;
import com.xmlmind.xml.load.StopLoadingException;
import com.xmlmind.xml.load.SubDocumentTypeCache;
import com.xmlmind.xml.load.XIncluder;
import com.xmlmind.xml.load.XInclusionScheme;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.sxpath.ElementMatcher;
import com.xmlmind.xml.validate.AnyDocumentType;
import com.xmlmind.xml.validate.AutoDocumentType;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.SchemaKind;
import com.xmlmind.xml.validate.SingleDocumentType;
import com.xmlmind.xml.validate.SubDocumentType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class LoadDocument
implements LoadOptions {
    private static final DTDAccelerator[] dtdAccelerator1 = new DTDAccelerator[1];
    private static final SubDocumentTypeCache[] subDocumentTypeCache1 = new SubDocumentTypeCache[1];
    private static final IdentityLinearHashtable<Namespace, BuiltInSubDocumentType> builtInSubDocumentTypeMap = new IdentityLinearHashtable();
    private static final DocumentTypeDetector[] documentTypeDetector1 = new DocumentTypeDetector[]{DocumentTypeDetectorImpl.INSTANCE};
    private static final int[] defaultOptions1 = new int[1];
    private static XInclusionScheme[] xincludeScheme1 = new XInclusionScheme[1];
    private static final String[] loadDocumentStepClassName = new String[1];

    private LoadDocument() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDTDAccelerator(DTDAccelerator dTDAccelerator) {
        DTDAccelerator[] dTDAcceleratorArray = dtdAccelerator1;
        synchronized (dtdAccelerator1) {
            LoadDocument.dtdAccelerator1[0] = dTDAccelerator;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DTDAccelerator getDTDAccelerator() {
        DTDAccelerator[] dTDAcceleratorArray = dtdAccelerator1;
        synchronized (dtdAccelerator1) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return dtdAccelerator1[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSubDocumentTypeCache(SubDocumentTypeCache subDocumentTypeCache) {
        SubDocumentTypeCache[] subDocumentTypeCacheArray = subDocumentTypeCache1;
        synchronized (subDocumentTypeCache1) {
            LoadDocument.subDocumentTypeCache1[0] = subDocumentTypeCache;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubDocumentTypeCache getSubDocumentTypeCache() {
        SubDocumentTypeCache[] subDocumentTypeCacheArray = subDocumentTypeCache1;
        synchronized (subDocumentTypeCache1) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return subDocumentTypeCache1[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBuiltInSubDocumentType(BuiltInSubDocumentType builtInSubDocumentType) {
        IdentityLinearHashtable<Namespace, BuiltInSubDocumentType> identityLinearHashtable = builtInSubDocumentTypeMap;
        synchronized (identityLinearHashtable) {
            Namespace namespace = builtInSubDocumentType.getTargetNamespace();
            if (namespace != null && namespace != Namespace.NONE) {
                builtInSubDocumentTypeMap.put(namespace, builtInSubDocumentType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubDocumentType getBuiltInSubDocumentType(Namespace namespace) {
        IdentityLinearHashtable<Namespace, BuiltInSubDocumentType> identityLinearHashtable = builtInSubDocumentTypeMap;
        synchronized (identityLinearHashtable) {
            BuiltInSubDocumentType builtInSubDocumentType = builtInSubDocumentTypeMap.get(namespace);
            return builtInSubDocumentType == null ? null : builtInSubDocumentType.getSubDocumentType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDocumentTypeDetector(DocumentTypeDetector documentTypeDetector) {
        DocumentTypeDetector[] documentTypeDetectorArray = documentTypeDetector1;
        synchronized (documentTypeDetector1) {
            LoadDocument.documentTypeDetector1[0] = documentTypeDetector;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentTypeDetector getDocumentTypeDetector() {
        DocumentTypeDetector[] documentTypeDetectorArray = documentTypeDetector1;
        synchronized (documentTypeDetector1) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return documentTypeDetector1[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultOptions(int n) {
        int[] nArray = defaultOptions1;
        synchronized (defaultOptions1) {
            LoadDocument.defaultOptions1[0] = n;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDefaultOptions() {
        int[] nArray = defaultOptions1;
        synchronized (defaultOptions1) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultOptions1[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XInclusionScheme[] getXIncludeScheme() {
        XInclusionScheme[] xInclusionSchemeArray = xincludeScheme1;
        synchronized (xincludeScheme1) {
            if (xincludeScheme1[0] == null) {
                try {
                    XInclusionScheme xInclusionScheme;
                    LoadDocument.xincludeScheme1[0] = xInclusionScheme = (XInclusionScheme)Class.forName("com.xmlmind.xml.xinclude.XIncludeScheme").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return xincludeScheme1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoadDocumentStepClassName(String string) {
        String[] stringArray = loadDocumentStepClassName;
        synchronized (loadDocumentStepClassName) {
            LoadDocument.loadDocumentStepClassName[0] = string;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLoadDocumentStepClassName() {
        String[] stringArray = loadDocumentStepClassName;
        synchronized (loadDocumentStepClassName) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return loadDocumentStepClassName[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoadDocumentStep createLoadDocumentStep(boolean bl, int n, Console console) {
        String[] stringArray = loadDocumentStepClassName;
        synchronized (loadDocumentStepClassName) {
            if (loadDocumentStepClassName[0] != null) {
                try {
                    Class<?> clazz = Class.forName(loadDocumentStepClassName[0]);
                    Constructor<?> constructor = clazz.getConstructor(Boolean.TYPE, Integer.TYPE, Console.class);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return (LoadDocumentStep)constructor.newInstance(bl, n, console);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new LoadDocumentStep(bl, n, console);
        }
    }

    public static Document load(File file) throws IOException {
        try {
            return LoadDocument.load(file, LoadDocument.getDefaultOptions(), null, null, null);
        }
        catch (SAXParseException sAXParseException) {
            throw new IOException(DocumentLoader.format(sAXParseException));
        }
        catch (SAXException sAXException) {
            throw new IOException(ThrowableUtil.reason(sAXException));
        }
    }

    public static Document load(File file, int n, Console console, List<LoadError> list, List<LoadError> list2) throws SAXException, IOException {
        return LoadDocument.load(FileUtil.fileToURL(file), n, console, list, list2);
    }

    public static Document load(URL uRL) throws IOException {
        try {
            return LoadDocument.load(uRL, LoadDocument.getDefaultOptions(), null, null, null);
        }
        catch (SAXParseException sAXParseException) {
            throw new IOException(DocumentLoader.format(sAXParseException));
        }
        catch (SAXException sAXException) {
            throw new IOException(ThrowableUtil.reason(sAXException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document load(URL uRL, int n, Console console, List<LoadError> list, List<LoadError> list2) throws SAXException, IOException {
        Document document;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(URLUtil.openStreamNoCache(uRL), 65535);
        InputSource inputSource = new InputSource(bufferedInputStream);
        inputSource.setSystemId(uRL.toExternalForm());
        try {
            document = LoadDocument.load(inputSource, uRL, n, console, list, list2);
        }
        finally {
            inputSource.getByteStream().close();
        }
        return document;
    }

    public static Document load(InputSource inputSource, int n, Console console, List<LoadError> list, List<LoadError> list2) throws SAXException, IOException {
        return LoadDocument.load(inputSource, null, n, console, list, list2);
    }

    public static Document load(InputSource inputSource, URL uRL, int n, Console console, List<LoadError> list, List<LoadError> list2) throws SAXException, IOException {
        Document document;
        InputStream inputStream = null;
        boolean bl = uRL != null && (inputStream = inputSource.getByteStream()) != null;
        LoadDocumentStep loadDocumentStep = LoadDocument.createLoadDocumentStep(bl, n, console);
        if (bl) {
            long l = System.currentTimeMillis();
            try {
                document = loadDocumentStep.load(inputSource);
            }
            catch (StopLoadingException stopLoadingException) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                inputStream = new BufferedInputStream(URLUtil.openStreamNoCache(uRL), 65535);
                inputSource.setByteStream(inputStream);
                LoadDocument.reportVerbose(console, Msg.msg("reloadingDocumentWithDTD", uRL, System.currentTimeMillis() - l));
                document = loadDocumentStep.load(inputSource);
            }
            LoadDocument.reportVerbose(console, Msg.msg("loadedDocument", uRL, System.currentTimeMillis() - l));
        } else {
            document = loadDocumentStep.load(inputSource);
        }
        LoadDocument.process(document, loadDocumentStep.detectedDocTypeSpec, n, console, list, list2);
        loadDocumentStep.documentLoaded(document);
        return document;
    }

    public static void process(Document document, DocumentTypeSpec documentTypeSpec, int n, Console console, List<LoadError> list, List<LoadError> list2) throws IOException {
        Object object;
        DocumentType documentType = LoadDocument.addDocumentType(document, documentTypeSpec, n, console, list, list2);
        XInclusionScheme[] xInclusionSchemeArray = (XInclusionScheme[])document.getProperty(Constants.XINCLUSION_SCHEMES_PROPERTY);
        if ((n & 0x2000) != 0 && xInclusionSchemeArray == null && (xInclusionSchemeArray = LoadDocument.getXIncludeScheme()) != null) {
            document.putProperty(Constants.XINCLUSION_SCHEMES_PROPERTY, xInclusionSchemeArray);
        }
        if ((n & 0x1000) == 0 && xInclusionSchemeArray != null) {
            LoadDocument.reportInfo(console, Msg.msg("processingXInclusions", document.getSourceURL()));
            object = new XIncluder(xInclusionSchemeArray);
            ((XIncluder)object).process(document, null, console, list, list2);
        }
        if ((n & 0x400) == 0) {
            object = null;
            if (documentType == null || documentType instanceof AnyDocumentType) {
                if ((n & 0x800) != 0) {
                    object = new SpaceTrimmer();
                }
            } else {
                object = new SpaceNormalizer(documentType);
            }
            if (object != null) {
                LoadDocument.reportInfo(console, Msg.msg("strippingWhitespace", document.getSourceURL()));
                ((SpaceProcessor)object).processSpace(document);
            }
        }
    }

    private static DocumentType addDocumentType(Document document, DocumentTypeSpec documentTypeSpec, int n, Console console, List<LoadError> list, List<LoadError> list2) throws IOException {
        DocumentType documentType = null;
        if (documentTypeSpec != null) {
            LoadError[] loadErrorArray;
            XInclusionScheme[] xInclusionSchemeArray;
            ElementMatcher elementMatcher = documentTypeSpec.getPreserveSpaceElements();
            if (elementMatcher != null) {
                document.putProperty(Constants.PRESERVE_SPACE_ELEMENTS_PROPERTY, elementMatcher);
            }
            if ((xInclusionSchemeArray = documentTypeSpec.getXInclusionSchemes()) != null) {
                document.putProperty(Constants.XINCLUSION_SCHEMES_PROPERTY, xInclusionSchemeArray);
            }
            DocumentTypeLoader documentTypeLoader = new DocumentTypeLoader();
            documentType = documentTypeLoader.loadDocumentType(documentTypeSpec, console);
            if (list != null && (loadErrorArray = documentTypeLoader.getLoadErrors()).length > 0) {
                list.addAll(Arrays.asList(loadErrorArray));
            }
            if (list2 != null && (loadErrorArray = documentTypeLoader.getLoadWarnings()).length > 0) {
                list2.addAll(Arrays.asList(loadErrorArray));
            }
            if (documentType != null) {
                LoadDocument.addPrefixes(documentType, document);
            }
        } else {
            documentType = LoadDocument.getBuiltInDocumentType(document, console);
            if (documentType != null) {
                LoadDocument.addPrefixes(documentType, document);
            } else if ((n & 0x200) != 0) {
                documentType = new AutoDocumentType(document);
            } else if ((n & 0x100) != 0) {
                documentType = AnyDocumentType.INSTANCE;
            }
        }
        if (documentType != null) {
            document.putProperty(Constants.DOCUMENT_TYPE_PROPERTY, documentType);
        }
        return documentType;
    }

    private static void addPrefixes(DocumentType documentType, Document document) {
        Object object = document.getProperty(Constants.NAMESPACE_PREFIX_MAP_PROPERTY);
        if (object == null || !(object instanceof PrefixPreferences)) {
            return;
        }
        PrefixPreferences prefixPreferences = (PrefixPreferences)object;
        SchemaKind schemaKind = documentType.getSchemaKind();
        PrefixEntry[] prefixEntryArray = documentType.getSchemaDeclaredPrefixes();
        if (prefixEntryArray != null && prefixEntryArray.length > 0) {
            if (schemaKind == SchemaKind.DTD) {
                PrefixEntry[] prefixEntryArray2 = LoadDocument.getAll(prefixPreferences);
                prefixPreferences.clear();
                prefixPreferences.add(prefixEntryArray, true);
                if (prefixEntryArray2 != null && prefixEntryArray2.length > 0) {
                    prefixPreferences.add(prefixEntryArray2, true);
                }
            } else {
                prefixPreferences.add(prefixEntryArray, true);
            }
        }
        if (schemaKind == SchemaKind.WXS) {
            prefixPreferences.add(Namespace.XSI, "xsi");
        }
    }

    private static PrefixEntry[] getAll(PrefixPreferences prefixPreferences) {
        PrefixEntry[] prefixEntryArray = prefixPreferences.getAll();
        Namespace namespace = prefixPreferences.getDefaultNamespace();
        if (namespace != null) {
            PrefixEntry[] prefixEntryArray2 = new PrefixEntry[prefixEntryArray.length + 1];
            System.arraycopy(prefixEntryArray, 0, prefixEntryArray2, 0, prefixEntryArray.length);
            prefixEntryArray2[prefixEntryArray.length] = new PrefixEntry("", namespace);
            prefixEntryArray = prefixEntryArray2;
        }
        return prefixEntryArray;
    }

    private static DocumentType getBuiltInDocumentType(Document document, Console console) {
        Namespace namespace = document.getRootElement().getNamespace();
        SubDocumentType subDocumentType = LoadDocument.getBuiltInSubDocumentType(namespace);
        if (subDocumentType == null) {
            return null;
        }
        LoadDocument.reportInfo(console, Msg.msg("usingBuiltInSchema", namespace.uri));
        return new SingleDocumentType(subDocumentType);
    }

    private static void reportInfo(Console console, String string) {
        if (console != null) {
            console.showMessage(string, Console.MessageType.INFO);
        }
    }

    private static void reportVerbose(Console console, String string) {
        if (console != null) {
            console.showMessage(string, Console.MessageType.VERBOSE);
        }
    }
}

